/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list;

import io.delilaheve.CustomAnvil;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.config.MainConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.ElementListConfigGui;
import xyz.alexcrea.cuanvil.gui.config.settings.SettingGui;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;

public abstract class SettingGuiListConfigGui<T, S extends SettingGui.SettingGuiFactory>
extends ElementListConfigGui<T> {
    protected HashMap<T, GuiItem> guiItemMap = new HashMap();
    protected HashMap<T, S> factoryMap = new HashMap();

    protected SettingGuiListConfigGui(@NotNull String title, Gui parent) {
        super(title, parent);
    }

    protected SettingGuiListConfigGui(@NotNull String title) {
        this(title, MainConfigGui.getInstance());
    }

    @Override
    protected GuiItem prepareCreateNewItem() {
        ItemStack createItem = new ItemStack(Material.PAPER);
        ItemMeta createMeta = createItem.getItemMeta();
        assert (createMeta != null);
        createMeta.setDisplayName(this.createItemName());
        createMeta.setLore(this.getCreateItemLore());
        createItem.setItemMeta(createMeta);
        return new GuiItem(createItem, this.getCreateClickConsumer(), (Plugin)CustomAnvil.instance);
    }

    @Override
    public void updateValueForGeneric(T generic, boolean shouldUpdate) {
        if (!this.factoryMap.containsKey(generic)) {
            S factory = this.createFactory(generic);
            GuiItem newItem = this.itemFromFactory(generic, factory);
            this.addToPage(newItem);
            this.guiItemMap.put(generic, newItem);
            this.factoryMap.put(generic, factory);
        } else {
            SettingGui.SettingGuiFactory factory = (SettingGui.SettingGuiFactory)this.factoryMap.get(generic);
            GuiItem oldItem = this.guiItemMap.get(generic);
            GuiItem newItem = this.itemFromFactory(generic, factory);
            this.updateGuiItem(oldItem, newItem);
        }
        if (shouldUpdate) {
            this.update();
        }
    }

    @Override
    protected void reloadValues() {
        this.guiItemMap.clear();
        this.factoryMap.clear();
        super.reloadValues();
    }

    private void updateGuiItem(GuiItem oldITem, GuiItem newItem) {
        oldITem.setItem(newItem.getItem());
        oldITem.setProperties(newItem.getProperties());
        oldITem.setVisible(newItem.isVisible());
    }

    @Override
    protected GuiItem findGuiItemForRemoval(T generic) {
        return this.guiItemMap.get(generic);
    }

    @Override
    protected void updateGeneric(T generic, ItemStack usedItem) {
    }

    @Override
    protected ItemStack createItemForGeneric(T generic) {
        return null;
    }

    protected abstract List<String> getCreateItemLore();

    protected abstract Consumer<InventoryClickEvent> getCreateClickConsumer();

    protected abstract String createItemName();

    protected abstract S createFactory(T var1);

    protected abstract GuiItem itemFromFactory(T var1, S var2);
}

