/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.group;

import io.delilaheve.CustomAnvil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012J\u0014\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u001c\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0005J\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013J\u0014\u0010!\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cJ\u0006\u0010\"\u001a\u00020\u001eJ\b\u0010#\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lxyz/alexcrea/cuanvil/group/EnchantConflictGroup;", "", "name", "", "cantConflict", "Lxyz/alexcrea/cuanvil/group/AbstractMaterialGroup;", "minBeforeBlock", "", "<init>", "(Ljava/lang/String;Lxyz/alexcrea/cuanvil/group/AbstractMaterialGroup;I)V", "getName", "()Ljava/lang/String;", "getMinBeforeBlock", "()I", "setMinBeforeBlock", "(I)V", "enchantments", "Ljava/util/HashSet;", "Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;", "Lkotlin/collections/HashSet;", "addEnchantment", "", "enchant", "addEnchantments", "enchants", "", "allowed", "", "", "mat", "Lorg/bukkit/Material;", "getCantConflictGroup", "getEnchants", "setEnchants", "getRepresentativeMaterial", "toString", "CustomAnvil"})
public final class EnchantConflictGroup {
    @NotNull
    private final String name;
    @NotNull
    private final AbstractMaterialGroup cantConflict;
    private int minBeforeBlock;
    @NotNull
    private final HashSet<CAEnchantment> enchantments;

    public EnchantConflictGroup(@NotNull String name, @NotNull AbstractMaterialGroup cantConflict, int minBeforeBlock) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(cantConflict, "cantConflict");
        this.name = name;
        this.cantConflict = cantConflict;
        this.minBeforeBlock = minBeforeBlock;
        this.enchantments = new HashSet();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getMinBeforeBlock() {
        return this.minBeforeBlock;
    }

    public final void setMinBeforeBlock(int n) {
        this.minBeforeBlock = n;
    }

    public final void addEnchantment(@NotNull CAEnchantment enchant) {
        Intrinsics.checkNotNullParameter(enchant, "enchant");
        this.enchantments.add(enchant);
    }

    public final void addEnchantments(@NotNull List<? extends CAEnchantment> enchants) {
        Intrinsics.checkNotNullParameter(enchants, "enchants");
        this.enchantments.addAll((Collection<CAEnchantment>)enchants);
    }

    public final boolean allowed(@NotNull Set<? extends CAEnchantment> enchants, @NotNull Material mat) {
        Intrinsics.checkNotNullParameter(enchants, "enchants");
        Intrinsics.checkNotNullParameter(mat, "mat");
        if (this.enchantments.size() < this.minBeforeBlock) {
            CustomAnvil.Companion.verboseLog("Conflicting bc of to many enchantments");
            return true;
        }
        if (this.cantConflict.contain(mat)) {
            return true;
        }
        int enchantAmount = 0;
        for (CAEnchantment cAEnchantment : enchants) {
            if (!this.enchantments.contains(cAEnchantment)) continue;
            CustomAnvil.Companion.verboseLog("Enchant " + cAEnchantment.getKey() + " is in: " + (enchantAmount + 1) + "/" + this.minBeforeBlock + " ");
            if (++enchantAmount <= this.minBeforeBlock) continue;
            CustomAnvil.Companion.verboseLog("it is not allowed bc of to many enchantment in conflict");
            return false;
        }
        return true;
    }

    @NotNull
    public final AbstractMaterialGroup getCantConflictGroup() {
        return this.cantConflict;
    }

    @NotNull
    public final HashSet<CAEnchantment> getEnchants() {
        return this.enchantments;
    }

    public final void setEnchants(@NotNull Set<? extends CAEnchantment> enchants) {
        Intrinsics.checkNotNullParameter(enchants, "enchants");
        this.enchantments.clear();
        this.enchantments.addAll((Collection<CAEnchantment>)enchants);
    }

    @NotNull
    public final Material getRepresentativeMaterial() {
        Set<AbstractMaterialGroup> groups2 = this.getCantConflictGroup().getGroups();
        Iterator<AbstractMaterialGroup> groupIterator = groups2.iterator();
        while (groupIterator.hasNext()) {
            Material mat = groupIterator.next().getRepresentativeMaterial();
            if (mat == Material.ENCHANTED_BOOK) continue;
            return mat;
        }
        return Material.ENCHANTED_BOOK;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

