/*
 * Decompiled with CFR 0.152.
 */
package net.abcsnoob;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiTPATraps
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private String trapDetectedMessage;
    private boolean checkSurroundingBlocks;
    private int checkRadius;
    private boolean preventLavaTrap;
    private boolean preventVoidTrap;
    private boolean preventSuffocationTrap;
    private boolean preventWaterTrap;
    private boolean preventFallTrap;
    private boolean preventBlockBreakAfterTeleport;
    private int blockBreakCooldownSeconds;
    private String blockBreakCooldownMessage;
    private Map<UUID, Long> lastTeleportTime;
    private boolean enableTpaWarning;
    private String tpaRequestWarningMessage;
    private String tpaAcceptWarningMessage;
    private boolean hasSimpleTPA;
    private Map<UUID, UUID> tpaRequests;
    private Map<UUID, Long> tpaRequestTime;
    private int tpaTimeoutSeconds;
    private String tpaRequestSent;
    private String tpaRequestReceived;
    private String tpaRequestAccepted;
    private String tpaRequestDenied;
    private String tpaRequestTimedOut;
    private String tpaNoPendingRequest;
    private String playerNotFound;
    private String cannotTpaToSelf;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadConfig();
        this.lastTeleportTime = new HashMap<UUID, Long>();
        if (this.getServer().getPluginManager().getPlugin("SimpleTPA") != null) {
            this.hasSimpleTPA = true;
            this.getLogger().info("SimpleTPA found. Using its TPA commands.");
        } else {
            this.hasSimpleTPA = false;
            this.getLogger().info("SimpleTPA not found. Registering custom TPA commands.");
            this.tpaRequests = new ConcurrentHashMap<UUID, UUID>();
            this.tpaRequestTime = new ConcurrentHashMap<UUID, Long>();
            this.getCommand("tpa").setExecutor((CommandExecutor)new CustomTPACommand());
            this.getCommand("tpaccept").setExecutor((CommandExecutor)new CustomTPACommand());
            this.getCommand("tpadeny").setExecutor((CommandExecutor)new CustomTPACommand());
            this.getCommand("tpahere").setExecutor((CommandExecutor)new CustomTPACommand());
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("AntiTPATraps has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("AntiTPATraps has been disabled!");
    }

    private void loadConfig() {
        this.trapDetectedMessage = this.config.getString("messages.trap-detected", "&cB\u1ea1n kh\u00f4ng th\u1ec3 d\u1ecbch chuy\u1ec3n \u0111\u1ebfn v\u1ecb tr\u00ed \u0111\u00f3 v\u00ec n\u00f3 \u0111\u01b0\u1ee3c coi l\u00e0 b\u1eaby!");
        this.blockBreakCooldownMessage = this.config.getString("messages.block-break-cooldown", "&cB\u1ea1n kh\u00f4ng th\u1ec3 \u0111\u1eadp kh\u1ed1i trong %seconds% gi\u00e2y sau khi d\u1ecbch chuy\u1ec3n.");
        this.tpaRequestWarningMessage = this.config.getString("messages.tpa-request-warning", "&eH\u00e3y c\u1ea9n th\u1eadn khi TPA! Lu\u00f4n ki\u1ec3m tra khu v\u1ef1c d\u1ecbch chuy\u1ec3n.");
        this.tpaAcceptWarningMessage = this.config.getString("messages.tpa-accept-warning", "&eB\u1ea1n s\u1eafp d\u1ecbch chuy\u1ec3n \u0111\u1ebfn m\u1ed9t ng\u01b0\u1eddi ch\u01a1i. H\u00e3y c\u1ea3nh gi\u00e1c v\u1edbi c\u00e1c b\u1eaby!");
        this.checkSurroundingBlocks = this.config.getBoolean("settings.check-surrounding-blocks", true);
        this.checkRadius = this.config.getInt("settings.check-radius", 3);
        this.preventLavaTrap = this.config.getBoolean("trap-types.lava-trap", true);
        this.preventVoidTrap = this.config.getBoolean("trap-types.void-trap", true);
        this.preventSuffocationTrap = this.config.getBoolean("trap-types.suffocation-trap", true);
        this.preventWaterTrap = this.config.getBoolean("trap-types.water-trap", false);
        this.preventFallTrap = this.config.getBoolean("trap-types.fall-trap", true);
        this.preventBlockBreakAfterTeleport = this.config.getBoolean("settings.prevent-block-break-after-teleport.enabled", true);
        this.blockBreakCooldownSeconds = this.config.getInt("settings.prevent-block-break-after-teleport.cooldown-seconds", 5);
        this.enableTpaWarning = this.config.getBoolean("settings.enable-tpa-warning", true);
        this.tpaTimeoutSeconds = this.config.getInt("settings.tpa-timeout-seconds", 60);
        this.tpaRequestSent = this.config.getString("messages.tpa-custom.request-sent", "&aY\u00eau c\u1ea7u TPA \u0111\u1ebfn %target% \u0111\u00e3 \u0111\u01b0\u1ee3c g\u1eedi.");
        this.tpaRequestReceived = this.config.getString("messages.tpa-custom.request-received", "&eB\u1ea1n c\u00f3 y\u00eau c\u1ea7u TPA t\u1eeb %sender%. G\u00f5 &a/tpaccept &e\u0111\u1ec3 ch\u1ea5p nh\u1eadn ho\u1eb7c &c/tpadeny &e\u0111\u1ec3 t\u1eeb ch\u1ed1i.");
        this.tpaRequestAccepted = this.config.getString("messages.tpa-custom.request-accepted", "&aY\u00eau c\u1ea7u TPA \u0111\u00e3 \u0111\u01b0\u1ee3c ch\u1ea5p nh\u1eadn. B\u1ea1n s\u1ebd \u0111\u01b0\u1ee3c d\u1ecbch chuy\u1ec3n trong v\u00e0i gi\u00e2y.");
        this.tpaRequestDenied = this.config.getString("messages.tpa-custom.request-denied", "&cY\u00eau c\u1ea7u TPA \u0111\u00e3 b\u1ecb t\u1eeb ch\u1ed1i.");
        this.tpaRequestTimedOut = this.config.getString("messages.tpa-custom.request-timed-out", "&cY\u00eau c\u1ea7u TPA \u0111\u00e3 h\u1ebft th\u1eddi gian.");
        this.tpaNoPendingRequest = this.config.getString("messages.tpa-custom.no-pending-request", "&cB\u1ea1n kh\u00f4ng c\u00f3 y\u00eau c\u1ea7u TPA \u0111ang ch\u1edd n\u00e0o.");
        this.playerNotFound = this.config.getString("messages.tpa-custom.player-not-found", "&cKh\u00f4ng t\u00ecm th\u1ea5y ng\u01b0\u1eddi ch\u01a1i n\u00e0y ho\u1eb7c h\u1ecd kh\u00f4ng tr\u1ef1c tuy\u1ebfn.");
        this.cannotTpaToSelf = this.config.getString("messages.tpa-custom.cannot-tpa-to-self", "&cB\u1ea1n kh\u00f4ng th\u1ec3 TPA \u0111\u1ebfn ch\u00ednh m\u00ecnh.");
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND || event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            Player player = event.getPlayer();
            Location toLocation = event.getTo();
            if (toLocation == null || toLocation.getWorld() == null) {
                return;
            }
            if (this.isTrapLocation(toLocation, player)) {
                event.setCancelled(true);
                player.sendMessage(this.trapDetectedMessage.replace("&", "\u00a7"));
                this.getLogger().info(player.getName() + " attempted to TPA into a trap at " + toLocation.getBlockX() + "," + toLocation.getBlockY() + "," + toLocation.getBlockZ());
                return;
            }
        }
        if (!event.isCancelled() && this.preventBlockBreakAfterTeleport) {
            this.lastTeleportTime.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.preventBlockBreakAfterTeleport) {
            return;
        }
        Player player = event.getPlayer();
        if (this.lastTeleportTime.containsKey(player.getUniqueId())) {
            long timeElapsed = (System.currentTimeMillis() - this.lastTeleportTime.get(player.getUniqueId())) / 1000L;
            if (timeElapsed < (long)this.blockBreakCooldownSeconds) {
                event.setCancelled(true);
                String message = this.blockBreakCooldownMessage.replace("%seconds%", String.valueOf((long)this.blockBreakCooldownSeconds - timeElapsed));
                player.sendMessage(message.replace("&", "\u00a7"));
            } else {
                this.lastTeleportTime.remove(player.getUniqueId());
            }
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (this.hasSimpleTPA) {
            if (!this.enableTpaWarning) {
                return;
            }
            Player player = event.getPlayer();
            String message = event.getMessage().toLowerCase();
            if (message.startsWith("/tpa ")) {
                player.sendMessage(this.tpaRequestWarningMessage.replace("&", "\u00a7"));
            } else if (message.equals("/tpaccept") || message.startsWith("/tpaccept ")) {
                player.sendMessage(this.tpaAcceptWarningMessage.replace("&", "\u00a7"));
            } else if (message.startsWith("/tpahere ")) {
                player.sendMessage(this.tpaRequestWarningMessage.replace("&", "\u00a7"));
            }
        }
    }

    private boolean isTrapLocation(Location loc, Player player) {
        Location blockBelow;
        if (this.preventVoidTrap && loc.getY() < 0.0) {
            return true;
        }
        if (this.preventSuffocationTrap) {
            Material playerFeetBlock = loc.getBlock().getType();
            Material playerHeadBlock = loc.clone().add(0.0, 1.0, 0.0).getBlock().getType();
            if (playerFeetBlock.isSolid() || playerHeadBlock.isSolid()) {
                return true;
            }
        }
        if (this.checkSurroundingBlocks) {
            for (int x = -this.checkRadius; x <= this.checkRadius; ++x) {
                for (int y = -this.checkRadius; y <= this.checkRadius; ++y) {
                    for (int z = -this.checkRadius; z <= this.checkRadius; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        Location checkLoc = loc.clone().add((double)x, (double)y, (double)z);
                        Material material = checkLoc.getBlock().getType();
                        if (this.preventLavaTrap && (material == Material.LAVA || material == Material.MAGMA_BLOCK)) {
                            return true;
                        }
                        if (!this.preventWaterTrap || material != Material.WATER || checkLoc.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.WATER || checkLoc.clone().add(0.0, 2.0, 0.0).getBlock().getType() != Material.WATER) continue;
                        return true;
                    }
                }
            }
        }
        if (this.preventFallTrap && (blockBelow = loc.clone().subtract(0.0, 1.0, 0.0)).getBlock().getType() == Material.AIR) {
            int airBlocksBelow = 0;
            for (int i = 1; i <= 20 && loc.clone().subtract(0.0, (double)i, 0.0).getBlock().getType() == Material.AIR; ++i) {
                ++airBlocksBelow;
            }
            if (airBlocksBelow >= 5) {
                return true;
            }
        }
        return false;
    }

    private class CustomTPACommand
    implements CommandExecutor {
        private CustomTPACommand() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Ch\u1ec9 ng\u01b0\u1eddi ch\u01a1i m\u1edbi c\u00f3 th\u1ec3 s\u1eed d\u1ee5ng l\u1ec7nh n\u00e0y.");
                return true;
            }
            Player player = (Player)sender;
            String cmdName = command.getName().toLowerCase();
            if (cmdName.equals("tpa")) {
                if (args.length != 1) {
                    player.sendMessage("C\u00fa ph\u00e1p: /tpa <t\u00ean_ng\u01b0\u1eddi_ch\u01a1i>");
                    return true;
                }
                Player target = AntiTPATraps.this.getServer().getPlayer(args[0]);
                if (target == null || !target.isOnline()) {
                    player.sendMessage(AntiTPATraps.this.playerNotFound.replace("&", "\u00a7"));
                    return true;
                }
                if (player.getUniqueId().equals(target.getUniqueId())) {
                    player.sendMessage(AntiTPATraps.this.cannotTpaToSelf.replace("&", "\u00a7"));
                    return true;
                }
                AntiTPATraps.this.tpaRequests.put(target.getUniqueId(), player.getUniqueId());
                AntiTPATraps.this.tpaRequestTime.put(target.getUniqueId(), System.currentTimeMillis());
                player.sendMessage(AntiTPATraps.this.tpaRequestSent.replace("%target%", target.getName()).replace("&", "\u00a7"));
                target.sendMessage(AntiTPATraps.this.tpaRequestReceived.replace("%sender%", player.getName()).replace("&", "\u00a7"));
                if (AntiTPATraps.this.enableTpaWarning) {
                    player.sendMessage(AntiTPATraps.this.tpaRequestWarningMessage.replace("&", "\u00a7"));
                }
            } else if (cmdName.equals("tpaccept")) {
                if (args.length > 0) {
                    Player specificSender = AntiTPATraps.this.getServer().getPlayer(args[0]);
                    if (specificSender == null || !specificSender.isOnline()) {
                        player.sendMessage(AntiTPATraps.this.playerNotFound.replace("&", "\u00a7"));
                        return true;
                    }
                    if (!AntiTPATraps.this.tpaRequests.containsKey(player.getUniqueId()) || !((UUID)AntiTPATraps.this.tpaRequests.get(player.getUniqueId())).equals(specificSender.getUniqueId())) {
                        player.sendMessage(AntiTPATraps.this.tpaNoPendingRequest.replace("&", "\u00a7"));
                        return true;
                    }
                } else if (!AntiTPATraps.this.tpaRequests.containsKey(player.getUniqueId())) {
                    player.sendMessage(AntiTPATraps.this.tpaNoPendingRequest.replace("&", "\u00a7"));
                    return true;
                }
                UUID senderUUID = (UUID)AntiTPATraps.this.tpaRequests.get(player.getUniqueId());
                Player senderPlayer = AntiTPATraps.this.getServer().getPlayer(senderUUID);
                if (senderPlayer == null || !senderPlayer.isOnline()) {
                    player.sendMessage(AntiTPATraps.this.playerNotFound.replace("&", "\u00a7"));
                    AntiTPATraps.this.tpaRequests.remove(player.getUniqueId());
                    AntiTPATraps.this.tpaRequestTime.remove(player.getUniqueId());
                    return true;
                }
                long timeElapsed = (System.currentTimeMillis() - (Long)AntiTPATraps.this.tpaRequestTime.get(player.getUniqueId())) / 1000L;
                if (timeElapsed > (long)AntiTPATraps.this.tpaTimeoutSeconds) {
                    player.sendMessage(AntiTPATraps.this.tpaRequestTimedOut.replace("&", "\u00a7"));
                    senderPlayer.sendMessage(AntiTPATraps.this.tpaRequestTimedOut.replace("&", "\u00a7"));
                    AntiTPATraps.this.tpaRequests.remove(player.getUniqueId());
                    AntiTPATraps.this.tpaRequestTime.remove(player.getUniqueId());
                    return true;
                }
                if (AntiTPATraps.this.isTrapLocation(player.getLocation(), senderPlayer)) {
                    player.sendMessage(AntiTPATraps.this.trapDetectedMessage.replace("&", "\u00a7"));
                    senderPlayer.sendMessage(AntiTPATraps.this.trapDetectedMessage.replace("&", "\u00a7"));
                    AntiTPATraps.this.getLogger().info(senderPlayer.getName() + " attempted to TPA into a trap (via custom TPA) at " + player.getLocation().getBlockX() + "," + player.getLocation().getBlockY() + "," + player.getLocation().getBlockZ());
                    AntiTPATraps.this.tpaRequests.remove(player.getUniqueId());
                    AntiTPATraps.this.tpaRequestTime.remove(player.getUniqueId());
                    return true;
                }
                player.sendMessage(AntiTPATraps.this.tpaRequestAccepted.replace("&", "\u00a7"));
                senderPlayer.sendMessage(AntiTPATraps.this.tpaRequestAccepted.replace("&", "\u00a7"));
                senderPlayer.teleport(player.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                if (AntiTPATraps.this.enableTpaWarning) {
                    player.sendMessage(AntiTPATraps.this.tpaAcceptWarningMessage.replace("&", "\u00a7"));
                }
                AntiTPATraps.this.tpaRequests.remove(player.getUniqueId());
                AntiTPATraps.this.tpaRequestTime.remove(player.getUniqueId());
            } else if (cmdName.equals("tpadeny")) {
                if (!AntiTPATraps.this.tpaRequests.containsKey(player.getUniqueId())) {
                    player.sendMessage(AntiTPATraps.this.tpaNoPendingRequest.replace("&", "\u00a7"));
                    return true;
                }
                UUID senderUUID = (UUID)AntiTPATraps.this.tpaRequests.get(player.getUniqueId());
                Player senderPlayer = AntiTPATraps.this.getServer().getPlayer(senderUUID);
                player.sendMessage(AntiTPATraps.this.tpaRequestDenied.replace("&", "\u00a7"));
                if (senderPlayer != null && senderPlayer.isOnline()) {
                    senderPlayer.sendMessage(AntiTPATraps.this.tpaRequestDenied.replace("&", "\u00a7"));
                }
                AntiTPATraps.this.tpaRequests.remove(player.getUniqueId());
                AntiTPATraps.this.tpaRequestTime.remove(player.getUniqueId());
            } else if (cmdName.equals("tpahere")) {
                if (args.length != 1) {
                    player.sendMessage("C\u00fa ph\u00e1p: /tpahere <t\u00ean_ng\u01b0\u1eddi_ch\u01a1i>");
                    return true;
                }
                Player target = AntiTPATraps.this.getServer().getPlayer(args[0]);
                if (target == null || !target.isOnline()) {
                    player.sendMessage(AntiTPATraps.this.playerNotFound.replace("&", "\u00a7"));
                    return true;
                }
                if (player.getUniqueId().equals(target.getUniqueId())) {
                    player.sendMessage(AntiTPATraps.this.cannotTpaToSelf.replace("&", "\u00a7"));
                    return true;
                }
                AntiTPATraps.this.tpaRequests.put(target.getUniqueId(), player.getUniqueId());
                AntiTPATraps.this.tpaRequestTime.put(target.getUniqueId(), System.currentTimeMillis());
                player.sendMessage(AntiTPATraps.this.tpaRequestSent.replace("%target%", target.getName()).replace("&", "\u00a7"));
                target.sendMessage(AntiTPATraps.this.tpaRequestReceived.replace("%sender%", player.getName() + " (TPA Here)").replace("&", "\u00a7"));
                if (AntiTPATraps.this.enableTpaWarning) {
                    player.sendMessage(AntiTPATraps.this.tpaRequestWarningMessage.replace("&", "\u00a7"));
                }
            }
            return true;
        }
    }
}

