/*
 * Decompiled with CFR 0.152.
 */
package com.abcsnoob.mc.safetpa.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class LangManager {
    private static YamlConfiguration lang;

    public static void load(File dataFolder) {
        try {
            File f;
            File dir = new File(dataFolder, "lang");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(f = new File(dir, "vi-vn.yml")).exists()) {
                try (InputStream in = LangManager.class.getResourceAsStream("/lang/vi-vn.yml");){
                    if (in != null) {
                        Files.copy(in, f.toPath(), new CopyOption[0]);
                    } else {
                        System.err.println("[LangManager] Kh\u00f4ng t\u00ecm th\u1ea5y resource /lang/vi-vn.yml");
                    }
                }
            }
            lang = YamlConfiguration.loadConfiguration((File)f);
        }
        catch (IOException e) {
            e.printStackTrace();
            lang = new YamlConfiguration();
        }
    }

    public static String get(String key) {
        if (lang == null) {
            return key;
        }
        String s = lang.getString(key);
        return s == null ? key : s;
    }

    public static String format(String key, Map<String, String> placeholders) {
        String raw = LangManager.get(key);
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                raw = raw.replace("{" + e.getKey() + "}", e.getValue());
            }
        }
        return raw;
    }
}

