/*
 * Decompiled with CFR 0.152.
 */
package com.abcsnoob.mc.safetpa.events;

import com.abcsnoob.mc.safetpa.data.TpaRequest;
import com.abcsnoob.mc.safetpa.utils.LangManager;
import com.abcsnoob.mc.safetpa.utils.TpaManager;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener
implements Listener {
    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        if (!TpaManager.hasRequest(player.getUniqueId())) {
            return;
        }
        TpaRequest request = TpaManager.getRequestFor(player.getUniqueId());
        if (request == null) {
            return;
        }
        Location saved = request.getSavedTargetLocation();
        if (saved == null) {
            return;
        }
        Location current = player.getLocation();
        if (saved.getWorld() != current.getWorld()) {
            TpaManager.removeRequest(player.getUniqueId());
            player.sendMessage(LangManager.get("messages.tpa_cancelled_move"));
            return;
        }
        double distance = saved.distance(current);
        if (distance > 1.0) {
            TpaManager.removeRequest(player.getUniqueId());
            player.sendMessage(LangManager.get("messages.tpa_cancelled_move"));
        }
    }
}

