/*
 * Decompiled with CFR 0.152.
 */
package com.zirstatix.ddosguard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.player.PlayerLoginEvent;

public class ConnectionLimiter {
    private final FileConfiguration config;
    private final Map<String, Integer> connectionCounts;

    public ConnectionLimiter(FileConfiguration config) {
        this.config = config;
        this.connectionCounts = new HashMap<String, Integer>();
    }

    public String getRealIP(PlayerLoginEvent event) {
        String realIp = event.getRealAddress().getHostAddress();
        String forwardedIp = event.getHostname();
        if (forwardedIp != null && forwardedIp.contains("X-Forwarded-For")) {
            realIp = forwardedIp.split(":")[1].trim();
        }
        return realIp;
    }

    public boolean isAllowed(String ip) {
        int maxConnections = this.config.getInt("max-connections");
        boolean allowProxies = this.config.getBoolean("allow-proxies");
        List whitelistedIPs = this.config.getStringList("whitelisted-ips");
        if (whitelistedIPs.contains(ip)) {
            return true;
        }
        if (maxConnections == 0) {
            return false;
        }
        if (this.connectionCounts.getOrDefault(ip, 0) >= maxConnections) {
            return allowProxies || !this.isProxy(ip);
        }
        return true;
    }

    public boolean isProxy(String ip) {
        return false;
    }

    public void trackConnection(String ip) {
        this.connectionCounts.put(ip, this.connectionCounts.getOrDefault(ip, 0) + 1);
    }

    public String getKickMessage(String ip) {
        if (this.isProxy(ip)) {
            return this.config.getString("proxy-kick-message");
        }
        return this.config.getString("kick-message");
    }

    public void decrementConnection(String ip) {
        int currentConnections = this.connectionCounts.getOrDefault(ip, 0);
        if (currentConnections > 0) {
            this.connectionCounts.put(ip, currentConnections - 1);
        }
    }
}

