/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.bluecolored.bluemap.api.BlueMapAPI;
import fr.xyness.SCS.CPlayerMain;
import fr.xyness.SCS.ClaimBossBar;
import fr.xyness.SCS.ClaimMain;
import fr.xyness.SCS.Commands.ClaimCommand;
import fr.xyness.SCS.Commands.ClaimsCommand;
import fr.xyness.SCS.Commands.ProtectedAreaCommand;
import fr.xyness.SCS.Commands.ScsCommand;
import fr.xyness.SCS.Commands.UnclaimCommand;
import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.Config.ClaimLanguage;
import fr.xyness.SCS.Config.ClaimPurge;
import fr.xyness.SCS.Config.ClaimSettings;
import fr.xyness.SCS.Listeners.ClaimEvents;
import fr.xyness.SCS.Listeners.ClaimEventsEnterLeave;
import fr.xyness.SCS.Listeners.ClaimGuiEvents;
import fr.xyness.SCS.Listeners.FoliaClaimEvents;
import fr.xyness.SCS.Listeners.PaperClaimEvents;
import fr.xyness.SCS.Listeners.SpigotClaimEvents;
import fr.xyness.SCS.Support.ClaimBluemap;
import fr.xyness.SCS.Support.ClaimDynmap;
import fr.xyness.SCS.Support.ClaimPl3xMap;
import fr.xyness.SCS.Support.ClaimPlaceholdersExpansion;
import fr.xyness.SCS.Support.ClaimVault;
import fr.xyness.SCS.Support.ClaimWorldGuard;
import fr.xyness.SCS.Support.ClaimbStats;
import fr.xyness.SCS.Types.WorldMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class SimpleClaimSystem
extends JavaPlugin {
    private ClaimDynmap dynmapInstance;
    private ClaimBluemap bluemapInstance;
    private ClaimPl3xMap pl3xmapInstance;
    private ClaimWorldGuard claimWorldguardInstance;
    private ClaimVault claimVaultInstance;
    private ClaimbStats bStatsInstance;
    private ClaimMain claimInstance;
    private ClaimGuis claimGuisInstance;
    private ClaimSettings claimSettingsInstance;
    private ClaimLanguage claimLanguageInstance;
    private ClaimPurge claimPurgeInstance;
    private CPlayerMain cPlayerMainInstance;
    private ClaimBossBar claimBossBarInstance;
    private SimpleClaimSystem instance;
    private String Version = "1.12.3.3";
    private HikariDataSource dataSource;
    private boolean isFolia = false;
    private boolean isPaper = false;
    private String minecraftVersion;
    private boolean isUpdateAvailable;
    private String updateMessage;
    private ConsoleCommandSender logger = Bukkit.getConsoleSender();

    public void onEnable() {
        this.instance = this;
        this.info("==========================================================================");
        if (this.loadConfig(false, (CommandSender)Bukkit.getConsoleSender())) {
            this.info(" ");
            this.info("SimpleClaimSystem is enabled !");
            this.info("Discord for support : https://discord.gg/6sRTGprM95");
            this.info("Documentation : https://xyness.gitbook.io/simpleclaimsystem");
            this.info("Developped by Xyness");
        } else {
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.info("==========================================================================");
    }

    public void onDisable() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
        Bukkit.getOnlinePlayers().forEach(p -> this.claimBossBarInstance.disableBossBar((Player)p));
        this.info("==========================================================================");
        this.info("SimpleClaimSystem is disabled !");
        this.info("Discord for support : https://discord.gg/6sRTGprM95");
        this.info("Documentation : https://xyness.gitbook.io/simpleclaimsystem");
        this.info("Developped by Xyness");
        this.info("==========================================================================");
    }

    public void onLoad() {
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.claimWorldguardInstance = new ClaimWorldGuard();
            this.claimWorldguardInstance.registerCustomFlag();
        }
    }

    public boolean loadConfig(boolean reload, CommandSender sender) {
        boolean[] status = new boolean[]{true};
        Runnable reloadTask = () -> {
            BarStyle style;
            Object sql;
            Statement stmt;
            Connection connection;
            HikariConfig configH;
            if (reload) {
                sender.sendMessage(this.getLanguage().getMessage("reload-attempt"));
                this.info("==========================================================================");
            }
            this.saveDefaultConfig();
            this.reloadConfig();
            this.info(String.valueOf(ChatColor.AQUA) + "  ___   ___   ___ ");
            this.info(String.valueOf(ChatColor.AQUA) + " / __| / __| / __|  " + String.valueOf(ChatColor.DARK_GREEN) + "SimpleClaimSystem " + String.valueOf(ChatColor.AQUA) + "v" + this.Version);
            if (this.getConfig().getBoolean("check-for-updates")) {
                this.info(String.valueOf(ChatColor.AQUA) + " \\__ \\ \u2223(__  \\__ \\  " + String.valueOf(ChatColor.GRAY) + this.checkForUpdates());
            } else {
                this.info(String.valueOf(ChatColor.AQUA) + " \\__ \\ \u2223(__  \\__ \\  " + String.valueOf(ChatColor.GRAY) + "Updates checker is disabled");
            }
            this.info(String.valueOf(ChatColor.AQUA) + " |___/ \\___| |___/  " + String.valueOf(ChatColor.DARK_GRAY) + "Running on " + Bukkit.getVersion());
            this.info(" ");
            if (reload) {
                HandlerList.unregisterAll((Plugin)this);
                this.claimInstance.clearAll();
                this.claimSettingsInstance.clearAll();
                this.cPlayerMainInstance.clearAll();
                this.claimBossBarInstance.clearAll();
            } else {
                this.claimInstance = new ClaimMain(this);
                this.claimGuisInstance = new ClaimGuis(this);
                this.claimSettingsInstance = new ClaimSettings();
                this.cPlayerMainInstance = new CPlayerMain(this);
                this.claimLanguageInstance = new ClaimLanguage(this);
                this.claimBossBarInstance = new ClaimBossBar(this);
                this.bStatsInstance = new ClaimbStats();
                this.bStatsInstance.enableMetrics(this);
            }
            this.updateConfigWithDefaults();
            this.checkFolia();
            this.checkPaper();
            this.checkMinecraftVersion();
            if (Bukkit.getPluginManager().getPlugin("GriefPrevention") != null) {
                this.claimSettingsInstance.addSetting("griefprevention", "true");
            } else {
                this.claimSettingsInstance.addSetting("griefprevention", "false");
            }
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                this.claimSettingsInstance.addSetting("placeholderapi", "true");
                if (!reload) {
                    new ClaimPlaceholdersExpansion(this).register();
                }
            } else {
                this.claimSettingsInstance.addSetting("placeholderapi", "false");
            }
            if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
                this.claimSettingsInstance.addSetting("worldguard", "true");
            } else {
                this.claimSettingsInstance.addSetting("worldguard", "false");
            }
            boolean[] check_vault = new boolean[]{false};
            if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                this.claimVaultInstance = new ClaimVault();
                if (this.claimVaultInstance.setupEconomy()) {
                    this.claimSettingsInstance.addSetting("vault", "true");
                    check_vault[0] = true;
                } else {
                    this.claimSettingsInstance.addSetting("vault", "false");
                }
            } else {
                this.claimSettingsInstance.addSetting("vault", "false");
            }
            Plugin floodgate = Bukkit.getPluginManager().getPlugin("floodgate");
            if (floodgate != null) {
                this.claimSettingsInstance.addSetting("floodgate", "true");
            } else {
                this.claimSettingsInstance.addSetting("floodgate", "false");
            }
            Plugin dynmap = Bukkit.getPluginManager().getPlugin("dynmap");
            if (dynmap != null) {
                this.claimSettingsInstance.addSetting("dynmap", "true");
            } else {
                this.claimSettingsInstance.addSetting("dynmap", "false");
            }
            Plugin bluemap = Bukkit.getPluginManager().getPlugin("bluemap");
            if (bluemap != null) {
                this.claimSettingsInstance.addSetting("bluemap", "true");
            } else {
                this.claimSettingsInstance.addSetting("bluemap", "false");
            }
            Plugin pl3xmap = Bukkit.getPluginManager().getPlugin("pl3xmap");
            if (pl3xmap != null) {
                this.claimSettingsInstance.addSetting("pl3xmap", "true");
            } else {
                this.claimSettingsInstance.addSetting("pl3xmap", "false");
            }
            File dossier = new File(this.getDataFolder(), "langs");
            if (!dossier.exists()) {
                dossier.mkdirs();
            }
            this.claimSettingsInstance.addSetting("check-for-updates", this.getConfig().getString("check-for-updates"));
            this.claimSettingsInstance.addSetting("updates-notifications", this.getConfig().getString("updates-notifications"));
            this.checkAndSaveResource("langs/en_US.yml");
            this.updateLangFileWithMissingKeys("en_US.yml");
            String lang = this.getConfig().getString("lang");
            File custom = new File(String.valueOf(this.getDataFolder()) + File.separator + "langs", lang);
            if (!custom.exists()) {
                this.info(String.valueOf(ChatColor.RED) + "File '" + lang + "' not found, using en_US.yml");
                lang = "en_US.yml";
            } else {
                this.updateLangFileWithMissingKeys(lang);
            }
            this.claimSettingsInstance.addSetting("lang", lang);
            File lang_final = new File(String.valueOf(this.getDataFolder()) + File.separator + "langs", lang);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)lang_final);
            HashMap<String, String> messages = new HashMap<String, String>();
            for (String key : config.getKeys(false)) {
                if (key.equals("help-command")) {
                    ConfigurationSection configHelp = config.getConfigurationSection("help-command");
                    for (String help : configHelp.getKeys(false)) {
                        messages.put("help-command." + help, configHelp.getString(help));
                    }
                    continue;
                }
                String value = config.getString(key);
                messages.put(key, value);
            }
            this.claimLanguageInstance.setLanguage(messages);
            HashMap<String, LinkedHashMap<String, Boolean>> defaultSettings = new HashMap<String, LinkedHashMap<String, Boolean>>();
            LinkedHashMap<String, Boolean> v = new LinkedHashMap<String, Boolean>();
            ConfigurationSection statusSettings = this.getConfig().getConfigurationSection("default-values-settings");
            for (String key : statusSettings.getKeys(false)) {
                ConfigurationSection statusSettingsSub = statusSettings.getConfigurationSection(key);
                v = new LinkedHashMap();
                for (String subkey : statusSettingsSub.getKeys(false)) {
                    v.put(subkey, statusSettingsSub.getBoolean(subkey));
                }
                defaultSettings.put(key.toLowerCase(), v);
            }
            this.claimSettingsInstance.setDefaultValues(defaultSettings);
            this.loadGuis();
            String configC = this.getConfig().getString("database");
            if (configC.equalsIgnoreCase("true")) {
                configH = new HikariConfig();
                configH.setJdbcUrl("jdbc:mysql://" + this.getConfig().getString("database-settings.hostname") + ":" + this.getConfig().getString("database-settings.port") + "/" + this.getConfig().getString("database-settings.database_name"));
                configH.setUsername(this.getConfig().getString("database-settings.username"));
                configH.setPassword(this.getConfig().getString("database-settings.password"));
                configH.addDataSourceProperty("cachePrepStmts", "true");
                configH.addDataSourceProperty("prepStmtCacheSize", "250");
                configH.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
                configH.addDataSourceProperty("useServerPrepStmts", "true");
                configH.setPoolName("MySQL");
                configH.setMaximumPoolSize(10);
                configH.setMinimumIdle(2);
                configH.setIdleTimeout(60000L);
                configH.setMaxLifetime(600000L);
                this.dataSource = new HikariDataSource(configH);
                try {
                    connection = this.dataSource.getConnection();
                    try {
                        this.info("Database connection successful.");
                        try {
                            stmt = connection.createStatement();
                            try {
                                sql = "CREATE TABLE IF NOT EXISTS scs_claims_1 (id INT AUTO_INCREMENT PRIMARY KEY, id_claim INT NOT NULL, owner_uuid VARCHAR(36) NOT NULL, owner_name VARCHAR(36) NOT NULL, claim_name VARCHAR(255) NOT NULL, claim_description VARCHAR(255) NOT NULL, chunks TEXT NOT NULL, world_name VARCHAR(255) NOT NULL, location VARCHAR(255) NOT NULL, members TEXT NOT NULL, permissions VARCHAR(510) NOT NULL, for_sale TINYINT(1) NOT NULL DEFAULT 0, sale_price DOUBLE NOT NULL DEFAULT 0, bans TEXT NOT NULL DEFAULT '')";
                                stmt.executeUpdate((String)sql);
                                sql = "CREATE TABLE IF NOT EXISTS scs_players (id INT AUTO_INCREMENT PRIMARY KEY, uuid_server VARCHAR(36) NOT NULL UNIQUE, uuid_mojang VARCHAR(36) NOT NULL, player_name VARCHAR(36) NOT NULL, player_head TEXT NOT NULL, player_textures TEXT NOT NULL)";
                                stmt.executeUpdate((String)sql);
                                sql = "UPDATE scs_claims_1 SET owner_uuid = '" + ClaimMain.SERVER_UUID.toString() + "' WHERE owner_uuid = 'none';";
                                stmt.executeUpdate((String)sql);
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            this.info(String.valueOf(ChatColor.RED) + "Error creating tables, using local db.");
                            configC = "false";
                        }
                        DatabaseMetaData metaData = connection.getMetaData();
                        try (ResultSet resultSet = metaData.getTables(null, null, "scs_claims", new String[]{"TABLE"});){
                            if (resultSet.next()) {
                                this.claimInstance.convertDistantToNewDistant();
                            }
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.info(String.valueOf(ChatColor.RED) + "Error connecting to database, using local db.");
                    configC = "false";
                }
            }
            if (configC.equals("false")) {
                configH = new HikariConfig();
                configH.setJdbcUrl("jdbc:sqlite:plugins/SimpleClaimSystem/storage.db");
                configH.addDataSourceProperty("cachePrepStmts", "true");
                configH.addDataSourceProperty("prepStmtCacheSize", "250");
                configH.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
                configH.setPoolName("SQLitePool");
                configH.setMaximumPoolSize(10);
                configH.setMinimumIdle(2);
                configH.setIdleTimeout(60000L);
                configH.setMaxLifetime(600000L);
                this.dataSource = new HikariDataSource(configH);
                try {
                    connection = this.dataSource.getConnection();
                    try {
                        try {
                            stmt = connection.createStatement();
                            try {
                                sql = "CREATE TABLE IF NOT EXISTS scs_claims_1 (id INTEGER PRIMARY KEY AUTOINCREMENT, id_claim INT NOT NULL, owner_uuid VARCHAR(36) NOT NULL, owner_name VARCHAR(36) NOT NULL, claim_name VARCHAR(255) NOT NULL, claim_description VARCHAR(255) NOT NULL, chunks TEXT NOT NULL, world_name VARCHAR(255) NOT NULL, location VARCHAR(255) NOT NULL, members TEXT NOT NULL, permissions VARCHAR(510) NOT NULL, for_sale TINYINT(1) NOT NULL DEFAULT 0, sale_price DOUBLE NOT NULL DEFAULT 0, bans TEXT NOT NULL DEFAULT '')";
                                stmt.executeUpdate((String)sql);
                                sql = "CREATE TABLE IF NOT EXISTS scs_players (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid_server VARCHAR(36) NOT NULL UNIQUE, uuid_mojang VARCHAR(36) NOT NULL, player_name VARCHAR(36) NOT NULL, player_head TEXT NOT NULL, player_textures TEXT NOT NULL)";
                                stmt.executeUpdate((String)sql);
                                sql = "UPDATE scs_claims_1 SET owner_uuid = '" + ClaimMain.SERVER_UUID.toString() + "' WHERE owner_uuid = 'none';";
                                stmt.executeUpdate((String)sql);
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            this.info(String.valueOf(ChatColor.RED) + "Error creating tables, disabling plugin");
                            status[0] = false;
                            if (connection != null) {
                                connection.close();
                            }
                            return;
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.info(String.valueOf(ChatColor.RED) + "Error creating tables, disabling plugin");
                    status[0] = false;
                    return;
                }
                String databasePath = "plugins/SimpleClaimSystem/claims.db";
                File databaseFile = new File(databasePath);
                if (databaseFile.exists()) {
                    this.claimInstance.convertLocalToNewLocal();
                }
            }
            this.claimSettingsInstance.addSetting("database", configC);
            configC = this.getConfig().getString("auto-purge");
            this.claimSettingsInstance.addSetting("auto-purge", configC);
            if (configC.equals("true")) {
                configC = this.getConfig().getString("auto-purge-checking");
                this.claimSettingsInstance.addSetting("auto-purge-checking", configC);
                try {
                    int minutes = Integer.parseInt(configC);
                    if (minutes < 1) {
                        this.info(String.valueOf(ChatColor.RED) + "'auto-purge-checking' must be a correct number (integer and > 0). Using default value.");
                        minutes = 60;
                    }
                    configC = this.getConfig().getString("auto-purge-time-without-login");
                    this.claimSettingsInstance.addSetting("auto-purge-time-without-login", configC);
                    this.claimPurgeInstance = new ClaimPurge(this);
                    this.claimPurgeInstance.startPurge(minutes, configC);
                }
                catch (NumberFormatException e) {
                    this.info(String.valueOf(ChatColor.RED) + "'auto-purge-checking' must be a correct number (integer and > 0). Using default value.");
                    int minutes = 60;
                    configC = this.getConfig().getString("auto-purge-time-without-login");
                    this.claimSettingsInstance.addSetting("auto-purge-time-without-login", configC);
                    this.claimPurgeInstance = new ClaimPurge(this);
                    this.claimPurgeInstance.startPurge(minutes, configC);
                }
            } else if (this.claimPurgeInstance != null) {
                this.claimPurgeInstance.stopPurge();
            }
            ArrayList<String> aliases_claim = this.getConfig().getStringList("command-aliases.claim");
            ArrayList<String> aliases_unclaim = this.getConfig().getStringList("command-aliases.unclaim");
            ArrayList<String> aliases_claims = this.getConfig().getStringList("command-aliases.claims");
            if (aliases_claim == null) {
                this.info(String.valueOf(ChatColor.RED) + "'aliases_claim' is missing in config. Using default value.");
                aliases_claim = new ArrayList<String>();
                aliases_claim.add("/territory");
            }
            if (aliases_unclaim == null) {
                this.info(String.valueOf(ChatColor.RED) + "'aliases_unclaim' is missing in config. Using default value.");
                aliases_unclaim = new ArrayList<String>();
                aliases_unclaim.add("/unterritory");
            }
            if (aliases_claims == null) {
                this.info(String.valueOf(ChatColor.RED) + "'aliases_claims' is missing in config. Using default value.");
                aliases_claims = new ArrayList<String>();
                aliases_claims.add("/territories");
            }
            for (String command : aliases_claim) {
                this.claimSettingsInstance.addAliase(command, "/claim");
            }
            for (String command : aliases_unclaim) {
                this.claimSettingsInstance.addAliase(command, "/unclaim");
            }
            for (String command : aliases_claims) {
                this.claimSettingsInstance.addAliase(command, "/claims");
            }
            ConfigurationSection worldsAliasesSection = this.getConfig().getConfigurationSection("world-aliases");
            LinkedHashMap<String, String> worldsAliases = new LinkedHashMap<String, String>();
            for (String key : worldsAliasesSection.getKeys(false)) {
                worldsAliases.put(key, worldsAliasesSection.getString(key));
            }
            this.claimSettingsInstance.setWorldAliases(worldsAliases);
            configC = this.getConfig().getString("dynmap");
            if (configC.equalsIgnoreCase("true") && this.claimSettingsInstance.getBooleanSetting("dynmap")) {
                DynmapAPI dynmapAPI;
                MarkerAPI markerAPI;
                if (!reload && (markerAPI = (dynmapAPI = (DynmapAPI)dynmap).getMarkerAPI()) != null) {
                    MarkerSet markerSet = markerAPI.createMarkerSet("SimpleClaimSystem", "Claims", null, false);
                    this.dynmapInstance = new ClaimDynmap(markerSet, this);
                }
            } else {
                this.claimSettingsInstance.addSetting("dynmap", "false");
            }
            this.claimSettingsInstance.addSetting("dynmap-claim-border-color", this.getConfig().getString("dynmap-settings.claim-border-color"));
            this.claimSettingsInstance.addSetting("dynmap-claim-fill-color", this.getConfig().getString("dynmap-settings.claim-fill-color"));
            this.claimSettingsInstance.addSetting("dynmap-claim-hover-text", this.getConfig().getString("dynmap-settings.claim-hover-text"));
            configC = this.getConfig().getString("bluemap");
            if (configC.equalsIgnoreCase("true") && this.claimSettingsInstance.getBooleanSetting("bluemap")) {
                if (!reload) {
                    Optional apiO = BlueMapAPI.getInstance();
                    if (apiO.isPresent()) {
                        this.bluemapInstance = new ClaimBluemap((BlueMapAPI)apiO.get(), this);
                    } else {
                        BlueMapAPI.onEnable(task -> {
                            Optional apiCheck = BlueMapAPI.getInstance();
                            if (apiCheck.isPresent()) {
                                this.claimSettingsInstance.addSetting("bluemap", "true");
                                this.bluemapInstance = new ClaimBluemap((BlueMapAPI)apiCheck.get(), this);
                            }
                        });
                        this.claimSettingsInstance.addSetting("bluemap", "false");
                    }
                }
            } else {
                this.claimSettingsInstance.addSetting("bluemap", "false");
            }
            this.claimSettingsInstance.addSetting("bluemap-claim-border-color", this.getConfig().getString("bluemap-settings.claim-border-color"));
            this.claimSettingsInstance.addSetting("bluemap-claim-fill-color", this.getConfig().getString("bluemap-settings.claim-fill-color"));
            this.claimSettingsInstance.addSetting("bluemap-claim-hover-text", this.getConfig().getString("bluemap-settings.claim-hover-text"));
            configC = this.getConfig().getString("pl3xmap");
            if (configC.equalsIgnoreCase("true") && this.claimSettingsInstance.getBooleanSetting("pl3xmap")) {
                if (!reload) {
                    this.pl3xmapInstance = new ClaimPl3xMap(this);
                }
            } else {
                this.claimSettingsInstance.addSetting("pl3xmap", "false");
            }
            this.claimSettingsInstance.addSetting("pl3xmap-claim-border-color", this.getConfig().getString("pl3xmap-settings.claim-border-color"));
            this.claimSettingsInstance.addSetting("pl3xmap-claim-fill-color", this.getConfig().getString("pl3xmap-settings.claim-fill-color"));
            this.claimSettingsInstance.addSetting("pl3xmap-claim-hover-text", this.getConfig().getString("pl3xmap-settings.claim-hover-text"));
            configC = this.getConfig().getString("protection-message");
            if (configC.equalsIgnoreCase("action_bar") || configC.equalsIgnoreCase("title") || configC.equalsIgnoreCase("subtitle") || configC.equalsIgnoreCase("chat") || configC.equalsIgnoreCase("bossbar")) {
                this.claimSettingsInstance.addSetting("protection-message", configC);
            } else {
                this.info(String.valueOf(ChatColor.RED) + "'protection-message' must be 'ACTION_BAR', 'TITLE', 'SUBTITLE', 'CHAT' or 'BOSSBAR'. Using default value.");
                this.claimSettingsInstance.addSetting("protection-message", "ACTION_BAR");
            }
            ConfigurationSection worldsSection = this.getConfig().getConfigurationSection("claims-worlds-mode");
            LinkedHashMap<String, WorldMode> worlds = new LinkedHashMap<String, WorldMode>();
            for (Object key : worldsSection.getKeys(false)) {
                WorldMode mode;
                try {
                    mode = WorldMode.valueOf(worldsSection.getString((String)key));
                    if (mode == null) {
                        this.info(String.valueOf(ChatColor.RED) + "Invalid world mode for '" + (String)key + "', using default mode.");
                        mode = WorldMode.SURVIVAL;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid world mode for '" + (String)key + "', using default mode.");
                    mode = WorldMode.SURVIVAL;
                }
                worlds.put((String)key, mode);
            }
            if (this.getConfig().contains("worlds-disabled")) {
                List disabledWorlds = this.getConfig().getStringList("worlds-disabled");
                for (String world : disabledWorlds) {
                    this.getConfig().set("claims-worlds-mode." + world, (Object)"DISABLED");
                    worlds.put(world, WorldMode.DISABLED);
                }
                this.getConfig().set("worlds-disabled", null);
            }
            this.claimSettingsInstance.setWorlds(worlds);
            this.claimSettingsInstance.addSetting("keep-chunks-loaded", this.getConfig().getString("keep-chunks-loaded"));
            this.claimSettingsInstance.addSetting("max-length-claim-name", this.getConfig().getString("max-length-claim-name"));
            this.claimSettingsInstance.addSetting("max-length-claim-description", this.getConfig().getString("max-length-claim-description"));
            this.claimSettingsInstance.addSetting("claim-invitations-system", this.getConfig().getString("claim-invitations-system"));
            this.claimSettingsInstance.addSetting("claim-invitation-expiration-delay", this.getConfig().getString("claim-invitation-expiration-delay"));
            this.claimSettingsInstance.addSetting("claim-confirmation", this.getConfig().getString("claim-confirmation"));
            this.claimSettingsInstance.addSetting("claim-particles", this.getConfig().getString("claim-particles"));
            this.claimSettingsInstance.addSetting("claim-particles-not-enter", this.getConfig().getString("claim-particles-not-enter"));
            this.claimSettingsInstance.addSetting("claim-fly-disabled-on-damage", this.getConfig().getString("claim-fly-disabled-on-damage"));
            this.claimSettingsInstance.addSetting("claim-fly-message-auto-fly", this.getConfig().getString("claim-fly-message-auto-fly"));
            this.claimSettingsInstance.addSetting("enter-leave-messages", this.getConfig().getString("enter-leave-messages"));
            this.claimSettingsInstance.addSetting("enter-leave-title-messages", this.getConfig().getString("enter-leave-title-messages"));
            this.claimSettingsInstance.addSetting("enter-leave-chat-messages", this.getConfig().getString("enter-leave-chat-messages"));
            this.claimSettingsInstance.addSetting("claims-visitors-off-visible", this.getConfig().getString("claims-visitors-off-visible"));
            if (this.isFolia) {
                this.info(String.valueOf(ChatColor.RED) + "'/claim fly' command disabled because the server is running on Folia.");
            }
            if ((configC = this.getConfig().getString("map-type").toLowerCase()).equals("scoreboard") && this.isFolia) {
                this.info(String.valueOf(ChatColor.RED) + "'map-type' set to 'CHAT' because the server is running on Folia.");
                configC = "chat";
            }
            this.claimSettingsInstance.addSetting("map-type", configC);
            if (check_vault[0]) {
                this.claimSettingsInstance.addSetting("economy", this.getConfig().getString("economy"));
                this.claimSettingsInstance.addSetting("max-sell-price", this.getConfig().getString("max-sell-price"));
                this.claimSettingsInstance.addSetting("claim-cost", this.getConfig().getString("claim-cost"));
                this.claimSettingsInstance.addSetting("claim-cost-multiplier", this.getConfig().getString("claim-cost-multiplier"));
                this.claimSettingsInstance.addSetting("chunk-cost", this.getConfig().getString("chunk-cost"));
                this.claimSettingsInstance.addSetting("chunk-cost-multiplier", this.getConfig().getString("chunk-cost-multiplier"));
                this.claimSettingsInstance.addSetting("use-formatted-number", this.getConfig().getString("use-formatted-number"));
            } else {
                this.claimSettingsInstance.addSetting("economy", "false");
            }
            this.claimSettingsInstance.addSetting("announce-sale.bossbar", this.getConfig().getString("announce-sale.bossbar"));
            String barColor = this.getConfig().getString("announce-sale.bossbar-settings.color").toUpperCase();
            try {
                BarColor color = BarColor.valueOf((String)barColor);
                if (color == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color RED.");
                    barColor = "YELLOW";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color RED.");
                barColor = "YELLOW";
            }
            String barStyle = this.getConfig().getString("announce-sale.bossbar-settings.style").toUpperCase();
            try {
                style = BarStyle.valueOf((String)barStyle);
                if (style == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar style, using default style SOLID.");
                    barStyle = "SOLID";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar style, using default style SOLID.");
                barStyle = "SOLID";
            }
            this.claimSettingsInstance.addSetting("announce-sale.bossbar-settings.color", barColor);
            this.claimSettingsInstance.addSetting("announce-sale.bossbar-settings.style", barStyle);
            this.claimSettingsInstance.addSetting("announce-sale.chat", this.getConfig().getString("announce-sale.chat"));
            this.claimSettingsInstance.addSetting("announce-sale.title", this.getConfig().getString("announce-sale.title"));
            this.claimSettingsInstance.addSetting("announce-sale.actionbar", this.getConfig().getString("announce-sale.actionbar"));
            configC = this.getConfig().getString("bossbar");
            this.claimSettingsInstance.addSetting("bossbar", configC);
            barColor = this.getConfig().getString("bossbar-settings.color").toUpperCase();
            try {
                BarColor color = BarColor.valueOf((String)barColor);
                if (color == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color YELLOW.");
                    barColor = "YELLOW";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color YELLOW.");
                barColor = "YELLOW";
            }
            barStyle = this.getConfig().getString("bossbar-settings.style").toUpperCase();
            try {
                style = BarStyle.valueOf((String)barStyle);
                if (style == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar style, using default style SOLID.");
                    barStyle = "SOLID";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar style, using default style SOLID.");
                barStyle = "SOLID";
            }
            this.claimSettingsInstance.addSetting("bossbar-color", barColor);
            this.claimSettingsInstance.addSetting("bossbar-style", barStyle);
            this.claimSettingsInstance.addSetting("teleportation-delay-moving", this.getConfig().getString("teleportation-delay-moving"));
            if (this.getConfig().contains("expulsion-location")) {
                if (this.getConfig().getConfigurationSection("expulsion-location").getKeys(false).isEmpty()) {
                    this.info(String.valueOf(ChatColor.RED) + "'expulsion-location' : don't forget to set it with /scs setexpulsionlocation.");
                } else {
                    String world;
                    world = Bukkit.getWorld((String)this.getConfig().getString("expulsion-location.world"));
                    if (world == null) {
                        this.info(String.valueOf(ChatColor.RED) + "'expulsion-location' : the world is incorrect.");
                        status[0] = false;
                        return;
                    }
                    double x = this.getConfig().getDouble("expulsion-location.x");
                    double y = this.getConfig().getDouble("expulsion-location.y");
                    double z = this.getConfig().getDouble("expulsion-location.z");
                    float yaw = (float)this.getConfig().getDouble("expulsion-location.yaw");
                    float pitch = (float)this.getConfig().getDouble("expulsion-location.pitch");
                    Location location = new Location((World)world, x, y, z, yaw, pitch);
                    this.claimSettingsInstance.setExpulsionLocation(location);
                }
            }
            ConfigurationSection groupsSection = this.getConfig().getConfigurationSection("groups");
            LinkedHashMap<String, String> groups = new LinkedHashMap<String, String>();
            HashMap<String, Map<String, Double>> groupsSettings = new HashMap<String, Map<String, Double>>();
            for (String key : groupsSection.getKeys(false)) {
                if (!key.equalsIgnoreCase("default")) {
                    groups.put(key, this.getConfig().getString("groups." + key + ".permission"));
                }
                HashMap<String, Double> settings = new HashMap<String, Double>();
                settings.put("max-claims", this.getConfig().getDouble("groups." + key + ".max-claims"));
                settings.put("max-radius-claims", this.getConfig().getDouble("groups." + key + ".max-radius-claims"));
                settings.put("teleportation-delay", this.getConfig().getDouble("groups." + key + ".teleportation-delay"));
                settings.put("max-members", this.getConfig().getDouble("groups." + key + ".max-members"));
                settings.put("claim-cost", this.getConfig().getDouble("groups." + key + ".claim-cost"));
                settings.put("claim-cost-multiplier", this.getConfig().getDouble("groups." + key + ".claim-cost-multiplier"));
                settings.put("max-chunks-per-claim", this.getConfig().getDouble("groups." + key + ".max-chunks-per-claim"));
                settings.put("claim-distance", this.getConfig().getDouble("groups." + key + ".claim-distance"));
                settings.put("max-chunks-total", this.getConfig().getDouble("groups." + key + ".max-chunks-total"));
                settings.put("chunk-cost", this.getConfig().getDouble("groups." + key + ".chunk-cost"));
                settings.put("chunk-cost-multiplier", this.getConfig().getDouble("groups." + key + ".chunk-cost-multiplier"));
                groupsSettings.put(key, settings);
            }
            this.claimSettingsInstance.setGroups(groups);
            this.claimSettingsInstance.setGroupsSettings(groupsSettings);
            this.getServer().getPluginManager().registerEvents((Listener)new ClaimEventsEnterLeave(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new ClaimGuiEvents(this), (Plugin)this);
            if (this.isFolia) {
                this.getServer().getPluginManager().registerEvents((Listener)new FoliaClaimEvents(this), (Plugin)this);
            } else if (this.isPaper) {
                this.getServer().getPluginManager().registerEvents((Listener)new PaperClaimEvents(this), (Plugin)this);
            } else {
                this.getServer().getPluginManager().registerEvents((Listener)new SpigotClaimEvents(this), (Plugin)this);
            }
            v = new LinkedHashMap();
            statusSettings = this.getConfig().getConfigurationSection("status-settings");
            for (String key : statusSettings.getKeys(false)) {
                v.put(key, statusSettings.getBoolean(key));
            }
            this.claimSettingsInstance.setEnabledSettings(v);
            v = new LinkedHashMap();
            statusSettings = this.getConfig().getConfigurationSection("permissions-on-SurvivalRequiringClaims");
            for (String key : statusSettings.getKeys(false)) {
                v.put(key, statusSettings.getBoolean(key));
            }
            this.claimSettingsInstance.setSurvivalRequiringClaimsSettings(v);
            this.claimSettingsInstance.setRestrictedItems(this.getConfig().getStringList("blocked-items"));
            this.claimSettingsInstance.setRestrictedContainers(this.getConfig().getStringList("blocked-interact-blocks"));
            this.claimSettingsInstance.setRestrictedEntityType(this.getConfig().getStringList("blocked-entities"));
            this.claimSettingsInstance.setSpecialBlocks(this.getConfig().getStringList("special-blocks"));
            this.claimSettingsInstance.setBreakBlocksIgnore(this.getConfig().getStringList("ignored-break-blocks"));
            this.claimSettingsInstance.setPlaceBlocksIgnore(this.getConfig().getStringList("ignored-place-blocks"));
            this.getServer().getPluginManager().registerEvents((Listener)new ClaimEvents(this), (Plugin)this);
            this.getCommand("claim").setExecutor((CommandExecutor)new ClaimCommand(this));
            this.getCommand("unclaim").setExecutor((CommandExecutor)new UnclaimCommand(this));
            this.getCommand("scs").setExecutor((CommandExecutor)new ScsCommand(this));
            this.getCommand("claims").setExecutor((CommandExecutor)new ClaimsCommand(this));
            this.getCommand("protectedarea").setExecutor((CommandExecutor)new ProtectedAreaCommand(this));
            this.saveConfig();
            this.reloadConfig();
            this.claimBossBarInstance.loadBossbarSettings();
            this.claimInstance.loadClaims();
            this.cPlayerMainInstance.loadPlayers();
            ConfigurationSection playersSection = this.getConfig().getConfigurationSection("players");
            HashMap<UUID, Map<String, Double>> playersSettings = new HashMap<UUID, Map<String, Double>>();
            for (String key : playersSection.getKeys(false)) {
                UUID uuid;
                HashMap<String, Double> settings = new HashMap<String, Double>();
                if (this.getConfig().isSet("players." + key + ".max-claims")) {
                    settings.put("max-claims", this.getConfig().getDouble("players." + key + ".max-claims"));
                }
                if (this.getConfig().isSet("players." + key + ".max-radius-claims")) {
                    settings.put("max-radius-claims", this.getConfig().getDouble("players." + key + ".max-radius-claims"));
                }
                if (this.getConfig().isSet("players." + key + ".teleportation-delay")) {
                    settings.put("teleportation-delay", this.getConfig().getDouble("players." + key + ".teleportation-delay"));
                }
                if (this.getConfig().isSet("players." + key + ".claim-cost")) {
                    settings.put("claim-cost", this.getConfig().getDouble("players." + key + ".claim-cost"));
                }
                if (this.getConfig().isSet("players." + key + ".claim-cost-multiplier")) {
                    settings.put("claim-cost-multiplier", this.getConfig().getDouble("players." + key + ".claim-cost-multiplier"));
                }
                if (this.getConfig().isSet("players." + key + ".max-chunks-per-claim")) {
                    settings.put("max-chunks-per-claim", this.getConfig().getDouble("players." + key + ".max-chunks-per-claim"));
                }
                if (this.getConfig().isSet("players." + key + ".claim-distance")) {
                    settings.put("claim-distance", this.getConfig().getDouble("players." + key + ".claim-distance"));
                }
                if (this.getConfig().isSet("players." + key + ".max-chunks-total")) {
                    settings.put("max-chunks-total", this.getConfig().getDouble("players." + key + ".max-chunks-total"));
                }
                if (this.getConfig().isSet("players." + key + ".chunk-cost")) {
                    settings.put("chunk-cost", this.getConfig().getDouble("players." + key + ".chunk-cost"));
                }
                if (this.getConfig().isSet("players." + key + ".chunk-cost-multiplier")) {
                    settings.put("chunk-cost-multiplier", this.getConfig().getDouble("players." + key + ".chunk-cost-multiplier"));
                }
                if (settings.isEmpty() || (uuid = this.cPlayerMainInstance.getPlayerUUID(key)) == null) continue;
                playersSettings.put(uuid, settings);
            }
            this.cPlayerMainInstance.setPlayersConfigSettings(playersSettings);
            if (this.isFolia) {
                Bukkit.getOnlinePlayers().forEach(p -> {
                    this.cPlayerMainInstance.addPlayerPermSetting((Player)p);
                    Bukkit.getRegionScheduler().run((Plugin)this, p.getLocation(), task -> this.claimBossBarInstance.activeBossBar((Player)p, p.getLocation().getChunk()));
                });
            } else {
                Bukkit.getOnlinePlayers().forEach(p -> {
                    this.cPlayerMainInstance.addPlayerPermSetting((Player)p);
                    this.claimBossBarInstance.activeBossBar((Player)p, p.getLocation().getChunk());
                });
            }
            if (reload) {
                this.info("==========================================================================");
                if (status[0]) {
                    sender.sendMessage(this.getLanguage().getMessage("reload-complete"));
                } else {
                    sender.sendMessage(this.getLanguage().getMessage("reload-not-complete"));
                }
            }
        };
        if (reload) {
            this.executeAsync(() -> reloadTask.run());
        } else {
            reloadTask.run();
        }
        return status[0];
    }

    public boolean reloadOnlyConfig(CommandSender sender) {
        boolean[] status = new boolean[]{true};
        this.executeAsync(() -> {
            BarStyle style;
            Object sql;
            Statement stmt;
            Connection connection;
            HikariConfig configH;
            sender.sendMessage(this.getLanguage().getMessage("config-reload-attempt"));
            this.info("==========================================================================");
            this.saveDefaultConfig();
            this.reloadConfig();
            this.claimBossBarInstance.clearAll();
            this.updateConfigWithDefaults();
            this.checkFolia();
            boolean check_vault = false;
            if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                this.claimVaultInstance = new ClaimVault();
                if (this.claimVaultInstance.setupEconomy()) {
                    this.claimSettingsInstance.addSetting("vault", "true");
                    check_vault = true;
                } else {
                    this.claimSettingsInstance.addSetting("vault", "false");
                }
            } else {
                this.claimSettingsInstance.addSetting("vault", "false");
            }
            File dossier = new File(this.getDataFolder(), "langs");
            if (!dossier.exists()) {
                dossier.mkdirs();
            }
            this.claimSettingsInstance.addSetting("check-for-updates", this.getConfig().getString("check-for-updates"));
            this.claimSettingsInstance.addSetting("updates-notifications", this.getConfig().getString("updates-notifications"));
            this.checkAndSaveResource("langs/en_US.yml");
            this.updateLangFileWithMissingKeys("en_US.yml");
            String lang = this.getConfig().getString("lang");
            File custom = new File(String.valueOf(this.getDataFolder()) + File.separator + "langs", lang);
            if (!custom.exists()) {
                this.info(String.valueOf(ChatColor.RED) + "File '" + lang + "' not found, using en_US.yml");
                lang = "en_US.yml";
            } else {
                this.updateLangFileWithMissingKeys(lang);
            }
            this.claimSettingsInstance.addSetting("lang", lang);
            File lang_final = new File(String.valueOf(this.getDataFolder()) + File.separator + "langs", lang);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)lang_final);
            HashMap<String, String> messages = new HashMap<String, String>();
            for (String key : config.getKeys(false)) {
                if (key.equals("help-command")) {
                    ConfigurationSection configHelp = config.getConfigurationSection("help-command");
                    for (String help : configHelp.getKeys(false)) {
                        messages.put("help-command." + help, configHelp.getString(help));
                    }
                    continue;
                }
                String value = config.getString(key);
                messages.put(key, value);
            }
            this.claimLanguageInstance.setLanguage(messages);
            HashMap<String, LinkedHashMap<String, Boolean>> defaultSettings = new HashMap<String, LinkedHashMap<String, Boolean>>();
            LinkedHashMap<String, Boolean> v = new LinkedHashMap<String, Boolean>();
            ConfigurationSection statusSettings = this.getConfig().getConfigurationSection("default-values-settings");
            for (String key : statusSettings.getKeys(false)) {
                ConfigurationSection statusSettingsSub = statusSettings.getConfigurationSection(key);
                v = new LinkedHashMap();
                for (String subkey : statusSettingsSub.getKeys(false)) {
                    v.put(subkey, statusSettingsSub.getBoolean(subkey));
                }
                defaultSettings.put(key.toLowerCase(), v);
            }
            this.claimSettingsInstance.setDefaultValues(defaultSettings);
            String configC = this.getConfig().getString("database");
            if (configC.equalsIgnoreCase("true")) {
                configH = new HikariConfig();
                configH.setJdbcUrl("jdbc:mysql://" + this.getConfig().getString("database-settings.hostname") + ":" + this.getConfig().getString("database-settings.port") + "/" + this.getConfig().getString("database-settings.database_name"));
                configH.setUsername(this.getConfig().getString("database-settings.username"));
                configH.setPassword(this.getConfig().getString("database-settings.password"));
                configH.addDataSourceProperty("cachePrepStmts", "true");
                configH.addDataSourceProperty("prepStmtCacheSize", "250");
                configH.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
                configH.addDataSourceProperty("useServerPrepStmts", "true");
                configH.setPoolName("MySQL");
                configH.setMaximumPoolSize(10);
                configH.setMinimumIdle(2);
                configH.setIdleTimeout(60000L);
                configH.setMaxLifetime(600000L);
                this.dataSource = new HikariDataSource(configH);
                try {
                    connection = this.dataSource.getConnection();
                    try {
                        this.info("Database connection successful.");
                        try {
                            stmt = connection.createStatement();
                            try {
                                sql = "CREATE TABLE IF NOT EXISTS scs_claims_1 (id INT AUTO_INCREMENT PRIMARY KEY, id_claim INT NOT NULL, owner_uuid VARCHAR(36) NOT NULL, owner_name VARCHAR(36) NOT NULL, claim_name VARCHAR(255) NOT NULL, claim_description VARCHAR(255) NOT NULL, chunks TEXT NOT NULL, world_name VARCHAR(255) NOT NULL, location VARCHAR(255) NOT NULL, members TEXT NOT NULL, permissions VARCHAR(510) NOT NULL, for_sale TINYINT(1) NOT NULL DEFAULT 0, sale_price DOUBLE NOT NULL DEFAULT 0, bans TEXT NOT NULL DEFAULT '')";
                                stmt.executeUpdate((String)sql);
                                sql = "CREATE TABLE IF NOT EXISTS scs_players (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid_server VARCHAR(36) NOT NULL UNIQUE, uuid_mojang VARCHAR(36) NOT NULL, player_name VARCHAR(36) NOT NULL, player_head TEXT NOT NULL, player_textures TEXT NOT NULL)";
                                stmt.executeUpdate((String)sql);
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            this.info(String.valueOf(ChatColor.RED) + "Error creating tables, using local db.");
                            configC = "false";
                        }
                        DatabaseMetaData metaData = connection.getMetaData();
                        try (ResultSet resultSet = metaData.getTables(null, null, "scs_claims", new String[]{"TABLE"});){
                            if (resultSet.next()) {
                                this.claimInstance.convertDistantToNewDistant();
                            }
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.info(String.valueOf(ChatColor.RED) + "Error connecting to database, using local db.");
                    configC = "false";
                }
            }
            if (configC.equals("false")) {
                configH = new HikariConfig();
                configH.setJdbcUrl("jdbc:sqlite:plugins/SimpleClaimSystem/storage.db");
                configH.addDataSourceProperty("cachePrepStmts", "true");
                configH.addDataSourceProperty("prepStmtCacheSize", "250");
                configH.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
                configH.setPoolName("SQLitePool");
                configH.setMaximumPoolSize(10);
                configH.setMinimumIdle(2);
                configH.setIdleTimeout(60000L);
                configH.setMaxLifetime(600000L);
                this.dataSource = new HikariDataSource(configH);
                try {
                    connection = this.dataSource.getConnection();
                    try {
                        try {
                            stmt = connection.createStatement();
                            try {
                                sql = "CREATE TABLE IF NOT EXISTS scs_claims_1 (id INTEGER PRIMARY KEY AUTOINCREMENT, id_claim INT NOT NULL, owner_uuid VARCHAR(36) NOT NULL, owner_name VARCHAR(36) NOT NULL, claim_name VARCHAR(255) NOT NULL, claim_description VARCHAR(255) NOT NULL, chunks TEXT NOT NULL, world_name VARCHAR(255) NOT NULL, location VARCHAR(255) NOT NULL, members TEXT NOT NULL, permissions VARCHAR(510) NOT NULL, for_sale TINYINT(1) NOT NULL DEFAULT 0, sale_price DOUBLE NOT NULL DEFAULT 0, bans TEXT NOT NULL DEFAULT '')";
                                stmt.executeUpdate((String)sql);
                                sql = "CREATE TABLE IF NOT EXISTS scs_players (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid_server VARCHAR(36) NOT NULL UNIQUE, uuid_mojang VARCHAR(36) NOT NULL, player_name VARCHAR(36) NOT NULL, player_head TEXT NOT NULL, player_textures TEXT NOT NULL)";
                                stmt.executeUpdate((String)sql);
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            this.info(String.valueOf(ChatColor.RED) + "Error creating tables.");
                            status[0] = false;
                            if (connection != null) {
                                connection.close();
                            }
                            return;
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.info(String.valueOf(ChatColor.RED) + "Error creating tables.");
                    status[0] = false;
                    return;
                }
                String databasePath = "plugins/SimpleClaimSystem/claims.db";
                File databaseFile = new File(databasePath);
                if (databaseFile.exists()) {
                    this.claimInstance.convertLocalToNewLocal();
                }
            }
            this.claimSettingsInstance.addSetting("database", configC);
            configC = this.getConfig().getString("auto-purge");
            this.claimSettingsInstance.addSetting("auto-purge", configC);
            if (configC.equals("true")) {
                configC = this.getConfig().getString("auto-purge-checking");
                this.claimSettingsInstance.addSetting("auto-purge-checking", configC);
                try {
                    int minutes = Integer.parseInt(configC);
                    if (minutes < 1) {
                        this.info(String.valueOf(ChatColor.RED) + "'auto-purge-checking' must be a correct number (integer and > 0). Using default value.");
                        minutes = 60;
                    }
                    configC = this.getConfig().getString("auto-purge-time-without-login");
                    this.claimSettingsInstance.addSetting("auto-purge-time-without-login", configC);
                    this.claimPurgeInstance = new ClaimPurge(this);
                    this.claimPurgeInstance.startPurge(minutes, configC);
                }
                catch (NumberFormatException e) {
                    this.info(String.valueOf(ChatColor.RED) + "'auto-purge-checking' must be a correct number (integer and > 0). Using default value.");
                    int minutes = 60;
                    configC = this.getConfig().getString("auto-purge-time-without-login");
                    this.claimSettingsInstance.addSetting("auto-purge-time-without-login", configC);
                    this.claimPurgeInstance = new ClaimPurge(this);
                    this.claimPurgeInstance.startPurge(minutes, configC);
                }
            } else if (this.claimPurgeInstance != null) {
                this.claimPurgeInstance.stopPurge();
            }
            ArrayList<String> aliases_claim = this.getConfig().getStringList("command-aliases.claim");
            ArrayList<String> aliases_unclaim = this.getConfig().getStringList("command-aliases.unclaim");
            ArrayList<String> aliases_claims = this.getConfig().getStringList("command-aliases.claims");
            if (aliases_claim == null) {
                this.info(String.valueOf(ChatColor.RED) + "'aliases_claim' is missing in config. Using default value.");
                aliases_claim = new ArrayList<String>();
                aliases_claim.add("/territory");
            }
            if (aliases_unclaim == null) {
                this.info(String.valueOf(ChatColor.RED) + "'aliases_unclaim' is missing in config. Using default value.");
                aliases_unclaim = new ArrayList<String>();
                aliases_unclaim.add("/unterritory");
            }
            if (aliases_claims == null) {
                this.info(String.valueOf(ChatColor.RED) + "'aliases_claims' is missing in config. Using default value.");
                aliases_claims = new ArrayList<String>();
                aliases_claims.add("/territories");
            }
            for (String command : aliases_claim) {
                this.claimSettingsInstance.addAliase(command, "/claim");
            }
            for (String command : aliases_unclaim) {
                this.claimSettingsInstance.addAliase(command, "/unclaim");
            }
            for (String command : aliases_claims) {
                this.claimSettingsInstance.addAliase(command, "/claims");
            }
            this.claimSettingsInstance.addSetting("dynmap-claim-border-color", this.getConfig().getString("dynmap-settings.claim-border-color"));
            this.claimSettingsInstance.addSetting("dynmap-claim-fill-color", this.getConfig().getString("dynmap-settings.claim-fill-color"));
            this.claimSettingsInstance.addSetting("dynmap-claim-hover-text", this.getConfig().getString("dynmap-settings.claim-hover-text"));
            this.claimSettingsInstance.addSetting("bluemap-claim-border-color", this.getConfig().getString("bluemap-settings.claim-border-color"));
            this.claimSettingsInstance.addSetting("bluemap-claim-fill-color", this.getConfig().getString("bluemap-settings.claim-fill-color"));
            this.claimSettingsInstance.addSetting("bluemap-claim-hover-text", this.getConfig().getString("bluemap-settings.claim-hover-text"));
            this.claimSettingsInstance.addSetting("pl3xmap-claim-border-color", this.getConfig().getString("pl3xmap-settings.claim-border-color"));
            this.claimSettingsInstance.addSetting("pl3xmap-claim-fill-color", this.getConfig().getString("pl3xmap-settings.claim-fill-color"));
            this.claimSettingsInstance.addSetting("pl3xmap-claim-hover-text", this.getConfig().getString("pl3xmap-settings.claim-hover-text"));
            configC = this.getConfig().getString("protection-message");
            if (configC.equalsIgnoreCase("action_bar") || configC.equalsIgnoreCase("title") || configC.equalsIgnoreCase("subtitle") || configC.equalsIgnoreCase("chat") || configC.equalsIgnoreCase("bossbar")) {
                this.claimSettingsInstance.addSetting("protection-message", configC);
            } else {
                this.info(String.valueOf(ChatColor.RED) + "'protection-message' must be 'ACTION_BAR', 'TITLE', 'SUBTITLE', 'CHAT' or 'BOSSBAR'. Using default value.");
                this.claimSettingsInstance.addSetting("protection-message", "ACTION_BAR");
            }
            ConfigurationSection worldsSection = this.getConfig().getConfigurationSection("claims-worlds-mode");
            LinkedHashMap<String, WorldMode> worlds = new LinkedHashMap<String, WorldMode>();
            for (Object key : worldsSection.getKeys(false)) {
                WorldMode mode;
                try {
                    mode = WorldMode.valueOf(worldsSection.getString((String)key));
                    if (mode == null) {
                        this.info(String.valueOf(ChatColor.RED) + "Invalid world mode for '" + (String)key + "', using default mode.");
                        mode = WorldMode.SURVIVAL;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid world mode for '" + (String)key + "', using default mode.");
                    mode = WorldMode.SURVIVAL;
                }
                worlds.put((String)key, mode);
            }
            if (this.getConfig().contains("worlds-disabled")) {
                List disabledWorlds = this.getConfig().getStringList("worlds-disabled");
                for (String world : disabledWorlds) {
                    this.getConfig().set("claims-worlds-mode." + world, (Object)"DISABLED");
                    worlds.put(world, WorldMode.DISABLED);
                }
                this.getConfig().set("worlds-disabled", null);
            }
            this.claimSettingsInstance.setWorlds(worlds);
            this.claimSettingsInstance.addSetting("keep-chunks-loaded", this.getConfig().getString("keep-chunks-loaded"));
            this.claimSettingsInstance.addSetting("max-length-claim-name", this.getConfig().getString("max-length-claim-name"));
            this.claimSettingsInstance.addSetting("max-length-claim-description", this.getConfig().getString("max-length-claim-description"));
            this.claimSettingsInstance.addSetting("claim-invitations-system", this.getConfig().getString("claim-invitations-system"));
            this.claimSettingsInstance.addSetting("claim-invitation-expiration-delay", this.getConfig().getString("claim-invitation-expiration-delay"));
            this.claimSettingsInstance.addSetting("claim-confirmation", this.getConfig().getString("claim-confirmation"));
            this.claimSettingsInstance.addSetting("claim-particles", this.getConfig().getString("claim-particles"));
            this.claimSettingsInstance.addSetting("claim-particles-not-enter", this.getConfig().getString("claim-particles-not-enter"));
            this.claimSettingsInstance.addSetting("claim-fly-disabled-on-damage", this.getConfig().getString("claim-fly-disabled-on-damage"));
            this.claimSettingsInstance.addSetting("claim-fly-message-auto-fly", this.getConfig().getString("claim-fly-message-auto-fly"));
            this.claimSettingsInstance.addSetting("enter-leave-messages", this.getConfig().getString("enter-leave-messages"));
            this.claimSettingsInstance.addSetting("enter-leave-title-messages", this.getConfig().getString("enter-leave-title-messages"));
            this.claimSettingsInstance.addSetting("enter-leave-chat-messages", this.getConfig().getString("enter-leave-chat-messages"));
            this.claimSettingsInstance.addSetting("claims-visitors-off-visible", this.getConfig().getString("claims-visitors-off-visible"));
            if (this.isFolia) {
                this.info(String.valueOf(ChatColor.RED) + "'/claim fly' command disabled because the server is running on Folia.");
            }
            if ((configC = this.getConfig().getString("map-type").toLowerCase()).equals("scoreboard") && this.isFolia) {
                this.info(String.valueOf(ChatColor.RED) + "'map-type' set to 'CHAT' because the server is running on Folia.");
                configC = "chat";
            }
            this.claimSettingsInstance.addSetting("map-type", configC);
            if (check_vault) {
                this.claimSettingsInstance.addSetting("economy", this.getConfig().getString("economy"));
                this.claimSettingsInstance.addSetting("max-sell-price", this.getConfig().getString("max-sell-price"));
                this.claimSettingsInstance.addSetting("claim-cost", this.getConfig().getString("claim-cost"));
                this.claimSettingsInstance.addSetting("claim-cost-multiplier", this.getConfig().getString("claim-cost-multiplier"));
                this.claimSettingsInstance.addSetting("chunk-cost", this.getConfig().getString("chunk-cost"));
                this.claimSettingsInstance.addSetting("chunk-cost-multiplier", this.getConfig().getString("chunk-cost-multiplier"));
                this.claimSettingsInstance.addSetting("use-formatted-number", this.getConfig().getString("use-formatted-number"));
            } else {
                this.claimSettingsInstance.addSetting("economy", "false");
            }
            this.claimSettingsInstance.addSetting("announce-sale.bossbar", this.getConfig().getString("announce-sale.bossbar"));
            String barColor = this.getConfig().getString("announce-sale.bossbar-settings.color").toUpperCase();
            try {
                BarColor color = BarColor.valueOf((String)barColor);
                if (color == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color RED.");
                    barColor = "YELLOW";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color RED.");
                barColor = "YELLOW";
            }
            String barStyle = this.getConfig().getString("announce-sale.bossbar-settings.style").toUpperCase();
            try {
                style = BarStyle.valueOf((String)barStyle);
                if (style == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar style, using default style SOLID.");
                    barStyle = "SOLID";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar style, using default style SOLID.");
                barStyle = "SOLID";
            }
            this.claimSettingsInstance.addSetting("announce-sale.bossbar-settings.color", barColor);
            this.claimSettingsInstance.addSetting("announce-sale.bossbar-settings.style", barStyle);
            this.claimSettingsInstance.addSetting("announce-sale.chat", this.getConfig().getString("announce-sale.chat"));
            this.claimSettingsInstance.addSetting("announce-sale.title", this.getConfig().getString("announce-sale.title"));
            this.claimSettingsInstance.addSetting("announce-sale.actionbar", this.getConfig().getString("announce-sale.actionbar"));
            configC = this.getConfig().getString("bossbar");
            this.claimSettingsInstance.addSetting("bossbar", configC);
            barColor = this.getConfig().getString("bossbar-settings.color").toUpperCase();
            try {
                BarColor color = BarColor.valueOf((String)barColor);
                if (color == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color YELLOW.");
                    barColor = "YELLOW";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color YELLOW.");
                barColor = "YELLOW";
            }
            barStyle = this.getConfig().getString("bossbar-settings.style").toUpperCase();
            try {
                style = BarStyle.valueOf((String)barStyle);
                if (style == null) {
                    this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar color, using default color YELLOW.");
                    barColor = "YELLOW";
                }
            }
            catch (IllegalArgumentException e) {
                this.info(String.valueOf(ChatColor.RED) + "Invalid bossbar style, using default style SOLID.");
                barStyle = "SOLID";
            }
            this.claimSettingsInstance.addSetting("bossbar-color", barColor);
            this.claimSettingsInstance.addSetting("bossbar-style", barStyle);
            this.claimSettingsInstance.addSetting("teleportation-delay-moving", this.getConfig().getString("teleportation-delay-moving"));
            if (this.getConfig().contains("expulsion-location")) {
                if (this.getConfig().getConfigurationSection("expulsion-location").getKeys(false).isEmpty()) {
                    this.info(String.valueOf(ChatColor.RED) + "'expulsion-location' : don't forget to set it with /scs setexpulsionlocation.");
                } else {
                    String world;
                    world = Bukkit.getWorld((String)this.getConfig().getString("expulsion-location.world"));
                    if (world == null) {
                        this.info(String.valueOf(ChatColor.RED) + "'expulsion-location' : the world is incorrect.");
                        status[0] = false;
                        return;
                    }
                    double x = this.getConfig().getDouble("expulsion-location.x");
                    double y = this.getConfig().getDouble("expulsion-location.y");
                    double z = this.getConfig().getDouble("expulsion-location.z");
                    float yaw = (float)this.getConfig().getDouble("expulsion-location.yaw");
                    float pitch = (float)this.getConfig().getDouble("expulsion-location.pitch");
                    Location location = new Location((World)world, x, y, z, yaw, pitch);
                    this.claimSettingsInstance.setExpulsionLocation(location);
                }
            }
            ConfigurationSection groupsSection = this.getConfig().getConfigurationSection("groups");
            LinkedHashMap<String, String> groups = new LinkedHashMap<String, String>();
            HashMap<String, Map<String, Double>> groupsSettings = new HashMap<String, Map<String, Double>>();
            for (String key : groupsSection.getKeys(false)) {
                if (!key.equalsIgnoreCase("default")) {
                    groups.put(key, this.getConfig().getString("groups." + key + ".permission"));
                }
                HashMap<String, Double> settings = new HashMap<String, Double>();
                settings.put("max-claims", this.getConfig().getDouble("groups." + key + ".max-claims"));
                settings.put("max-radius-claims", this.getConfig().getDouble("groups." + key + ".max-radius-claims"));
                settings.put("teleportation-delay", this.getConfig().getDouble("groups." + key + ".teleportation-delay"));
                settings.put("max-members", this.getConfig().getDouble("groups." + key + ".max-members"));
                settings.put("claim-cost", this.getConfig().getDouble("groups." + key + ".claim-cost"));
                settings.put("claim-cost-multiplier", this.getConfig().getDouble("groups." + key + ".claim-cost-multiplier"));
                settings.put("max-chunks-per-claim", this.getConfig().getDouble("groups." + key + ".max-chunks-per-claim"));
                settings.put("claim-distance", this.getConfig().getDouble("groups." + key + ".claim-distance"));
                settings.put("max-chunks-total", this.getConfig().getDouble("groups." + key + ".max-chunks-total"));
                settings.put("chunk-cost", this.getConfig().getDouble("groups." + key + ".chunk-cost"));
                settings.put("chunk-cost-multiplier", this.getConfig().getDouble("groups." + key + ".chunk-cost-multiplier"));
                groupsSettings.put(key, settings);
            }
            this.claimSettingsInstance.setGroups(groups);
            this.claimSettingsInstance.setGroupsSettings(groupsSettings);
            ConfigurationSection playersSection = this.getConfig().getConfigurationSection("players");
            HashMap<UUID, Map<String, Double>> playersSettings = new HashMap<UUID, Map<String, Double>>();
            for (String key : playersSection.getKeys(false)) {
                UUID uuid;
                HashMap<String, Double> settings = new HashMap<String, Double>();
                if (this.getConfig().isSet("players." + key + ".max-claims")) {
                    settings.put("max-claims", this.getConfig().getDouble("players." + key + ".max-claims"));
                }
                if (this.getConfig().isSet("players." + key + ".max-radius-claims")) {
                    settings.put("max-radius-claims", this.getConfig().getDouble("players." + key + ".max-radius-claims"));
                }
                if (this.getConfig().isSet("players." + key + ".teleportation-delay")) {
                    settings.put("teleportation-delay", this.getConfig().getDouble("players." + key + ".teleportation-delay"));
                }
                if (this.getConfig().isSet("players." + key + ".claim-cost")) {
                    settings.put("claim-cost", this.getConfig().getDouble("players." + key + ".claim-cost"));
                }
                if (this.getConfig().isSet("players." + key + ".claim-cost-multiplier")) {
                    settings.put("claim-cost-multiplier", this.getConfig().getDouble("players." + key + ".claim-cost-multiplier"));
                }
                if (this.getConfig().isSet("players." + key + ".max-chunks-per-claim")) {
                    settings.put("max-chunks-per-claim", this.getConfig().getDouble("players." + key + ".max-chunks-per-claim"));
                }
                if (this.getConfig().isSet("players." + key + ".claim-distance")) {
                    settings.put("claim-distance", this.getConfig().getDouble("players." + key + ".claim-distance"));
                }
                if (this.getConfig().isSet("players." + key + ".max-chunks-total")) {
                    settings.put("max-chunks-total", this.getConfig().getDouble("players." + key + ".max-chunks-total"));
                }
                if (this.getConfig().isSet("players." + key + ".chunk-cost")) {
                    settings.put("chunk-cost", this.getConfig().getDouble("players." + key + ".chunk-cost"));
                }
                if (this.getConfig().isSet("players." + key + ".chunk-cost-multiplier")) {
                    settings.put("chunk-cost-multiplier", this.getConfig().getDouble("players." + key + ".chunk-cost-multiplier"));
                }
                if (settings.isEmpty() || this.cPlayerMainInstance == null || (uuid = this.cPlayerMainInstance.getPlayerUUID(key)) == null) continue;
                playersSettings.put(uuid, settings);
            }
            this.cPlayerMainInstance.setPlayersConfigSettings(playersSettings);
            v = new LinkedHashMap();
            statusSettings = this.getConfig().getConfigurationSection("status-settings");
            for (String key : statusSettings.getKeys(false)) {
                v.put(key, statusSettings.getBoolean(key));
            }
            this.claimSettingsInstance.setEnabledSettings(v);
            v = new LinkedHashMap();
            statusSettings = this.getConfig().getConfigurationSection("permissions-on-SurvivalRequiringClaims");
            for (String key : statusSettings.getKeys(false)) {
                v.put(key, statusSettings.getBoolean(key));
            }
            this.claimSettingsInstance.setSurvivalRequiringClaimsSettings(v);
            this.claimSettingsInstance.setRestrictedItems(this.getConfig().getStringList("blocked-items"));
            this.claimSettingsInstance.setRestrictedContainers(this.getConfig().getStringList("blocked-interact-blocks"));
            this.claimSettingsInstance.setRestrictedEntityType(this.getConfig().getStringList("blocked-entities"));
            this.claimSettingsInstance.setSpecialBlocks(this.getConfig().getStringList("special-blocks"));
            this.claimSettingsInstance.setBreakBlocksIgnore(this.getConfig().getStringList("ignored-break-blocks"));
            this.claimSettingsInstance.setPlaceBlocksIgnore(this.getConfig().getStringList("ignored-place-blocks"));
            this.saveConfig();
            this.reloadConfig();
            this.claimBossBarInstance.loadBossbarSettings();
            if (this.isFolia) {
                Bukkit.getOnlinePlayers().forEach(p -> {
                    this.cPlayerMainInstance.addPlayerPermSetting((Player)p);
                    Bukkit.getRegionScheduler().run((Plugin)this, p.getLocation(), task -> this.claimBossBarInstance.activeBossBar((Player)p, p.getLocation().getChunk()));
                });
            } else {
                Bukkit.getOnlinePlayers().forEach(p -> {
                    this.cPlayerMainInstance.addPlayerPermSetting((Player)p);
                    this.claimBossBarInstance.activeBossBar((Player)p, p.getLocation().getChunk());
                });
            }
            this.info("==========================================================================");
            if (status[0]) {
                sender.sendMessage(this.getLanguage().getMessage("config-reload-complete"));
            } else {
                sender.sendMessage(this.getLanguage().getMessage("config-reload-not-complete"));
            }
        });
        return status[0];
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public void info(String msg) {
        this.logger.sendMessage(msg);
    }

    public boolean isFolia() {
        return this.isFolia;
    }

    public boolean isPaper() {
        return this.isPaper;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getUpdateMessage() {
        return this.updateMessage;
    }

    public boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    public void executeAsync(Runnable gTask) {
        if (this.isFolia) {
            Bukkit.getAsyncScheduler().runNow((Plugin)this, task -> gTask.run());
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, gTask);
        }
    }

    public void executeAsyncLocation(Runnable gTask, Location location) {
        if (this.isFolia) {
            Bukkit.getRegionScheduler().run((Plugin)this.instance, location, task -> gTask.run());
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.instance, gTask);
        }
    }

    public void executeAsyncLater(Runnable gTask, long delayMillis) {
        if (this.isFolia) {
            Bukkit.getAsyncScheduler().runDelayed((Plugin)this, task -> gTask.run(), delayMillis, TimeUnit.MILLISECONDS);
        } else {
            long delayTicks = Math.max(1L, delayMillis * 20L / 1000L);
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, gTask, delayTicks);
        }
    }

    public void executeSyncLater(Runnable gTask, long delayMillis) {
        long delayTicks = Math.max(1L, delayMillis * 20L / 1000L);
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this, task -> gTask.run(), delayTicks);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this, gTask, delayTicks);
        }
    }

    public void executeSync(Runnable gTask) {
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)this, () -> gTask.run());
        } else {
            Bukkit.getScheduler().runTask((Plugin)this, gTask);
        }
    }

    public void executeEntitySync(Player player, Runnable gTask) {
        if (this.isFolia) {
            player.getScheduler().execute((Plugin)this, gTask, null, 0L);
        } else {
            Bukkit.getScheduler().runTask((Plugin)this, gTask);
        }
    }

    public void checkFolia() {
        if (Bukkit.getVersion().toLowerCase().contains("folia")) {
            try {
                Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
                this.isFolia = true;
            }
            catch (ClassNotFoundException e) {
                this.isFolia = false;
            }
            return;
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.isFolia = true;
        }
        catch (ClassNotFoundException e) {
            this.isFolia = false;
        }
    }

    public void checkPaper() {
        if (Bukkit.getVersion().toLowerCase().contains("paper")) {
            try {
                Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
                this.isPaper = true;
            }
            catch (ClassNotFoundException e) {
                this.isPaper = false;
            }
            return;
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
            this.isPaper = true;
        }
        catch (ClassNotFoundException e) {
            this.isPaper = false;
        }
    }

    public void reloadLang(CommandSender sender, String l) {
        boolean check;
        String lang = l;
        File custom = new File(String.valueOf(this.getDataFolder()) + File.separator + "langs", lang);
        boolean bl = check = !custom.exists();
        if (!custom.exists()) {
            lang = "en_US.yml";
        } else {
            this.updateLangFileWithMissingKeys(lang);
        }
        this.claimSettingsInstance.addSetting("lang", lang);
        File lang_final = new File(String.valueOf(this.getDataFolder()) + File.separator + "langs", lang);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)lang_final);
        HashMap<String, String> messages = new HashMap<String, String>();
        for (String key : config.getKeys(false)) {
            String value = config.getString(key);
            messages.put(key, value);
        }
        this.claimLanguageInstance.setLanguage(messages);
        this.getConfig().set("lang", (Object)lang);
        this.saveConfig();
        this.reloadConfig();
        if (check) {
            sender.sendMessage("The file you indicate doesn't exists. Using default file.");
        }
        sender.sendMessage("Language file loaded \u00a77(" + l + "\u00a77)\u00a7f.");
        if (this.isFolia) {
            Bukkit.getOnlinePlayers().forEach(p -> Bukkit.getRegionScheduler().run((Plugin)this, p.getLocation(), task -> this.claimBossBarInstance.activeBossBar((Player)p, p.getLocation().getChunk())));
        } else {
            Bukkit.getOnlinePlayers().forEach(p -> this.claimBossBarInstance.activeBossBar((Player)p, p.getLocation().getChunk()));
        }
    }

    private void updateLangFileWithMissingKeys(String file) {
        try {
            InputStream defLangStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("langs/en_US.yml");
            if (defLangStream == null) {
                return;
            }
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defLangStream, StandardCharsets.UTF_8));
            File langFile = new File(String.valueOf(this.getDataFolder()) + File.separator + "langs", file);
            if (!langFile.exists()) {
                return;
            }
            YamlConfiguration customConfig = YamlConfiguration.loadConfiguration((File)langFile);
            boolean needSave = false;
            for (String key : defConfig.getKeys(true)) {
                if (customConfig.contains(key)) continue;
                customConfig.set(key, defConfig.get(key));
                needSave = true;
            }
            HashSet customConfigKeys = new HashSet(customConfig.getKeys(true));
            for (String key : customConfigKeys) {
                if (defConfig.contains(key) || key.startsWith("custom-")) continue;
                customConfig.set(key, null);
                needSave = true;
            }
            if (needSave) {
                customConfig.save(langFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateConfigWithDefaults() {
        ConfigurationSection groups;
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveDefaultConfig();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream defConfigStream = this.getResource("config.yml");
        if (defConfigStream == null) {
            return;
        }
        YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
        boolean changed = false;
        for (Object key : defConfig.getKeys(true)) {
            if (config.contains((String)key)) continue;
            config.set((String)key, defConfig.get((String)key));
            changed = true;
        }
        HashSet configKeys = new HashSet(config.getKeys(true));
        for (String key : configKeys) {
            if (defConfig.contains(key) || this.checkKey(key)) continue;
            config.set(key, null);
            changed = true;
        }
        ConfigurationSection defaultGroup = defConfig.getConfigurationSection("groups.default");
        if (this.addMissingKeysFromDefault(defaultGroup, groups = defConfig.getConfigurationSection("groups"))) {
            changed = true;
        }
        if (changed) {
            try {
                config.save(configFile);
                this.reloadConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean addMissingKeysFromDefault(ConfigurationSection defaultGroup, ConfigurationSection groups) {
        boolean changed = false;
        for (String groupName : groups.getKeys(false)) {
            ConfigurationSection group;
            if (groupName.equals("default") || (group = groups.getConfigurationSection(groupName)) == null) continue;
            changed = this.addMissingKeys(defaultGroup, group);
        }
        return changed;
    }

    private boolean addMissingKeys(ConfigurationSection defaultGroup, ConfigurationSection group) {
        boolean changed = false;
        for (String key : defaultGroup.getKeys(false)) {
            if (group.contains(key)) continue;
            Object value = defaultGroup.get(key);
            group.set(key, value);
            changed = true;
        }
        return changed;
    }

    private boolean checkKey(String key) {
        return key.startsWith("groups.") || key.startsWith("players.") || key.startsWith("expulsion-location") || key.startsWith("claims-worlds-mode") || key.equals("worlds-disabled") || key.startsWith("world-aliases");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String checkForUpdates() {
        try {
            URI uri = URI.create("https://raw.githubusercontent.com/Xyness/SimpleClaimSystem/main/version.yml");
            URL url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String response = reader.readLine();
                if (!this.Version.equalsIgnoreCase(response)) {
                    this.updateMessage = "\u00a74[SCS] \u00a7cUpdate available : \u00a7l" + response + " \u00a77(You have " + this.Version + ")";
                    this.isUpdateAvailable = true;
                    String string = "\u00a7cUpdate available : \u00a74" + response;
                    return string;
                }
                this.isUpdateAvailable = false;
                String string = "You are using the latest version";
                return string;
            }
        }
        catch (Exception e) {
            return "Error when checking new update";
        }
    }

    public CompletableFuture<String> checkForUpdatesAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URI uri = URI.create("https://raw.githubusercontent.com/Xyness/SimpleClaimSystem/main/version.yml");
                URL url = uri.toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String response = reader.readLine();
                    if (!this.Version.equalsIgnoreCase(response)) {
                        this.updateMessage = "\u00a74[SCS] \u00a7cUpdate available : \u00a7l" + response + " \u00a77(You have " + this.Version + ")";
                        this.isUpdateAvailable = true;
                        String string = "\u00a7cUpdate available : \u00a74" + response;
                        return string;
                    }
                    this.isUpdateAvailable = false;
                    String string = "You are using the latest version";
                    return string;
                }
            }
            catch (Exception e) {
                return "Error when checking new update";
            }
        });
    }

    private void checkAndSaveResource(String resource) {
        File file = new File(String.valueOf(this.getDataFolder()) + File.separator + resource);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.saveResource(resource, false);
        }
    }

    public SimpleClaimSystem getInstance() {
        return this.instance;
    }

    public ClaimMain getMain() {
        return this.claimInstance;
    }

    public ClaimGuis getGuis() {
        return this.claimGuisInstance;
    }

    public ClaimSettings getSettings() {
        return this.claimSettingsInstance;
    }

    public ClaimLanguage getLanguage() {
        return this.claimLanguageInstance;
    }

    public ClaimWorldGuard getWorldGuard() {
        return this.claimWorldguardInstance;
    }

    public ClaimVault getVault() {
        return this.claimVaultInstance;
    }

    public CPlayerMain getPlayerMain() {
        return this.cPlayerMainInstance;
    }

    public ClaimBossBar getBossBars() {
        return this.claimBossBarInstance;
    }

    public ClaimDynmap getDynmap() {
        return this.dynmapInstance;
    }

    public ClaimBluemap getBluemap() {
        return this.bluemapInstance;
    }

    public ClaimPl3xMap getPl3xMap() {
        return this.pl3xmapInstance;
    }

    public ClaimPurge getAutopurge() {
        return this.claimPurgeInstance;
    }

    public void getOfflinePlayer(String playerName, Consumer<OfflinePlayer> callback) {
        CompletableFuture.runAsync(() -> {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
            this.executeSync(() -> callback.accept(offlinePlayer));
        });
    }

    public void setExpulsionLocation(Location loc) {
        this.getSettings().setExpulsionLocation(loc);
        CompletableFuture.runAsync(() -> {
            FileConfiguration config = this.getConfig();
            config.set("expulsion-location.world", (Object)loc.getWorld().getName());
            config.set("expulsion-location.x", (Object)loc.getX());
            config.set("expulsion-location.y", (Object)loc.getY());
            config.set("expulsion-location.z", (Object)loc.getZ());
            config.set("expulsion-location.yaw", (Object)Float.valueOf(loc.getYaw()));
            config.set("expulsion-location.pitch", (Object)Float.valueOf(loc.getPitch()));
            this.saveConfig();
            this.reloadConfig();
        });
    }

    public void checkMinecraftVersion() {
        String version = Bukkit.getBukkitVersion();
        String[] parts = version.split("\\.");
        this.minecraftVersion = parts.length >= 2 ? parts[0] + "." + parts[1] : version.split("-")[0];
    }

    public void loadGuis() {
        File check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "chunk_confirmation.yml");
        if (!check_gui.exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/chunk_confirmation.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "claim_confirmation.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/claim_confirmation.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "unclaim_confirmation.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/unclaim_confirmation.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "settings.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/settings.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "members.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/members.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "bans.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/bans.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "chunks.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/chunks.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "claims.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/claims.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "claims_owner.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/claims_owner.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "list.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/list.yml", false);
        }
        if (!(check_gui = new File(String.valueOf(this.getDataFolder()) + File.separator + "guis", "main.yml")).exists()) {
            check_gui.getParentFile().mkdirs();
            this.saveResource("guis/main.yml", false);
        }
        this.claimGuisInstance.loadGuiSettings();
    }

    public void deleteDirectory(File dir) {
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
            dir.delete();
        }
    }
}

