/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Listeners;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import fr.xyness.SCS.Types.WorldMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.WeatherType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ClaimEvents
implements Listener {
    private SimpleClaimSystem instance;
    private final List<PotionEffectType> NEGATIVE_EFFECTS = new ArrayList<PotionEffectType>();
    private final String bukkitVersion = Bukkit.getVersion();

    public ClaimEvents(SimpleClaimSystem instance) {
        this.instance = instance;
        this.NEGATIVE_EFFECTS.add(PotionEffectType.HARM);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.POISON);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.WITHER);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.SLOW);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.WEAKNESS);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.BLINDNESS);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.HUNGER);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.SLOW_DIGGING);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.LEVITATION);
        this.NEGATIVE_EFFECTS.add(PotionEffectType.CONFUSION);
        if (!this.bukkitVersion.contains("1.18")) {
            this.NEGATIVE_EFFECTS.add(PotionEffectType.DARKNESS);
        }
    }

    @EventHandler
    public void onCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase();
        String command = message.split(" ")[0];
        String aliase = this.instance.getSettings().getAliase(command);
        if (aliase != null) {
            String newCommand = message.replaceFirst(command, aliase);
            event.setMessage(newCommand);
        }
    }

    @EventHandler
    public void onPlayerToggleGlide(EntityToggleGlideEvent event) {
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getEntity().getWorld().getName());
        if (event.getEntity() instanceof Player && event.isGliding()) {
            Player player = (Player)event.getEntity();
            if (player.hasPermission("scs.bypass")) {
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (claim != null) {
                if (!claim.getPermissionForPlayer("Elytra", player)) {
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("elytra"), this.instance.getSettings().getSetting("protection-message"));
                    event.setCancelled(true);
                }
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Elytra")) {
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("elytra-mode"), this.instance.getSettings().getSetting("protection-message"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onFireworkLaunch(ProjectileLaunchEvent event) {
        Firework firework;
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getEntity().getWorld().getName());
        if (event.getEntity() instanceof Firework && (firework = (Firework)event.getEntity()).getShooter() instanceof Player) {
            Player player = (Player)firework.getShooter();
            if (player == null) {
                return;
            }
            if (player.hasPermission("scs.bypass")) {
                return;
            }
            if (player.isGliding() || player.getTargetBlockExact(5) == null) {
                Chunk chunk = player.getLocation().getChunk();
                Claim claim = this.instance.getMain().getClaim(chunk);
                if (claim != null) {
                    if (!claim.getPermissionForPlayer("Elytra", player)) {
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("elytra"), this.instance.getSettings().getSetting("protection-message"));
                        event.setCancelled(true);
                    }
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Elytra")) {
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("elytra-mode"), this.instance.getSettings().getSetting("protection-message"));
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPotionSplash(PotionSplashEvent event) {
        ThrownPotion thrownPotion;
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getEntity().getWorld().getName());
        if (event.getEntity() instanceof ThrownPotion && (thrownPotion = event.getEntity()).getShooter() instanceof Player) {
            Player damager = (Player)thrownPotion.getShooter();
            if (damager.hasPermission("scs.bypass")) {
                return;
            }
            for (PotionEffect effect : thrownPotion.getEffects()) {
                if (!this.NEGATIVE_EFFECTS.contains(effect.getType())) continue;
                for (Entity entity : event.getAffectedEntities()) {
                    if (entity.getType() != EntityType.PLAYER) continue;
                    Player player = (Player)entity;
                    if (player == damager) {
                        return;
                    }
                    Chunk chunk = player.getLocation().getChunk();
                    Claim claim = this.instance.getMain().getClaim(chunk);
                    if (claim != null) {
                        if (claim.getPermission("Pvp", "Natural")) continue;
                        this.instance.getMain().sendMessage(damager, this.instance.getLanguage().getMessage("pvp"), this.instance.getSettings().getSetting("protection-message"));
                        event.setIntensity((LivingEntity)player, 0.0);
                        continue;
                    }
                    if (mode != WorldMode.SURVIVAL_REQUIRING_CLAIMS || this.instance.getSettings().getSettingSRC("Pvp")) continue;
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("pvp-mode"), this.instance.getSettings().getSetting("protection-message"));
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!this.instance.getSettings().getBooleanSetting("claim-fly-disabled-on-damage")) {
            return;
        }
        Player player = (Player)event.getEntity();
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (cPlayer != null && cPlayer.getClaimFly().booleanValue()) {
            this.instance.getPlayerMain().removePlayerFly(player);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("claim-fly-disabled-on-damage"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Chunk chunk = player.getLocation().getChunk();
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getWorld().getName());
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Projectile projectile;
            ProjectileSource shooter;
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (event.getDamager() instanceof Player) {
                Player damager = (Player)event.getDamager();
                if (player == damager) {
                    return;
                }
                if (damager.hasPermission("scs.bypass")) {
                    return;
                }
                if (!claim.getPermission("Pvp", "Natural")) {
                    this.instance.getMain().sendMessage(damager, this.instance.getLanguage().getMessage("pvp"), this.instance.getSettings().getSetting("protection-message"));
                    event.setCancelled(true);
                }
            } else if (event.getDamager() instanceof Projectile && (shooter = (projectile = (Projectile)event.getDamager()).getShooter()) instanceof Player) {
                Player damager = (Player)shooter;
                if (player == damager) {
                    return;
                }
                if (damager.hasPermission("scs.bypass")) {
                    return;
                }
                if (!claim.getPermission("Pvp", "Natural")) {
                    this.instance.getMain().sendMessage(damager, this.instance.getLanguage().getMessage("pvp"), this.instance.getSettings().getSetting("protection-message"));
                    event.setCancelled(true);
                }
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Pvp")) {
            ProjectileSource shooter;
            Entity projectile = event.getDamager();
            if (projectile instanceof Player) {
                Player damager = (Player)projectile;
                this.instance.getMain().sendMessage(damager, this.instance.getLanguage().getMessage("pvp-mode"), this.instance.getSettings().getSetting("protection-message"));
                event.setCancelled(true);
            } else if (event.getDamager() instanceof Projectile && (shooter = (projectile = (Projectile)event.getDamager()).getShooter()) instanceof Player) {
                Player damager = (Player)shooter;
                this.instance.getMain().sendMessage(damager, this.instance.getLanguage().getMessage("pvp-mode"), this.instance.getSettings().getSetting("protection-message"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity entity;
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getLocation().getWorld().getName());
        Chunk chunk = event.getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            LivingEntity entity2 = event.getEntity();
            if ((entity2 instanceof Monster || entity2 instanceof Phantom) && !claim.getPermission("Monsters", "Natural")) {
                event.setCancelled(true);
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Monsters") && ((entity = event.getEntity()) instanceof Monster || entity instanceof Phantom)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Chunk chunk = event.getItemDrop().getLocation().getChunk();
        Player player = event.getPlayer();
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getWorld().getName());
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("ItemsDrop", player)) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("itemsdrop"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("ItemsDrop")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("itemsdrop-mode"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler
    public void onPlayerUsePortal(PlayerPortalEvent event) {
        Chunk chunk = event.getFrom().getChunk();
        Player player = event.getPlayer();
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getWorld().getName());
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("Portals", player)) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("portals"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Portals")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("portals-mode"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getLocation().getWorld().getName());
        Iterator blockIterator = event.blockList().iterator();
        while (blockIterator.hasNext()) {
            Block block = (Block)blockIterator.next();
            Chunk chunk = block.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk) && !this.instance.getMain().canPermCheck(chunk, "Explosions", "Natural")) {
                blockIterator.remove();
                continue;
            }
            if (mode != WorldMode.SURVIVAL_REQUIRING_CLAIMS || this.instance.getSettings().getSettingSRC("Explosions")) continue;
            blockIterator.remove();
        }
        if (this.instance.getMinecraftVersion().contains("1.21") && event.getEntityType() == EntityType.WIND_CHARGE) {
            Projectile wind = (Projectile)event.getEntity();
            ProjectileSource projectileSource = wind.getShooter();
            if (projectileSource instanceof Player) {
                Player player = (Player)projectileSource;
                Chunk chunk = event.getEntity().getLocation().getChunk();
                if (this.instance.getMain().checkIfClaimExists(chunk)) {
                    Claim claim = this.instance.getMain().getClaim(chunk);
                    if (!claim.getPermissionForPlayer("Windcharges", player)) {
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("windcharges"), this.instance.getSettings().getSetting("protection-message"));
                        event.getEntity().getNearbyEntities(5.0, 5.0, 5.0).forEach(entity -> entity.setVelocity(new Vector(0, 0, 0)));
                    }
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Windcharges")) {
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("windcharges-mode"), this.instance.getSettings().getSetting("protection-message"));
                    event.getEntity().getNearbyEntities(5.0, 5.0, 5.0).forEach(entity -> entity.setVelocity(new Vector(0, 0, 0)));
                }
                return;
            }
            return;
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        ProjectileSource chunk4;
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getEntity().getWorld().getName());
        if (event.getEntityType() == EntityType.WITHER_SKULL) {
            if (event.getHitBlock() != null) {
                Block block = event.getHitBlock();
                Chunk chunk2 = block.getLocation().getChunk();
                if (this.instance.getMain().checkIfClaimExists(chunk2) && !this.instance.getMain().canPermCheck(chunk2, "Explosions", "Natural")) {
                    event.getEntity().remove();
                    event.setCancelled(true);
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Explosions")) {
                    event.getEntity().remove();
                    event.setCancelled(true);
                }
            }
            if (event.getHitEntity() != null) {
                Chunk chunk3 = event.getHitEntity().getLocation().getChunk();
                if (this.instance.getMain().checkIfClaimExists(chunk3) && !this.instance.getMain().canPermCheck(chunk3, "Explosions", "Natural")) {
                    event.getEntity().remove();
                    event.setCancelled(true);
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Explosions")) {
                    event.getEntity().remove();
                    event.setCancelled(true);
                }
            }
            event.getEntity().getNearbyEntities(5.0, 5.0, 5.0).forEach(entity -> {
                Chunk chunk = entity.getLocation().getChunk();
                if (this.instance.getMain().checkIfClaimExists(chunk) && !this.instance.getMain().canPermCheck(chunk, "Explosions", "Natural")) {
                    entity.setVelocity(new Vector(0, 0, 0));
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Explosions")) {
                    entity.setVelocity(new Vector(0, 0, 0));
                }
            });
        } else if (this.instance.getMinecraftVersion().contains("1.21") && event.getEntityType() == EntityType.WIND_CHARGE) {
            if (event.getHitBlock() != null) {
                Block block = event.getHitBlock();
                Chunk chunk4 = block.getLocation().getChunk();
                if (this.instance.getMain().checkIfClaimExists(chunk4) && !this.instance.getMain().canPermCheck(chunk4, "Explosions", "Natural")) {
                    event.setCancelled(true);
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Explosions")) {
                    event.setCancelled(true);
                }
            }
            if (event.getHitEntity() != null) {
                Chunk chunk5 = event.getHitEntity().getLocation().getChunk();
                if (this.instance.getMain().checkIfClaimExists(chunk5) && !this.instance.getMain().canPermCheck(chunk5, "Explosions", "Natural")) {
                    event.setCancelled(true);
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Explosions")) {
                    event.setCancelled(true);
                }
            }
        } else if (event.getEntityType() == EntityType.ENDER_PEARL && this.instance.isFolia() && (chunk4 = event.getEntity().getShooter()) instanceof Player) {
            Player player = (Player)chunk4;
            EnderPearl pearl = (EnderPearl)event.getEntity();
            Location playerLocation = player.getLocation();
            Location pearlLocation = pearl.getLocation();
            Chunk to = pearlLocation.getChunk();
            Chunk from = playerLocation.getChunk();
            if (!this.instance.getMain().checkIfClaimExists(to)) {
                this.instance.getBossBars().disableBossBar(player);
                return;
            }
            UUID playerId = player.getUniqueId();
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(playerId);
            if (cPlayer == null) {
                return;
            }
            String ownerTO = this.instance.getMain().getOwnerInClaim(to);
            String ownerFROM = this.instance.getMain().getOwnerInClaim(from);
            Claim claim = this.instance.getMain().getClaim(to);
            if (claim != null) {
                if (this.instance.getMain().checkBan(claim, player) && !this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass.ban")) {
                    this.cancelTeleport(event, player, "player-banned");
                    return;
                }
                if (!claim.getPermissionForPlayer("Enter", player) && !this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass.enter")) {
                    this.cancelTeleport(event, player, "enter");
                    return;
                }
                if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass") && !claim.getPermissionForPlayer("Teleportations", player)) {
                    this.cancelTeleport(event, player, "teleportations");
                    return;
                }
            }
            this.instance.getBossBars().activeBossBar(player, to);
            this.handleAutoFly(player, cPlayer, to, ownerTO);
            this.handleWeatherSettings(player, to, from);
            String world = player.getWorld().getName();
            if (!ownerTO.equals(ownerFROM)) {
                this.handleEnterLeaveMessages(player, to, from, ownerTO, ownerFROM);
                if (cPlayer.getClaimAuto().equals("addchunk")) {
                    this.handleAutoAddChunk(player, cPlayer, to, world);
                } else if (cPlayer.getClaimAuto().equals("delchunk")) {
                    this.handleAutoDelChunk(player, cPlayer, to, world);
                } else if (cPlayer.getClaimAuto().equals("claim")) {
                    this.handleAutoClaim(player, cPlayer, to, world);
                } else if (cPlayer.getClaimAuto().equals("unclaim")) {
                    this.handleAutoUnclaim(player, cPlayer, to, world);
                }
            }
            if (cPlayer.getClaimAutomap().booleanValue()) {
                this.handleAutoMap(player, cPlayer, to, world);
            }
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getBlock().getWorld().getName());
        Iterator blockIterator = event.blockList().iterator();
        while (blockIterator.hasNext()) {
            Block block = (Block)blockIterator.next();
            Chunk chunk = block.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk) && !this.instance.getMain().canPermCheck(chunk, "Explosions", "Natural")) {
                blockIterator.remove();
                continue;
            }
            if (mode != WorldMode.SURVIVAL_REQUIRING_CLAIMS || this.instance.getSettings().getSettingSRC("Explosions")) continue;
            blockIterator.remove();
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getBlock().getLocation().getWorld().getName());
        if (event.getEntityType() == EntityType.WITHER || event.getEntityType() == EntityType.WITHER_SKULL) {
            Block block = event.getBlock();
            Chunk chunk = block.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk) && !this.instance.getMain().canPermCheck(chunk, "Explosions", "Natural")) {
                event.setCancelled(true);
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Explosions")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("Destroy", player) && !this.instance.getSettings().isBreakBlockIgnore(event.getBlock().getType())) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
            if (this.instance.getSettings().isSpecialBlock(event.getBlock().getType()) && !claim.getPermissionForPlayer("SpecialBlocks", player)) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("specialblocks"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS) {
            if (!this.instance.getSettings().getSettingSRC("Destroy")) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy-mode"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
            if (this.instance.getSettings().isSpecialBlock(event.getBlock().getType()) && !this.instance.getSettings().getSettingSRC("SpecialBlocks")) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("specialblocks-mode"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onVehicleDamage(VehicleDamageEvent event) {
        Entity damager = event.getAttacker();
        if (damager == null) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(damager.getLocation().getWorld().getName());
        Chunk chunk = event.getVehicle().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            if (damager instanceof Player) {
                Player player = (Player)damager;
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                    return;
                }
                Claim claim = this.instance.getMain().getClaim(chunk);
                if (!claim.getPermissionForPlayer("Destroy", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                return;
            }
            if (!this.instance.getMain().canPermCheck(chunk, "Destroy", "Visitors")) {
                event.setCancelled(true);
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Destroy")) {
            if (damager instanceof Player) {
                Player player = (Player)damager;
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                    return;
                }
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy-mode"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        Block block = event.getBlock();
        Chunk chunk = block.getLocation().getChunk();
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Bed) {
            BlockFace facing;
            Block adjacentBlock;
            Chunk adjacentChunk;
            Bed bed = (Bed)blockData;
            if (!this.instance.getSettings().isPlaceBlockIgnore(block.getType()) && !chunk.equals((Object)(adjacentChunk = (adjacentBlock = block.getRelative(facing = bed.getFacing())).getChunk()))) {
                if (this.instance.getMain().checkIfClaimExists(adjacentChunk) && !this.instance.getMain().getOwnerInClaim(chunk).equals(this.instance.getMain().getOwnerInClaim(adjacentChunk))) {
                    Claim claim = this.instance.getMain().getClaim(adjacentChunk);
                    if (!claim.getPermissionForPlayer("Build", player)) {
                        event.setCancelled(true);
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build"), this.instance.getSettings().getSetting("protection-message"));
                        return;
                    }
                } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Build")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
        }
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("Build", player) && !this.instance.getSettings().isPlaceBlockIgnore(block.getType())) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Build")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build-mode"), this.instance.getSettings().getSetting("protection-message"));
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("Build", player) && !this.instance.getSettings().isPlaceBlockIgnore(event.getBlock().getType())) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Build")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build-mode"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHangingBreak(HangingBreakEvent event) {
        Chunk chunk = event.getEntity().getLocation().getChunk();
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getEntity().getLocation().getWorld().getName());
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            if (event.getCause() == HangingBreakEvent.RemoveCause.PHYSICS && !this.instance.getMain().canPermCheck(chunk, "Destroy", "Visitors")) {
                event.setCancelled(true);
            } else if (event.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION && !this.instance.getMain().canPermCheck(chunk, "Explosions", "Natural")) {
                event.setCancelled(true);
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS) {
            if (event.getCause() == HangingBreakEvent.RemoveCause.PHYSICS && !this.instance.getSettings().getSettingSRC("Destroy")) {
                event.setCancelled(true);
            } else if (event.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION && !this.instance.getSettings().getSettingSRC("Explosions")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        if (event.getEntity().getType() == EntityType.PAINTING || event.getEntity().getType() == EntityType.ITEM_FRAME || event.getEntity().getType() == EntityType.GLOW_ITEM_FRAME) {
            WorldMode mode = this.instance.getSettings().getWorldMode(event.getEntity().getLocation().getWorld().getName());
            Chunk chunk = event.getEntity().getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Entity entity = event.getRemover();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                        return;
                    }
                    Claim claim = this.instance.getMain().getClaim(chunk);
                    if (!claim.getPermissionForPlayer("Destroy", player)) {
                        event.setCancelled(true);
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy"), this.instance.getSettings().getSetting("protection-message"));
                        return;
                    }
                    return;
                }
                if (!this.instance.getMain().canPermCheck(chunk, "Destroy", "Visitors")) {
                    event.setCancelled(true);
                    return;
                }
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Destroy")) {
                Entity entity = event.getRemover();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                        return;
                    }
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBucketUse(PlayerBucketEmptyEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("Build", player) && !this.instance.getSettings().isPlaceBlockIgnore(event.getBlock().getType())) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Build")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build-mode"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBucketUse(PlayerBucketFillEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("Destroy", player) && !this.instance.getSettings().isBreakBlockIgnore(event.getBlock().getType())) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Destroy")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy-mode"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        if (event.getCaught() instanceof Entity && (entity = event.getCaught()) != null) {
            Chunk chunk = entity.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Claim claim = this.instance.getMain().getClaim(chunk);
                if (!claim.getPermissionForPlayer("Entities", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Entities")) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities-mode"), this.instance.getSettings().getSetting("protection-message"));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityPlace(EntityPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("Build", player)) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Build")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build-mode"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
        Block block = event.getClickedBlock();
        Chunk chunk = block == null ? player.getLocation().getChunk() : block.getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Material item;
                Material mat = event.getClickedBlock().getType();
                if (mat.name().contains("BUTTON") && !claim.getPermissionForPlayer("Buttons", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("buttons"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.name().contains("TRAPDOOR") && !claim.getPermissionForPlayer("Trapdoors", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("trapdoors"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.name().contains("DOOR") && !claim.getPermissionForPlayer("Doors", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("doors"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.name().contains("FENCE_GATE") && !claim.getPermissionForPlayer("Fencegates", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("fencegates"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.LEVER) && !claim.getPermissionForPlayer("Levers", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("levers"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.REPEATER) && !claim.getPermissionForPlayer("RepeatersComparators", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("repeaters"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.COMPARATOR) && !claim.getPermissionForPlayer("RepeatersComparators", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("comparators"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.BELL) && !claim.getPermissionForPlayer("Bells", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("bells"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (!claim.getPermissionForPlayer("InteractBlocks", player)) {
                    item = block.getType();
                    if (this.instance.getSettings().isRestrictedContainer(item)) {
                        event.setCancelled(true);
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("interactblocks"), this.instance.getSettings().getSetting("protection-message"));
                        return;
                    }
                }
                if (!claim.getPermissionForPlayer("Items", player)) {
                    item = event.getMaterial();
                    if (this.instance.getSettings().isRestrictedItem(item)) {
                        event.setCancelled(true);
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items"), this.instance.getSettings().getSetting("protection-message"));
                        return;
                    }
                }
                return;
            }
            if (event.getAction() == Action.PHYSICAL) {
                if (block != null && block.getType().name().contains("PRESSURE_PLATE") && !claim.getPermissionForPlayer("Plates", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("plates"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (block.getType() == Material.TRIPWIRE && !claim.getPermissionForPlayer("Tripwires", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("tripwires"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
            if (!claim.getPermissionForPlayer("Items", player)) {
                Material item = event.getMaterial();
                if (this.instance.getSettings().isRestrictedItem(item)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
            return;
        }
        if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS) {
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Material item;
                Material mat = event.getClickedBlock().getType();
                if (mat.name().contains("BUTTON") && !this.instance.getSettings().getSettingSRC("Buttons")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("buttons-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.name().contains("TRAPDOOR") && !this.instance.getSettings().getSettingSRC("Trapdoors")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("trapdoors-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.name().contains("DOOR") && !this.instance.getSettings().getSettingSRC("Doors")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("doors-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.name().contains("FENCE_GATE") && !this.instance.getSettings().getSettingSRC("Fencegates")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("fencegates-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.LEVER) && !this.instance.getSettings().getSettingSRC("Levers")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("levers-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.REPEATER) && !this.instance.getSettings().getSettingSRC("RepeatersComparators")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("repeaters-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.COMPARATOR) && !this.instance.getSettings().getSettingSRC("RepeatersComparators")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("comparators-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (mat.equals((Object)Material.BELL) && !this.instance.getSettings().getSettingSRC("Bells")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("bells-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (!this.instance.getSettings().getSettingSRC("InteractBlocks")) {
                    item = block.getType();
                    if (this.instance.getSettings().isRestrictedContainer(item)) {
                        event.setCancelled(true);
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("interactblocks-mode"), this.instance.getSettings().getSetting("protection-message"));
                        return;
                    }
                }
                if (!this.instance.getSettings().getSettingSRC("Items")) {
                    item = event.getMaterial();
                    if (this.instance.getSettings().isRestrictedItem(item)) {
                        event.setCancelled(true);
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items-mode"), this.instance.getSettings().getSetting("protection-message"));
                        return;
                    }
                }
                return;
            }
            if (event.getAction() == Action.PHYSICAL) {
                if (block != null && block.getType().name().contains("PRESSURE_PLATE") && !this.instance.getSettings().getSettingSRC("Plates")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("plates-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                if (block.getType() == Material.TRIPWIRE && !this.instance.getSettings().getSettingSRC("Tripwires")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("tripwires-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
            if (!this.instance.getSettings().getSettingSRC("Items")) {
                Material item = event.getMaterial();
                if (this.instance.getSettings().isRestrictedItem(item)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractAtEntityEvent event) {
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getRightClicked().getLocation().getWorld().getName());
        Chunk chunk = event.getRightClicked().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            Entity entity = event.getRightClicked();
            EntityType e = event.getRightClicked().getType();
            if (!this.instance.getSettings().isRestrictedEntityType(e)) {
                return;
            }
            if (!claim.getPermissionForPlayer("Entities", player)) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
            ItemStack itemInHand = player.getInventory().getItem(event.getHand());
            if (itemInHand != null) {
                if (!this.instance.getSettings().isRestrictedItem(itemInHand.getType())) {
                    return;
                }
                Claim claim2 = this.instance.getMain().getClaim(entity.getLocation().getChunk());
                if (claim2 == null) {
                    return;
                }
                if (!claim.getPermissionForPlayer("Items", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS) {
            EntityType e = event.getRightClicked().getType();
            if (!this.instance.getSettings().isRestrictedEntityType(e)) {
                return;
            }
            if (!this.instance.getSettings().getSettingSRC("Entities")) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities-mode"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
            ItemStack itemInHand = player.getInventory().getItem(event.getHand());
            if (itemInHand != null) {
                if (!this.instance.getSettings().isRestrictedItem(itemInHand.getType())) {
                    return;
                }
                if (!this.instance.getSettings().getSettingSRC("Items")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity2(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getRightClicked().getLocation().getWorld().getName());
        Chunk chunk = event.getRightClicked().getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            Entity entity = event.getRightClicked();
            EntityType e = event.getRightClicked().getType();
            if (!this.instance.getSettings().isRestrictedEntityType(e)) {
                return;
            }
            if (!claim.getPermissionForPlayer("Entities", player)) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
            ItemStack itemInHand = player.getInventory().getItem(event.getHand());
            if (itemInHand != null) {
                if (!this.instance.getSettings().isRestrictedItem(itemInHand.getType())) {
                    return;
                }
                Claim claim2 = this.instance.getMain().getClaim(entity.getLocation().getChunk());
                if (claim2 == null) {
                    return;
                }
                if (!claim.getPermissionForPlayer("Items", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS) {
            EntityType e = event.getRightClicked().getType();
            if (!this.instance.getSettings().isRestrictedEntityType(e)) {
                return;
            }
            if (!this.instance.getSettings().getSettingSRC("Entities")) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities-mode"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
            ItemStack itemInHand = player.getInventory().getItem(event.getHand());
            if (itemInHand != null) {
                if (!this.instance.getSettings().isRestrictedItem(itemInHand.getType())) {
                    return;
                }
                if (!this.instance.getSettings().getSettingSRC("Items")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("items-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
            }
        }
    }

    @EventHandler
    public void onLiquidFlow(BlockFromToEvent event) {
        Block block = event.getBlock();
        Block toBlock = event.getToBlock();
        Chunk chunk = toBlock.getLocation().getChunk();
        WorldMode mode = this.instance.getSettings().getWorldMode(toBlock.getLocation().getWorld().getName());
        if (block.getLocation().getChunk().equals((Object)chunk)) {
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            if (this.instance.getMain().getOwnerInClaim(chunk).equals(this.instance.getMain().getOwnerInClaim(block.getLocation().getChunk()))) {
                return;
            }
            if (this.instance.getMain().canPermCheck(chunk, "Liquids", "Natural")) {
                return;
            }
            if (block.isLiquid()) {
                Waterlogged waterlogged;
                if (toBlock.getBlockData() instanceof Waterlogged && (waterlogged = (Waterlogged)toBlock.getBlockData()).isWaterlogged()) {
                    event.setCancelled(true);
                    return;
                }
                if (toBlock.isEmpty() || toBlock.isPassable()) {
                    event.setCancelled(true);
                }
            } else {
                Waterlogged waterlogged;
                if (block.getBlockData() instanceof Waterlogged && (waterlogged = (Waterlogged)block.getBlockData()).isWaterlogged()) {
                    event.setCancelled(true);
                    return;
                }
                if (toBlock.isEmpty() || toBlock.isPassable()) {
                    event.setCancelled(true);
                }
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Liquids")) {
            if (block.isLiquid()) {
                Waterlogged waterlogged;
                if (toBlock.getBlockData() instanceof Waterlogged && (waterlogged = (Waterlogged)toBlock.getBlockData()).isWaterlogged()) {
                    event.setCancelled(true);
                    return;
                }
                if (toBlock.isEmpty() || toBlock.isPassable()) {
                    event.setCancelled(true);
                }
            } else {
                Waterlogged waterlogged;
                if (block.getBlockData() instanceof Waterlogged && (waterlogged = (Waterlogged)block.getBlockData()).isWaterlogged()) {
                    event.setCancelled(true);
                    return;
                }
                if (toBlock.isEmpty() || toBlock.isPassable()) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onDispense(BlockDispenseEvent event) {
        Block block = event.getBlock();
        if (this.hasCrossChunkRedstoneSourceAndNeedBlock(block)) {
            event.setCancelled(true);
            return;
        }
        Chunk targetChunk = block.getRelative(((Directional)event.getBlock().getBlockData()).getFacing()).getLocation().getChunk();
        if (block.getLocation().getChunk().equals((Object)targetChunk)) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(block.getLocation().getWorld().getName());
        if (this.instance.getMain().checkIfClaimExists(targetChunk)) {
            if (this.instance.getMain().getOwnerInClaim(block.getLocation().getChunk()).equals(this.instance.getMain().getOwnerInClaim(targetChunk))) {
                return;
            }
            if (!this.instance.getMain().canPermCheck(targetChunk, "Redstone", "Natural")) {
                event.setCancelled(true);
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Redstone")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRedstoneChange(BlockRedstoneEvent event) {
        BlockFace[] faces;
        Block targetBlock = event.getBlock();
        Chunk targetChunk = targetBlock.getChunk();
        if (event.getNewCurrent() <= 0) {
            return;
        }
        WorldMode mode = this.instance.getSettings().getWorldMode(targetBlock.getLocation().getWorld().getName());
        for (BlockFace face : faces = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block neighbor = targetBlock.getRelative(face);
            if (neighbor.getType() == Material.AIR || neighbor.getChunk().equals((Object)targetChunk)) continue;
            if (this.instance.getMain().checkIfClaimExists(targetChunk)) {
                if (this.instance.getMain().getOwnerInClaim(neighbor.getChunk()).equals(this.instance.getMain().getOwnerInClaim(targetChunk))) {
                    return;
                }
                if (!this.instance.getMain().canPermCheck(targetChunk, "Redstone", "Natural")) {
                    event.setNewCurrent(0);
                }
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Redstone")) {
                event.setNewCurrent(0);
            }
            return;
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Block piston = event.getBlock();
        if (this.hasCrossChunkRedstoneSourceAndNeedBlock(piston)) {
            event.setCancelled(true);
            return;
        }
        ArrayList<Block> affectedBlocks = new ArrayList<Block>(event.getBlocks());
        BlockFace direction = event.getDirection();
        if (!affectedBlocks.isEmpty()) {
            affectedBlocks.add(piston.getRelative(direction));
        }
        if (!this.canPistonMoveBlock(affectedBlocks, direction, piston.getLocation().getChunk(), false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Block piston = event.getBlock();
        if (this.hasCrossChunkRedstoneSourceAndNeedBlock(piston)) {
            event.setCancelled(true);
            return;
        }
        ArrayList<Block> affectedBlocks = new ArrayList<Block>(event.getBlocks());
        BlockFace direction = event.getDirection();
        if (event.isSticky() && !affectedBlocks.isEmpty()) {
            affectedBlocks.add(piston.getRelative(direction));
        }
        if (!this.canPistonMoveBlock(affectedBlocks, direction, piston.getLocation().getChunk(), true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFrostWalkerUse(EntityBlockFormEvent event) {
        Entity entity;
        Chunk chunk = event.getBlock().getLocation().getChunk();
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getBlock().getLocation().getWorld().getName());
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Entity entity2;
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (event.getNewState().getType() == Material.FROSTED_ICE && (entity2 = event.getEntity()) instanceof Player) {
                Player player = (Player)entity2;
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                    return;
                }
                if (claim.getPermissionForPlayer("FrostWalker", player)) {
                    return;
                }
                ItemStack boots = player.getInventory().getBoots();
                if (boots != null && boots.containsEnchantment(Enchantment.FROST_WALKER)) {
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("frostwalker"), this.instance.getSettings().getSetting("protection-message"));
                    event.setCancelled(true);
                }
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Frostwalker") && event.getNewState().getType() == Material.FROSTED_ICE && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                return;
            }
            ItemStack boots = player.getInventory().getBoots();
            if (boots != null && boots.containsEnchantment(Enchantment.FROST_WALKER)) {
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("frostwalker-mode"), this.instance.getSettings().getSetting("protection-message"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockSpread(BlockSpreadEvent event) {
        if (event.getNewState().getType() == Material.FIRE) {
            Chunk chunk = event.getBlock().getLocation().getChunk();
            WorldMode mode = this.instance.getSettings().getWorldMode(event.getBlock().getLocation().getWorld().getName());
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                if (this.instance.getMain().canPermCheck(chunk, "Firespread", "Natural")) {
                    return;
                }
                event.setCancelled(true);
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Firespread")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        Chunk chunk = event.getBlock().getLocation().getChunk();
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getBlock().getLocation().getWorld().getName());
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            Player player = event.getPlayer();
            if (player != null) {
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                    return;
                }
                if (!claim.getPermissionForPlayer("Build", player)) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                return;
            }
            if (this.instance.getMain().canPermCheck(chunk, "Firespread", "Natural")) {
                return;
            }
            event.setCancelled(true);
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS) {
            Player player = event.getPlayer();
            if (player != null) {
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                    return;
                }
                if (!this.instance.getSettings().getSettingSRC("Build")) {
                    event.setCancelled(true);
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("build-mode"), this.instance.getSettings().getSetting("protection-message"));
                    return;
                }
                return;
            }
            if (!this.instance.getSettings().getSettingSRC("Firespread")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        Chunk chunk = event.getBlock().getLocation().getChunk();
        WorldMode mode = this.instance.getSettings().getWorldMode(event.getBlock().getLocation().getWorld().getName());
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            if (this.instance.getMain().canPermCheck(chunk, "Firespread", "Natural")) {
                return;
            }
            event.setCancelled(true);
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Firespread")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity2(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ArmorStand || entity instanceof ItemFrame || entity instanceof GlowItemFrame) {
            Entity damager = event.getDamager();
            WorldMode mode = this.instance.getSettings().getWorldMode(damager.getLocation().getWorld().getName());
            Chunk chunk = entity.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                if (damager instanceof Player) {
                    Claim claim = this.instance.getMain().getClaim(chunk);
                    Player player = (Player)damager;
                    if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                        return;
                    }
                    if (!claim.getPermissionForPlayer("Destroy", player)) {
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy"), this.instance.getSettings().getSetting("protection-message"));
                        event.setCancelled(true);
                    }
                    return;
                }
                if (!this.instance.getMain().canPermCheck(chunk, "Destroy", "Visitors")) {
                    event.setCancelled(true);
                }
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS) {
                if (damager instanceof Player) {
                    Player player = (Player)damager;
                    if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                        return;
                    }
                    if (!this.instance.getSettings().getSettingSRC("Destroy")) {
                        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy-mode"), this.instance.getSettings().getSetting("protection-message"));
                        event.setCancelled(true);
                    }
                    return;
                }
                if (!this.instance.getSettings().getSettingSRC("Destroy")) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Chunk chunk = entity.getLocation().getChunk();
        WorldMode mode = this.instance.getSettings().getWorldMode(entity.getLocation().getWorld().getName());
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            if (!(entity instanceof Player || entity instanceof Monster || entity instanceof ArmorStand || entity instanceof ItemFrame)) {
                Projectile projectile;
                ProjectileSource shooter;
                Entity damager = event.getDamager();
                if (damager instanceof Player) {
                    this.processDamageByPlayer((Player)damager, chunk, event);
                } else if (damager instanceof Projectile && (shooter = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
                    this.processDamageByPlayer((Player)shooter, chunk, event);
                }
            }
        } else if (!(mode != WorldMode.SURVIVAL_REQUIRING_CLAIMS || this.instance.getSettings().getSettingSRC("Damages") || entity instanceof Player || entity instanceof Monster || entity instanceof ArmorStand || entity instanceof ItemFrame)) {
            Projectile projectile;
            ProjectileSource shooter;
            Entity damager = event.getDamager();
            if (damager instanceof Player) {
                Player player = (Player)damager;
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                    return;
                }
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("damages-mode"), this.instance.getSettings().getSetting("protection-message"));
            } else if (damager instanceof Projectile && (shooter = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
                Player player = (Player)shooter;
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("damages-mode"), this.instance.getSettings().getSetting("protection-message"));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onVehicleEnter(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                return;
            }
            WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
            Vehicle vehicle = event.getVehicle();
            EntityType vehicleType = vehicle.getType();
            if (!this.instance.getSettings().isRestrictedEntityType(vehicleType)) {
                return;
            }
            Chunk chunk = vehicle.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Claim claim = this.instance.getMain().getClaim(chunk);
                if (claim.getPermissionForPlayer("Entities", player)) {
                    return;
                }
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities"), this.instance.getSettings().getSetting("protection-message"));
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Entities")) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("entities-mode"), this.instance.getSettings().getSetting("protection-message"));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockChange(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        if (entity.getType() == EntityType.PLAYER && block.getType() == Material.FARMLAND) {
            Player player = (Player)entity;
            Chunk chunk = block.getLocation().getChunk();
            WorldMode mode = this.instance.getSettings().getWorldMode(player.getLocation().getWorld().getName());
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Claim claim = this.instance.getMain().getClaim(chunk);
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
                    return;
                }
                if (!claim.getPermissionForPlayer("Destroy", player)) {
                    this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy"), this.instance.getSettings().getSetting("protection-message"));
                    event.setCancelled(true);
                }
            } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("Destroy")) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("destroy-mode"), this.instance.getSettings().getSetting("protection-message"));
            }
        }
    }

    private boolean hasCrossChunkRedstoneSourceAndNeedBlock(Block block) {
        Chunk currentChunk = block.getChunk();
        for (BlockFace face : BlockFace.values()) {
            Block neighbor = block.getRelative(face);
            if (neighbor.getBlockPower() <= 0 || neighbor.getChunk().equals((Object)currentChunk)) continue;
            if (this.instance.getMain().getOwnerInClaim(neighbor.getChunk()).equals(this.instance.getMain().getOwnerInClaim(currentChunk))) {
                return false;
            }
            if (this.instance.getMain().canPermCheck(currentChunk, "Redstone", "Natural")) continue;
            return true;
        }
        return false;
    }

    private boolean canPistonMoveBlock(List<Block> blocks, BlockFace direction, Chunk pistonChunk, boolean retractOrNot) {
        WorldMode mode = this.instance.getSettings().getWorldMode(pistonChunk.getWorld().getName());
        if (retractOrNot) {
            for (Block block : blocks) {
                Chunk chunk = block.getLocation().getChunk();
                if (chunk.equals((Object)pistonChunk)) continue;
                if (this.instance.getMain().checkIfClaimExists(chunk)) {
                    if (this.instance.getMain().getOwnerInClaim(pistonChunk).equals(this.instance.getMain().getOwnerInClaim(chunk))) {
                        return true;
                    }
                    if (this.instance.getMain().canPermCheck(chunk, "Redstone", "Natural")) continue;
                    return false;
                }
                if (mode != WorldMode.SURVIVAL_REQUIRING_CLAIMS || this.instance.getSettings().getSettingSRC("Redstone")) continue;
                return false;
            }
            return true;
        }
        for (Block block : blocks) {
            Chunk chunk = block.getRelative(direction).getLocation().getChunk();
            if (chunk.equals((Object)pistonChunk)) continue;
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                if (this.instance.getMain().getOwnerInClaim(pistonChunk).equals(this.instance.getMain().getOwnerInClaim(chunk))) {
                    return true;
                }
                if (this.instance.getMain().canPermCheck(chunk, "Redstone", "Natural")) continue;
                return false;
            }
            if (mode != WorldMode.SURVIVAL_REQUIRING_CLAIMS || this.instance.getSettings().getSettingSRC("Redstone")) continue;
            return false;
        }
        return true;
    }

    private void processDamageByPlayer(Player player, Chunk chunk, EntityDamageByEntityEvent event) {
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        Claim claim = this.instance.getMain().getClaim(chunk);
        if (!claim.getPermissionForPlayer("Damages", player)) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("damages"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    private void handleWeatherSettings(Player player, Chunk to, Chunk from) {
        Claim claimTo = this.instance.getMain().getClaim(to);
        Claim claimFrom = this.instance.getMain().getClaim(from);
        if (this.instance.getMain().checkIfClaimExists(to) && !claimTo.getPermissionForPlayer("Weather", player)) {
            player.setPlayerWeather(WeatherType.CLEAR);
        } else if (this.instance.getMain().checkIfClaimExists(from) && !claimFrom.getPermissionForPlayer("Weather", player)) {
            player.resetPlayerWeather();
        }
    }

    private void handleAutoFly(Player player, CPlayer cPlayer, Chunk chunk, String owner) {
        Claim claim = this.instance.getMain().getClaim(chunk);
        if (cPlayer.getClaimAutofly().booleanValue() && (owner.equals(player.getName()) || claim != null && claim.getPermissionForPlayer("Fly", player)) && !this.instance.isFolia()) {
            this.instance.getPlayerMain().activePlayerFly(player);
            if (this.instance.getSettings().getBooleanSetting("claim-fly-message-auto-fly")) {
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("fly-enabled"), "CHAT");
            }
        } else if (claim != null && !claim.getPermissionForPlayer("Fly", player) && !owner.equals(player.getName()) && cPlayer.getClaimFly().booleanValue() && !this.instance.isFolia()) {
            this.instance.getPlayerMain().removePlayerFly(player);
            if (this.instance.getSettings().getBooleanSetting("claim-fly-message-auto-fly")) {
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("fly-disabled"), "CHAT");
            }
        }
    }

    private void handleAutoDelChunk(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autodelchunk-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            Claim claim = cPlayer.getTargetClaimChunk();
            if (claim == null) {
                return;
            }
            if (claim.getChunks().size() == 1) {
                player.sendMessage(this.instance.getLanguage().getMessage("cannot-remove-only-remaining-chunk"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
            if (!chunks.contains(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunk-not-in-claim"));
                return;
            }
            chunks.remove(chunk);
            if (!this.instance.getMain().isAnyChunkAdjacent(chunks, chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("one-chunk-must-be-adjacent-delchunk"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    String chunk_string = world + ";" + String.valueOf(chunk.getX()) + ";" + String.valueOf(chunk.getZ());
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + chunk_string + "]").replace("%claim-name%", claim.getName())));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error-delete-chunk")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoAddChunk(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autoaddchunk-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            String playerName = player.getName();
            Claim claim = cPlayer.getTargetClaimChunk();
            if (claim == null) {
                return;
            }
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Claim claim_target = this.instance.getMain().getClaim(chunk);
                if (claim_target.getOwner().equalsIgnoreCase(playerName)) {
                    if (claim_target.equals(claim)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-in-claim").replace("%claim-name%", claim.getName()));
                        return;
                    }
                    player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-owner").replace("%claim-name%", claim.getName()).replace("%claim-name-1%", claim_target.getName()));
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-not-owner"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
            if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + 1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            if (!cPlayer.canClaimWithNumber(chunks.size() + 1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            chunks.add(chunk);
            if (!this.instance.getMain().areChunksInSameWorld(chunks)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunks-must-be-from-same-world"));
                return;
            }
            chunks.remove(chunk);
            if (!this.instance.getMain().isAnyChunkAdjacent(chunks, chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("one-chunk-must-be-adjacent"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).thenAccept(successs -> {
                if (successs.booleanValue()) {
                    double[] price = new double[]{0.0};
                    if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("chunk-cost")) {
                        price[0] = this.instance.getSettings().getBooleanSetting("chunk-cost-multiplier") ? cPlayer.getChunkMultipliedCost(chunks.size()).doubleValue() : cPlayer.getChunkCost();
                        double balance = this.instance.getVault().getPlayerBalance(playerName);
                        if (balance < price[0]) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round((price[0] - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                            return;
                        }
                        this.instance.getVault().removePlayerBalance(playerName, price[0]);
                        if (price[0] > 0.0) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-chunk").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price[0] * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                        }
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near")));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().addClaimChunk(claim, chunk).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-successful").replace("%chunk%", "[" + chunk.getWorld().getName() + ";" + String.valueOf(chunk.getX()) + ";" + String.valueOf(chunk.getZ()) + "]").replace("%claim-name%", claim.getName())));
                        if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                            this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks()), true, false);
                        }
                        return;
                    }
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoUnclaim(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autounclaim-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (owner.equals("*") && player.hasPermission("scs.admin")) {
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("delete-claim-protected-area"));
                    } else {
                        player.sendMessage(this.instance.getLanguage().getMessage("error"));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            if (!owner.equals(player.getName())) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoClaim(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autoclaim-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            String playerName = player.getName();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                this.instance.getMain().handleClaimConflict(player, chunk);
                return;
            }
            if (!this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).join().booleanValue()) {
                player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near"));
                return;
            }
            if (!cPlayer.canClaim()) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                double price = this.instance.getSettings().getBooleanSetting("claim-cost-multiplier") ? cPlayer.getMultipliedCost().doubleValue() : cPlayer.getCost();
                double balance = this.instance.getVault().getPlayerBalance(playerName);
                if (balance < price) {
                    player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round((price - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")));
                    return;
                }
                this.instance.getVault().removePlayerBalance(playerName, price);
                if (price > 0.0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("you-paid-claim").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")));
                }
            }
            ((CompletableFuture)this.instance.getMain().createClaim(player, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    int remainingClaims = cPlayer.getMaxClaims() - cPlayer.getClaimsCount();
                    player.sendMessage(this.instance.getLanguage().getMessage("create-claim-success").replace("%remaining-claims%", this.instance.getMain().getNumberSeparate(String.valueOf(remainingClaims))));
                    if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                        this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)Set.of(chunk)), true, false);
                    }
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoMap(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("automap-world-disabled").replace("%world%", world));
            cPlayer.setClaimAutomap(false);
        } else {
            this.instance.getMain().getMap(player, chunk, true);
        }
    }

    private void handleEnterLeaveMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        if (this.instance.getSettings().getBooleanSetting("enter-leave-messages")) {
            this.enterleaveMessages(player, to, from, ownerTO, ownerFROM);
        }
        if (this.instance.getSettings().getBooleanSetting("enter-leave-chat-messages")) {
            this.enterleaveChatMessages(player, to, from, ownerTO, ownerFROM);
        }
        if (this.instance.getSettings().getBooleanSetting("enter-leave-title-messages")) {
            this.enterleavetitleMessages(player, to, from, ownerTO, ownerFROM);
        }
    }

    private void enterleaveChatMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        String playerName = player.getName();
        String toName = this.instance.getMain().getClaimNameByChunk(to);
        String fromName = this.instance.getMain().getClaimNameByChunk(from);
        if (this.instance.getMain().checkIfClaimExists(to)) {
            Claim claim = this.instance.getMain().getClaim(to);
            String message = claim.getSale() && this.instance.getSettings().getBooleanSetting("announce-sale.chat") ? (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale-chat").replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale-chat").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))) : (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-chat").replace("%name%", toName) : this.instance.getLanguage().getMessage("enter-territory-chat").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName));
            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(from)) {
            String message = ownerFROM.equals("*") ? this.instance.getLanguage().getMessage("leave-protected-area").replace("%name%", fromName) : this.instance.getLanguage().getMessage("leave-territory").replace("%owner%", ownerFROM).replace("%player%", playerName).replace("%name%", fromName);
            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
        }
    }

    private void enterleaveMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        String playerName = player.getName();
        String toName = this.instance.getMain().getClaimNameByChunk(to);
        String fromName = this.instance.getMain().getClaimNameByChunk(from);
        if (this.instance.getMain().checkIfClaimExists(to)) {
            Claim claim = this.instance.getMain().getClaim(to);
            String message = claim.getSale() && this.instance.getSettings().getBooleanSetting("announce-sale.actionbar") ? (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale").replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))) : (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area").replace("%name%", toName) : this.instance.getLanguage().getMessage("enter-territory").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName));
            this.instance.executeEntitySync(player, () -> this.instance.getMain().sendMessage(player, message, "ACTION_BAR"));
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(from)) {
            String message = ownerFROM.equals("*") ? this.instance.getLanguage().getMessage("leave-protected-area").replace("%name%", fromName) : this.instance.getLanguage().getMessage("leave-territory").replace("%owner%", ownerFROM).replace("%player%", playerName).replace("%name%", fromName);
            this.instance.executeEntitySync(player, () -> this.instance.getMain().sendMessage(player, message, "ACTION_BAR"));
        }
    }

    private void enterleavetitleMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        String toName = this.instance.getMain().getClaimNameByChunk(to);
        String fromName = this.instance.getMain().getClaimNameByChunk(from);
        String playerName = player.getName();
        if (this.instance.getMain().checkIfClaimExists(to)) {
            String toSubtitleKey;
            String toTitleKey;
            Claim claim = this.instance.getMain().getClaim(to);
            if (claim.getSale() && this.instance.getSettings().getBooleanSetting("announce-sale.title")) {
                toTitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"));
                toSubtitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"));
            } else {
                toTitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName) : this.instance.getLanguage().getMessage("enter-territory-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName);
                toSubtitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName) : this.instance.getLanguage().getMessage("enter-territory-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName);
            }
            this.instance.executeEntitySync(player, () -> player.sendTitle(toTitleKey, toSubtitleKey, 5, 25, 5));
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(from)) {
            String fromTitleKey = ownerFROM.equals("*") ? "leave-protected-area-title" : "leave-territory-title";
            String fromSubtitleKey = ownerFROM.equals("*") ? "leave-protected-area-subtitle" : "leave-territory-subtitle";
            String title = this.instance.getLanguage().getMessage(fromTitleKey).replace("%name%", fromName).replace("%owner%", ownerFROM).replace("%player%", playerName);
            String subtitle = this.instance.getLanguage().getMessage(fromSubtitleKey).replace("%name%", fromName).replace("%owner%", ownerFROM).replace("%player%", playerName);
            this.instance.executeEntitySync(player, () -> player.sendTitle(title, subtitle, 5, 25, 5));
        }
    }

    private void cancelTeleport(ProjectileHitEvent event, Player player, String message) {
        event.getEntity().remove();
        event.setCancelled(true);
        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage(message), this.instance.getSettings().getSetting("protection-message"));
    }
}

