/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ClaimsOwnerGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimsOwnerGui(Player player, int page, String filter, String owner, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("claims_owner");
        String title = guiSettings.getTitle().replace("%page%", String.valueOf(page)).replace("%owner%", owner);
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(page, filter, owner).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private CompletableFuture<Boolean> loadItems(int page, String filter, String owner) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            Set<Claim> claims = this.getClaims(filter, owner);
            ArrayList<Claim> claimList = new ArrayList<Claim>(claims);
            Collections.sort(claimList, (claim1, claim2) -> claim1.getName().compareTo(claim2.getName()));
            claims = new LinkedHashSet<Claim>(claimList);
            int claimsCount = claims.size();
            cPlayer.setOwner(owner);
            cPlayer.setFilter(filter);
            cPlayer.clearMapClaim();
            cPlayer.clearMapLoc();
            cPlayer.setGuiPage(page);
            GuiSettings guiSettings = ClaimGuis.gui_settings.get("claims_owner");
            int max = guiSettings.getSlots().size();
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("claims_owner"));
            for (GuiSlot slot : slots) {
                Material mat;
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                if (key.equals("BackPageOther") && page > 1) continue;
                if (key.equals("BackPage")) {
                    if (page == 1) continue;
                    title = title.replace("%page%", String.valueOf(page - 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page - 1));
                }
                if (key.equals("NextPage")) {
                    if (claimsCount <= page * max) continue;
                    title = title.replace("%page%", String.valueOf(page + 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page + 1));
                }
                if (key.equals("Filter")) {
                    lore_string = lore_string.replaceAll("%status_color_" + this.getStatusIndex(filter) + "%", this.instance.getLanguage().getMessage("status_color_active_filter")).replaceAll("%status_color_[^" + this.getStatusIndex(filter) + "]%", this.instance.getLanguage().getMessage("status_color_inactive_filter"));
                }
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    mat = slot.getMaterial();
                    this.inv.setItem(slot_int, this.instance.getGuis().createCustomItem(mat, title, lore, slot.getCustomModelData()));
                    continue;
                }
                if (slot.isCustomHead()) {
                    SkullMeta meta;
                    ItemStack head;
                    if (slot.getCustomTextures().equalsIgnoreCase("%player%")) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        meta.setOwningPlayer((OfflinePlayer)this.player);
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    if (slot.getCustomTextures().length() < 17) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        OfflinePlayer targetP = Bukkit.getOfflinePlayer((String)slot.getCustomTextures());
                        if (targetP != null) {
                            meta.setOwningPlayer(targetP);
                        }
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            List<String> loreTemplate = this.instance.getGuis().getLore(this.instance.getLanguage().getMessage("access-all-claim-lore"));
            int startItem = (page - 1) * max;
            List<Integer> slots_i = guiSettings.getSlots();
            int i = slots_i.get(0);
            int count = 0;
            int count2 = 0;
            for (Claim claim : claims) {
                if (count++ < startItem) continue;
                if (count2 > max - 1) break;
                i = slots_i.get(count2);
                ++count2;
                if (!claim.getPermissionForPlayer("GuiTeleport", this.player) && !this.instance.getSettings().getBooleanSetting("claims-visitors-off-visible")) continue;
                List<String> lore = this.prepareLore(loreTemplate, claim, this.player);
                String title = this.instance.getLanguage().getMessage("access-all-claim-title").replace("%owner%", owner).replace("%name%", claim.getName()).replace("%coords%", this.instance.getMain().getClaimCoords(claim));
                cPlayer.addMapClaim(i, claim);
                cPlayer.addMapLoc(i, claim.getLocation());
                ItemStack item = this.instance.getPlayerMain().getPlayerHead(owner);
                if (item == null) {
                    item = new ItemStack(Material.PLAYER_HEAD);
                }
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                meta.setDisplayName(title);
                meta.setLore(lore);
                item.setItemMeta((ItemMeta)meta);
                this.inv.setItem(i, item);
            }
            return true;
        });
    }

    private Set<Claim> getClaims(String filter, String owner) {
        return "sales".equals(filter) ? this.instance.getMain().getClaimsInSale(owner) : this.instance.getMain().getPlayerClaims(owner);
    }

    private List<String> prepareLore(List<String> template, Claim claim, Player player) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : template) {
            if ((line = line.replace("%description%", claim.getDescription()).replace("%name%", claim.getName()).replace("%coords%", this.instance.getMain().getClaimCoords(claim))).contains("%members%")) {
                lore.addAll(Arrays.asList(this.getMembers(claim).split("\n")));
                continue;
            }
            lore.add(line);
        }
        this.addEconomyLore(player, claim, lore);
        this.addVisitorLore(claim, lore, player);
        return lore;
    }

    private void addEconomyLore(Player player, Claim claim, List<String> lore) {
        if (this.instance.getSettings().getBooleanSetting("economy") && claim.getSale()) {
            Collections.addAll(lore, this.instance.getLanguage().getMessage("all-claim-buyable-price").replace("%price%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")).split("\n"));
            lore.add((String)(this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.buy") ? this.instance.getLanguage().getMessage("all-claim-is-buyable") : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-buy")));
        }
    }

    private void addVisitorLore(Claim claim, List<String> lore, Player player) {
        String visitorMessage = claim.getPermissionForPlayer("GuiTeleport", player) || claim.getOwner().equals(player.getName()) || this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass.guiteleport") ? this.instance.getLanguage().getMessage("access-all-claim-lore-allow-visitors") : this.instance.getLanguage().getMessage("access-all-claim-lore-deny-visitors");
        lore.add((String)(this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp") ? visitorMessage : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-teleport")));
    }

    private int getStatusIndex(String filter) {
        switch (filter) {
            case "sales": {
                return 2;
            }
        }
        return 1;
    }

    public String getMembers(Claim claim) {
        CustomSet<String> members = this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers());
        if (members.isEmpty()) {
            return this.instance.getLanguage().getMessage("claim-list-no-member");
        }
        StringBuilder membersList = new StringBuilder();
        int i = 0;
        for (String member : members) {
            if (member == null) continue;
            Player player = Bukkit.getPlayer((String)member);
            String memberName = player != null ? "\u00a7a" + member : "\u00a7c" + member;
            membersList.append(memberName);
            if (i < members.size() - 1) {
                membersList.append("\u00a77, ");
            }
            if ((i + 1) % 4 == 0 && i < members.size() - 1) {
                membersList.append("\n");
            }
            ++i;
        }
        return membersList.toString();
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

