/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ClaimMembersGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimMembersGui(Player player, Claim claim, int page, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("members");
        String title = guiSettings.getTitle().replace("%name%", claim.getName()).replace("%page%", String.valueOf(page));
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(claim, page).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Claim claim, int page) {
        return CompletableFuture.supplyAsync(() -> {
            String playerName = this.player.getName();
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            HashSet members = this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers());
            ArrayList<String> membersList = new ArrayList<String>(members);
            Collections.sort(membersList, (member1, member2) -> member1.compareTo((String)member2));
            members = new LinkedHashSet<String>(membersList);
            int membersCount = members.size();
            members.remove(playerName);
            cPlayer.setClaim(claim);
            cPlayer.clearMapString();
            cPlayer.setGuiPage(page);
            GuiSettings guiSettings = ClaimGuis.gui_settings.get("members");
            int max = guiSettings.getSlots().size();
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("members"));
            for (GuiSlot slot : slots) {
                Material mat;
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                if (key.equals("BackPage")) {
                    if (page == 1) continue;
                    title = title.replace("%page%", String.valueOf(page - 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page - 1));
                }
                if (key.equals("NextPage")) {
                    if (membersCount <= page * max) continue;
                    title = title.replace("%page%", String.valueOf(page + 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page + 1));
                }
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    mat = slot.getMaterial();
                    this.inv.setItem(slot_int, this.instance.getGuis().createCustomItem(mat, title, lore, slot.getCustomModelData()));
                    continue;
                }
                if (slot.isCustomHead()) {
                    SkullMeta meta;
                    ItemStack head;
                    if (slot.getCustomTextures().equalsIgnoreCase("%player%")) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        meta.setOwningPlayer((OfflinePlayer)this.player);
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    if (slot.getCustomTextures().length() < 17) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        OfflinePlayer targetP = Bukkit.getOfflinePlayer((String)slot.getCustomTextures());
                        if (targetP != null) {
                            meta.setOwningPlayer(targetP);
                        }
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            if (page == 1) {
                int n = guiSettings.getSlots().get(0);
                ItemStack ownerHead = this.instance.getPlayerMain().getPlayerHead(playerName);
                SkullMeta metaHead = (SkullMeta)ownerHead.getItemMeta();
                metaHead.setDisplayName(this.instance.getLanguage().getMessage("player-member-title").replace("%player%", playerName));
                metaHead.setLore(this.instance.getGuis().getLore(this.instance.getLanguage().getMessage("owner-territory-lore")));
                ownerHead.setItemMeta((ItemMeta)metaHead);
                this.inv.setItem(n, ownerHead);
                cPlayer.addMapString(n, playerName);
            }
            ArrayList<String> lore = new ArrayList<String>(this.instance.getGuis().getLore(this.instance.getLanguage().getMessage("territory-access-lore-new")));
            lore.add((String)(this.instance.getPlayerMain().checkPermPlayer(this.player, "scs.command.claim.remove") ? this.instance.getLanguage().getMessage("access-claim-clickable-removemember") : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-remove-member")));
            int startItem = (page - 1) * max;
            List<Integer> slots_i = guiSettings.getSlots();
            int i = slots_i.get(1);
            int count = 0;
            int count2 = 0;
            for (String p : members) {
                if (count++ < startItem) continue;
                if (count2 > max - 1) break;
                i = slots_i.get(count2);
                ++count2;
                cPlayer.addMapString(i, p);
                ItemStack item = this.instance.getPlayerMain().getPlayerHead(p);
                if (item == null) {
                    item = new ItemStack(Material.PLAYER_HEAD);
                }
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                meta.setDisplayName(this.instance.getLanguage().getMessage("player-member-title").replace("%player%", p));
                meta.setLore(lore);
                item.setItemMeta((ItemMeta)meta);
                this.inv.setItem(i, item);
                ++i;
            }
            return true;
        });
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

