/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ChunkConfirmationGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ChunkConfirmationGui(Player player, SimpleClaimSystem instance, double price) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("chunk_confirmation");
        String title = guiSettings.getTitle();
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(price).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(double price) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("chunk_confirmation"));
            for (GuiSlot slot : slots) {
                int slot_int = slot.getSlot();
                String title = slot.getTitle();
                String lore_string = this.replaceLore(slot.getKey(), slot.getLore(), price);
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                Material mat = slot.getMaterial();
                if (slot.isCustomModel()) {
                    this.inv.setItem(slot_int, this.instance.getGuis().createCustomItem(mat, title, lore, slot.getCustomModelData()));
                    continue;
                }
                if (slot.isCustomHead()) {
                    SkullMeta meta;
                    ItemStack head;
                    if (slot.getCustomTextures().equalsIgnoreCase("%player%")) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        meta.setOwningPlayer((OfflinePlayer)this.player);
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    if (slot.getCustomTextures().length() < 17) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        OfflinePlayer targetP = Bukkit.getOfflinePlayer((String)slot.getCustomTextures());
                        if (targetP != null) {
                            meta.setOwningPlayer(targetP);
                        }
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            return true;
        });
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public String replaceLore(String key, String lore, double price) {
        if (key.equalsIgnoreCase("main-item")) {
            return lore.replace("%price%", this.instance.getMain().getPrice(String.valueOf(price))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"));
        }
        return lore;
    }
}

