/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.Guis.Bedrock.BClaimsOwnerGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimsGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimsGui(Player player, SimpleClaimSystem instance, String filter) {
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (cPlayer == null) {
            return;
        }
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-claims-title"))).content(this.getContent(filter)).button(instance.getLanguage().getMessage("bedrock-gui-claims-filter")).validResultHandler(response -> {
            int clickedSlot = response.clickedButtonId();
            if (clickedSlot == 0) {
                new BClaimsGui(player, instance, this.getNextFilter(filter));
                return;
            }
            String owner = cPlayer.getMapString(clickedSlot);
            if (filter.equals("sales")) {
                new BClaimsOwnerGui(player, instance, owner, filter);
                return;
            }
            new BClaimsOwnerGui(player, instance, owner, "all");
        });
        Map<String, Integer> owners = this.getOwnersByFilter(filter);
        LinkedHashMap sortedOwners = owners.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        cPlayer.clearMapString();
        int i = 1;
        for (Map.Entry entry : sortedOwners.entrySet()) {
            String owner = (String)entry.getKey();
            int claimAmount = (Integer)entry.getValue();
            cPlayer.addMapString(i, owner);
            String ownerHeadUrl = "https://mc-heads.net/avatar/" + owner + "/150";
            form.button(owner + " (Claims: " + instance.getMain().getNumberSeparate(String.valueOf(claimAmount)) + ")", FormImage.Type.URL, ownerHeadUrl);
            ++i;
        }
        this.floodgatePlayer.sendForm(form.build());
    }

    public String getContent(String filter) {
        if (filter.equals("all")) {
            return this.instance.getLanguage().getMessage("bedrock-gui-claims-click-1");
        }
        if (filter.equals("sales")) {
            return this.instance.getLanguage().getMessage("bedrock-gui-claims-click-2");
        }
        if (filter.equals("online")) {
            return this.instance.getLanguage().getMessage("bedrock-gui-claims-click-3");
        }
        if (filter.equals("offline")) {
            return this.instance.getLanguage().getMessage("bedrock-gui-claims-click-4");
        }
        return this.instance.getLanguage().getMessage("bedrock-gui-claims-click-1");
    }

    public String getNextFilter(String filter) {
        filter = filter.equals("all") ? "sales" : (filter.equals("sales") ? "online" : (filter.equals("online") ? "offline" : "all"));
        return filter;
    }

    private Map<String, Integer> getOwnersByFilter(String filter) {
        switch (filter) {
            case "sales": {
                return this.instance.getMain().getClaimsOwnersWithSales();
            }
            case "online": {
                return this.instance.getMain().getClaimsOnlineOwners();
            }
            case "offline": {
                return this.instance.getMain().getClaimsOfflineOwners();
            }
        }
        return this.instance.getMain().getClaimsOwnersGui();
    }
}

