/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.Guis.Bedrock.BClaimMainGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.Claim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimMembersGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimMembersGui(Player player, Claim claim, SimpleClaimSystem instance) {
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-members-title").replace("%name%", claim.getName()))).button(instance.getLanguage().getMessage("bedrock-back-page-main")).content(instance.getLanguage().getMessage("bedrock-gui-members-click")).validResultHandler(response -> {
            if (response.clickedButtonId() == 0) {
                new BClaimMainGui(player, claim, instance);
                return;
            }
            String member = response.clickedButton().text();
            if (player.getName().equals(member)) {
                return;
            }
            if (instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.remove")) {
                String message = instance.getLanguage().getMessage("remove-member-success").replace("%player%", member).replace("%claim-name%", claim.getName());
                ((CompletableFuture)this.instance.getMain().removeClaimMember(claim, member).thenAccept(success -> {
                    if (success.booleanValue()) {
                        instance.executeEntitySync(player, () -> player.sendMessage(message));
                        Player target = Bukkit.getPlayer((String)member);
                        if (target != null && target.isOnline()) {
                            instance.executeEntitySync(target, () -> target.sendMessage(instance.getLanguage().getMessage("remove-claim-player").replace("%claim-name%", claim.getName()).replace("%owner%", member)));
                        }
                    } else {
                        instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
        });
        HashSet members = instance.getMain().convertUUIDSetToStringSet(claim.getMembers());
        ArrayList<String> membersList = new ArrayList<String>(members);
        Collections.sort(membersList, (member1, member2) -> member1.compareTo((String)member2));
        members = new LinkedHashSet<String>(membersList);
        for (String member : members) {
            String memberHeadUrl = "https://mc-heads.net/avatar/" + member + "/150";
            form.button(member, FormImage.Type.URL, memberHeadUrl);
        }
        this.floodgatePlayer.sendForm(form.build());
    }
}

