/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.AdminGestion;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class AdminGestionClaimMainGui
implements InventoryHolder {
    private Inventory inv;
    private SimpleClaimSystem instance;

    public AdminGestionClaimMainGui(Player player, Claim claim, SimpleClaimSystem instance) {
        this.instance = instance;
        String title = "\u00a74[A]\u00a7r " + claim.getName() + " (" + claim.getOwner() + ")";
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)title);
        ((CompletableFuture)this.loadItems(player, claim).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Player player, Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
            cPlayer.setClaim(claim);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Chunks: \u00a7b" + this.instance.getMain().getNumberSeparate(String.valueOf(claim.getChunks().size())));
            lore.add(" ");
            lore.add("\u00a77Members: \u00a7a" + this.instance.getMain().getNumberSeparate(String.valueOf(claim.getMembers().size())));
            lore.add("\u00a77Bans: \u00a7c" + this.instance.getMain().getNumberSeparate(String.valueOf(claim.getBans().size())));
            lore.add(" ");
            lore.add((String)(claim.getSale() ? "\u00a7a\u2714 Claim in sale \u00a77(" + this.instance.getMain().getNumberSeparate(String.valueOf(claim.getPrice())) + this.instance.getLanguage().getMessage("money-symbol") + "\u00a77)" : "\u00a7c\u2718 Claim not in sale"));
            this.inv.setItem(13, this.instance.getGuis().createItem(Material.PAINTING, "\u00a76" + claim.getName(), lore));
            lore.clear();
            lore.add("\u00a77Manage banned players");
            lore.add("\u00a77\u25b8 \u00a7fClick to perform");
            this.inv.setItem(20, this.instance.getGuis().createItem(Material.LECTERN, "\u00a7cBans", lore));
            lore.clear();
            lore.add("\u00a77Delete this claim?");
            lore.add("\u00a77\u25b8 \u00a7fClick to perform");
            this.inv.setItem(24, this.instance.getGuis().createItem(Material.RED_CONCRETE, "\u00a74Unclaim", lore));
            lore.clear();
            lore.add("\u00a77Manage settings");
            lore.add("\u00a77\u25b8 \u00a7fClick to perform");
            this.inv.setItem(29, this.instance.getGuis().createItem(Material.REPEATER, "\u00a73Settings", lore));
            lore.clear();
            lore.add("\u00a77Manage members");
            lore.add("\u00a77\u25b8 \u00a7fClick to perform");
            this.inv.setItem(30, this.instance.getGuis().createItem(Material.TOTEM_OF_UNDYING, "\u00a7aMembers", lore));
            lore.clear();
            lore.add("\u00a77Manage chunks");
            lore.add("\u00a77\u25b8 \u00a7fClick to perform");
            this.inv.setItem(32, this.instance.getGuis().createItem(Material.RED_MUSHROOM_BLOCK, "\u00a76Chunks", lore));
            lore.clear();
            lore.add("\u00a77Teleport to the claim's spawn");
            lore.add("\u00a77\u25b8 \u00a7fClick to perform");
            this.inv.setItem(33, this.instance.getGuis().createItem(Material.ENDER_PEARL, "\u00a75Teleport", lore));
            lore.clear();
            lore.add("\u00a77Go back to claims list of " + (claim.getOwner().equals("*") ? "protected areas" : claim.getOwner()));
            lore.add("\u00a77\u25b8 \u00a7fClick to access");
            this.inv.setItem(49, this.instance.getGuis().createItem(Material.DARK_OAK_DOOR, "\u00a7cPrevious page", lore));
            return true;
        });
    }

    public boolean isClickableSlot(String key) {
        switch (key) {
            default: 
        }
        return true;
    }

    public boolean checkPermButton(Player player, String key) {
        switch (key) {
            case "unclaim": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim");
            }
            case "manage-members": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members");
            }
            case "manage-bans": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans");
            }
            case "manage-settings": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings");
            }
            case "manage-chunks": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks");
            }
            case "claim-info": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list");
            }
        }
        return false;
    }

    public boolean checkPermPerm(Player player, String perm) {
        return this.instance.getPlayerMain().checkPermPlayer(player, "scs.setting." + perm);
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }
}

