/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Config;

import fr.xyness.SCS.SimpleClaimSystem;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ClaimPurge {
    private long offlineTime;
    private BukkitTask BukkitTaskPurge = null;
    private ScheduledTask ScheduledTaskPurge = null;
    private SimpleClaimSystem instance;

    public ClaimPurge(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public boolean hasBeenOfflineFor(OfflinePlayer target) {
        if (!target.isOnline()) {
            if (!target.hasPlayedBefore()) {
                return false;
            }
            long lastPlayed = target.getLastPlayed();
            if (lastPlayed <= 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            long timeElapsed = currentTime - lastPlayed;
            return timeElapsed > this.offlineTime;
        }
        return false;
    }

    public void stopPurge() {
        if (this.BukkitTaskPurge != null) {
            this.BukkitTaskPurge.cancel();
        }
        if (this.ScheduledTaskPurge != null) {
            this.ScheduledTaskPurge.cancel();
        }
    }

    public void startPurge(int minutes, String time) {
        int interval = this.convertTimeToSeconds(time);
        this.offlineTime = (long)interval * 1000L;
        int ticks = minutes * 60 * 20;
        if (this.instance.isFolia()) {
            this.ScheduledTaskPurge = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.instance, task -> this.purgeClaims(), (long)minutes, (long)minutes, TimeUnit.MINUTES);
        } else {
            this.BukkitTaskPurge = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.instance, new Runnable(){

                @Override
                public void run() {
                    ClaimPurge.this.purgeClaims();
                }
            }, (long)ticks, (long)ticks);
        }
    }

    public void purgeClaims() {
        HashMap<String, String> players = new HashMap<String, String>();
        for (String owner : this.instance.getMain().getClaimsOwners()) {
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)owner);
            if (!this.hasBeenOfflineFor(p)) continue;
            int nb = this.instance.getMain().getPlayerClaimsCount(p.getUniqueId());
            players.put(owner, String.valueOf(nb));
            this.instance.getMain().deleteAllClaims(owner);
        }
        StringBuilder sb = new StringBuilder();
        if (players.isEmpty()) {
            sb.append("no claims removed.");
        } else {
            for (Map.Entry entry : players.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append(key).append(" (").append(this.instance.getMain().getNumberSeparate(value)).append(" claims), ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.append(".");
        }
        this.instance.getLogger().info("Auto-purge: " + sb.toString());
    }

    public void purgeClaims(Player player) {
        HashMap<String, String> players = new HashMap<String, String>();
        for (String owner : this.instance.getMain().getClaimsOwners()) {
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)owner);
            if (!this.hasBeenOfflineFor(p)) continue;
            int nb = this.instance.getMain().getPlayerClaimsCount(p.getUniqueId());
            players.put(owner, String.valueOf(nb));
            this.instance.getMain().deleteAllClaims(owner);
        }
        StringBuilder sb = new StringBuilder();
        if (players.isEmpty()) {
            sb.append("no claims removed.");
        } else {
            for (Map.Entry entry : players.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append(key).append(" (").append(this.instance.getMain().getNumberSeparate(value)).append(" claims), ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.append(".");
        }
        player.sendMessage("Auto-purge: " + sb.toString());
    }

    public int convertTimeToSeconds(String time) {
        int totalSeconds = 0;
        Pattern pattern = Pattern.compile("(\\d+)([smhdwMy])");
        Matcher matcher = pattern.matcher(time);
        while (matcher.find()) {
            int value = Integer.parseInt(matcher.group(1));
            char unit = matcher.group(2).charAt(0);
            switch (unit) {
                case 's': {
                    totalSeconds += value;
                    break;
                }
                case 'm': {
                    totalSeconds += value * 60;
                    break;
                }
                case 'h': {
                    totalSeconds += value * 60 * 60;
                    break;
                }
                case 'd': {
                    totalSeconds += value * 60 * 60 * 24;
                    break;
                }
                case 'w': {
                    totalSeconds += value * 60 * 60 * 24 * 7;
                    break;
                }
                case 'M': {
                    totalSeconds += value * 60 * 60 * 24 * 30;
                    break;
                }
                case 'y': {
                    totalSeconds += value * 60 * 60 * 24 * 365;
                    break;
                }
            }
        }
        return totalSeconds;
    }
}

