/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Commands;

import fr.xyness.SCS.Guis.Bedrock.BUnclaimConfirmationGui;
import fr.xyness.SCS.Guis.UnclaimConfirmationGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.WorldMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.geysermc.floodgate.api.FloodgateApi;

public class UnclaimCommand
implements CommandExecutor,
TabCompleter {
    public static Map<Player, String> isOnDelete = new HashMap<Player, String>();
    private SimpleClaimSystem instance;

    public UnclaimCommand(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
            ArrayList<String> completions = new ArrayList<String>();
            if (args.length == 1) {
                completions.addAll(this.getPrimaryCompletions(player, args));
            }
            return completions;
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return new ArrayList<String>();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.instance.getLanguage().getMessage("command-only-by-players"));
            return true;
        }
        Player player = (Player)sender;
        String playerName = player.getName();
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        String world = player.getWorld().getName();
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getAliase(world)));
            return false;
        }
        if (args.length > 1) {
            player.sendMessage(this.instance.getLanguage().getMessage("help-unclaim").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")));
            return false;
        }
        if (args.length == 1) {
            if (args[0].equals("*")) {
                if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim.all")) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                    return false;
                }
                if (cPlayer.getClaimsCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-has-no-claim"));
                    return false;
                }
                if (this.instance.getSettings().getBooleanSetting("claim-confirmation")) {
                    if (isOnDelete.containsKey(player)) {
                        isOnDelete.remove(player);
                        ((CompletableFuture)this.instance.getMain().deleteAllClaims(playerName).thenAccept(success -> {
                            if (success.booleanValue()) {
                                player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                            } else {
                                player.sendMessage(this.instance.getLanguage().getMessage("error"));
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                    } else {
                        isOnDelete.put(player, "*");
                        if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                            new BUnclaimConfirmationGui(player, this.instance);
                            return true;
                        }
                        new UnclaimConfirmationGui(player, this.instance);
                    }
                } else {
                    ((CompletableFuture)this.instance.getMain().deleteAllClaims(playerName).thenAccept(success -> {
                        if (success.booleanValue()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                        } else {
                            player.sendMessage(this.instance.getLanguage().getMessage("error"));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                }
                return true;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[0], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return false;
            }
            if (this.instance.getSettings().getBooleanSetting("claim-confirmation")) {
                if (isOnDelete.containsKey(player)) {
                    isOnDelete.remove(player);
                    ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                        if (success.booleanValue()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                        } else {
                            player.sendMessage(this.instance.getLanguage().getMessage("error"));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                } else {
                    isOnDelete.put(player, claim.getName());
                    if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                        new BUnclaimConfirmationGui(player, this.instance);
                        return true;
                    }
                    new UnclaimConfirmationGui(player, this.instance);
                }
            } else {
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                    } else {
                        player.sendMessage(this.instance.getLanguage().getMessage("error"));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            }
            return true;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (!this.instance.getMain().checkIfClaimExists(chunk)) {
            player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
            return false;
        }
        Claim claim = this.instance.getMain().getClaim(chunk);
        String owner = claim.getOwner();
        if (owner.equals("*") && player.hasPermission("scs.admin")) {
            ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.instance.getLanguage().getMessage("delete-claim-protected-area"));
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return true;
        }
        if (!owner.equals(player.getName())) {
            player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
            return false;
        }
        if (this.instance.getSettings().getBooleanSetting("claim-confirmation")) {
            if (isOnDelete.containsKey(player)) {
                isOnDelete.remove(player);
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                    } else {
                        player.sendMessage(this.instance.getLanguage().getMessage("error"));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            } else {
                isOnDelete.put(player, claim.getName());
                if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                    new BUnclaimConfirmationGui(player, this.instance);
                    return true;
                }
                new UnclaimConfirmationGui(player, this.instance);
            }
        } else {
            ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
        return true;
    }

    private List<String> getPrimaryCompletions(Player player, String[] args) {
        String partialInput = args.length > 0 ? args[0].toLowerCase() : "";
        ArrayList<String> completions = new ArrayList<String>();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim.all")) {
            completions.add("*");
        }
        completions.addAll(this.instance.getMain().getClaimsNameFromOwner(player.getName()));
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }
}

