/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import fr.xyness.SCS.API.Listeners.ClaimCreateEvent;
import fr.xyness.SCS.API.Listeners.UnclaimEvent;
import fr.xyness.SCS.API.Listeners.UnclaimallEvent;
import fr.xyness.SCS.CScoreboard;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ClaimMain {
    private Map<Chunk, Claim> listClaims = new HashMap<Chunk, Claim>();
    private Map<UUID, CustomSet<Claim>> playerClaims = new ConcurrentHashMap<UUID, CustomSet<Claim>>();
    public static final UUID SERVER_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private final Map<Player, Location> playerLocations = new HashMap<Player, Location>();
    private final Map<Player, BukkitTask> activeTasks = new ConcurrentHashMap<Player, BukkitTask>();
    private final Map<Player, ScheduledTask> activeFoliaTasks = new ConcurrentHashMap<Player, ScheduledTask>();
    private CustomSet<Chunk> chunksParticles = new CustomSet();
    private CustomSet<String> commandArgsClaim = new CustomSet<String>((Collection<String>)Set.of("add", "autoclaim", "automap", "list", "map", "members", "remove", "see", "setdesc", "setname", "setspawn", "settings", "tp", "chat", "ban", "unban", "bans", "owner", "autofly", "fly", "merge", "sell", "cancel", "addchunk", "removechunk", "chunks", "main", "kick", "autounclaim", "autoaddchunk", "autodelchunk", "accept", "deny", "cancelinv"));
    private CustomSet<String> commandArgsScs = new CustomSet<String>((Collection<String>)Set.of("reload", "config-reload", "transfer", "list", "player", "group", "forceunclaim", "setowner", "set-lang", "reset-all-player-claims-settings", "reset-all-admin-claims-settings", "admin", "setexpulsionlocation"));
    private CustomSet<String> commandArgsParea = new CustomSet<String>((Collection<String>)Set.of("setdesc", "settings", "setname", "members", "tp", "list", "ban", "unban", "bans", "add", "remove", "unclaim", "main", "kick"));
    private SimpleClaimSystem instance;

    public ClaimMain(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public void clearAll() {
        this.playerClaims.clear();
        this.playerLocations.clear();
        this.listClaims.clear();
        this.activeTasks.values().stream().forEach(t -> t.cancel());
        this.activeTasks.clear();
        if (this.instance.isFolia()) {
            this.activeFoliaTasks.values().stream().forEach(t -> t.cancel());
            this.activeFoliaTasks.clear();
        }
    }

    public void clearDataForPlayer(Player player) {
        this.playerLocations.remove(player);
        if (this.activeTasks.containsKey(player)) {
            this.activeTasks.get(player).cancel();
            this.activeTasks.remove(player);
        }
        if (this.instance.isFolia() && this.activeFoliaTasks.containsKey(player)) {
            this.activeFoliaTasks.get(player).cancel();
            this.activeFoliaTasks.remove(player);
        }
    }

    public void sendMessage(Player player, String message, String type) {
        if (message.isBlank()) {
            return;
        }
        switch (type) {
            case "ACTION_BAR": {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                return;
            }
            case "SUBTITLE": {
                player.sendTitle("", message, 0, 25, 0);
                return;
            }
            case "TITLE": {
                player.sendTitle(message, "", 0, 25, 0);
                return;
            }
            case "CHAT": {
                player.sendMessage(message);
                return;
            }
            case "BOSSBAR": {
                this.sendBossbarMessage(player, message);
                return;
            }
        }
    }

    public void sendBossbarMessage(final Player player, String message) {
        final BossBar b = this.instance.getBossBars().checkBossBar(player);
        b.setTitle(message);
        b.setVisible(true);
        b.setColor(BarColor.RED);
        Runnable updateTask = () -> {
            if (!player.isOnline()) {
                return;
            }
            final int[] counter = new int[]{20};
            if (this.instance.isFolia()) {
                Runnable countdownTask = () -> {
                    if (counter[0] <= 0) {
                        b.setColor(BarColor.valueOf((String)this.instance.getSettings().getSetting("bossbar-color")));
                        b.setProgress(1.0);
                        Bukkit.getRegionScheduler().run((Plugin)this.instance, player.getLocation(), task -> this.instance.getBossBars().activeBossBar(player, player.getLocation().getChunk()));
                    } else {
                        counter[0] = counter[0] - 1;
                        b.setProgress((double)counter[0] / 20.0);
                    }
                };
                if (this.activeFoliaTasks.containsKey(player)) {
                    this.activeFoliaTasks.get(player).cancel();
                }
                ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.instance, subtask -> {
                    countdownTask.run();
                    if (!player.isOnline()) {
                        subtask.cancel();
                    }
                    if (counter[0] <= 0) {
                        subtask.cancel();
                        b.setColor(BarColor.valueOf((String)this.instance.getSettings().getSetting("bossbar-color")));
                        b.setProgress(1.0);
                        Bukkit.getRegionScheduler().run((Plugin)this.instance, player.getLocation(), subsubtask -> this.instance.getBossBars().activeBossBar(player, player.getLocation().getChunk()));
                    }
                }, 0L, 100L, TimeUnit.MILLISECONDS);
                this.activeFoliaTasks.put(player, task);
            } else {
                final Runnable countdownTask = () -> {
                    if (counter[0] <= 0) {
                        b.setColor(BarColor.valueOf((String)this.instance.getSettings().getSetting("bossbar-color")));
                        b.setProgress(1.0);
                        this.instance.getBossBars().activeBossBar(player, player.getLocation().getChunk());
                    } else {
                        counter[0] = counter[0] - 1;
                        b.setProgress((double)counter[0] / 20.0);
                    }
                };
                if (this.activeTasks.containsKey(player)) {
                    this.activeTasks.get(player).cancel();
                }
                BukkitTask task = new BukkitRunnable(){

                    public void run() {
                        countdownTask.run();
                        if (!player.isOnline()) {
                            this.cancel();
                        }
                        if (counter[0] <= 0) {
                            this.cancel();
                            b.setColor(BarColor.valueOf((String)ClaimMain.this.instance.getSettings().getSetting("bossbar-color")));
                            b.setProgress(1.0);
                            ClaimMain.this.instance.getBossBars().activeBossBar(player, player.getLocation().getChunk());
                        }
                    }
                }.runTaskTimer((Plugin)this.instance, 0L, 2L);
                this.activeTasks.put(player, task);
            }
        };
        updateTask.run();
    }

    public String getNumberSeparate(String text) {
        if (text.contains(".")) {
            String[] parts = text.split("\\.");
            return this.getNumberSeparate(parts[0]) + "." + parts[1];
        }
        StringBuilder sb = new StringBuilder(text);
        int length = sb.length();
        for (int i = length - 3; i > 0; i -= 3) {
            sb.insert(i, ',');
        }
        return sb.toString();
    }

    public String getNumberFormatted(String text) {
        if (text.contains(".")) {
            String[] parts = text.split("\\.");
            if (parts[1].equals("0")) {
                return this.getNumberFormatted(parts[0]);
            }
            return this.getNumberFormatted(parts[0]) + "." + parts[1];
        }
        int length = text.length();
        String decimalPart = "";
        if (length >= 4 && length <= 6) {
            String mainPart = text.substring(0, length - 3);
            decimalPart = text.substring(length - 3, length - 2);
            return mainPart + (String)(decimalPart.equals("0") ? "" : "," + decimalPart) + this.instance.getLanguage().getMessage("formatted-1000");
        }
        if (length >= 7 && length <= 9) {
            String mainPart = text.substring(0, length - 6);
            decimalPart = text.substring(length - 6, length - 5);
            return mainPart + (String)(decimalPart.equals("0") ? "" : "," + decimalPart) + this.instance.getLanguage().getMessage("formatted-1000000");
        }
        if (length >= 10 && length <= 12) {
            String mainPart = text.substring(0, length - 9);
            decimalPart = text.substring(length - 9, length - 8);
            return mainPart + (String)(decimalPart.equals("0") ? "" : "," + decimalPart) + this.instance.getLanguage().getMessage("formatted-1000000000");
        }
        if (length >= 13 && length <= 15) {
            String mainPart = text.substring(0, length - 12);
            decimalPart = text.substring(length - 12, length - 11);
            return mainPart + (String)(decimalPart.equals("0") ? "" : "," + decimalPart) + this.instance.getLanguage().getMessage("formatted-1000000000000");
        }
        if (length >= 16 && length <= 18) {
            String mainPart = text.substring(0, length - 15);
            decimalPart = text.substring(length - 15, length - 14);
            return mainPart + (String)(decimalPart.equals("0") ? "" : "," + decimalPart) + this.instance.getLanguage().getMessage("formatted-1000000000000000");
        }
        if (length >= 19 && length <= 21) {
            String mainPart = text.substring(0, length - 18);
            decimalPart = text.substring(length - 18, length - 17);
            return mainPart + (String)(decimalPart.equals("0") ? "" : "," + decimalPart) + this.instance.getLanguage().getMessage("formatted-1000000000000000000");
        }
        if (length >= 22 && length <= 24) {
            String mainPart = text.substring(0, length - 21);
            decimalPart = text.substring(length - 21, length - 20);
            return mainPart + (String)(decimalPart.equals("0") ? "" : "," + decimalPart) + this.instance.getLanguage().getMessage("formatted-1000000000000000000000");
        }
        return text;
    }

    public String getPrice(long price) {
        if (this.instance.getSettings().getBooleanSetting("use-formatted-number")) {
            return this.getNumberFormatted(String.valueOf(price));
        }
        return this.getNumberSeparate(String.valueOf(price));
    }

    public String getPrice(String price) {
        if (this.instance.getSettings().getBooleanSetting("use-formatted-number")) {
            return this.getNumberFormatted(price);
        }
        return this.getNumberSeparate(price);
    }

    public Claim getClaim(Chunk chunk) {
        return this.listClaims.get(chunk);
    }

    public Claim getClaimByName(String name, Player owner) {
        return this.playerClaims.getOrDefault(owner.getUniqueId(), new CustomSet()).stream().filter(claim -> claim.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Claim getClaimByName(String name, UUID ownerUUID) {
        return this.playerClaims.getOrDefault(ownerUUID, new CustomSet()).stream().filter(claim -> claim.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Claim getProtectedAreaByName(String name) {
        return this.playerClaims.getOrDefault(SERVER_UUID, new CustomSet()).stream().filter(claim -> claim.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public CustomSet<Claim> getProtectedAreas() {
        return this.playerClaims.getOrDefault(SERVER_UUID, new CustomSet());
    }

    public CustomSet<Chunk> getAllChunksFromAllClaims(String owner) {
        return this.listClaims.entrySet().stream().filter(entry -> ((Claim)entry.getValue()).getOwner().equals(owner)).map(Map.Entry::getKey).collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<Chunk> getAllChunksFromAllProtectedAreas() {
        return this.listClaims.entrySet().stream().filter(entry -> ((Claim)entry.getValue()).getUUID().equals(SERVER_UUID)).map(Map.Entry::getKey).collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<Claim> getClaimsInSale(String owner) {
        return this.listClaims.values().stream().filter(claim -> claim.getOwner().equals(owner) && claim.getSale()).collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<Claim> getPlayerClaims(String owner) {
        return this.listClaims.values().stream().filter(claim -> claim.getOwner().equalsIgnoreCase(owner)).collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<Claim> getPlayerClaims(UUID targetUUID) {
        return this.playerClaims.getOrDefault(targetUUID, new CustomSet());
    }

    public void setPlayerClaims(UUID targetUUID, CustomSet<Claim> claims) {
        this.playerClaims.put(targetUUID, claims);
    }

    public Claim getClaimFromChunk(Chunk chunk) {
        return this.listClaims.get(chunk);
    }

    public CustomSet<String> getStringChunkFromClaim(Claim claim) {
        return claim.getChunks().stream().map(chunk -> chunk.getWorld().getName() + ";" + chunk.getX() + ";" + chunk.getZ()).collect(Collectors.toCollection(CustomSet::new));
    }

    public int getPlayerClaimsCount(UUID targetUUID) {
        return this.playerClaims.getOrDefault(targetUUID, new CustomSet()).size();
    }

    public Map<String, Integer> getClaimsOwnersGui() {
        HashMap<String, Integer> players = new HashMap<String, Integer>();
        this.playerClaims.keySet().stream().forEach(UUID2 -> {
            if (!UUID2.equals(SERVER_UUID)) {
                players.put(this.instance.getPlayerMain().getPlayerName((UUID)UUID2), this.playerClaims.get(UUID2).size());
            }
        });
        return players;
    }

    public CustomSet<String> getClaimsOwners() {
        return this.playerClaims.values().stream().filter(claims -> !claims.isEmpty()).map(claims -> ((Claim)claims.iterator().next()).getOwner()).filter(owner -> !"*".equals(owner)).collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<Chunk> getAllClaimsChunk() {
        return this.listClaims.keySet().stream().collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<Claim> getAllClaims() {
        return this.listClaims.values().stream().collect(Collectors.toCollection(CustomSet::new));
    }

    public int getAllClaimsCount() {
        return this.listClaims.values().size();
    }

    public int getProtectedAreasCount() {
        return this.playerClaims.getOrDefault(SERVER_UUID, new CustomSet()).size();
    }

    public CustomSet<String> getAllMembersOfAllPlayerClaim(String owner) {
        return this.listClaims.values().stream().filter(claim -> claim.getOwner().equals(owner)).flatMap(claim -> claim.getMembers().stream()).map(uuid -> this.instance.getPlayerMain().getPlayerName((UUID)uuid)).collect(Collectors.toCollection(CustomSet::new));
    }

    public Map<String, Integer> getClaimsOnlineOwners() {
        return this.playerClaims.values().stream().flatMap(Collection::stream).filter(claim -> {
            Player player = Bukkit.getPlayer((String)claim.getOwner());
            return player != null && player.isOnline() && !claim.getUUID().equals(SERVER_UUID);
        }).collect(Collectors.toConcurrentMap(Claim::getOwner, claim -> 1, Integer::sum, ConcurrentHashMap::new));
    }

    public Map<String, Integer> getClaimsOwnersWithSales() {
        return this.playerClaims.entrySet().stream().filter(entry -> !((UUID)entry.getKey()).equals(SERVER_UUID)).filter(entry -> ((CustomSet)entry.getValue()).stream().anyMatch(Claim::getSale)).collect(Collectors.toMap(entry -> {
            CustomSet claims = (CustomSet)entry.getValue();
            return claims.isEmpty() ? "Unknown" : ((Claim)claims.iterator().next()).getOwner();
        }, entry -> (int)((CustomSet)entry.getValue()).stream().filter(Claim::getSale).count(), (oldValue, newValue) -> oldValue));
    }

    public Map<String, Integer> getClaimsOfflineOwners() {
        return this.playerClaims.values().stream().flatMap(Collection::stream).filter(claim -> {
            Player player = Bukkit.getPlayer((String)claim.getOwner());
            return player == null && !claim.getUUID().equals(SERVER_UUID);
        }).collect(Collectors.toConcurrentMap(Claim::getOwner, claim -> 1, Integer::sum, ConcurrentHashMap::new));
    }

    public CustomSet<Claim> getClaimsWhereMemberNotOwner(Player player) {
        UUID playerId = player.getUniqueId();
        String playerName = player.getName();
        return this.listClaims.entrySet().stream().filter(entry -> !((Claim)entry.getValue()).getOwner().equals(playerName) && ((Claim)entry.getValue()).getMembers().contains(playerId)).map(Map.Entry::getValue).collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<String> getClaimsNameFromOwner(String owner) {
        return this.listClaims.entrySet().stream().filter(entry -> ((Claim)entry.getValue()).getOwner().equalsIgnoreCase(owner)).map(entry -> ((Claim)entry.getValue()).getName()).collect(Collectors.toCollection(CustomSet::new));
    }

    public CustomSet<String> getClaimsNameInSaleFromOwner(String owner) {
        return this.listClaims.entrySet().stream().filter(entry -> ((Claim)entry.getValue()).getOwner().equalsIgnoreCase(owner) && ((Claim)entry.getValue()).getSale()).map(entry -> ((Claim)entry.getValue()).getName()).collect(Collectors.toCollection(CustomSet::new));
    }

    public List<String> getAllMembersWithPlayerParallel(String playerName) {
        return this.listClaims.values().stream().filter(claim -> claim.getMembers().contains(this.instance.getPlayerMain().getPlayerUUID(playerName))).flatMap(claim -> claim.getMembers().stream()).map(uuid -> this.instance.getPlayerMain().getPlayerName((UUID)uuid)).filter(member -> !member.equals(playerName)).distinct().collect(Collectors.toList());
    }

    public CustomSet<String> convertUUIDSetToStringSet(Set<UUID> uuids) {
        return uuids.stream().map(uuid -> this.instance.getPlayerMain().getPlayerName((UUID)uuid)).filter(Objects::nonNull).collect(Collectors.toCollection(CustomSet::new));
    }

    public boolean areChunksInSameWorld(Set<Chunk> chunks) {
        if (chunks == null || chunks.isEmpty()) {
            return true;
        }
        World firstWorld = null;
        for (Chunk chunk : chunks) {
            if (firstWorld == null) {
                firstWorld = chunk.getWorld();
                continue;
            }
            if (chunk.getWorld().equals((Object)firstWorld)) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyChunkAdjacent(Set<Chunk> chunks, Chunk targetChunk) {
        int targetX = targetChunk.getX();
        int targetZ = targetChunk.getZ();
        World targetWorld = targetChunk.getWorld();
        for (Chunk chunk : chunks) {
            if (!chunk.getWorld().equals((Object)targetWorld)) continue;
            int x = chunk.getX();
            int z = chunk.getZ();
            if (!(x == targetX + 1 && z == targetZ || x == targetX - 1 && z == targetZ || x == targetX && z == targetZ + 1) && (x != targetX || z != targetZ - 1)) continue;
            return true;
        }
        return false;
    }

    public boolean areChunksConnected(Set<Chunk> chunks) {
        if (chunks.size() < 2) {
            return true;
        }
        HashSet<Chunk> remainingChunks = new HashSet<Chunk>(chunks);
        ArrayDeque<Chunk> queue = new ArrayDeque<Chunk>();
        Chunk start = (Chunk)remainingChunks.iterator().next();
        queue.add(start);
        remainingChunks.remove(start);
        while (!queue.isEmpty()) {
            Chunk current = (Chunk)queue.poll();
            int x = current.getX();
            int z = current.getZ();
            remainingChunks.removeIf(chunk -> {
                if (chunk.getX() == x + 1 && chunk.getZ() == z || chunk.getX() == x - 1 && chunk.getZ() == z || chunk.getX() == x && chunk.getZ() == z + 1 || chunk.getX() == x && chunk.getZ() == z - 1) {
                    queue.add((Chunk)chunk);
                    return true;
                }
                return false;
            });
            if (!remainingChunks.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyChunkAdjacentBetweenSets(Set<Chunk> set1, CustomSet<Chunk> set2) {
        for (Chunk chunk1 : set1) {
            int x1 = chunk1.getX();
            int z1 = chunk1.getZ();
            World world1 = chunk1.getWorld();
            for (Chunk chunk2 : set2) {
                if (!chunk2.getWorld().equals((Object)world1)) continue;
                int x2 = chunk2.getX();
                int z2 = chunk2.getZ();
                if (!(x1 == x2 + 1 && z1 == z2 || x1 == x2 - 1 && z1 == z2 || x1 == x2 && z1 == z2 + 1) && (x1 != x2 || z1 != z2 - 1)) continue;
                return true;
            }
        }
        return false;
    }

    public void goClaim(final Player player, Location loc) {
        if (loc == null) {
            return;
        }
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        int delay = cPlayer.getDelay();
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass") || delay == 0) {
            this.teleportPlayer(player, loc);
            player.sendMessage(this.instance.getLanguage().getMessage("teleportation-success"));
            return;
        }
        player.sendMessage(this.instance.getLanguage().getMessage("teleportation-in-progress").replace("%delay%", String.valueOf(delay)));
        Location originalLocation = player.getLocation().clone();
        this.playerLocations.put(player, originalLocation);
        final Runnable teleportTask = this.createTeleportTask(player, loc, originalLocation, delay);
        if (this.instance.isFolia()) {
            Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.instance, task -> {
                teleportTask.run();
                if (!this.playerLocations.containsKey(player)) {
                    task.cancel();
                }
            }, 0L, 500L, TimeUnit.MILLISECONDS);
        } else {
            new BukkitRunnable(){

                public void run() {
                    teleportTask.run();
                    if (!ClaimMain.this.playerLocations.containsKey(player)) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.instance, 0L, 10L);
        }
    }

    public void teleportPlayer(Player player, Location loc) {
        if (this.instance.isFolia()) {
            Location playerLoc = player.getLocation();
            if (player.isOnline() && !player.isDead()) {
                player.teleportAsync(loc).thenAccept(success -> this.instance.executeSync(() -> {
                    PlayerTeleportEvent e = new PlayerTeleportEvent(player, playerLoc, loc);
                    Bukkit.getPluginManager().callEvent((Event)e);
                }));
            }
        } else if (player.isOnline() && !player.isDead()) {
            player.teleport(loc);
        }
    }

    public void teleportPlayerToExpulsion(Player player) {
        Location loc = this.instance.getSettings().getExpulsionLocation();
        this.teleportPlayer(player, loc == null ? ((World)Bukkit.getWorlds().get(0)).getSpawnLocation() : loc);
    }

    private Runnable createTeleportTask(final Player player, final Location loc, final Location originalLocation, final int delay) {
        return new Runnable(){
            int countdown;
            {
                this.countdown = delay * 2;
            }

            @Override
            public void run() {
                Location currentLocation;
                if (!player.isOnline() || !ClaimMain.this.playerLocations.containsKey(player)) {
                    ClaimMain.this.playerLocations.remove(player);
                    return;
                }
                if (!(ClaimMain.this.instance.getSettings().getBooleanSetting("teleportation-delay-moving") || (currentLocation = player.getLocation()).equals((Object)originalLocation) || currentLocation.getX() == originalLocation.getX() && currentLocation.getY() == originalLocation.getY() && currentLocation.getZ() == originalLocation.getZ())) {
                    player.sendMessage(ClaimMain.this.instance.getLanguage().getMessage("teleportation-canceled-moving"));
                    ClaimMain.this.playerLocations.remove(player);
                    return;
                }
                if (this.countdown <= 0) {
                    ClaimMain.this.teleportPlayer(player, loc);
                    player.sendMessage(ClaimMain.this.instance.getLanguage().getMessage("teleportation-success"));
                    ClaimMain.this.playerLocations.remove(player);
                } else {
                    --this.countdown;
                }
            }
        };
    }

    public boolean checkName(UUID ownerId, String name) {
        return this.playerClaims.getOrDefault(ownerId, new CustomSet()).stream().noneMatch(claim -> claim.getName().toLowerCase().equals(name.toLowerCase()));
    }

    public String getClaimNameByChunk(Chunk chunk) {
        Claim claim = this.listClaims.getOrDefault(chunk, null);
        return claim == null ? "" : claim.getName();
    }

    public String getClaimCoords(Claim claim) {
        Location loc = claim.getLocation();
        String world = this.instance.getSettings().getWorldAliase(loc.getWorld().getName());
        String x = String.valueOf(Math.round(loc.getX() * 10.0 / 10.0));
        String y = String.valueOf(Math.round(loc.getY() * 10.0 / 10.0));
        String z = String.valueOf(Math.round(loc.getZ() * 10.0 / 10.0));
        return world + ", " + x + ", " + y + ", " + z;
    }

    public int findFreeId(UUID targetUUID) {
        return this.playerClaims.getOrDefault(targetUUID, new CustomSet()).stream().mapToInt(Claim::getId).max().orElse(-1) + 1;
    }

    public int findFreeIdProtectedArea() {
        return this.playerClaims.getOrDefault(SERVER_UUID, new CustomSet()).stream().mapToInt(Claim::getId).max().orElse(-1) + 1;
    }

    public Location getCenterLocationOfChunk(Chunk chunk) {
        World world = chunk.getWorld();
        int centerX = (chunk.getX() << 4) + 8;
        int centerZ = (chunk.getZ() << 4) + 8;
        int maxY = world.getHighestBlockYAt(centerX, centerZ);
        return new Location(world, (double)centerX, (double)maxY, (double)centerZ);
    }

    public static String replaceCharAt(String str, int index, char newChar) {
        if (str == null) {
            return null;
        }
        if (index < 0 || index >= str.length()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        StringBuilder sb = new StringBuilder(str);
        sb.setCharAt(index, newChar);
        return sb.toString();
    }

    public static String removeCharAt(String str, int index) {
        if (str == null) {
            return null;
        }
        if (index < 0 || index >= str.length()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        StringBuilder sb = new StringBuilder(str);
        sb.deleteCharAt(index);
        return sb.toString();
    }

    public static String removeCharsAtIndices(String str, List<Integer> indices) {
        if (str == null) {
            return null;
        }
        Collections.sort(indices, Collections.reverseOrder());
        StringBuilder sb = new StringBuilder(str);
        for (int index : indices) {
            if (index < 0 || index >= sb.length()) {
                throw new IllegalArgumentException("Index out of bounds: " + index);
            }
            sb.deleteCharAt(index);
        }
        return sb.toString();
    }

    public void convertLocalToNewLocal() {
        StringBuilder natural = new StringBuilder();
        StringBuilder visitors = new StringBuilder();
        StringBuilder members_ = new StringBuilder();
        for (String key : this.instance.getSettings().getDefaultValues().get("natural").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("natural").get(key).booleanValue()) {
                natural.append("1");
                continue;
            }
            natural.append("0");
        }
        for (String key : this.instance.getSettings().getDefaultValues().get("visitors").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("visitors").get(key).booleanValue()) {
                visitors.append("1");
                continue;
            }
            visitors.append("0");
        }
        for (String key : this.instance.getSettings().getDefaultValues().get("members").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("members").get(key).booleanValue()) {
                members_.append("1");
                continue;
            }
            members_.append("0");
        }
        this.instance.getSettings().setDefaultValuesCode(natural.toString(), "natural");
        this.instance.getSettings().setDefaultValuesCode(visitors.toString(), "visitors");
        this.instance.getSettings().setDefaultValuesCode(members_.toString(), "members");
        this.instance.info("Starting the conversion.");
        HikariConfig localConfig = new HikariConfig();
        localConfig.setJdbcUrl("jdbc:sqlite:plugins/SimpleClaimSystem/claims.db");
        localConfig.addDataSourceProperty("busy_timeout", "5000");
        int[] count = new int[]{0};
        try (HikariDataSource localDataSource = new HikariDataSource(localConfig);
             Connection connection = localDataSource.getConnection();){
            String getQuery = "SELECT * FROM scs_claims";
            try (PreparedStatement preparedStatement = connection.prepareStatement(getQuery);
                 ResultSet rs = preparedStatement.executeQuery();){
                ArrayList<CompletionStage> futureClaims = new ArrayList<CompletionStage>();
                while (rs.next()) {
                    World world;
                    int id = rs.getInt("id");
                    String uuid = rs.getString("uuid");
                    String owner_uuid = uuid.equals("aucun") ? SERVER_UUID.toString() : uuid;
                    String owner_name = rs.getString("name").equals("admin") ? "*" : rs.getString("name");
                    String claim_name = rs.getString("claim_name");
                    String claim_description = rs.getString("claim_description");
                    String world_name = rs.getString("World");
                    World check_world = Bukkit.getWorld((String)world_name);
                    World world2 = world = check_world == null ? Bukkit.createWorld((WorldCreator)new WorldCreator(world_name)) : check_world;
                    if (world == null) continue;
                    String location = rs.getString("Location");
                    String members = rs.getString("Members");
                    String permissions = this.instance.getSettings().getDefaultValuesCode("all");
                    boolean for_sale = rs.getBoolean("isSale");
                    double sale_price = rs.getDouble("SalePrice");
                    String bans = rs.getString("Bans");
                    ConcurrentHashMap.KeySetView chunks = ConcurrentHashMap.newKeySet();
                    List X = Arrays.stream(rs.getString("X").split(";")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
                    List Z = Arrays.stream(rs.getString("Z").split(";")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
                    if (X.size() != Z.size()) continue;
                    if (this.instance.isFolia()) {
                        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
                        for (int i = 0; i < X.size(); ++i) {
                            int x = (Integer)X.get(i);
                            int z = (Integer)Z.get(i);
                            CompletionStage future = ((CompletableFuture)world.getChunkAtAsync(x, z).thenAccept(chunks::add)).exceptionally(ex -> {
                                ex.printStackTrace();
                                return null;
                            });
                            futures.add(future);
                        }
                        CompletionStage claimFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
                            count[0] = count[0] + 1;
                            return new ClaimData(id, owner_uuid, owner_name, claim_name, claim_description, this.serializeChunks(chunks), world_name, location, members, permissions, for_sale, sale_price, bans);
                        });
                        futureClaims.add(claimFuture);
                        continue;
                    }
                    for (int i = 0; i < X.size(); ++i) {
                        int x = (Integer)X.get(i);
                        int z = (Integer)Z.get(i);
                        Chunk chunk = world.getChunkAt(x, z);
                        chunks.add(chunk);
                    }
                    count[0] = count[0] + 1;
                    ClaimData claimData = new ClaimData(id, owner_uuid, owner_name, claim_name, claim_description, this.serializeChunks(chunks), world_name, location, members, permissions, for_sale, sale_price, bans);
                    futureClaims.add(CompletableFuture.completedFuture(claimData));
                }
                CompletableFuture<Void> allClaimsFuture = CompletableFuture.allOf(futureClaims.toArray(new CompletableFuture[0]));
                ((CompletableFuture)((CompletableFuture)allClaimsFuture.thenRun(() -> {
                    try (Connection targetConnection = this.instance.getDataSource().getConnection();
                         PreparedStatement stmt = targetConnection.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions, for_sale, sale_price, bans) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                        for (CompletableFuture future : futureClaims) {
                            ClaimData claimData;
                            try {
                                claimData = (ClaimData)future.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                            stmt.setInt(1, claimData.id);
                            stmt.setString(2, claimData.owner_uuid);
                            stmt.setString(3, claimData.owner_name);
                            stmt.setString(4, claimData.claim_name);
                            stmt.setString(5, claimData.claim_description);
                            stmt.setString(6, claimData.chunks);
                            stmt.setString(7, claimData.world_name);
                            stmt.setString(8, claimData.location);
                            stmt.setString(9, claimData.members);
                            stmt.setString(10, claimData.permissions);
                            stmt.setBoolean(11, claimData.for_sale);
                            stmt.setDouble(12, claimData.sale_price);
                            stmt.setString(13, claimData.bans);
                            stmt.addBatch();
                        }
                        stmt.executeBatch();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    this.instance.info(String.valueOf(ChatColor.DARK_GREEN) + this.getNumberSeparate(String.valueOf(count[0])) + " claims converted.");
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                })).join();
                final Runnable task = () -> {
                    boolean isDeleted;
                    File dbFile;
                    if (localDataSource != null) {
                        localDataSource.close();
                    }
                    if ((dbFile = new File("plugins/SimpleClaimSystem/claims.db")).exists() && (isDeleted = dbFile.delete())) {
                        this.instance.getLogger().info("Old database file deleted successfully.");
                    }
                };
                if (this.instance.isFolia()) {
                    Bukkit.getAsyncScheduler().runDelayed((Plugin)this.instance, t -> task.run(), 10L, TimeUnit.SECONDS);
                } else {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.instance, new Runnable(){

                        @Override
                        public void run() {
                            task.run();
                        }
                    }, 200L);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void convertDistantToNewDistant() {
        StringBuilder natural = new StringBuilder();
        StringBuilder visitors = new StringBuilder();
        StringBuilder members_ = new StringBuilder();
        for (String key : this.instance.getSettings().getDefaultValues().get("natural").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("natural").get(key).booleanValue()) {
                natural.append("1");
                continue;
            }
            natural.append("0");
        }
        for (String key : this.instance.getSettings().getDefaultValues().get("visitors").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("visitors").get(key).booleanValue()) {
                visitors.append("1");
                continue;
            }
            visitors.append("0");
        }
        for (String key : this.instance.getSettings().getDefaultValues().get("members").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("members").get(key).booleanValue()) {
                members_.append("1");
                continue;
            }
            members_.append("0");
        }
        this.instance.getSettings().setDefaultValuesCode(natural.toString(), "natural");
        this.instance.getSettings().setDefaultValuesCode(visitors.toString(), "visitors");
        this.instance.getSettings().setDefaultValuesCode(members_.toString(), "members");
        int count = 0;
        try (Connection connection = this.instance.getDataSource().getConnection();){
            String getQuery = "SELECT * FROM scs_claims";
            try (PreparedStatement preparedStatement = connection.prepareStatement(getQuery);
                 ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    World world;
                    int id = rs.getInt("id");
                    String owner_name = rs.getString("name");
                    String owner_uuid = owner_name.equals("*") ? SERVER_UUID.toString() : rs.getString("uuid");
                    String claim_name = rs.getString("claim_name");
                    String claim_description = rs.getString("claim_description");
                    String world_name = rs.getString("World");
                    World check_world = Bukkit.getWorld((String)world_name);
                    World world2 = world = check_world == null ? Bukkit.createWorld((WorldCreator)new WorldCreator(world_name)) : check_world;
                    if (world == null) continue;
                    String location = rs.getString("Location");
                    String members = rs.getString("Members");
                    String permissions = this.instance.getSettings().getDefaultValuesCode("all");
                    boolean for_sale = rs.getBoolean("isSale");
                    Double sale_price = rs.getDouble("SalePrice");
                    String bans = rs.getString("Bans");
                    ConcurrentHashMap.KeySetView chunks = ConcurrentHashMap.newKeySet();
                    List X = Arrays.stream(rs.getString("X").split(";")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
                    List Z = Arrays.stream(rs.getString("Z").split(";")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
                    if (X.size() != Z.size()) continue;
                    Iterator xIterator = X.iterator();
                    Iterator zIterator = Z.iterator();
                    ++count;
                    Runnable task = () -> this.instance.executeAsync(() -> {
                        try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions, for_sale, sale_price, bans) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                            stmt.setInt(1, id);
                            stmt.setString(2, owner_uuid);
                            stmt.setString(3, owner_name);
                            stmt.setString(4, claim_name);
                            stmt.setString(5, claim_description);
                            stmt.setString(6, this.serializeChunks(chunks));
                            stmt.setString(7, world_name);
                            stmt.setString(8, location);
                            stmt.setString(9, members);
                            stmt.setString(10, permissions);
                            stmt.setBoolean(11, for_sale);
                            stmt.setDouble(12, sale_price);
                            stmt.setString(13, bans);
                            stmt.executeUpdate();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                    if (this.instance.isFolia()) {
                        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
                        while (xIterator.hasNext() && zIterator.hasNext()) {
                            int x = (Integer)xIterator.next();
                            int z = (Integer)zIterator.next();
                            CompletionStage future = ((CompletableFuture)world.getChunkAtAsync(x, z).thenAccept(chunk -> chunks.add(chunk))).exceptionally(ex -> {
                                ex.printStackTrace();
                                return null;
                            });
                            futures.add(future);
                        }
                        CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                        ((CompletableFuture)allOf.thenRun(() -> task.run())).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                        continue;
                    }
                    while (xIterator.hasNext() && zIterator.hasNext()) {
                        int x = (Integer)xIterator.next();
                        int z = (Integer)zIterator.next();
                        Chunk chunk2 = world.getChunkAt(x, z);
                        chunks.add(chunk2);
                    }
                    task.run();
                }
            }
            this.instance.getLogger().info(this.getNumberSeparate(String.valueOf(count)) + " claims converted.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void importFromXClaims(CommandSender sender) {
        this.instance.executeAsync(() -> {
            File file = new File("plugins/SimpleClaimSystem/xclaims.yml");
            int[] i = new int[]{0};
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            Set claimKeys = config.getKeys(false);
            for (String key : claimKeys) {
                String claim_name = config.getString(key + ".name").replace(" ", "_");
                String owner = config.getString(key + ".owner");
                UUID uuid_owner = UUID.fromString(owner);
                String owner_name = Bukkit.getOfflinePlayer((UUID)uuid_owner).getName();
                int id = this.findFreeId(uuid_owner);
                String world_name = config.getString(key + ".world");
                World world = Bukkit.getWorld((String)world_name);
                ConfigurationSection userSection = config.getConfigurationSection(key + ".users");
                Set list_users = userSection.getKeys(false);
                list_users.add(owner_name);
                String users = String.join((CharSequence)";", list_users);
                ConfigurationSection chunkSection = config.getConfigurationSection(key + ".chunks");
                ConcurrentHashMap.KeySetView chunks = ConcurrentHashMap.newKeySet();
                Runnable task = () -> {
                    Location loc = this.getCenterLocationOfChunk((Chunk)chunks.iterator().next());
                    String chunksData = this.serializeChunks(chunks);
                    try (Connection connection = this.instance.getDataSource().getConnection();
                         PreparedStatement stmt = connection.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                        stmt.setInt(1, id);
                        stmt.setString(2, owner);
                        stmt.setString(3, owner_name);
                        stmt.setString(4, claim_name);
                        stmt.setString(5, this.instance.getLanguage().getMessage("default-description"));
                        stmt.setString(6, chunksData);
                        stmt.setString(7, world_name);
                        stmt.setString(8, this.getLocationString(loc));
                        stmt.setString(9, users);
                        stmt.setString(10, this.instance.getSettings().getDefaultValuesCode("all"));
                        stmt.executeUpdate();
                        i[0] = i[0] + 1;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                };
                ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
                for (String chunkId : chunkSection.getKeys(false)) {
                    CompletableFuture<Object> future;
                    int x = chunkSection.getInt(chunkId + ".x");
                    int z = chunkSection.getInt(chunkId + ".z");
                    if (this.instance.isFolia()) {
                        future = ((CompletableFuture)world.getChunkAtAsync(x, z).thenAccept(chunk -> {
                            Set set = chunks;
                            synchronized (set) {
                                chunks.add(chunk);
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                    } else {
                        Chunk chunk2 = world.getChunkAt(x, z);
                        chunks.add(chunk2);
                        future = CompletableFuture.completedFuture(null);
                    }
                    futures.add(future);
                }
                CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                ((CompletableFuture)allOf.thenRun(() -> task.run())).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            }
            this.instance.executeSync(() -> {
                sender.sendMessage(this.getNumberSeparate(String.valueOf(i[0])) + " imported claims, reloading..");
                Bukkit.dispatchCommand((CommandSender)sender, (String)"scs reload");
            });
        });
    }

    public void importFromGriefPrevention(CommandSender sender) {
        this.instance.executeAsync(() -> {
            int[] i = new int[]{0};
            for (me.ryanhamshire.GriefPrevention.Claim claim : GriefPrevention.instance.dataStore.getClaims()) {
                CustomSet<Chunk> chunks = new CustomSet<Chunk>(claim.getChunks());
                String owner = claim.getOwnerName();
                UUID trueUUID = claim.getOwnerID();
                if (trueUUID == null) continue;
                String uuid = trueUUID.toString();
                int id = this.findFreeId(trueUUID);
                String claim_name = "claim-" + String.valueOf(id);
                if (!this.instance.getMain().areChunksInSameWorld(chunks)) continue;
                boolean check = false;
                Chunk last_chunk = null;
                Iterator iterator = chunks.iterator();
                while (iterator.hasNext()) {
                    Chunk c;
                    last_chunk = c = (Chunk)iterator.next();
                    if (!this.listClaims.containsKey(c)) continue;
                    check = true;
                }
                if (check) continue;
                if (last_chunk == null) {
                    // empty if block
                }
                Location loc = this.getCenterLocationOfChunk(last_chunk);
                String world = last_chunk.getWorld().getName();
                String chunksData = this.serializeChunks(chunks);
                try {
                    Connection connection = this.instance.getDataSource().getConnection();
                    try {
                        PreparedStatement stmt = connection.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        try {
                            stmt.setInt(1, id);
                            stmt.setString(2, uuid);
                            stmt.setString(3, owner);
                            stmt.setString(4, claim_name);
                            stmt.setString(5, this.instance.getLanguage().getMessage("default-description"));
                            stmt.setString(6, chunksData);
                            stmt.setString(7, world);
                            stmt.setString(8, this.getLocationString(loc));
                            stmt.setString(9, owner);
                            stmt.setString(10, this.instance.getSettings().getDefaultValuesCode("all"));
                            stmt.executeUpdate();
                            i[0] = i[0] + 1;
                        }
                        finally {
                            if (stmt == null) continue;
                            stmt.close();
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.instance.executeSync(() -> {
                sender.sendMessage(this.getNumberSeparate(String.valueOf(i[0])) + " imported claims, reloading..");
                Bukkit.dispatchCommand((CommandSender)sender, (String)"scs reload");
            });
        });
    }

    public void transferClaims() {
        this.instance.executeAsync(() -> {
            int count;
            PreparedStatement insertStmt;
            Connection remoteConn;
            ResultSet rs;
            PreparedStatement selectStmt;
            Connection localConn;
            HikariDataSource localDataSource;
            try (Connection connection = this.instance.getDataSource().getConnection();){
                try (Statement stmt = connection.createStatement();){
                    String sql = "TRUNCATE TABLE scs_claims_1";
                    stmt.executeUpdate(sql);
                    sql = "TRUNCATE TABLE scs_players";
                    stmt.executeUpdate(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            boolean check = false;
            boolean check2 = false;
            HikariConfig localConfig = new HikariConfig();
            localConfig.setJdbcUrl("jdbc:sqlite:plugins/SimpleClaimSystem/storage.db");
            localConfig.setDriverClassName("org.sqlite.JDBC");
            try {
                localDataSource = new HikariDataSource(localConfig);
                try {
                    localConn = localDataSource.getConnection();
                    try {
                        selectStmt = localConn.prepareStatement("SELECT id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions, for_sale, sale_price, bans FROM scs_claims_1");
                        try {
                            rs = selectStmt.executeQuery();
                            try {
                                remoteConn = this.instance.getDataSource().getConnection();
                                try {
                                    insertStmt = remoteConn.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions, for_sale, sale_price, bans) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                                    try {
                                        count = 0;
                                        while (rs.next()) {
                                            insertStmt.setInt(1, rs.getInt("id_claim"));
                                            insertStmt.setString(2, rs.getString("owner_uuid"));
                                            insertStmt.setString(3, rs.getString("owner_name"));
                                            insertStmt.setString(4, rs.getString("claim_name"));
                                            insertStmt.setString(5, rs.getString("claim_description"));
                                            insertStmt.setString(6, rs.getString("chunks"));
                                            insertStmt.setString(7, rs.getString("world_name"));
                                            insertStmt.setString(8, rs.getString("location"));
                                            insertStmt.setString(9, rs.getString("members"));
                                            insertStmt.setString(10, rs.getString("permissions"));
                                            insertStmt.setInt(11, rs.getInt("for_sale"));
                                            insertStmt.setDouble(12, rs.getDouble("sale_price"));
                                            insertStmt.setString(13, rs.getString("bans"));
                                            insertStmt.addBatch();
                                            ++count;
                                        }
                                        insertStmt.executeBatch();
                                        this.instance.getLogger().info(this.getNumberSeparate(String.valueOf(count)) + " claims transferred.");
                                        check = true;
                                    }
                                    finally {
                                        if (insertStmt != null) {
                                            insertStmt.close();
                                        }
                                    }
                                }
                                finally {
                                    if (remoteConn != null) {
                                        remoteConn.close();
                                    }
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (selectStmt != null) {
                                selectStmt.close();
                            }
                        }
                    }
                    finally {
                        if (localConn != null) {
                            localConn.close();
                        }
                    }
                }
                finally {
                    localDataSource.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                check = false;
            }
            try {
                localDataSource = new HikariDataSource(localConfig);
                try {
                    localConn = localDataSource.getConnection();
                    try {
                        selectStmt = localConn.prepareStatement("SELECT uuid_server, uuid_mojang, player_name, player_head, player_textures FROM scs_players");
                        try {
                            rs = selectStmt.executeQuery();
                            try {
                                remoteConn = this.instance.getDataSource().getConnection();
                                try {
                                    insertStmt = remoteConn.prepareStatement("INSERT INTO scs_players (uuid_server, uuid_mojang, player_name, player_head, player_textures) VALUES (?, ?, ?, ?, ?)");
                                    try {
                                        count = 0;
                                        while (rs.next()) {
                                            insertStmt.setString(1, rs.getString("uuid_server"));
                                            insertStmt.setString(2, rs.getString("uuid_mojang"));
                                            insertStmt.setString(3, rs.getString("player_name"));
                                            insertStmt.setString(4, rs.getString("player_head"));
                                            insertStmt.setString(5, rs.getString("player_textures"));
                                            insertStmt.addBatch();
                                            ++count;
                                        }
                                        insertStmt.executeBatch();
                                        this.instance.getLogger().info(this.getNumberSeparate(String.valueOf(count)) + " players transferred.");
                                        check2 = true;
                                    }
                                    finally {
                                        if (insertStmt != null) {
                                            insertStmt.close();
                                        }
                                    }
                                }
                                finally {
                                    if (remoteConn != null) {
                                        remoteConn.close();
                                    }
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (selectStmt != null) {
                                selectStmt.close();
                            }
                        }
                    }
                    finally {
                        if (localConn != null) {
                            localConn.close();
                        }
                    }
                }
                finally {
                    localDataSource.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                check2 = false;
            }
            if (check && check2) {
                this.instance.getLogger().info("Safe reloading..");
                this.instance.executeSync(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"scs reload"));
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String serializeChunks(Set<Chunk> chunks) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                String encoded;
                for (Chunk chunk : chunks) {
                    objectOutputStream.writeInt(chunk.getX());
                    objectOutputStream.writeInt(chunk.getZ());
                }
                objectOutputStream.flush();
                string = encoded = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            }
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadClaims() {
        ResultSet resultSet;
        String getQuery;
        this.instance.info(" ");
        this.instance.info(String.valueOf(ChatColor.DARK_GREEN) + "Loading claims..");
        StringBuilder natural = new StringBuilder();
        StringBuilder visitors = new StringBuilder();
        StringBuilder members_ = new StringBuilder();
        for (String key : this.instance.getSettings().getDefaultValues().get("natural").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("natural").get(key).booleanValue()) {
                natural.append("1");
                continue;
            }
            natural.append("0");
        }
        for (String key : this.instance.getSettings().getDefaultValues().get("visitors").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("visitors").get(key).booleanValue()) {
                visitors.append("1");
                continue;
            }
            visitors.append("0");
        }
        for (String key : this.instance.getSettings().getDefaultValues().get("members").keySet()) {
            if (this.instance.getSettings().getDefaultValues().get("members").get(key).booleanValue()) {
                members_.append("1");
                continue;
            }
            members_.append("0");
        }
        this.instance.getSettings().setDefaultValuesCode(natural.toString(), "natural");
        this.instance.getSettings().setDefaultValuesCode(visitors.toString(), "visitors");
        this.instance.getSettings().setDefaultValuesCode(members_.toString(), "members");
        try (Connection connection = this.instance.getDataSource().getConnection();){
            connection.setAutoCommit(false);
            String insertQuery = "UPDATE scs_claims_1 SET permissions = ? WHERE id = ?";
            String updateQuery = "UPDATE scs_claims_1 SET members = ?, bans = ? WHERE id = ?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(insertQuery);){
                PreparedStatement preparedStatement2 = connection.prepareStatement(updateQuery);
                getQuery = "SELECT * FROM scs_claims_1";
                try (PreparedStatement stat = connection.prepareStatement(getQuery);){
                    resultSet = stat.executeQuery();
                    try {
                        int batchCount = 0;
                        int batchCount2 = 0;
                        while (resultSet.next()) {
                            String perms;
                            String[] parts;
                            int id = resultSet.getInt("id");
                            boolean[] isToUpdate = new boolean[]{false};
                            String s_members = resultSet.getString("members");
                            CustomSet members = new CustomSet();
                            if (!s_members.isBlank()) {
                                for (String m2 : parts = s_members.split(";")) {
                                    UUID uuid = null;
                                    try {
                                        uuid = UUID.fromString(m2);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        uuid = Bukkit.getOfflinePlayer((String)m2).getUniqueId();
                                        isToUpdate[0] = true;
                                    }
                                    members.add(uuid);
                                }
                            }
                            String s_bans = resultSet.getString("bans");
                            CustomSet bans = new CustomSet();
                            if (!s_bans.isBlank()) {
                                for (String string : parts = s_bans.split(";")) {
                                    UUID uuid = null;
                                    try {
                                        uuid = UUID.fromString(string);
                                    }
                                    catch (IllegalArgumentException e) {
                                        uuid = Bukkit.getOfflinePlayer((String)string).getUniqueId();
                                        isToUpdate[0] = true;
                                    }
                                    bans.add(uuid);
                                }
                            }
                            if (isToUpdate[0]) {
                                String members_new = members.stream().map(UUID::toString).collect(Collectors.joining(";"));
                                preparedStatement2.setString(1, members_new);
                                String bans_new = bans.stream().map(UUID::toString).collect(Collectors.joining(";"));
                                preparedStatement2.setString(2, bans_new);
                                preparedStatement2.setInt(3, id);
                                preparedStatement2.addBatch();
                                ++batchCount2;
                            }
                            if ((parts = (perms = resultSet.getString("permissions")).split(";")).length != 3) continue;
                            HashMap<String, String> permList = new HashMap<String, String>();
                            for (String s : parts) {
                                String[] parts2 = s.split(":");
                                if (parts2.length != 2) continue;
                                permList.put(parts2[0], parts2[1]);
                            }
                            StringBuilder final_perm = new StringBuilder();
                            for (Map.Entry entry : permList.entrySet()) {
                                String key = (String)entry.getKey();
                                String perm = (String)entry.getValue();
                                int defaultLength = this.instance.getSettings().getDefaultValuesCode(key).length();
                                StringBuilder permCompleted = new StringBuilder(perm);
                                if (perm.length() != defaultLength) {
                                    int diff = defaultLength - perm.length();
                                    if (diff < 0) {
                                        for (i = 0; i < perm.length() - diff && perm.length() + i < defaultLength; ++i) {
                                            permCompleted.append(this.instance.getSettings().getDefaultValuesCode(key).charAt(perm.length() + i));
                                        }
                                    } else {
                                        for (i = 0; i < diff && perm.length() + i < defaultLength; ++i) {
                                            permCompleted.append(this.instance.getSettings().getDefaultValuesCode(key).charAt(perm.length() + i));
                                        }
                                    }
                                }
                                if (final_perm.toString().isBlank()) {
                                    final_perm.append(key + ":" + permCompleted.toString());
                                    continue;
                                }
                                final_perm.append(";" + key + ":" + permCompleted.toString());
                            }
                            String string = final_perm.toString();
                            preparedStatement.setString(1, string);
                            preparedStatement.setInt(2, id);
                            preparedStatement.addBatch();
                            ++batchCount;
                        }
                        if (batchCount2 > 0) {
                            preparedStatement2.executeBatch();
                            connection.commit();
                        }
                        if (batchCount > 0) {
                            preparedStatement.executeBatch();
                            connection.commit();
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                connection.rollback();
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int[] i = new int[]{0};
        int max_i = 0;
        int protected_areas_count = 0;
        HashMap owners = new HashMap();
        try (Connection connection = this.instance.getDataSource().getConnection();){
            getQuery = "SELECT * FROM scs_claims_1";
            try (PreparedStatement preparedStatement = connection.prepareStatement(getQuery);){
                resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        String world_name;
                        World check_world;
                        World world;
                        ++max_i;
                        String uuid_string = resultSet.getString("owner_uuid");
                        UUID uuid_owner = uuid_string.equals("none") || uuid_string.equals("aucun") ? SERVER_UUID : UUID.fromString(uuid_string);
                        String permissions = resultSet.getString("permissions");
                        String name = resultSet.getString("claim_name");
                        String description = resultSet.getString("claim_description");
                        int id = resultSet.getInt("id_claim");
                        String owner = resultSet.getString("owner_name");
                        if (uuid_owner.equals(SERVER_UUID)) {
                            ++protected_areas_count;
                        }
                        World world2 = world = (check_world = Bukkit.getWorld((String)(world_name = resultSet.getString("world_name")))) == null ? Bukkit.createWorld((WorldCreator)new WorldCreator(world_name)) : check_world;
                        if (world == null) {
                            this.instance.info("Error when loading world, id claim: " + String.valueOf(id));
                            continue;
                        }
                        String[] parts = resultSet.getString("location").split(";");
                        double L_X = Double.parseDouble(parts[0]);
                        double L_Y = Double.parseDouble(parts[1]);
                        double L_Z = Double.parseDouble(parts[2]);
                        float L_Yaw = (float)Double.parseDouble(parts[3]);
                        float L_Pitch = (float)Double.parseDouble(parts[4]);
                        Location location = new Location(world, L_X, L_Y, L_Z, L_Yaw, L_Pitch);
                        String s_members = resultSet.getString("members");
                        CustomSet members = new CustomSet();
                        if (!s_members.isBlank()) {
                            for (String m : parts = s_members.split(";")) {
                                UUID uuid = null;
                                try {
                                    uuid = UUID.fromString(m);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    this.instance.info("Error when loading uuid, id claim: " + String.valueOf(id) + ", uuid: " + m);
                                    continue;
                                }
                                members.add(uuid);
                            }
                        }
                        String s_bans = resultSet.getString("bans");
                        CustomSet bans = new CustomSet();
                        if (!s_bans.isBlank()) {
                            for (String string : parts = s_bans.split(";")) {
                                UUID uuid = null;
                                try {
                                    uuid = UUID.fromString(string);
                                }
                                catch (IllegalArgumentException e) {
                                    this.instance.info("Error when loading uuid, id claim: " + String.valueOf(id) + ", uuid: " + string);
                                    continue;
                                }
                                bans.add(uuid);
                            }
                        }
                        HashMap perms = new HashMap();
                        parts = permissions.split(";");
                        if (parts.length != 3) {
                            this.instance.info("Error when loading perms, id claim: " + String.valueOf(id));
                            continue;
                        }
                        HashMap<String, String> permList = new HashMap<String, String>();
                        for (String s : parts) {
                            String[] parts2 = s.split(":");
                            if (parts2.length != 2) continue;
                            permList.put(parts2[0], parts2[1]);
                        }
                        for (Map.Entry entry : permList.entrySet()) {
                            String key = (String)entry.getKey();
                            String perm = (String)entry.getValue();
                            int count_i = 0;
                            LinkedHashMap<String, Boolean> perm_value = new LinkedHashMap<String, Boolean>();
                            for (String perm_key : this.instance.getSettings().getDefaultValues().get(key).keySet()) {
                                char currentChar = perm.charAt(count_i);
                                ++count_i;
                                perm_value.put(perm_key, currentChar == '1');
                            }
                            perms.put(key, perm_value);
                        }
                        boolean sale = resultSet.getBoolean("for_sale");
                        long l = resultSet.getLong("sale_price");
                        String chunksData = resultSet.getString("chunks");
                        ConcurrentHashMap.KeySetView chunks = ConcurrentHashMap.newKeySet();
                        i[0] = i[0] + 1;
                        Runnable task = () -> {
                            Claim claim = new Claim(uuid_owner, new CustomSet<Chunk>(chunks), owner, new CustomSet<UUID>(members), location, name, description, new LinkedHashMap<String, LinkedHashMap<String, Boolean>>(perms), sale, price, new CustomSet<UUID>(bans), id);
                            chunks.forEach(c -> this.listClaims.put((Chunk)c, claim));
                            if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                                this.instance.getDynmap().createClaimZone(claim);
                            }
                            if (this.instance.getSettings().getBooleanSetting("keep-chunks-loaded")) {
                                if (this.instance.isFolia()) {
                                    chunks.forEach(c -> Bukkit.getRegionScheduler().execute((Plugin)this.instance, world, c.getX(), c.getZ(), () -> c.setForceLoaded(true)));
                                } else {
                                    List<CompletableFuture> keepLoadedFutures = chunks.stream().map(chunk -> CompletableFuture.runAsync(() -> Bukkit.getScheduler().callSyncMethod((Plugin)this.instance, () -> {
                                        chunk.setForceLoaded(true);
                                        return null;
                                    }))).collect(Collectors.toList());
                                    CompletableFuture<Void> allKeptLoaded = CompletableFuture.allOf(keepLoadedFutures.toArray(new CompletableFuture[0]));
                                    allKeptLoaded.join();
                                }
                            }
                            if (owner != null) {
                                if (!owner.equals("*")) {
                                    owners.put(owner, uuid_owner.toString());
                                }
                                this.playerClaims.computeIfAbsent(uuid_owner, k -> new CustomSet()).add(claim);
                            }
                            this.instance.getBossBars().activateBossBar(chunks);
                        };
                        ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
                        try {
                            byte[] data = Base64.getDecoder().decode(chunksData);
                            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(data));
                            try {
                                try {
                                    while (true) {
                                        CompletableFuture<Object> future;
                                        int x = objectInputStream.readInt();
                                        int z = objectInputStream.readInt();
                                        if (this.instance.isFolia()) {
                                            future = ((CompletableFuture)world.getChunkAtAsync(x, z).thenAccept(chunk -> {
                                                Set set = chunks;
                                                synchronized (set) {
                                                    chunks.add(chunk);
                                                }
                                            })).exceptionally(ex -> {
                                                ex.printStackTrace();
                                                return null;
                                            });
                                        } else {
                                            Chunk chunk2 = world.getChunkAt(x, z);
                                            chunks.add(chunk2);
                                            future = CompletableFuture.completedFuture(null);
                                        }
                                        futures.add(future);
                                    }
                                }
                                catch (EOFException e) {
                                    objectInputStream.close();
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    objectInputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                        ((CompletableFuture)allOf.thenRun(() -> task.run())).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.instance.info(this.getNumberSeparate(String.valueOf(i[0])) + "/" + this.getNumberSeparate(String.valueOf(max_i)) + " claims loaded.");
        this.instance.info("> including " + this.getNumberSeparate(String.valueOf(protected_areas_count)) + " protected areas.");
    }

    public CompletableFuture<Boolean> createClaim(Player player, Chunk chunk) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String playerName = player.getName();
                UUID playerId = player.getUniqueId();
                CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(playerId);
                cPlayer.setClaimsCount(cPlayer.getClaimsCount() + 1);
                int id = this.findFreeId(playerId);
                String uuid = playerId.toString();
                String claimName = "claim-" + String.valueOf(id);
                String description = this.instance.getLanguage().getMessage("default-description");
                String locationString = this.getLocationString(player.getLocation());
                HashMap<String, LinkedHashMap<String, Boolean>> perms = new HashMap<String, LinkedHashMap<String, Boolean>>(this.instance.getSettings().getDefaultValues());
                Claim newClaim = new Claim(playerId, new CustomSet<Chunk>((Collection<Chunk>)Set.of(chunk)), playerName, new CustomSet<UUID>((Collection<UUID>)Set.of(playerId)), player.getLocation(), claimName, description, new HashMap<String, LinkedHashMap<String, Boolean>>(perms), false, 0L, new CustomSet<UUID>(), id);
                this.listClaims.put(chunk, newClaim);
                this.playerClaims.computeIfAbsent(player.getUniqueId(), k -> new CustomSet()).add(newClaim);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("keep-chunks-loaded")) {
                    if (this.instance.isFolia()) {
                        Bukkit.getRegionScheduler().execute((Plugin)this.instance, chunk.getWorld(), chunk.getX(), chunk.getZ(), () -> chunk.setForceLoaded(true));
                    } else {
                        Bukkit.getScheduler().callSyncMethod((Plugin)this.instance, () -> {
                            chunk.setForceLoaded(true);
                            return null;
                        });
                    }
                }
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunk));
                this.getMapAutoForChunks(Set.of(chunk));
                this.updateWeatherChunk(newClaim);
                this.updateFlyChunk(newClaim);
                ClaimCreateEvent event = new ClaimCreateEvent(newClaim);
                this.instance.executeSync(() -> Bukkit.getPluginManager().callEvent((Event)event));
                return this.insertClaimIntoDatabase(id, uuid, playerName, claimName, description, chunk, locationString);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    public void handleClaimConflict(Player player, Chunk chunk) {
        Claim claim = this.listClaims.get(chunk);
        String owner = claim.getOwner();
        if (owner.equals("*")) {
            player.sendMessage(this.instance.getLanguage().getMessage("create-error-protected-area"));
        } else if (owner.equals(player.getName())) {
            player.sendMessage(this.instance.getLanguage().getMessage("create-already-yours"));
        } else {
            player.sendMessage(this.instance.getLanguage().getMessage("create-already-claim").replace("%player%", owner));
        }
    }

    private String getLocationString(Location location) {
        return String.format("%s;%s;%s;%s;%s", location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    public CompletableFuture<Boolean> createAdminClaim(Player player, Chunk chunk) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String uuid = SERVER_UUID.toString();
                int id = this.findFreeIdProtectedArea();
                String claimName = "admin-" + String.valueOf(id);
                String description = this.instance.getLanguage().getMessage("default-description");
                String locationString = this.getLocationString(player.getLocation());
                HashMap<String, LinkedHashMap<String, Boolean>> perms = new HashMap<String, LinkedHashMap<String, Boolean>>(this.instance.getSettings().getDefaultValues());
                Claim newClaim = new Claim(SERVER_UUID, new CustomSet<Chunk>((Collection<Chunk>)Set.of(chunk)), "*", new CustomSet<UUID>(), player.getLocation(), claimName, description, new HashMap<String, LinkedHashMap<String, Boolean>>(perms), false, 0L, new CustomSet<UUID>(), id);
                this.listClaims.put(chunk, newClaim);
                this.playerClaims.computeIfAbsent(SERVER_UUID, k -> new CustomSet()).add(newClaim);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("keep-chunks-loaded")) {
                    if (this.instance.isFolia()) {
                        Bukkit.getRegionScheduler().execute((Plugin)this.instance, chunk.getWorld(), chunk.getX(), chunk.getZ(), () -> chunk.setForceLoaded(true));
                    } else {
                        Bukkit.getScheduler().callSyncMethod((Plugin)this.instance, () -> {
                            chunk.setForceLoaded(true);
                            return null;
                        });
                    }
                }
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunk));
                this.getMapAutoForChunks(Set.of(chunk));
                this.updateWeatherChunk(newClaim);
                this.updateFlyChunk(newClaim);
                ClaimCreateEvent event = new ClaimCreateEvent(newClaim);
                this.instance.executeSync(() -> Bukkit.getPluginManager().callEvent((Event)event));
                return this.insertClaimIntoDatabase(id, uuid, "*", claimName, description, chunk, locationString);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean insertClaimIntoDatabase(int id, String uuid, String owner, String claimName, String description, Chunk chunk, String locationString) {
        try (Connection connection = this.instance.getDataSource().getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = connection.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions, bans) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                try {
                    stmt.setInt(1, id);
                    stmt.setString(2, uuid);
                    stmt.setString(3, owner);
                    stmt.setString(4, claimName);
                    stmt.setString(5, description);
                    stmt.setString(6, this.serializeChunks(Set.of(chunk)));
                    stmt.setString(7, chunk.getWorld().getName());
                    stmt.setString(8, locationString);
                    stmt.setString(9, owner.equals("*") ? "" : uuid);
                    stmt.setString(10, this.instance.getSettings().getDefaultValuesCode("all"));
                    stmt.setString(11, "");
                    stmt.executeUpdate();
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public CompletableFuture<Boolean> createClaimRadius(Player player, CustomSet<Chunk> chunks, int radius) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String playerName = player.getName();
                UUID playerId = player.getUniqueId();
                CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(playerId);
                String uuid = player.getUniqueId().toString();
                int id = this.findFreeId(playerId);
                String claimName = "claim-" + id;
                String description = this.instance.getLanguage().getMessage("default-description");
                String locationString = this.getLocationString(player.getLocation());
                HashMap<String, LinkedHashMap<String, Boolean>> perms = new HashMap<String, LinkedHashMap<String, Boolean>>(this.instance.getSettings().getDefaultValues());
                Claim newClaim = new Claim(playerId, new CustomSet<Chunk>((Collection<Chunk>)chunks), playerName, new CustomSet<UUID>((Collection<UUID>)Set.of(playerId)), player.getLocation(), claimName, description, new HashMap<String, LinkedHashMap<String, Boolean>>(perms), false, 0L, new CustomSet<UUID>(), id);
                this.playerClaims.computeIfAbsent(player.getUniqueId(), k -> new CustomSet()).add(newClaim);
                cPlayer.setClaimsCount(cPlayer.getClaimsCount() + 1);
                List X = Collections.synchronizedList(new ArrayList());
                List Z = Collections.synchronizedList(new ArrayList());
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunks));
                chunks.forEach(c -> {
                    this.listClaims.put((Chunk)c, newClaim);
                    X.add(c.getX());
                    Z.add(c.getZ());
                });
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("keep-chunks-loaded")) {
                    if (this.instance.isFolia()) {
                        chunks.stream().forEach(c -> Bukkit.getRegionScheduler().execute((Plugin)this.instance, c.getWorld(), c.getX(), c.getZ(), () -> c.setForceLoaded(true)));
                    } else {
                        Bukkit.getScheduler().callSyncMethod((Plugin)this.instance, () -> {
                            this.instance.executeSync(() -> chunks.stream().forEach(c -> c.setForceLoaded(true)));
                            return null;
                        });
                    }
                }
                this.getMapAutoForChunks(chunks);
                this.updateWeatherChunk(newClaim);
                this.updateFlyChunk(newClaim);
                ClaimCreateEvent event = new ClaimCreateEvent(newClaim);
                this.instance.executeSync(() -> Bukkit.getPluginManager().callEvent((Event)event));
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    Boolean bl;
                    block22: {
                        PreparedStatement stmt = connection.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions, bans) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        try {
                            stmt.setInt(1, id);
                            stmt.setString(2, uuid);
                            stmt.setString(3, playerName);
                            stmt.setString(4, claimName);
                            stmt.setString(5, description);
                            stmt.setString(6, this.serializeChunks(chunks));
                            stmt.setString(7, player.getWorld().getName());
                            stmt.setString(8, locationString);
                            stmt.setString(9, uuid);
                            stmt.setString(10, this.instance.getSettings().getDefaultValuesCode("all"));
                            stmt.setString(11, "");
                            stmt.executeUpdate();
                            bl = true;
                            if (stmt == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return bl;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> createAdminClaimRadius(Player player, CustomSet<Chunk> chunks, int radius) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String playerName = "*";
                int id = this.findFreeIdProtectedArea();
                String claimName = "admin-" + String.valueOf(id);
                String description = this.instance.getLanguage().getMessage("default-description");
                String locationString = this.getLocationString(player.getLocation());
                HashMap<String, LinkedHashMap<String, Boolean>> perms = new HashMap<String, LinkedHashMap<String, Boolean>>(this.instance.getSettings().getDefaultValues());
                Claim newClaim = new Claim(SERVER_UUID, new CustomSet<Chunk>((Collection<Chunk>)chunks), playerName, new CustomSet<UUID>(), player.getLocation(), claimName, description, new HashMap<String, LinkedHashMap<String, Boolean>>(perms), false, 0L, new CustomSet<UUID>(), id);
                this.playerClaims.computeIfAbsent(SERVER_UUID, k -> new CustomSet()).add(newClaim);
                List X = Collections.synchronizedList(new ArrayList());
                List Z = Collections.synchronizedList(new ArrayList());
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunks));
                chunks.stream().forEach(c -> {
                    this.listClaims.put((Chunk)c, newClaim);
                    X.add(c.getX());
                    Z.add(c.getZ());
                });
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().createClaimZone(newClaim);
                }
                if (this.instance.getSettings().getBooleanSetting("keep-chunks-loaded")) {
                    if (this.instance.isFolia()) {
                        chunks.stream().forEach(c -> Bukkit.getRegionScheduler().execute((Plugin)this.instance, c.getWorld(), c.getX(), c.getZ(), () -> c.setForceLoaded(true)));
                    } else {
                        Bukkit.getScheduler().callSyncMethod((Plugin)this.instance, () -> {
                            this.instance.executeSync(() -> chunks.stream().forEach(c -> c.setForceLoaded(true)));
                            return null;
                        });
                    }
                }
                this.getMapAutoForChunks(chunks);
                this.updateWeatherChunk(newClaim);
                this.updateFlyChunk(newClaim);
                ClaimCreateEvent event = new ClaimCreateEvent(newClaim);
                this.instance.executeSync(() -> Bukkit.getPluginManager().callEvent((Event)event));
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    Boolean bl;
                    block22: {
                        PreparedStatement stmt = connection.prepareStatement("INSERT INTO scs_claims_1 (id_claim, owner_uuid, owner_name, claim_name, claim_description, chunks, world_name, location, members, permissions, bans) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        try {
                            stmt.setInt(1, id);
                            stmt.setString(2, SERVER_UUID.toString());
                            stmt.setString(3, "*");
                            stmt.setString(4, claimName);
                            stmt.setString(5, description);
                            stmt.setString(6, this.serializeChunks(chunks));
                            stmt.setString(7, player.getWorld().getName());
                            stmt.setString(8, locationString);
                            stmt.setString(9, "");
                            stmt.setString(10, this.instance.getSettings().getDefaultValuesCode("all"));
                            stmt.setString(11, "");
                            stmt.executeUpdate();
                            bl = true;
                            if (stmt == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return bl;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    public double calculateClaimPrice(CPlayer cPlayer, int numClaims) {
        if (!this.instance.getSettings().getBooleanSetting("economy") || !this.instance.getSettings().getBooleanSetting("claim-cost")) {
            return 0.0;
        }
        return this.instance.getSettings().getBooleanSetting("claim-cost-multiplier") ? cPlayer.getRadiusMultipliedCost(numClaims) : cPlayer.getCost() * (double)numClaims;
    }

    public boolean checkIfClaimExists(Chunk chunk) {
        return this.listClaims.containsKey(chunk);
    }

    public boolean checkIfClaimExists(Claim claim) {
        return this.listClaims.containsValue(claim);
    }

    public boolean canPermCheck(Chunk chunk, String perm, String role) {
        Claim claim = this.listClaims.get(chunk);
        return claim != null && claim.getPermission(perm, role == null ? "natural" : role.toLowerCase());
    }

    public String getOwnerInClaim(Chunk chunk) {
        Claim claim = this.listClaims.get(chunk);
        return claim == null ? "" : claim.getOwner();
    }

    public boolean checkMembre(Claim claim, Player player) {
        return claim == null ? false : claim.getMembers().contains(player.getUniqueId());
    }

    public boolean checkMembre(Claim claim, String targetName) {
        return claim != null && claim.getMembers().stream().map(member -> this.instance.getPlayerMain().getPlayerName((UUID)member)).anyMatch(playerName -> playerName != null && playerName.equalsIgnoreCase(targetName));
    }

    public boolean checkBan(Claim claim, Player player) {
        return claim == null ? false : claim.getBans().contains(player.getUniqueId());
    }

    public boolean checkBan(Claim claim, String targetName) {
        return claim != null && claim.getBans().stream().map(ban -> this.instance.getPlayerMain().getPlayerName((UUID)ban)).anyMatch(playerName -> playerName != null && playerName.equalsIgnoreCase(targetName));
    }

    public String getRealNameFromClaimMembers(Claim claim, String targetName) {
        if (claim != null) {
            return claim.getMembers().stream().map(member -> this.instance.getPlayerMain().getPlayerName((UUID)member)).filter(playerName -> playerName.equalsIgnoreCase(targetName)).findFirst().orElse(targetName);
        }
        return targetName;
    }

    public String getRealNameFromClaimBans(Claim claim, String targetName) {
        if (claim != null) {
            return claim.getBans().stream().map(ban -> this.instance.getPlayerMain().getPlayerName((UUID)ban)).filter(playerName -> playerName.equalsIgnoreCase(targetName)).findFirst().orElse(targetName);
        }
        return targetName;
    }

    public String getBanString(Claim claim) {
        if (claim != null) {
            return claim.getBans().stream().map(UUID::toString).collect(Collectors.joining(";"));
        }
        return "";
    }

    public String getMemberString(Claim claim) {
        if (claim != null) {
            return claim.getMembers().stream().map(UUID::toString).collect(Collectors.joining(";"));
        }
        return "";
    }

    public CompletableFuture<Boolean> updatePermsBedrock(Claim claim, Map<String, LinkedHashMap<String, Boolean>> permissionsMap) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String owner = claim.getOwner();
                claim.setPermissions(new HashMap<String, LinkedHashMap<String, Boolean>>(permissionsMap));
                permissionsMap.forEach((role, perms) -> perms.forEach((permission, value) -> {
                    if (permission.equalsIgnoreCase("Weather")) {
                        this.updateWeatherChunk(claim);
                    }
                    if (permission.equalsIgnoreCase("Fly")) {
                        this.updateFlyChunk(claim);
                    }
                }));
                String uuid = owner.equals("*") ? SERVER_UUID.toString() : this.instance.getPlayerMain().getPlayerUUID(owner).toString();
                String permissionsString = permissionsMap.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + ((LinkedHashMap)entry.getValue()).entrySet().stream().map(subEntry -> (Boolean)subEntry.getValue() != false ? "1" : "0").collect(Collectors.joining())).collect(Collectors.joining(";"));
                String updateQuery = "UPDATE scs_claims_1 SET permissions = ? WHERE owner_uuid = ? AND claim_name = ?";
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    Boolean bl;
                    block16: {
                        PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);
                        try {
                            preparedStatement.setString(1, permissionsString);
                            preparedStatement.setString(2, uuid);
                            preparedStatement.setString(3, claim.getName());
                            preparedStatement.executeUpdate();
                            bl = true;
                            if (preparedStatement == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return bl;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> updatePerm(Claim claim, String permission, boolean value, String role) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String owner = claim.getOwner();
                String roleKey = role == null ? "natural" : role.toLowerCase();
                LinkedHashMap<String, Boolean> currentPermissions = claim.getPermissions().get(roleKey);
                LinkedHashMap<String, Boolean> newPermissions = new LinkedHashMap<String, Boolean>(currentPermissions);
                newPermissions.put(permission, value);
                claim.getPermissions().put(roleKey, newPermissions);
                if (permission.equals("Weather")) {
                    this.updateWeatherChunk(claim);
                }
                if (permission.equals("Fly")) {
                    this.updateFlyChunk(claim);
                }
                String uuid = owner.equals("*") ? SERVER_UUID.toString() : this.instance.getPlayerMain().getPlayerUUID(owner).toString();
                String permissions = claim.getPermissions().entrySet().stream().map(entry -> (String)entry.getKey() + ":" + ((LinkedHashMap)entry.getValue()).entrySet().stream().map(subEntry -> (Boolean)subEntry.getValue() != false ? "1" : "0").collect(Collectors.joining())).collect(Collectors.joining(";"));
                String updateQuery = "UPDATE scs_claims_1 SET permissions = ? WHERE owner_uuid = ? AND claim_name = ?";
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    Boolean bl;
                    block18: {
                        PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);
                        try {
                            preparedStatement.setString(1, permissions);
                            preparedStatement.setString(2, uuid);
                            preparedStatement.setString(3, claim.getName());
                            preparedStatement.executeUpdate();
                            bl = true;
                            if (preparedStatement == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return bl;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> applyAllSettings(Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                HashMap<String, LinkedHashMap<String, Boolean>> perms = new HashMap<String, LinkedHashMap<String, Boolean>>(claim.getPermissions());
                this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).stream().forEach(c -> {
                    c.setPermissions(new HashMap<String, LinkedHashMap<String, Boolean>>(perms));
                    this.updateWeatherChunk((Claim)c);
                    this.updateFlyChunk((Claim)c);
                });
                String permissions = perms.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + ((LinkedHashMap)entry.getValue()).entrySet().stream().map(subEntry -> (Boolean)subEntry.getValue() != false ? "1" : "0").collect(Collectors.joining())).collect(Collectors.joining(";"));
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET permissions = ? WHERE owner_uuid = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, permissions);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> addClaimBan(Claim claim, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                String claimName = claim.getName();
                UUID uuid = claim.getUUID();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                claim.addBan(targetUUID);
                claim.removeMember(targetUUID);
                String banString = this.getBanString(claim);
                String memberString = this.getMemberString(claim);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET bans = ?, members = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, banString);
                        preparedStatement.setString(2, memberString);
                        preparedStatement.setString(3, uuid.toString());
                        preparedStatement.setString(4, claimName);
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> removeClaimBan(Claim claim, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                String claimName = claim.getName();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                UUID uuid = claim.getUUID();
                claim.removeBan(targetUUID);
                String banString = this.getBanString(claim);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET bans = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, banString);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claimName);
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> addAllClaimBan(String owner, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block19: {
                UUID uuid = owner.equals("*") ? SERVER_UUID : this.instance.getPlayerMain().getPlayerUUID(owner);
                String uuid_string = uuid.toString();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).stream().forEach(claim -> {
                    claim.addBan(targetUUID);
                    claim.removeMember(targetUUID);
                });
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET bans = ?, members = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        for (Claim claim2 : this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet())) {
                            preparedStatement.setString(1, this.getBanString(claim2));
                            preparedStatement.setString(2, this.getMemberString(claim2));
                            preparedStatement.setString(3, uuid_string);
                            preparedStatement.setString(4, claim2.getName());
                            preparedStatement.addBatch();
                        }
                        preparedStatement.executeBatch();
                    }
                    bl = true;
                    if (connection == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> removeAllClaimBan(String owner, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block19: {
                UUID uuid = owner.equals("*") ? SERVER_UUID : this.instance.getPlayerMain().getPlayerUUID(owner);
                String uuid_string = uuid.toString();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).stream().forEach(claim -> claim.removeBan(targetUUID));
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET bans = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        for (Claim claim2 : this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet())) {
                            preparedStatement.setString(1, this.getBanString(claim2));
                            preparedStatement.setString(2, uuid_string);
                            preparedStatement.setString(3, claim2.getName());
                            preparedStatement.addBatch();
                        }
                        preparedStatement.executeBatch();
                    }
                    bl = true;
                    if (connection == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> addClaimMember(Claim claim, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                claim.addMember(targetUUID);
                String membersString = this.getMemberString(claim);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET members = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, membersString);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> addAllClaimsMember(String owner, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block19: {
                UUID uuid = owner.equals("*") ? SERVER_UUID : this.instance.getPlayerMain().getPlayerUUID(owner);
                String uuid_string = uuid.toString();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).stream().forEach(claim -> claim.addMember(targetUUID));
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET members = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        for (Claim claim2 : this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet())) {
                            preparedStatement.setString(1, this.getMemberString(claim2));
                            preparedStatement.setString(2, uuid_string);
                            preparedStatement.setString(3, claim2.getName());
                            preparedStatement.addBatch();
                        }
                        preparedStatement.executeBatch();
                    }
                    bl = true;
                    if (connection == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> removeClaimMember(Claim claim, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                claim.removeMember(targetUUID);
                String membersString = this.getMemberString(claim);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET Members = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, membersString);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> removeAllClaimsMember(String owner, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block19: {
                UUID uuid = owner.equals("*") ? SERVER_UUID : this.instance.getPlayerMain().getPlayerUUID(owner);
                String uuid_string = uuid.toString();
                UUID targetUUID = this.instance.getPlayerMain().getPlayerUUID(name);
                this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).stream().forEach(claim -> claim.removeMember(targetUUID));
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET Members = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        for (Claim claim2 : this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet())) {
                            preparedStatement.setString(1, this.getMemberString(claim2));
                            preparedStatement.setString(2, uuid_string);
                            preparedStatement.setString(3, claim2.getName());
                            preparedStatement.addBatch();
                        }
                        preparedStatement.executeBatch();
                    }
                    bl = true;
                    if (connection == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> setClaimName(Claim claim, String name) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block21: {
                UUID uuid = claim.getUUID();
                String old_name = claim.getName();
                claim.setName(name);
                Set<Chunk> chunks = claim.getChunks();
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunks));
                this.getMapAutoForChunks(chunks);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().updateName(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().updateName(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().updateName(claim);
                }
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET claim_name = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, name);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, old_name);
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> setClaimLocation(Claim claim, Location loc) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                claim.setLocation(loc);
                String loc_string = String.valueOf(loc.getX()) + ";" + String.valueOf(loc.getY()) + ";" + String.valueOf(loc.getZ()) + ";" + String.valueOf(loc.getYaw()) + ";" + String.valueOf(loc.getPitch());
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET Location = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, loc_string);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> deleteClaim(Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block23: {
                Player player;
                UUID uuid = claim.getUUID();
                Set<Chunk> chunks = claim.getChunks();
                this.instance.executeSync(() -> this.instance.getBossBars().deactivateBossBar(chunks));
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().deleteMarker(chunks);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().deleteMarker(chunks);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().deleteMarker(chunks);
                }
                chunks.stream().forEach(c -> this.listClaims.remove(c));
                this.resetWeatherChunk(claim);
                this.resetFlyChunk(claim);
                this.getMapAutoForChunks(chunks);
                if (!claim.getOwner().equals("*") && (player = Bukkit.getPlayer((UUID)uuid)) != null && player.isOnline()) {
                    CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(uuid);
                    cPlayer.setClaimsCount(cPlayer.getClaimsCount() - 1);
                }
                this.playerClaims.get(uuid).remove(claim);
                if (this.playerClaims.get(uuid).isEmpty()) {
                    this.playerClaims.remove(uuid);
                }
                UnclaimEvent event = new UnclaimEvent(claim);
                this.instance.executeSync(() -> Bukkit.getPluginManager().callEvent((Event)event));
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String deleteQuery = "DELETE FROM scs_claims_1 WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(deleteQuery);){
                        preparedStatement.setString(1, uuid.toString());
                        preparedStatement.setString(2, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block23;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> deleteAllClaims(String owner) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Player player;
                UUID uuid;
                UUID uUID = uuid = owner.equals("*") ? SERVER_UUID : this.instance.getPlayerMain().getPlayerUUID(owner);
                if (!owner.equals("*") && (player = Bukkit.getPlayer((String)owner)) != null && player.isOnline()) {
                    CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
                    cPlayer.setClaimsCount(0);
                }
                CustomSet<Claim> claims = this.playerClaims.getOrDefault(uuid, new CustomSet());
                this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).stream().forEach(claim -> {
                    Set<Chunk> chunks = claim.getChunks();
                    this.instance.executeSync(() -> this.instance.getBossBars().deactivateBossBar(chunks));
                    if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                        this.instance.getDynmap().deleteMarker(chunks);
                    }
                    if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                        this.instance.getBluemap().deleteMarker(chunks);
                    }
                    if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                        this.instance.getPl3xMap().deleteMarker(chunks);
                    }
                    chunks.stream().forEach(c -> this.listClaims.remove(c));
                    this.updateWeatherChunk((Claim)claim);
                    this.updateFlyChunk((Claim)claim);
                    this.getMapAutoForChunks(chunks);
                });
                this.playerClaims.remove(uuid);
                UnclaimallEvent event = new UnclaimallEvent(claims);
                this.instance.executeSync(() -> Bukkit.getPluginManager().callEvent((Event)event));
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    String deleteQuery = "DELETE FROM scs_claims_1 WHERE owner_uuid = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(deleteQuery);){
                        preparedStatement.setString(1, uuid.toString());
                        preparedStatement.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> setClaimDescription(Claim claim, String description) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                claim.setDescription(description);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET claim_description = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, description);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> setChunkSale(Claim claim, long price) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                claim.setSale(true);
                claim.setPrice(price);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET for_sale = true, sale_price = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, String.valueOf(price));
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> delChunkSale(Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                claim.setSale(false);
                claim.setPrice(0L);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET for_sale = false, sale_price = 0 WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, uuid.toString());
                        preparedStatement.setString(2, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> resetAllOwnerClaimsSettings(String owner) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                String defaultValue = this.instance.getSettings().getDefaultValuesCode("all");
                HashMap<String, LinkedHashMap<String, Boolean>> perm = new HashMap<String, LinkedHashMap<String, Boolean>>(this.instance.getSettings().getDefaultValues());
                UUID uuid = owner.equals("*") ? SERVER_UUID : this.instance.getPlayerMain().getPlayerUUID(owner);
                this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).stream().forEach(c -> {
                    c.setPermissions(new HashMap<String, LinkedHashMap<String, Boolean>>(perm));
                    this.updateWeatherChunk((Claim)c);
                    this.updateFlyChunk((Claim)c);
                });
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET permissions = ? WHERE owner_uuid = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, defaultValue);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> resetClaimSettings(Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                UUID uuid = claim.getUUID();
                String defaultValue = this.instance.getSettings().getDefaultValuesCode("all");
                HashMap<String, LinkedHashMap<String, Boolean>> perm = new HashMap<String, LinkedHashMap<String, Boolean>>(this.instance.getSettings().getDefaultValues());
                claim.setPermissions(perm);
                this.updateWeatherChunk(claim);
                this.updateFlyChunk(claim);
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET Permissions = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, defaultValue);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> resetAllPlayerClaimsSettings() {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block18: {
                String defaultValue = this.instance.getSettings().getDefaultValuesCode("all");
                HashMap<String, LinkedHashMap<String, Boolean>> perm = new HashMap<String, LinkedHashMap<String, Boolean>>(this.instance.getSettings().getDefaultValues());
                this.listClaims.values().stream().forEach(c -> {
                    if (!c.getUUID().equals(SERVER_UUID)) {
                        c.setPermissions(new HashMap<String, LinkedHashMap<String, Boolean>>(perm));
                        this.updateWeatherChunk((Claim)c);
                        this.updateFlyChunk((Claim)c);
                    }
                });
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET permissions = ? WHERE owner_uuid <> ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, defaultValue);
                        preparedStatement.setString(2, SERVER_UUID.toString());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> sellChunk(Player player, Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block25: {
                Player ownerP;
                String playerName = player.getName();
                UUID playerId = player.getUniqueId();
                String old_name = claim.getName();
                String owner = claim.getOwner();
                double price = claim.getPrice();
                if (!owner.equalsIgnoreCase("*")) {
                    this.instance.getVault().addPlayerBalance(owner, price);
                }
                this.instance.getVault().removePlayerBalance(playerName, price);
                UUID uuid = claim.getUUID();
                if (!owner.equals("*") && (ownerP = Bukkit.getPlayer((String)owner)) != null && ownerP.isOnline()) {
                    CPlayer cOwner = this.instance.getPlayerMain().getCPlayer(uuid);
                    cOwner.setClaimsCount(cOwner.getClaimsCount() - 1);
                }
                this.playerClaims.get(uuid).remove(claim);
                if (this.playerClaims.get(uuid).isEmpty()) {
                    this.playerClaims.remove(uuid);
                }
                CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(playerId);
                cTarget.setClaimsCount(cTarget.getClaimsCount() + 1);
                claim.setOwner(playerName);
                int id = this.findFreeId(playerId);
                String new_name = "claim-" + String.valueOf(id);
                claim.setName(new_name);
                claim.setId(id);
                claim.setUUID(playerId);
                CustomSet<UUID> members = new CustomSet<UUID>((Collection<UUID>)claim.getMembers());
                if (!members.contains(playerId)) {
                    members.add(playerId);
                }
                members.remove(uuid);
                claim.setMembers(members);
                String members_string = this.getMemberString(claim);
                claim.setSale(false);
                claim.setPrice(0L);
                this.playerClaims.computeIfAbsent(playerId, k -> new CustomSet()).add(claim);
                Set<Chunk> chunks = claim.getChunks();
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunks));
                this.getMapAutoForChunks(chunks);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().updateName(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().updateName(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().updateName(claim);
                }
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET id_claim = ?, owner_uuid = ?, owner_name = ?, members = ?, claim_name = ?, for_sale = false, sale_price = 0 WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setInt(1, id);
                        preparedStatement.setString(2, playerId.toString());
                        preparedStatement.setString(3, playerName);
                        preparedStatement.setString(4, members_string);
                        preparedStatement.setString(5, new_name);
                        preparedStatement.setString(6, uuid.toString());
                        preparedStatement.setString(7, old_name);
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> setOwner(String playerName, Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block27: {
                String old_name = claim.getName();
                String owner = claim.getOwner();
                UUID uuid = claim.getUUID();
                if (!owner.equals("*")) {
                    Player ownerP = Bukkit.getPlayer((String)owner);
                    if (ownerP != null && ownerP.isOnline()) {
                        CPlayer cOwner = this.instance.getPlayerMain().getCPlayer(uuid);
                        cOwner.setClaimsCount(cOwner.getClaimsCount() - 1);
                    }
                } else {
                    uuid = SERVER_UUID;
                }
                this.playerClaims.get(uuid).remove(claim);
                if (this.playerClaims.get(uuid).isEmpty()) {
                    this.playerClaims.remove(uuid);
                }
                UUID uuidNewOwner = this.instance.getPlayerMain().getPlayerUUID(playerName);
                String uuid_new_owner = uuidNewOwner.toString();
                Player player = Bukkit.getPlayer((String)playerName);
                if (player != null && player.isOnline()) {
                    CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(uuidNewOwner);
                    cTarget.setClaimsCount(cTarget.getClaimsCount() + 1);
                }
                claim.setOwner(playerName);
                int id = this.findFreeId(uuidNewOwner);
                String new_name = "claim-" + String.valueOf(id);
                claim.setName(new_name);
                claim.setId(id);
                claim.setUUID(uuidNewOwner);
                CustomSet<UUID> members = new CustomSet<UUID>((Collection<UUID>)claim.getMembers());
                if (!members.contains(uuidNewOwner)) {
                    members.add(uuidNewOwner);
                }
                members.remove(uuid);
                claim.setMembers(members);
                String members_string = this.getMemberString(claim);
                this.playerClaims.computeIfAbsent(uuidNewOwner, k -> new CustomSet()).add(claim);
                Set<Chunk> chunks = claim.getChunks();
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunks));
                this.getMapAutoForChunks(chunks);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().updateName(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().updateName(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().updateName(claim);
                }
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET id_claim = ?, owner_uuid = ?, owner_name = ?, members = ?, claim_name = ?, for_sale = false, sale_price = 0 WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setInt(1, id);
                        preparedStatement.setString(2, uuid_new_owner);
                        preparedStatement.setString(3, playerName);
                        preparedStatement.setString(4, members_string);
                        preparedStatement.setString(5, new_name);
                        preparedStatement.setString(6, uuid.toString());
                        preparedStatement.setString(7, old_name);
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block27;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> setOwner(String newOwner, CustomSet<Claim> claims, String oldOwner) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public CompletableFuture<Boolean> removeClaimChunk(Claim claim, String chunk_default) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block27: {
                int Z_;
                int X_;
                String[] parts = chunk_default.split(";");
                World world = Bukkit.getWorld((String)parts[0]);
                if (world == null) {
                    return false;
                }
                try {
                    X_ = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                try {
                    Z_ = Integer.parseInt(parts[2]);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (this.instance.isFolia()) {
                    CompletionStage future = world.getChunkAtAsync(X_, Z_).thenApply(chunk -> {
                        Boolean bl;
                        block19: {
                            CustomSet<Chunk> chunks = new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks());
                            if (!chunks.contains(chunk)) {
                                return false;
                            }
                            chunks.remove(chunk);
                            claim.setChunks(chunks);
                            this.listClaims.remove(chunk);
                            if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                                this.instance.getDynmap().deleteMarker(Set.of(chunk));
                            }
                            if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                                this.instance.getBluemap().deleteMarker(Set.of(chunk));
                            }
                            if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                                this.instance.getPl3xMap().deleteMarker(Set.of(chunk));
                            }
                            this.instance.executeSync(() -> this.instance.getBossBars().deactivateBossBar(Set.of(chunk)));
                            this.updateWeatherChunk(claim);
                            this.updateFlyChunk(claim);
                            this.getMapAutoForChunks(chunks);
                            String chunksData = this.serializeChunks(chunks);
                            UUID uuid = claim.getUUID();
                            Connection connection = this.instance.getDataSource().getConnection();
                            try {
                                String updateQuery = "UPDATE scs_claims_1 SET chunks = ? WHERE owner_uuid = ? AND claim_name = ?";
                                try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                                    preparedStatement.setString(1, chunksData);
                                    preparedStatement.setString(2, uuid.toString());
                                    preparedStatement.setString(3, claim.getName());
                                    preparedStatement.executeUpdate();
                                }
                                bl = true;
                                if (connection == null) break block19;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (connection != null) {
                                        try {
                                            connection.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                    return false;
                                }
                            }
                            connection.close();
                        }
                        return bl;
                    });
                    return (Boolean)((CompletableFuture)future).join();
                }
                Chunk chunk2 = world.getChunkAt(X_, Z_);
                CustomSet<Chunk> chunks = new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks());
                chunks.remove(chunk2);
                claim.setChunks(chunks);
                this.listClaims.remove(chunk2);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().deleteMarker(Set.of(chunk2));
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().deleteMarker(Set.of(chunk2));
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().deleteMarker(Set.of(chunk2));
                }
                this.instance.executeSync(() -> this.instance.getBossBars().deactivateBossBar(Set.of(chunk2)));
                this.updateWeatherChunk(claim);
                this.updateFlyChunk(claim);
                String chunksData = this.serializeChunks(chunks);
                UUID uuid = claim.getUUID();
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET chunks = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, chunksData);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block27;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> removeClaimChunk(Claim claim, Chunk chunk) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block21: {
                CustomSet<Chunk> chunks = new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks());
                chunks.remove(chunk);
                claim.setChunks(chunks);
                this.listClaims.remove(chunk);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().deleteMarker(Set.of(chunk));
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().deleteMarker(Set.of(chunk));
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().deleteMarker(Set.of(chunk));
                }
                this.instance.executeSync(() -> this.instance.getBossBars().deactivateBossBar(Set.of(chunk)));
                this.updateWeatherChunk(claim);
                this.updateFlyChunk(claim);
                this.getMapAutoForChunks(chunks);
                String chunksData = this.serializeChunks(chunks);
                UUID uuid = claim.getUUID();
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET chunks = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, chunksData);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> addClaimChunk(Claim claim, Chunk chunk) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block22: {
                CustomSet<Chunk> chunks = new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks());
                if (chunks.contains(chunk)) {
                    return false;
                }
                chunks.add(chunk);
                claim.setChunks(chunks);
                this.listClaims.put(chunk, claim);
                if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                    this.instance.getDynmap().createClaimZone(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                    this.instance.getBluemap().createClaimZone(claim);
                }
                if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                    this.instance.getPl3xMap().createClaimZone(claim);
                }
                this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(Set.of(chunk)));
                this.updateWeatherChunk(claim);
                this.updateFlyChunk(claim);
                this.getMapAutoForChunks(chunks);
                String chunksData = this.serializeChunks(chunks);
                UUID uuid = claim.getUUID();
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET chunks = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, chunksData);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.setString(3, claim.getName());
                        preparedStatement.executeUpdate();
                    }
                    bl = true;
                    if (connection == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<Boolean> mergeClaims(Claim claim1, CustomSet<Claim> claims) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block27: {
                Player player;
                claims.stream().forEach(claim -> {
                    Set<Chunk> chunks = claim.getChunks();
                    chunks.stream().forEach(c -> this.listClaims.put((Chunk)c, claim1));
                    claim1.addChunks(chunks);
                    this.instance.executeSync(() -> this.instance.getBossBars().activateBossBar(chunks));
                    if (this.instance.getSettings().getBooleanSetting("dynmap")) {
                        this.instance.getDynmap().updateName(claim1);
                    }
                    if (this.instance.getSettings().getBooleanSetting("bluemap")) {
                        this.instance.getBluemap().updateName(claim1);
                    }
                    if (this.instance.getSettings().getBooleanSetting("pl3xmap")) {
                        this.instance.getPl3xMap().updateName(claim1);
                    }
                    this.updateWeatherChunk(claim1);
                    this.updateFlyChunk(claim1);
                    this.getMapAutoForChunks(chunks);
                });
                UUID uuid = claim1.getUUID();
                String uuid_string = uuid.toString();
                String owner = claim1.getOwner();
                if (!owner.equals("*") && (player = Bukkit.getPlayer((String)owner)) != null && player.isOnline()) {
                    CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(uuid);
                    cPlayer.setClaimsCount(cPlayer.getClaimsCount() - claims.size());
                }
                HashSet toRemove = new HashSet(claims);
                this.instance.executeSync(() -> this.playerClaims.computeIfAbsent(uuid, k -> new CustomSet()).removeAll(toRemove));
                String chunksData = this.serializeChunks(claim1.getChunks());
                Connection connection = this.instance.getDataSource().getConnection();
                try {
                    String updateQuery = "UPDATE scs_claims_1 SET chunks = ? WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, chunksData);
                        preparedStatement.setString(2, uuid_string);
                        preparedStatement.setString(3, claim1.getName());
                        preparedStatement.executeUpdate();
                    }
                    String deleteQuery = "DELETE FROM scs_claims_1 WHERE owner_uuid = ? AND claim_name = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(deleteQuery);){
                        for (Claim claim2 : claims) {
                            preparedStatement.setString(1, uuid_string);
                            preparedStatement.setString(2, claim2.getName());
                            preparedStatement.addBatch();
                        }
                        preparedStatement.executeBatch();
                    }
                    bl = true;
                    if (connection == null) break block27;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public void displayChunksNotEnter(final Player player, final CustomSet<Chunk> chunks) {
        if (this.chunksParticles.containsAll(chunks)) {
            return;
        }
        this.chunksParticles.addAll(chunks);
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 1.5f);
        CompletableFuture<Set<Location>> futureLocations = this.getParticleLocations(chunks);
        futureLocations.thenAccept(particleLocations -> {
            if (this.instance.isFolia()) {
                int[] counter = new int[]{0};
                Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.instance, task -> {
                    if (counter[0] >= 10) {
                        task.cancel();
                        this.chunksParticles.removeAll(chunks);
                        return;
                    }
                    World world = player.getWorld();
                    particleLocations.stream().forEach(location -> world.spawnParticle(Particle.REDSTONE, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions));
                    counter[0] = counter[0] + 1;
                }, 0L, 500L, TimeUnit.MILLISECONDS);
            } else {
                new BukkitRunnable((Set)particleLocations, dustOptions){
                    int counter = 0;
                    final /* synthetic */ Set val$particleLocations;
                    final /* synthetic */ Particle.DustOptions val$dustOptions;
                    {
                        this.val$particleLocations = set;
                        this.val$dustOptions = dustOptions;
                    }

                    public void run() {
                        if (this.counter >= 10) {
                            this.cancel();
                            ClaimMain.this.chunksParticles.removeAll(chunks);
                            return;
                        }
                        World world = player.getWorld();
                        this.val$particleLocations.stream().forEach(location -> world.spawnParticle(Particle.REDSTONE, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)this.val$dustOptions));
                        ++this.counter;
                    }
                }.runTaskTimerAsynchronously((Plugin)this.instance, 0L, 10L);
            }
        });
    }

    public void displayChunks(final Player player, final CustomSet<Chunk> chunks, boolean claim, boolean see) {
        if (this.chunksParticles.containsAll(chunks)) {
            return;
        }
        this.chunksParticles.addAll(chunks);
        Particle.DustOptions dustOptions = this.getDustOptions(player, claim, see);
        CompletableFuture<Set<Location>> futureLocations = this.getParticleLocations(chunks);
        futureLocations.thenAccept(particleLocations -> {
            if (this.instance.isFolia()) {
                int[] counter = new int[]{0};
                Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.instance, task -> {
                    if (counter[0] >= 10) {
                        task.cancel();
                        this.chunksParticles.removeAll(chunks);
                        return;
                    }
                    World world = player.getWorld();
                    particleLocations.stream().forEach(location -> world.spawnParticle(Particle.REDSTONE, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions));
                    counter[0] = counter[0] + 1;
                }, 0L, 500L, TimeUnit.MILLISECONDS);
            } else {
                new BukkitRunnable((Set)particleLocations, dustOptions){
                    int counter = 0;
                    final /* synthetic */ Set val$particleLocations;
                    final /* synthetic */ Particle.DustOptions val$dustOptions;
                    {
                        this.val$particleLocations = set;
                        this.val$dustOptions = dustOptions;
                    }

                    public void run() {
                        if (this.counter >= 10) {
                            this.cancel();
                            ClaimMain.this.instance.executeSync(() -> ClaimMain.this.chunksParticles.removeAll(chunks));
                            return;
                        }
                        World world = player.getWorld();
                        this.val$particleLocations.stream().forEach(location -> world.spawnParticle(Particle.REDSTONE, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)this.val$dustOptions));
                        ++this.counter;
                    }
                }.runTaskTimerAsynchronously((Plugin)this.instance, 0L, 10L);
            }
        });
    }

    private Particle.DustOptions getDustOptions(Player player, boolean claim, boolean see) {
        if (!claim && !see) {
            Chunk chunk = player.getLocation().getChunk();
            if (this.checkIfClaimExists(chunk)) {
                String playerName = player.getName();
                if (this.listClaims.get(chunk).getOwner().equals(playerName)) {
                    return new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 1.5f);
                }
                return new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 1.5f);
            }
            return new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)255), 1.5f);
        }
        if (see) {
            return new Particle.DustOptions(Color.fromRGB((int)124, (int)0, (int)255), 1.5f);
        }
        return new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 1.5f);
    }

    private CompletableFuture<Set<Location>> getParticleLocations(Set<Chunk> chunks) {
        CustomSet locations = new CustomSet();
        CompletableFuture<Set<Location>> resultFuture = new CompletableFuture<Set<Location>>();
        if (this.instance.isFolia()) {
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (Chunk chunk : chunks) {
                World world = chunk.getWorld();
                int xStart = chunk.getX() << 4;
                int zStart = chunk.getZ() << 4;
                int xEnd = xStart + 15;
                int zEnd = zStart + 15;
                int yStart = world.getMinHeight();
                int yEnd = world.getMaxHeight() - 1;
                futures.add(world.getChunkAtAsync(chunk.getX() - 1, chunk.getZ()).thenAccept(adjChunk -> {
                    if (!chunks.contains(adjChunk)) {
                        for (int y = yStart; y <= yEnd; y += 2) {
                            for (int z = zStart; z <= zEnd; z += 2) {
                                locations.add(new Location(world, (double)xStart, (double)y, (double)z));
                            }
                        }
                    }
                }));
                futures.add(world.getChunkAtAsync(chunk.getX() + 1, chunk.getZ()).thenAccept(adjChunk -> {
                    if (!chunks.contains(adjChunk)) {
                        for (int y = yStart; y <= yEnd; y += 2) {
                            for (int z = zStart; z <= zEnd; z += 2) {
                                locations.add(new Location(world, (double)(xEnd + 1), (double)y, (double)z));
                            }
                        }
                    }
                }));
                futures.add(world.getChunkAtAsync(chunk.getX(), chunk.getZ() - 1).thenAccept(adjChunk -> {
                    if (!chunks.contains(adjChunk)) {
                        for (int y = yStart; y <= yEnd; y += 2) {
                            for (int x = xStart; x <= xEnd; x += 2) {
                                locations.add(new Location(world, (double)x, (double)y, (double)zStart));
                            }
                        }
                    }
                }));
                futures.add(world.getChunkAtAsync(chunk.getX(), chunk.getZ() + 1).thenAccept(adjChunk -> {
                    if (!chunks.contains(adjChunk)) {
                        for (int y = yStart; y <= yEnd; y += 2) {
                            for (int x = xStart; x <= xEnd; x += 2) {
                                locations.add(new Location(world, (double)x, (double)y, (double)(zEnd + 1)));
                            }
                        }
                    }
                }));
            }
            CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            ((CompletableFuture)allOf.thenRun(() -> resultFuture.complete(locations))).exceptionally(ex -> {
                ex.printStackTrace();
                resultFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        } else {
            for (Chunk chunk : chunks) {
                int x;
                int z;
                int y;
                World world = chunk.getWorld();
                int xStart = chunk.getX() << 4;
                int zStart = chunk.getZ() << 4;
                int xEnd = xStart + 15;
                int zEnd = zStart + 15;
                int yStart = world.getMinHeight();
                int yEnd = world.getMaxHeight() - 1;
                if (!chunks.contains(world.getChunkAt(chunk.getX() - 1, chunk.getZ()))) {
                    for (y = yStart; y <= yEnd; y += 2) {
                        for (z = zStart; z <= zEnd; z += 2) {
                            locations.add(new Location(world, (double)xStart, (double)y, (double)z));
                        }
                    }
                }
                if (!chunks.contains(world.getChunkAt(chunk.getX() + 1, chunk.getZ()))) {
                    for (y = yStart; y <= yEnd; y += 2) {
                        for (z = zStart; z <= zEnd; z += 2) {
                            locations.add(new Location(world, (double)(xEnd + 1), (double)y, (double)z));
                        }
                    }
                }
                if (!chunks.contains(world.getChunkAt(chunk.getX(), chunk.getZ() - 1))) {
                    for (y = yStart; y <= yEnd; y += 2) {
                        for (x = xStart; x <= xEnd; x += 2) {
                            locations.add(new Location(world, (double)x, (double)y, (double)zStart));
                        }
                    }
                }
                if (chunks.contains(world.getChunkAt(chunk.getX(), chunk.getZ() + 1))) continue;
                for (y = yStart; y <= yEnd; y += 2) {
                    for (x = xStart; x <= xEnd; x += 2) {
                        locations.add(new Location(world, (double)x, (double)y, (double)(zEnd + 1)));
                    }
                }
            }
            resultFuture.complete(locations);
        }
        return resultFuture;
    }

    public void displayChunkBorderWithRadius(final Player player, final int radius) {
        final Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 1.5f);
        if (this.instance.isFolia()) {
            Bukkit.getRegionScheduler().run((Plugin)this.instance, player.getLocation(), chunktask -> {
                Chunk centralChunk = player.getLocation().getChunk();
                if (this.chunksParticles.contains(centralChunk)) {
                    return;
                }
                this.chunksParticles.add(centralChunk);
                int[] counter = new int[]{0};
                Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.instance, task -> {
                    if (counter[0] >= 10) {
                        task.cancel();
                        this.chunksParticles.remove(centralChunk);
                        return;
                    }
                    World world = player.getWorld();
                    int xStart = centralChunk.getX() - radius << 4;
                    int zStart = centralChunk.getZ() - radius << 4;
                    int xEnd = centralChunk.getX() + radius + 1 << 4;
                    int zEnd = centralChunk.getZ() + radius + 1 << 4;
                    int yStart = world.getMinHeight();
                    int yEnd = world.getMaxHeight() - 1;
                    for (int y = yStart; y <= yEnd; y += 2) {
                        for (int x = xStart; x < xEnd; x += 2) {
                            world.spawnParticle(Particle.REDSTONE, new Location(world, (double)x, (double)y, (double)zStart), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                            world.spawnParticle(Particle.REDSTONE, new Location(world, (double)x, (double)y, (double)zEnd), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                        }
                        for (int z = zStart; z < zEnd; z += 2) {
                            world.spawnParticle(Particle.REDSTONE, new Location(world, (double)xStart, (double)y, (double)z), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                            world.spawnParticle(Particle.REDSTONE, new Location(world, (double)xEnd, (double)y, (double)z), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                        }
                    }
                    counter[0] = counter[0] + 1;
                }, 0L, 500L, TimeUnit.MILLISECONDS);
            });
            return;
        }
        final Chunk centralChunk = player.getLocation().getChunk();
        if (this.chunksParticles.contains(centralChunk)) {
            return;
        }
        this.chunksParticles.add(centralChunk);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (this.counter >= 10) {
                    this.cancel();
                    ClaimMain.this.chunksParticles.remove(centralChunk);
                    return;
                }
                World world = player.getWorld();
                int xStart = centralChunk.getX() - radius << 4;
                int zStart = centralChunk.getZ() - radius << 4;
                int xEnd = centralChunk.getX() + radius + 1 << 4;
                int zEnd = centralChunk.getZ() + radius + 1 << 4;
                int yStart = world.getMinHeight();
                int yEnd = world.getMaxHeight() - 1;
                for (int y = yStart; y <= yEnd; y += 2) {
                    for (int x = xStart; x < xEnd; x += 2) {
                        world.spawnParticle(Particle.REDSTONE, new Location(world, (double)x, (double)y, (double)zStart), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                        world.spawnParticle(Particle.REDSTONE, new Location(world, (double)x, (double)y, (double)zEnd), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    }
                    for (int z = zStart; z < zEnd; z += 2) {
                        world.spawnParticle(Particle.REDSTONE, new Location(world, (double)xStart, (double)y, (double)z), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                        world.spawnParticle(Particle.REDSTONE, new Location(world, (double)xEnd, (double)y, (double)z), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                    }
                }
                ++this.counter;
            }
        }.runTaskTimerAsynchronously((Plugin)this.instance, 0L, 10L);
    }

    public void getHelp(Player player, String help, String cmd) {
        if (help.equalsIgnoreCase("no arg")) {
            if (cmd.equalsIgnoreCase("claim")) {
                player.sendMessage(this.instance.getLanguage().getMessage("available-args").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%args%", String.join((CharSequence)", ", this.commandArgsClaim)));
            } else if (cmd.equalsIgnoreCase("scs")) {
                player.sendMessage(this.instance.getLanguage().getMessage("available-args").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%args%", String.join((CharSequence)", ", this.commandArgsScs)));
            } else if (cmd.equalsIgnoreCase("parea") || cmd.equalsIgnoreCase("protectedarea")) {
                player.sendMessage(this.instance.getLanguage().getMessage("available-args").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%args%", String.join((CharSequence)", ", this.commandArgsParea)));
            }
            return;
        }
        String help_msg = this.instance.getLanguage().getMessage("help-command." + cmd + "-" + help.toLowerCase());
        if (!help_msg.isEmpty()) {
            player.sendMessage(this.instance.getLanguage().getMessage("help-separator"));
            player.sendMessage(help_msg);
            player.sendMessage(this.instance.getLanguage().getMessage("help-separator"));
            return;
        }
        if (cmd.equalsIgnoreCase("claim")) {
            player.sendMessage(this.instance.getLanguage().getMessage("sub-arg-not-found").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%arg%", help).replace("%args%", String.join((CharSequence)", ", this.commandArgsClaim)));
        } else if (cmd.equalsIgnoreCase("scs")) {
            player.sendMessage(this.instance.getLanguage().getMessage("sub-arg-not-found").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%arg%", help).replace("%args%", String.join((CharSequence)", ", this.commandArgsScs)));
        } else if (cmd.equalsIgnoreCase("parea") || cmd.equalsIgnoreCase("protectedarea")) {
            player.sendMessage(this.instance.getLanguage().getMessage("sub-arg-not-found").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%arg%", help).replace("%args%", String.join((CharSequence)", ", this.commandArgsParea)));
        }
    }

    public void getHelp(CommandSender sender, String help, String cmd) {
        if (help.equalsIgnoreCase("no arg")) {
            if (cmd.equalsIgnoreCase("claim")) {
                sender.sendMessage(this.instance.getLanguage().getMessage("available-args").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%args%", String.join((CharSequence)", ", this.commandArgsClaim)));
            } else if (cmd.equalsIgnoreCase("scs")) {
                sender.sendMessage(this.instance.getLanguage().getMessage("available-args").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%args%", String.join((CharSequence)", ", this.commandArgsScs)));
            }
            return;
        }
        String help_msg = this.instance.getLanguage().getMessage("help-command." + cmd + "-" + help.toLowerCase());
        if (!help_msg.isEmpty()) {
            sender.sendMessage(this.instance.getLanguage().getMessage("help-separator"));
            sender.sendMessage(help_msg);
            sender.sendMessage(this.instance.getLanguage().getMessage("help-separator"));
            return;
        }
        if (cmd.equalsIgnoreCase("claim")) {
            sender.sendMessage(this.instance.getLanguage().getMessage("sub-arg-not-found").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%arg%", help).replace("%args%", String.join((CharSequence)", ", this.commandArgsClaim)));
        } else if (cmd.equalsIgnoreCase("scs")) {
            sender.sendMessage(this.instance.getLanguage().getMessage("sub-arg-not-found").replace("%help-separator%", this.instance.getLanguage().getMessage("help-separator")).replace("%arg%", help).replace("%args%", String.join((CharSequence)", ", this.commandArgsScs)));
        }
    }

    public CompletableFuture<Boolean> isAreaClaimFree(Chunk centerChunk, int distance, String playerName) {
        return CompletableFuture.supplyAsync(() -> {
            if (distance == 0) {
                return true;
            }
            World world = centerChunk.getWorld();
            int centerX = centerChunk.getX();
            int centerZ = centerChunk.getZ();
            for (Map.Entry<Chunk, Claim> entry : this.listClaims.entrySet()) {
                Chunk chunk = entry.getKey();
                Claim claim = entry.getValue();
                if (!chunk.getWorld().equals((Object)world)) continue;
                int chunkX = chunk.getX();
                int chunkZ = chunk.getZ();
                int deltaX = Math.abs(chunkX - centerX);
                int deltaZ = Math.abs(chunkZ - centerZ);
                if (deltaX > distance || deltaZ > distance || claim.getOwner().equals(playerName)) continue;
                return false;
            }
            return true;
        });
    }

    private String getDirection(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (0.0f <= yaw && yaw < 45.0f) {
            return this.instance.getLanguage().getMessage("map-direction-south");
        }
        if (45.0f <= yaw && yaw < 135.0f) {
            return this.instance.getLanguage().getMessage("map-direction-west");
        }
        if (135.0f <= yaw && yaw < 225.0f) {
            return this.instance.getLanguage().getMessage("map-direction-north");
        }
        if (225.0f <= yaw && yaw < 315.0f) {
            return this.instance.getLanguage().getMessage("map-direction-east");
        }
        if (315.0f <= yaw && (double)yaw < 360.0) {
            return this.instance.getLanguage().getMessage("map-direction-south");
        }
        return "Unknown";
    }

    public void getMap(Player player, Chunk to, boolean check) {
        this.instance.executeAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
            if (cPlayer == null) {
                return;
            }
            boolean scoreboard = this.instance.getSettings().getSetting("map-type").equals("scoreboard") && check;
            CScoreboard cScoreboard = scoreboard ? cPlayer.getScoreboard() : null;
            ArrayList<String> lines = new ArrayList<String>();
            if (scoreboard && cScoreboard != null) {
                lines.add("\u00a7e  ");
            }
            String direction = this.getDirection(player.getLocation().getYaw());
            Chunk centerChunk = to;
            int centerX = centerChunk.getX();
            int centerZ = centerChunk.getZ();
            boolean isClaimed = this.checkIfClaimExists(centerChunk);
            String name = isClaimed ? this.instance.getLanguage().getMessage("map-actual-claim-name-message").replace("%name%", this.getClaimNameByChunk(centerChunk)) : this.instance.getLanguage().getMessage("map-no-claim-name-message");
            String coords = this.instance.getLanguage().getMessage("map-coords-message").replace("%coords%", centerX + "," + centerZ).replace("%direction%", direction);
            String colorRelationNoClaim = this.instance.getLanguage().getMessage("map-no-claim-color");
            String colorCursor = this.instance.getLanguage().getMessage("map-cursor-color");
            String symbolNoClaim = this.instance.getLanguage().getMessage("map-symbol-no-claim");
            String symbolClaim = this.instance.getLanguage().getMessage("map-symbol-claim");
            String mapCursor = this.instance.getLanguage().getMessage("map-cursor");
            World world = player.getWorld();
            Function<Chunk, String> getChunkSymbol = chunk -> chunk.equals((Object)centerChunk) ? colorCursor + mapCursor + colorRelationNoClaim : (this.checkIfClaimExists((Chunk)chunk) ? this.getRelation(player, (Chunk)chunk) + symbolClaim + colorRelationNoClaim : colorRelationNoClaim + symbolNoClaim);
            HashMap<Integer, CallSite> legendMap = new HashMap<Integer, CallSite>();
            legendMap.put(-3, (CallSite)((Object)("  " + name + (String)(isClaimed ? " " + this.instance.getLanguage().getMessage("map-actual-claim-name-message-owner").replace("%owner%", this.listClaims.get(centerChunk).getOwner()) : ""))));
            legendMap.put(-2, (CallSite)((Object)("  " + coords)));
            legendMap.put(0, (CallSite)((Object)("  " + this.instance.getLanguage().getMessage("map-legend-you").replace("%cursor-color%", colorCursor))));
            legendMap.put(1, (CallSite)((Object)("  " + this.instance.getLanguage().getMessage("map-legend-free").replace("%no-claim-color%", colorRelationNoClaim))));
            legendMap.put(2, (CallSite)((Object)("  " + this.instance.getLanguage().getMessage("map-legend-yours").replace("%claim-relation-member%", this.instance.getLanguage().getMessage("map-claim-relation-member")))));
            legendMap.put(3, (CallSite)((Object)("  " + this.instance.getLanguage().getMessage("map-legend-other").replace("%claim-relation-visitor%", this.instance.getLanguage().getMessage("map-claim-relation-visitor")))));
            StringBuilder mapMessage = new StringBuilder("\n").append(colorRelationNoClaim);
            Runnable mapLogic = () -> IntStream.rangeClosed(-4, 4).forEach(dz -> {
                StringBuilder line = new StringBuilder(colorRelationNoClaim);
                IntStream.rangeClosed(-10, 10).forEach(dx -> {
                    int[] offset = this.adjustDirection(dx, dz, direction);
                    Chunk chunk = world.getChunkAt(centerX + offset[0], centerZ + offset[1]);
                    String symbol = (String)getChunkSymbol.apply(chunk);
                    mapMessage.append(symbol);
                    line.append(symbol);
                });
                if (legendMap.containsKey(dz)) {
                    String legend = (String)legendMap.get(dz);
                    mapMessage.append(legend);
                    line.append(legend);
                }
                mapMessage.append("\n");
                lines.add(line.toString());
            });
            if (this.instance.isFolia()) {
                Bukkit.getRegionScheduler().run((Plugin)this.instance, player.getLocation(), task -> {
                    mapLogic.run();
                    if (scoreboard) {
                        this.updateScoreboard(cScoreboard, lines);
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(mapMessage.toString()));
                    }
                });
            } else {
                mapLogic.run();
                if (scoreboard) {
                    this.updateScoreboard(cScoreboard, lines);
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(mapMessage.toString()));
                }
            }
        });
    }

    private void updateScoreboard(CScoreboard cScoreboard, List<String> lines) {
        lines.add("\u00a7f ");
        int score = 11;
        LinkedHashMap<Integer, String> toRend = new LinkedHashMap<Integer, String>();
        for (String line : this.differentiateDuplicates(lines)) {
            toRend.put(score--, line);
        }
        cScoreboard.updateLines(toRend);
    }

    private List<String> differentiateDuplicates(List<String> list) {
        HashMap<String, Integer> stringCount = new HashMap<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            String original = list.get(i);
            int count = stringCount.getOrDefault(original, 0);
            if (count > 0) {
                list.set(i, original + " ".repeat(count));
            }
            stringCount.put(original, count + 1);
        }
        return list;
    }

    private int[] adjustDirection(int dx, int dz, String direction) {
        int relX = dx;
        int relZ = dz;
        if (direction.equalsIgnoreCase(this.instance.getLanguage().getMessage("map-direction-north"))) {
            return new int[]{relX, relZ};
        }
        if (direction.equalsIgnoreCase(this.instance.getLanguage().getMessage("map-direction-south"))) {
            relX = -dx;
            relZ = -dz;
            return new int[]{relX, relZ};
        }
        if (direction.equalsIgnoreCase(this.instance.getLanguage().getMessage("map-direction-east"))) {
            relX = -dz;
            relZ = dx;
            return new int[]{relX, relZ};
        }
        if (direction.equalsIgnoreCase(this.instance.getLanguage().getMessage("map-direction-west"))) {
            relX = dz;
            relZ = -dx;
            return new int[]{relX, relZ};
        }
        return new int[]{relX, relZ};
    }

    public String getRelation(Player player, Chunk chunk) {
        Claim claim = this.listClaims.get(chunk);
        if (claim == null) {
            return this.instance.getLanguage().getMessage("map-claim-relation-visitor");
        }
        return this.checkMembre(claim, player) ? this.instance.getLanguage().getMessage("map-claim-relation-member") : this.instance.getLanguage().getMessage("map-claim-relation-visitor");
    }

    public void updateWeatherChunk(Claim claim) {
        Set<Chunk> chunks = claim.getChunks();
        if (this.instance.isFolia()) {
            Bukkit.getOnlinePlayers().stream().forEach(p -> Bukkit.getRegionScheduler().run((Plugin)this.instance, p.getLocation(), task -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    boolean value = claim.getPermissionForPlayer("Weather", (Player)p);
                    if (value) {
                        p.resetPlayerWeather();
                    } else {
                        p.setPlayerWeather(WeatherType.CLEAR);
                    }
                }
            }));
        } else {
            Bukkit.getOnlinePlayers().stream().forEach(p -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    boolean value = claim.getPermissionForPlayer("Weather", (Player)p);
                    if (value) {
                        p.resetPlayerWeather();
                    } else {
                        p.setPlayerWeather(WeatherType.CLEAR);
                    }
                }
            });
        }
    }

    public void updateFlyChunk(Claim claim) {
        Set<Chunk> chunks = claim.getChunks();
        if (!this.instance.isFolia()) {
            Bukkit.getOnlinePlayers().stream().forEach(p -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    boolean value = claim.getPermissionForPlayer("Fly", (Player)p);
                    CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(p.getUniqueId());
                    if (value) {
                        if (cPlayer.getClaimAutofly().booleanValue()) {
                            this.instance.getPlayerMain().activePlayerFly((Player)p);
                        }
                    } else if (cPlayer.getClaimFly().booleanValue()) {
                        this.instance.getPlayerMain().removePlayerFly((Player)p);
                    }
                }
            });
        }
    }

    public void resetWeatherChunk(Claim claim) {
        Set<Chunk> chunks = claim.getChunks();
        if (this.instance.isFolia()) {
            Bukkit.getOnlinePlayers().stream().forEach(p -> Bukkit.getRegionScheduler().run((Plugin)this.instance, p.getLocation(), task -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    p.resetPlayerWeather();
                }
            }));
        } else {
            Bukkit.getOnlinePlayers().stream().forEach(p -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    p.resetPlayerWeather();
                }
            });
        }
    }

    public void resetFlyChunk(Claim claim) {
        Set<Chunk> chunks = claim.getChunks();
        if (this.instance.isFolia()) {
            Bukkit.getOnlinePlayers().stream().forEach(p -> Bukkit.getRegionScheduler().run((Plugin)this.instance, p.getLocation(), task -> {
                CPlayer cPlayer;
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c) && (cPlayer = this.instance.getPlayerMain().getCPlayer(p.getUniqueId())).getClaimFly().booleanValue()) {
                    this.instance.getPlayerMain().removePlayerFly((Player)p);
                }
            }));
        } else {
            Bukkit.getOnlinePlayers().stream().forEach(p -> {
                CPlayer cPlayer;
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c) && (cPlayer = this.instance.getPlayerMain().getCPlayer(p.getUniqueId())).getClaimFly().booleanValue()) {
                    this.instance.getPlayerMain().removePlayerFly((Player)p);
                }
            });
        }
    }

    public void getMapAutoForChunks(Set<Chunk> chunks) {
        if (this.instance.isFolia()) {
            Bukkit.getOnlinePlayers().stream().forEach(p -> Bukkit.getRegionScheduler().run((Plugin)this.instance, p.getLocation(), task -> {
                CPlayer cPlayer;
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c) && (cPlayer = this.instance.getPlayerMain().getCPlayer(p.getUniqueId())).getClaimAutomap().booleanValue()) {
                    this.getMap((Player)p, c, true);
                }
            }));
        } else {
            Bukkit.getOnlinePlayers().stream().forEach(p -> {
                CPlayer cPlayer;
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c) && (cPlayer = this.instance.getPlayerMain().getCPlayer(p.getUniqueId())).getClaimAutomap().booleanValue()) {
                    this.getMap((Player)p, c, true);
                }
            });
        }
    }

    private /* synthetic */ void lambda$setOwner$184(Set chunks) {
        this.instance.getBossBars().activateBossBar(chunks);
    }

    private static /* synthetic */ CustomSet lambda$setOwner$183(UUID k) {
        return new CustomSet();
    }

    private static class ClaimData {
        int id;
        String owner_uuid;
        String owner_name;
        String claim_name;
        String claim_description;
        String chunks;
        String world_name;
        String location;
        String members;
        String permissions;
        boolean for_sale;
        double sale_price;
        String bans;

        public ClaimData(int id, String owner_uuid, String owner_name, String claim_name, String claim_description, String chunks, String world_name, String location, String members, String permissions, boolean for_sale, double sale_price, String bans) {
            this.id = id;
            this.owner_uuid = owner_uuid;
            this.owner_name = owner_name;
            this.claim_name = claim_name;
            this.claim_description = claim_description;
            this.chunks = chunks;
            this.world_name = world_name;
            this.location = location;
            this.members = members;
            this.permissions = permissions;
            this.for_sale = for_sale;
            this.sale_price = sale_price;
            this.bans = bans;
        }
    }
}

