/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.Claim;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ClaimBossBar {
    private final ConcurrentMap<Player, BossBar> bossBars = new ConcurrentHashMap<Player, BossBar>();
    private SimpleClaimSystem instance;
    private BarColor defaultColor;
    private BarStyle defaultStyle;
    private BarColor saleColor;
    private BarStyle saleStyle;

    public ClaimBossBar(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public void loadBossbarSettings() {
        this.defaultColor = BarColor.valueOf((String)this.instance.getSettings().getSetting("bossbar-color"));
        this.defaultStyle = BarStyle.valueOf((String)this.instance.getSettings().getSetting("bossbar-style"));
        this.saleColor = BarColor.valueOf((String)this.instance.getSettings().getSetting("announce-sale.bossbar-settings.color"));
        this.saleStyle = BarStyle.valueOf((String)this.instance.getSettings().getSetting("announce-sale.bossbar-settings.style"));
    }

    public void removePlayer(Player player) {
        this.bossBars.remove(player);
    }

    public void activeBossBar(Player player, Chunk chunk) {
        if (player == null) {
            return;
        }
        this.instance.executeAsync(() -> {
            String title;
            BossBar b = this.checkBossBar(player);
            if (!this.instance.getSettings().getBooleanSetting("bossbar")) {
                b.setVisible(false);
                return;
            }
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                b.setVisible(false);
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            String chunkName = claim.getName();
            if (claim.getSale() && this.instance.getSettings().getBooleanSetting("announce-sale.bossbar")) {
                b.setColor(this.saleColor);
                b.setStyle(this.saleStyle);
                title = owner.equals("*") ? this.instance.getLanguage().getMessage("bossbar-protected-area-for-sale-message", (OfflinePlayer)player).replace("%name%", chunkName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : (owner.equals(player.getName()) ? this.instance.getLanguage().getMessage("bossbar-owner-for-sale-message", (OfflinePlayer)player).replace("%owner%", owner).replace("%name%", chunkName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : (this.instance.getMain().checkMembre(claim, player) ? this.instance.getLanguage().getMessage("bossbar-member-for-sale-message", (OfflinePlayer)player).replace("%player%", player.getName()).replace("%owner%", owner).replace("%name%", chunkName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("bossbar-visitor-for-sale-message", (OfflinePlayer)player).replace("%player%", player.getName()).replace("%owner%", owner).replace("%name%", chunkName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
            } else {
                b.setColor(this.defaultColor);
                b.setStyle(this.defaultStyle);
                title = owner.equals("*") ? this.instance.getLanguage().getMessage("bossbar-protected-area-message", (OfflinePlayer)player).replace("%name%", chunkName) : (owner.equals(player.getName()) ? this.instance.getLanguage().getMessage("bossbar-owner-message", (OfflinePlayer)player).replace("%owner%", owner).replace("%name%", chunkName) : (this.instance.getMain().checkMembre(claim, player) ? this.instance.getLanguage().getMessage("bossbar-member-message", (OfflinePlayer)player).replace("%player%", player.getName()).replace("%owner%", owner).replace("%name%", chunkName) : this.instance.getLanguage().getMessage("bossbar-visitor-message", (OfflinePlayer)player).replace("%player%", player.getName()).replace("%owner%", owner).replace("%name%", chunkName)));
            }
            b.setTitle(title);
            b.setVisible(true);
        });
    }

    public void setBossBarColor(BarColor color) {
        this.bossBars.values().stream().forEach(b -> b.setColor(color));
    }

    public void setBossBarStyle(BarStyle style) {
        this.bossBars.values().stream().forEach(b -> b.setStyle(style));
    }

    public BossBar checkBossBar(Player player) {
        return this.bossBars.computeIfAbsent(player, p -> {
            BossBar b = Bukkit.getServer().createBossBar("", BarColor.valueOf((String)this.instance.getSettings().getSetting("bossbar-color")), BarStyle.valueOf((String)this.instance.getSettings().getSetting("bossbar-style")), new BarFlag[0]);
            b.addPlayer(p);
            return b;
        });
    }

    public void disableBossBar(Player player) {
        if (!this.instance.getSettings().getBooleanSetting("bossbar")) {
            return;
        }
        if (player == null) {
            return;
        }
        BossBar b = this.checkBossBar(player);
        b.setVisible(false);
    }

    public void clearAll() {
        this.bossBars.values().forEach(b -> b.setVisible(false));
        this.bossBars.clear();
    }

    public void activateBossBar(Chunk chunk) {
        if (!this.instance.getSettings().getBooleanSetting("bossbar")) {
            return;
        }
        Runnable bossBarTask = () -> {
            for (Entity entity : chunk.getEntities()) {
                if (!(entity instanceof Player)) continue;
                this.instance.getBossBars().activeBossBar((Player)entity, chunk);
            }
        };
        if (this.instance.isFolia()) {
            Bukkit.getRegionScheduler().run((Plugin)this.instance, chunk.getWorld(), chunk.getX(), chunk.getZ(), task -> bossBarTask.run());
        } else {
            bossBarTask.run();
        }
    }

    public void activateBossBar(Set<Chunk> chunks) {
        if (!this.instance.getSettings().getBooleanSetting("bossbar")) {
            return;
        }
        if (this.instance.isFolia()) {
            Bukkit.getOnlinePlayers().stream().forEach(p -> Bukkit.getRegionScheduler().run((Plugin)this.instance, p.getLocation(), task -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    this.activeBossBar((Player)p, c);
                }
            }));
        } else {
            Bukkit.getOnlinePlayers().stream().forEach(p -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    this.activeBossBar((Player)p, c);
                }
            });
        }
    }

    public void deactivateBossBar(Set<Chunk> chunks) {
        if (!this.instance.getSettings().getBooleanSetting("bossbar")) {
            return;
        }
        if (this.instance.isFolia()) {
            Bukkit.getOnlinePlayers().stream().forEach(p -> Bukkit.getRegionScheduler().run((Plugin)this.instance, p.getLocation(), task -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    this.disableBossBar((Player)p);
                }
            }));
        } else {
            Bukkit.getOnlinePlayers().stream().forEach(p -> {
                Chunk c = p.getLocation().getChunk();
                if (chunks.contains(c)) {
                    this.disableBossBar((Player)p);
                }
            });
        }
    }
}

