/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.API;

import fr.xyness.SCS.API.SimpleClaimSystemAPI;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SimpleClaimSystemAPI_Impl
implements SimpleClaimSystemAPI {
    private SimpleClaimSystem instance;

    public SimpleClaimSystemAPI_Impl(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    @Override
    public Claim getPlayerClaim(Player player, String claimName) {
        return this.instance.getMain().getClaimByName(claimName, player);
    }

    @Override
    public Set<Claim> getPlayerClaims(Player player) {
        return this.instance.getMain().getPlayerClaims(player.getUniqueId());
    }

    @Override
    public Set<Claim> getPlayerClaimsWhereMember(Player player) {
        return this.instance.getMain().getClaimsWhereMemberNotOwner(player);
    }

    @Override
    public CPlayer getCPlayer(String playerName) {
        return this.instance.getPlayerMain().getCPlayer(Bukkit.getOfflinePlayer((String)playerName).getUniqueId());
    }

    @Override
    public CPlayer getCPlayer(Player player) {
        return this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
    }

    @Override
    public boolean unclaim(Claim claim) {
        return this.instance.getMain().deleteClaim(claim).join();
    }

    @Override
    public boolean unclaimAll(String owner) {
        return this.instance.getMain().deleteAllClaims(owner).join();
    }

    @Override
    public boolean isClaimed(Chunk chunk) {
        return this.instance.getMain().checkIfClaimExists(chunk);
    }

    @Override
    public Claim getClaimAtChunk(Chunk chunk) {
        return this.instance.getMain().getClaim(chunk);
    }

    @Override
    public Set<Claim> getAllClaims() {
        return this.instance.getMain().getAllClaims();
    }

    @Override
    public Set<Claim> getClaims(World targetWorld) {
        return this.instance.getMain().getAllClaims().parallelStream().filter(claim -> claim.getLocation().getWorld().equals((Object)targetWorld)).collect(Collectors.toSet());
    }

    @Override
    public boolean applySettingsToAllClaims(Claim claim) {
        return this.instance.getMain().applyAllSettings(claim).join();
    }

    @Override
    public boolean resetClaimsSettings(String owner) {
        return this.instance.getMain().resetAllOwnerClaimsSettings(owner).join();
    }

    @Override
    public boolean resetAllClaimsSettings() {
        return this.instance.getMain().resetAllPlayerClaimsSettings().join();
    }

    @Override
    public boolean mergeMultipleClaims(Claim mainClaim, CustomSet<Claim> claimsToMerge) {
        return this.instance.getMain().mergeClaims(mainClaim, claimsToMerge).join();
    }

    @Override
    public void kickPlayerFromClaim(Claim claim, String targetPlayerName) {
        Player target = Bukkit.getPlayer((String)targetPlayerName);
        if (target != null && target.isOnline() && claim.getChunks().contains(target.getLocation().getChunk())) {
            this.instance.getMain().teleportPlayer(target, ((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
        }
    }

    @Override
    public void kickPlayerFromAllClaims(String owner, String targetPlayerName) {
        CustomSet<Chunk> chunks;
        Player target = Bukkit.getPlayer((String)targetPlayerName);
        if (target != null && target.isOnline() && (chunks = this.instance.getMain().getAllChunksFromAllClaims(owner)).contains(target.getLocation().getChunk())) {
            this.instance.getMain().teleportPlayer(target, ((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
        }
    }

    @Override
    public boolean banPlayerFromClaim(Claim claim, String targetPlayerName) {
        return this.instance.getMain().addClaimBan(claim, targetPlayerName).join();
    }

    @Override
    public boolean unbanPlayerFromClaim(Claim claim, String targetPlayerName) {
        return this.instance.getMain().removeClaimBan(claim, targetPlayerName).join();
    }

    @Override
    public boolean banPlayerFromAllClaims(String owner, String targetPlayerName) {
        return this.instance.getMain().addAllClaimBan(owner, targetPlayerName).join();
    }

    @Override
    public boolean unbanPlayerFromAllClaims(String owner, String targetPlayerName) {
        return this.instance.getMain().removeAllClaimBan(owner, targetPlayerName).join();
    }

    @Override
    public boolean addPlayerToClaim(Claim claim, String targetPlayerName) {
        return this.instance.getMain().addClaimMember(claim, targetPlayerName).join();
    }

    @Override
    public boolean removePlayerFromClaim(Claim claim, String targetPlayerName) {
        return this.instance.getMain().removeClaimMember(claim, targetPlayerName).join();
    }

    @Override
    public boolean addPlayerToAllClaims(String owner, String targetPlayerName) {
        return this.instance.getMain().addAllClaimsMember(owner, targetPlayerName).join();
    }

    @Override
    public boolean removePlayerFromAllClaims(String owner, String targetPlayerName) {
        return this.instance.getMain().removeAllClaimsMember(owner, targetPlayerName).join();
    }

    @Override
    public boolean resetClaimPerm(Claim claim) {
        return this.instance.getMain().resetClaimSettings(claim).join();
    }

    @Override
    public boolean setClaimPerm(Claim claim, String permission, boolean value, String role) {
        return this.instance.getMain().updatePerm(claim, permission, value, role).join();
    }

    @Override
    public boolean setClaimName(Claim claim, String newName) {
        return this.instance.getMain().setClaimName(claim, newName).join();
    }

    @Override
    public boolean setClaimLocation(Claim claim, Location newLoc) {
        return this.instance.getMain().setClaimLocation(claim, newLoc).join();
    }

    @Override
    public boolean setClaimDescription(Claim claim, String newDesc) {
        return this.instance.getMain().setClaimDescription(claim, newDesc).join();
    }

    @Override
    public boolean addClaimSale(Claim claim, long claimPrice) {
        return this.instance.getMain().setChunkSale(claim, claimPrice).join();
    }

    @Override
    public boolean removeClaimSale(Claim claim) {
        return this.instance.getMain().delChunkSale(claim).join();
    }

    @Override
    public boolean setClaimOwner(Claim claim, String newOwner) {
        return this.instance.getMain().setOwner(newOwner, claim).join();
    }

    @Override
    public boolean addClaimChunk(Claim claim, Chunk chunk) {
        return this.instance.getMain().addClaimChunk(claim, chunk).join();
    }

    @Override
    public boolean removeClaimChunk(Claim claim, Chunk chunk) {
        return this.instance.getMain().removeClaimChunk(claim, String.valueOf(chunk.getWorld().getName() + ";" + chunk.getX() + ";" + chunk.getZ())).join();
    }

    @Override
    public void getMap(Player player, Chunk chunk) {
        this.instance.getMain().getMap(player, chunk, false);
    }

    @Override
    public void updateBossBar(Player player, Chunk chunk) {
        this.instance.getBossBars().activeBossBar(player, chunk);
    }
}

