/*
 * Decompiled with CFR 0.152.
 */
package eu.raidersheaven.rhsignitem.handlers;

import eu.raidersheaven.rhsignitem.Main;
import eu.raidersheaven.rhsignitem.configurations.ConfigFile;
import eu.raidersheaven.rhsignitem.handlers.ColorFormatHandler;
import eu.raidersheaven.rhsignitem.handlers.LocaleHandler;
import eu.raidersheaven.rhsignitem.handlers.SoundHandler;
import java.util.function.Supplier;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class VaultMoneyHandler {
    public static boolean isVaultAvailable() {
        return Bukkit.getPluginManager().getPlugin("Vault") != null && Main.getEconomy() != null;
    }

    public static boolean shouldCancelStatus(Player player, Supplier<Boolean> isCommandEnabled) {
        double cost;
        if (!ConfigFile.vaultEnabled.booleanValue() || !isCommandEnabled.get().booleanValue()) {
            return false;
        }
        if (!VaultMoneyHandler.isVaultAvailable()) {
            return false;
        }
        Economy economy = Main.getEconomy();
        if (!economy.has((OfflinePlayer)player, cost = ConfigFile.vaultCost.doubleValue())) {
            if (ConfigFile.vaultMessagesPaymentFailed.booleanValue()) {
                player.sendMessage(ColorFormatHandler.formatComponent(LocaleHandler.vaultFail.replace("%prefix%", LocaleHandler.prefix).replace("%cost%", String.valueOf(cost))));
            }
            SoundHandler.fail(player);
            return true;
        }
        return false;
    }

    public static boolean shouldCancelPayment(Player player, Supplier<Boolean> isCommandEnabled) {
        double cost;
        if (!ConfigFile.vaultEnabled.booleanValue() || !isCommandEnabled.get().booleanValue()) {
            return false;
        }
        if (!VaultMoneyHandler.isVaultAvailable()) {
            return false;
        }
        Economy economy = Main.getEconomy();
        if (!economy.has((OfflinePlayer)player, cost = ConfigFile.vaultCost.doubleValue())) {
            if (ConfigFile.vaultMessagesPaymentFailed.booleanValue()) {
                player.sendMessage(ColorFormatHandler.formatComponent(LocaleHandler.vaultFail.replace("%prefix%", LocaleHandler.prefix).replace("%cost%", String.valueOf(cost))));
            }
            SoundHandler.fail(player);
            return true;
        }
        economy.withdrawPlayer((OfflinePlayer)player, cost);
        if (ConfigFile.vaultMessagesPaymentSuccessful.booleanValue()) {
            player.sendMessage(ColorFormatHandler.formatComponent(LocaleHandler.vaultSuccess.replace("%prefix%", LocaleHandler.prefix).replace("%cost%", String.valueOf(cost))));
        }
        return false;
    }
}

