/*
 * Decompiled with CFR 0.152.
 */
package eu.raidersheaven.rhleafdecay.handlers;

import eu.raidersheaven.rhleafdecay.configurations.ConfigFile;
import eu.raidersheaven.rhleafdecay.main.Main;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.plugin.Plugin;

public final class FoliaDecayHandler
implements Listener {
    public static final Set<String> whitelist = new HashSet<String>();
    public static final Set<String> blacklist = new HashSet<String>();
    private static final Set<Location> scheduled = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final EnumSet<BlockFace> NEIGHBORS = EnumSet.of(BlockFace.NORTH, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN});
    private volatile boolean singleLoopArmed = false;

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent event) {
        this.onRemove(event.getBlock(), ConfigFile.ticksBreak);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDecay(LeavesDecayEvent event) {
        this.onRemove(event.getBlock(), ConfigFile.ticksDecay);
    }

    private void onRemove(Block old, long delay) {
        Material type = old.getType();
        if (!(Tag.LOGS.isTagged((Keyed)type) || Tag.FENCES.isTagged((Keyed)type) || Tag.LEAVES.isTagged((Keyed)type))) {
            return;
        }
        String worldName = old.getWorld().getName().toLowerCase();
        whitelist.addAll(ConfigFile.filtersWhitelist);
        blacklist.addAll(ConfigFile.filtersBlacklist);
        if (!whitelist.isEmpty() && !whitelist.stream().map(String::toLowerCase).collect(Collectors.toSet()).contains(worldName)) {
            return;
        }
        if (!blacklist.isEmpty() && blacklist.stream().map(String::toLowerCase).collect(Collectors.toSet()).contains(worldName)) {
            return;
        }
        if (!whitelist.isEmpty() && !whitelist.contains(worldName)) {
            return;
        }
        if (blacklist.contains(worldName)) {
            return;
        }
        for (BlockFace face : NEIGHBORS) {
            Location loc;
            Leaves leaves;
            Block block = old.getRelative(face);
            if (!Tag.LEAVES.isTagged((Keyed)block.getType()) || (leaves = (Leaves)block.getBlockData()).isPersistent() || scheduled.contains(loc = FoliaDecayHandler.normalize(block.getLocation()))) continue;
            int mode = ConfigFile.mode;
            if (mode < 1) {
                mode = 1;
            }
            if (mode > 2) {
                mode = 1;
            }
            if (mode == 2) {
                if (scheduled.isEmpty() && !this.singleLoopArmed) {
                    this.singleLoopArmed = true;
                    this.armSingleLoop(delay);
                }
                scheduled.add(loc);
                continue;
            }
            scheduled.add(loc);
            FoliaDecayHandler.runRegionDelayed(loc, delay, () -> this.clusterAt(loc));
        }
    }

    private void clusterAt(Location loc) {
        if (!scheduled.remove(loc)) {
            return;
        }
        World world = loc.getWorld();
        if (world == null) {
            return;
        }
        Block block = world.getBlockAt(loc);
        Material type = block.getType();
        if (!Tag.LEAVES.isTagged((Keyed)type)) {
            return;
        }
        Leaves leaves = (Leaves)block.getBlockData();
        if (leaves.isPersistent()) {
            return;
        }
        if (leaves.getDistance() < 7) {
            return;
        }
        LeavesDecayEvent event = new LeavesDecayEvent(block);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        boolean drops = ConfigFile.featuresDrops;
        boolean particles = ConfigFile.featuresParticles;
        boolean sounds = ConfigFile.featuresSounds;
        if (sounds) {
            world.playSound(loc, Sound.BLOCK_AZALEA_LEAVES_BREAK, 0.05f, 1.2f);
        }
        if (particles) {
            world.spawnParticle(Particle.BLOCK, loc.clone().add(0.5, 0.5, 0.5), 8, 0.2, 0.2, 0.2, 0.0, (Object)type.createBlockData());
        }
        if (!drops) {
            block.setType(Material.AIR, false);
        } else {
            block.breakNaturally();
        }
    }

    private void single() {
        if (scheduled.isEmpty()) {
            this.singleLoopArmed = false;
            return;
        }
        Location next = FoliaDecayHandler.peekAny();
        if (next == null) {
            this.singleLoopArmed = false;
            return;
        }
        FoliaDecayHandler.runRegion(next, () -> this.clusterAt(next));
        if (!scheduled.isEmpty()) {
            this.armSingleLoop(Math.max(ConfigFile.ticksDecay, 1L));
        } else {
            this.singleLoopArmed = false;
        }
    }

    private static void runRegion(Location loc, Runnable task) {
        Bukkit.getRegionScheduler().execute((Plugin)Main.instance, loc, task);
    }

    private static void runRegionDelayed(Location loc, long delay, Runnable task) {
        Bukkit.getRegionScheduler().runDelayed((Plugin)Main.instance, loc, t -> task.run(), Math.max(1L, delay));
    }

    private void armSingleLoop(long delay) {
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)Main.instance, t -> this.single(), Math.max(1L, delay));
    }

    private static Location normalize(Location in) {
        World w = in.getWorld();
        return new Location(w, (double)in.getBlockX(), (double)in.getBlockY(), (double)in.getBlockZ(), 0.0f, 0.0f);
    }

    private static Location peekAny() {
        Iterator<Location> it = scheduled.iterator();
        return it.hasNext() ? it.next() : null;
    }
}

