/*
 * Decompiled with CFR 0.152.
 */
package eu.raidersheaven.rhleafdecay.handlers;

import eu.raidersheaven.rhleafdecay.configurations.ConfigFile;
import eu.raidersheaven.rhleafdecay.main.Main;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class DecayHandler
implements Listener {
    public static final Set<String> whitelist = new HashSet<String>();
    public static final Set<String> blacklist = new HashSet<String>();
    public static final Set<Block> scheduledBlocks = Collections.synchronizedSet(new HashSet());
    public static final EnumSet<BlockFace> NEIGHBORS = EnumSet.of(BlockFace.NORTH, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN});
    private final BukkitScheduler scheduler = Bukkit.getServer().getScheduler();

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent event) {
        this.onRemove(event.getBlock(), ConfigFile.ticksBreak);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDecay(LeavesDecayEvent event) {
        this.onRemove(event.getBlock(), ConfigFile.ticksDecay);
    }

    private void onRemove(Block old, long delay) {
        Material type = old.getType();
        if (!(Tag.LOGS.isTagged((Keyed)type) || Tag.FENCES.isTagged((Keyed)type) || Tag.LEAVES.isTagged((Keyed)type))) {
            return;
        }
        String worldName = old.getWorld().getName().toLowerCase();
        whitelist.addAll(ConfigFile.filtersWhitelist);
        blacklist.addAll(ConfigFile.filtersBlacklist);
        if (!whitelist.isEmpty() && !whitelist.stream().map(String::toLowerCase).collect(Collectors.toSet()).contains(worldName)) {
            return;
        }
        if (!blacklist.isEmpty() && blacklist.stream().map(String::toLowerCase).collect(Collectors.toSet()).contains(worldName)) {
            return;
        }
        if (!whitelist.isEmpty() && !whitelist.contains(worldName)) {
            return;
        }
        if (blacklist.contains(worldName)) {
            return;
        }
        for (BlockFace neighborFace : NEIGHBORS) {
            Leaves leaves;
            Block block = old.getRelative(neighborFace);
            if (!Tag.LEAVES.isTagged((Keyed)block.getType()) || (leaves = (Leaves)block.getBlockData()).isPersistent() || scheduledBlocks.contains(block)) continue;
            int mode = ConfigFile.mode;
            if (mode < 1) {
                mode = 1;
            }
            if (mode > 2) {
                mode = 1;
            }
            if (mode == 2) {
                if (scheduledBlocks.isEmpty()) {
                    this.scheduler.runTaskLater((Plugin)Main.instance, this::single, delay);
                }
                scheduledBlocks.add(block);
            } else {
                this.scheduler.runTaskLater((Plugin)Main.instance, () -> this.cluster(block), delay);
            }
            scheduledBlocks.add(block);
        }
    }

    private boolean cluster(Block block) {
        Material type = block.getType();
        World world = block.getWorld();
        Location location = block.getLocation();
        if (!scheduledBlocks.remove(block)) {
            return false;
        }
        if (!Tag.LEAVES.isTagged((Keyed)type)) {
            return false;
        }
        Leaves leaves = (Leaves)block.getBlockData();
        if (leaves.isPersistent()) {
            return false;
        }
        if (leaves.getDistance() < 7) {
            return false;
        }
        LeavesDecayEvent event = new LeavesDecayEvent(block);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean drops = ConfigFile.featuresDrops;
        boolean particles = ConfigFile.featuresParticles;
        boolean sounds = ConfigFile.featuresSounds;
        if (sounds) {
            world.playSound(location, Sound.BLOCK_AZALEA_LEAVES_BREAK, 0.05f, 1.2f);
        }
        if (particles) {
            world.spawnParticle(Particle.BLOCK, location.add(0.5, 0.5, 0.5), 8, 0.2, 0.2, 0.2, 0.0, (Object)type.createBlockData());
        }
        if (!drops) {
            block.setType(Material.AIR, false);
        } else {
            block.breakNaturally();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void single() {
        Block block;
        boolean decayed;
        ArrayList<Block> snapshot;
        if (scheduledBlocks.isEmpty()) {
            return;
        }
        Set<Block> set = scheduledBlocks;
        synchronized (set) {
            snapshot = new ArrayList<Block>(scheduledBlocks);
        }
        Iterator iterator = snapshot.iterator();
        while (iterator.hasNext() && !(decayed = this.cluster(block = (Block)iterator.next()))) {
        }
        if (!scheduledBlocks.isEmpty()) {
            long delay = Math.max(ConfigFile.ticksDecay, 1L);
            this.scheduler.runTaskLater((Plugin)Main.instance, this::single, delay);
        }
    }
}

