/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.domain.queue.services;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.serverwars.sunsetPlugin.Main;
import net.serverwars.sunsetPlugin.domain.lobby.models.Lobby;
import net.serverwars.sunsetPlugin.util.TimeKt;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/serverwars/sunsetPlugin/domain/queue/services/QueueTimerService;", "", "<init>", "()V", "tasks", "", "Ljava/util/UUID;", "Lkotlin/Pair;", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby;", "Lorg/bukkit/scheduler/BukkitTask;", "startTimer", "", "lobby", "queueUuid", "stopTimer", "formatTime", "", "seconds", "", "sunset-plugin"})
public final class QueueTimerService {
    @NotNull
    public static final QueueTimerService INSTANCE = new QueueTimerService();
    @NotNull
    private static final Map<UUID, Pair<Lobby, BukkitTask>> tasks = new ConcurrentHashMap();

    private QueueTimerService() {
    }

    public final void startTimer(@NotNull Lobby lobby2, @NotNull UUID queueUuid) {
        Intrinsics.checkNotNullParameter(lobby2, "lobby");
        Intrinsics.checkNotNullParameter(queueUuid, "queueUuid");
        if (tasks.containsKey(queueUuid)) {
            return;
        }
        long startTime = TimeKt.now();
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimer((Plugin)Main.Companion.getInst(), () -> QueueTimerService.startTimer$lambda$0(startTime, lobby2), 0L, 20L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimer(...)");
        BukkitTask task2 = bukkitTask;
        tasks.put(queueUuid, new Pair<Lobby, BukkitTask>(lobby2, task2));
    }

    @Nullable
    public final Lobby stopTimer(@NotNull UUID queueUuid) {
        Intrinsics.checkNotNullParameter(queueUuid, "queueUuid");
        BukkitTask taskLobby = tasks.remove(queueUuid);
        BukkitTask bukkitTask = taskLobby;
        if (bukkitTask != null && (bukkitTask = bukkitTask.getSecond()) != null) {
            bukkitTask.cancel();
        }
        BukkitTask bukkitTask2 = taskLobby;
        return bukkitTask2 != null ? (Lobby)bukkitTask2.getFirst() : null;
    }

    private final String formatTime(long seconds) {
        long minutes = seconds / (long)60;
        long secs = seconds % (long)60;
        String string = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, secs};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final void startTimer$lambda$0(long $startTime, Lobby $lobby) {
        long timeInQueue = (TimeKt.now() - $startTime) / (long)1000;
        Object[] objectArray = new Object[]{INSTANCE.formatTime(timeInQueue)};
        $lobby.sendActionBarMessage("queue.time_in_queue.action_bar", objectArray);
    }
}

