/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.domain.lobby.services;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.CreateLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.DeleteLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.SendLobbyToMatchException;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.UpdateLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.models.Lobby;
import net.serverwars.sunsetPlugin.domain.lobby.models.LobbyAccessType;
import net.serverwars.sunsetPlugin.domain.lobby.models.LobbyInvitation;
import net.serverwars.sunsetPlugin.domain.lobby.models.LobbySettings;
import net.serverwars.sunsetPlugin.domain.lobby.models.Participant;
import net.serverwars.sunsetPlugin.domain.queue.exceptions.LeaveQueueException;
import net.serverwars.sunsetPlugin.domain.queue.services.QueueService;
import net.serverwars.sunsetPlugin.util.PluginCoroutinesKt;
import net.serverwars.sunsetPlugin.util.SoundKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0013J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001fJ\u0016\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001aJ\u000e\u0010%\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u001aJ\u000e\u0010&\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u001aJ\u000e\u0010'\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u001aJ\u0006\u0010(\u001a\u00020\u0005J\b\u0010)\u001a\u0004\u0018\u00010\u0005J\u0006\u0010*\u001a\u00020\u001cJ\u0006\u0010+\u001a\u00020,R/\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lnet/serverwars/sunsetPlugin/domain/lobby/services/LobbyService;", "", "<init>", "()V", "<set-?>", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby;", "lobby", "getLobby", "()Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby;", "setLobby", "(Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby;)V", "lobby$delegate", "Lkotlin/properties/ReadWriteProperty;", "createLobby", "size", "", "accessType", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/LobbyAccessType;", "gameType", "", "updateLobbySize", "value", "updateLobbyAccessType", "updateLobbyGameType", "playerJoinLobby", "playerUuid", "Ljava/util/UUID;", "force", "", "participantLeaveLobby", "participant", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/Participant;", "kickParticipantFromLobby", "kickedParticipant", "createLobbyInvitation", "inviterParticipant", "invitedPlayerUuid", "revokeLobbyInvitation", "acceptLobbyInvitation", "declineLobbyInvitation", "deleteLobby", "getLobbyCopy", "lobbyExists", "sendLobbyToMatch", "", "sunset-plugin"})
@SourceDebugExtension(value={"SMAP\nLobbyService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LobbyService.kt\nnet/serverwars/sunsetPlugin/domain/lobby/services/LobbyService\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,253:1\n33#2,3:254\n*S KotlinDebug\n*F\n+ 1 LobbyService.kt\nnet/serverwars/sunsetPlugin/domain/lobby/services/LobbyService\n*L\n-1#1:254,3\n*E\n"})
public final class LobbyService {
    @NotNull
    public static final LobbyService INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ReadWriteProperty lobby$delegate;

    private LobbyService() {
    }

    private final Lobby getLobby() {
        return (Lobby)lobby$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setLobby(Lobby lobby2) {
        lobby$delegate.setValue(this, $$delegatedProperties[0], lobby2);
    }

    @NotNull
    public final Lobby createLobby(int size, @NotNull LobbyAccessType accessType, @NotNull String gameType) {
        Intrinsics.checkNotNullParameter((Object)accessType, "accessType");
        Intrinsics.checkNotNullParameter(gameType, "gameType");
        if (this.getLobby() != null) {
            throw new CreateLobbyException("command.lobby.create.error.too_many_existing_lobbies", new Object[0]);
        }
        if (!Lobby.Companion.getALLOWED_LOBBY_SIZES().contains(size)) {
            Object[] objectArray = new Object[]{size};
            throw new CreateLobbyException("command.lobby.create.error.invalid_size", objectArray);
        }
        LobbySettings newLobbySettings = LobbySettings.Companion.create(size, accessType, gameType);
        Lobby newLobby = Lobby.Companion.create(newLobbySettings);
        this.setLobby(newLobby);
        return newLobby;
    }

    @NotNull
    public final Lobby updateLobbySize(int value) {
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.set.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        if (!Lobby.Companion.getALLOWED_LOBBY_SIZES().contains(value)) {
            Object[] objectArray = new Object[]{value};
            throw new UpdateLobbyException("command.lobby.error.invalid_size", objectArray);
        }
        if (lobbyValue.getLobbySettings().getSize() == value) {
            throw new UpdateLobbyException("command.lobby.set.error.nothing_changed", new Object[0]);
        }
        SoundKt.playSetLobbySound(lobbyValue);
        LobbySettings updatedLobbySettings = lobbyValue.getLobbySettings().withSize(value);
        Lobby updatedLobby = lobbyValue.withLobbySettings(updatedLobbySettings);
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby updateLobbyAccessType(@NotNull LobbyAccessType value) {
        Intrinsics.checkNotNullParameter((Object)value, "value");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.set.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        if (lobbyValue.getLobbySettings().getAccessType() == value) {
            throw new UpdateLobbyException("command.lobby.set.error.nothing_changed", new Object[0]);
        }
        SoundKt.playSetLobbySound(lobbyValue);
        LobbySettings updatedLobbySettings = lobbyValue.getLobbySettings().withAccessType(value);
        Lobby updatedLobby = lobbyValue.withLobbySettings(updatedLobbySettings).withoutInvites();
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby updateLobbyGameType(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.set.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        if (Intrinsics.areEqual(lobbyValue.getLobbySettings().getGameType(), value)) {
            throw new UpdateLobbyException("command.lobby.set.error.nothing_changed", new Object[0]);
        }
        SoundKt.playSetLobbySound(lobbyValue);
        LobbySettings updatedLobbySettings = lobbyValue.getLobbySettings().withGameType(value);
        Lobby updatedLobby = lobbyValue.withLobbySettings(updatedLobbySettings);
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby playerJoinLobby(@NotNull UUID playerUuid, boolean force) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.join.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        Participant participant = Participant.Companion.create(playerUuid);
        if (lobbyValue.hasParticipant(participant)) {
            throw new UpdateLobbyException("command.lobby.join.error.already_in_lobby", new Object[0]);
        }
        if (lobbyValue.getParticipantAmount() >= lobbyValue.getLobbySettings().getSize()) {
            throw new UpdateLobbyException("command.lobby.join.error.lobby_full", new Object[0]);
        }
        if (!force && lobbyValue.getLobbySettings().getAccessType() == LobbyAccessType.INVITE_ONLY) {
            return this.acceptLobbyInvitation(playerUuid);
        }
        Lobby updatedLobby = lobbyValue.withParticipant(participant);
        this.setLobby(updatedLobby);
        SoundKt.playPlayerJoinsLobbySound(updatedLobby);
        return updatedLobby;
    }

    public static /* synthetic */ Lobby playerJoinLobby$default(LobbyService lobbyService, UUID uUID, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lobbyService.playerJoinLobby(uUID, bl);
    }

    @NotNull
    public final Lobby participantLeaveLobby(@NotNull Participant participant) {
        Intrinsics.checkNotNullParameter(participant, "participant");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.leave.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        if (!lobbyValue.hasParticipant(participant)) {
            throw new UpdateLobbyException("command.lobby.leave.error.not_in_lobby", new Object[0]);
        }
        SoundKt.playPlayerLeavesLobbySound(lobbyValue);
        Lobby updatedLobby = lobbyValue.withoutParticipant(participant);
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby kickParticipantFromLobby(@NotNull Participant kickedParticipant) {
        Intrinsics.checkNotNullParameter(kickedParticipant, "kickedParticipant");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.kick.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        if (!lobbyValue.hasParticipant(kickedParticipant)) {
            throw new UpdateLobbyException("command.lobby.kick.error.not_in_lobby", new Object[0]);
        }
        SoundKt.playPlayerKickedFromLobbySound(lobbyValue);
        Lobby updatedLobby = lobbyValue.withoutParticipant(kickedParticipant);
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby createLobbyInvitation(@NotNull Participant inviterParticipant, @NotNull UUID invitedPlayerUuid) {
        Intrinsics.checkNotNullParameter(inviterParticipant, "inviterParticipant");
        Intrinsics.checkNotNullParameter(invitedPlayerUuid, "invitedPlayerUuid");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.invite.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        if (!lobbyValue.hasParticipant(inviterParticipant)) {
            throw new UpdateLobbyException("command.lobby.invite.error.inviter_not_in_lobby", new Object[0]);
        }
        if (Intrinsics.areEqual(inviterParticipant, invitedPlayerUuid)) {
            throw new UpdateLobbyException("command.lobby.invite.error.self_invite", new Object[0]);
        }
        Participant invitedParticipant = Participant.Companion.create(invitedPlayerUuid);
        if (lobbyValue.hasParticipant(invitedParticipant)) {
            throw new UpdateLobbyException("command.lobby.invite.error.invitee_already_in_lobby", new Object[0]);
        }
        if (lobbyValue.getInvitationForPlayer(invitedPlayerUuid) != null) {
            throw new UpdateLobbyException("command.lobby.invite.error.invitee_already_invited", new Object[0]);
        }
        if (lobbyValue.getParticipantAmount() >= lobbyValue.getLobbySettings().getSize()) {
            throw new UpdateLobbyException("command.lobby.invite.error.lobby_full", new Object[0]);
        }
        SoundKt.playCreateInviteSound(lobbyValue);
        LobbyInvitation newInvitation = LobbyInvitation.Companion.create(invitedPlayerUuid);
        Lobby updatedLobby = lobbyValue.withInvite(newInvitation);
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby revokeLobbyInvitation(@NotNull UUID invitedPlayerUuid) {
        Intrinsics.checkNotNullParameter(invitedPlayerUuid, "invitedPlayerUuid");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.uninvite.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        Participant invitedParticipant = Participant.Companion.create(invitedPlayerUuid);
        if (lobbyValue.hasParticipant(invitedParticipant)) {
            throw new UpdateLobbyException("command.lobby.uninvite.error.uninvitee_already_in_lobby", new Object[0]);
        }
        LobbyInvitation lobbyInvitation = lobbyValue.getInvitationForPlayer(invitedPlayerUuid);
        if (lobbyInvitation == null) {
            throw new UpdateLobbyException("command.lobby.uninvite.error.uninvitee_not_invited", new Object[0]);
        }
        LobbyInvitation invitation = lobbyInvitation;
        SoundKt.playRevokeInviteSound(lobbyValue);
        Lobby updatedLobby = lobbyValue.withoutInvite(invitation);
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby acceptLobbyInvitation(@NotNull UUID invitedPlayerUuid) {
        Intrinsics.checkNotNullParameter(invitedPlayerUuid, "invitedPlayerUuid");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.invite.accept.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        if (lobbyValue.getParticipantAmount() >= lobbyValue.getLobbySettings().getSize()) {
            throw new UpdateLobbyException("command.lobby.invite.accept.error.lobby_full", new Object[0]);
        }
        Participant invitedParticipant = Participant.Companion.create(invitedPlayerUuid);
        if (lobbyValue.hasParticipant(invitedParticipant)) {
            throw new UpdateLobbyException("command.lobby.invite.accept.error.already_joined", new Object[0]);
        }
        LobbyInvitation lobbyInvitation = lobbyValue.getInvitationForPlayer(invitedPlayerUuid);
        if (lobbyInvitation == null) {
            throw new UpdateLobbyException("command.lobby.invite.accept.error.not_invited", new Object[0]);
        }
        LobbyInvitation invitation = lobbyInvitation;
        Lobby updatedLobby = lobbyValue.withoutInvite(invitation).withParticipant(invitedParticipant);
        this.setLobby(updatedLobby);
        SoundKt.playPlayerJoinsLobbySound(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby declineLobbyInvitation(@NotNull UUID invitedPlayerUuid) {
        Intrinsics.checkNotNullParameter(invitedPlayerUuid, "invitedPlayerUuid");
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new UpdateLobbyException("command.lobby.invite.decline.error.no_lobby", new Object[0]);
        }
        Lobby lobbyValue = lobby2;
        LobbyInvitation lobbyInvitation = lobbyValue.getInvitationForPlayer(invitedPlayerUuid);
        if (lobbyInvitation == null) {
            throw new UpdateLobbyException("command.lobby.invite.decline.error.not_invited", new Object[0]);
        }
        LobbyInvitation invitation = lobbyInvitation;
        Participant invitedParticipant = Participant.Companion.create(invitedPlayerUuid);
        if (lobbyValue.hasParticipant(invitedParticipant)) {
            throw new UpdateLobbyException("command.lobby.invite.decline.error.already_joined", new Object[0]);
        }
        Lobby updatedLobby = lobbyValue.withoutInvite(invitation);
        this.setLobby(updatedLobby);
        return updatedLobby;
    }

    @NotNull
    public final Lobby deleteLobby() {
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new DeleteLobbyException("command.lobby.delete.error.no_lobby", new Object[0]);
        }
        Lobby deletedLobby = lobby2;
        this.setLobby(null);
        return deletedLobby;
    }

    @Nullable
    public final Lobby getLobbyCopy() {
        Lobby lobby2 = this.getLobby();
        return lobby2 != null ? Lobby.copy$default(lobby2, null, null, 0L, null, null, 31, null) : null;
    }

    public final boolean lobbyExists() {
        return this.getLobby() != null;
    }

    public final void sendLobbyToMatch() {
        Lobby lobby2 = this.getLobby();
        if (lobby2 == null) {
            throw new SendLobbyToMatchException("Could not send Lobby to match, no lobby found.");
        }
        Lobby lobbyValue = lobby2;
        lobbyValue.sendParticipantsToMatch();
    }

    static {
        Object object = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(LobbyService.class, "lobby", "getLobby()Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby;", 0))};
        $$delegatedProperties = object;
        INSTANCE = new LobbyService();
        object = Delegates.INSTANCE;
        Object initialValue$iv = null;
        boolean $i$f$observable = false;
        lobby$delegate = new ObservableProperty<Lobby>(initialValue$iv){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(KProperty property2, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter(property2, "property");
                Lobby cfr_ignored_0 = (Lobby)newValue;
                Lobby cfr_ignored_1 = (Lobby)oldValue;
                boolean bl = false;
                PluginCoroutinesKt.runAsync((Function1)new Function1<Continuation<? super Unit>, Object>(null){
                    int label;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                this.label = 1;
                                Object object2 = QueueService.INSTANCE.leaveQueue(this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object2;
                                try {
                                    ResultKt.throwOnFailure($result);
                                    object2 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (LeaveQueueException leaveQueueException) {
                                    // empty catch block
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
        };
    }
}

