/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.domain.lobby.models;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.CreateParticipantException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lnet/serverwars/sunsetPlugin/domain/lobby/models/Participant;", "", "playerUuid", "Ljava/util/UUID;", "name", "", "<init>", "(Ljava/util/UUID;Ljava/lang/String;)V", "getPlayerUuid", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "sunset-plugin"})
public final class Participant {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID playerUuid;
    @NotNull
    private final String name;

    public Participant(@NotNull UUID playerUuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(name, "name");
        this.playerUuid = playerUuid;
        this.name = name;
    }

    @NotNull
    public final UUID getPlayerUuid() {
        return this.playerUuid;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final UUID component1() {
        return this.playerUuid;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Participant copy(@NotNull UUID playerUuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(name, "name");
        return new Participant(playerUuid, name);
    }

    public static /* synthetic */ Participant copy$default(Participant participant, UUID uUID, String string, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = participant.playerUuid;
        }
        if ((n & 2) != 0) {
            string = participant.name;
        }
        return participant.copy(uUID, string);
    }

    @NotNull
    public String toString() {
        return "Participant(playerUuid=" + this.playerUuid + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result2 = this.playerUuid.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Participant)) {
            return false;
        }
        Participant participant = (Participant)other;
        if (!Intrinsics.areEqual(this.playerUuid, participant.playerUuid)) {
            return false;
        }
        return Intrinsics.areEqual(this.name, participant.name);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/serverwars/sunsetPlugin/domain/lobby/models/Participant$Companion;", "", "<init>", "()V", "create", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/Participant;", "playerUuid", "Ljava/util/UUID;", "sunset-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Participant create(@NotNull UUID playerUuid) {
            Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUuid);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            OfflinePlayer player = offlinePlayer;
            if (player.hasPlayedBefore()) {
                String string = player.getName();
                Intrinsics.checkNotNull(string);
                return new Participant(playerUuid, string);
            }
            throw new CreateParticipantException("Player " + playerUuid + " not found.");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

