/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.domain.lobby.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.serverwars.sunsetPlugin.config.Config;
import net.serverwars.sunsetPlugin.domain.lobby.models.LobbyInvitation;
import net.serverwars.sunsetPlugin.domain.lobby.models.LobbySettings;
import net.serverwars.sunsetPlugin.domain.lobby.models.Participant;
import net.serverwars.sunsetPlugin.domain.lobby.services.LobbyService;
import net.serverwars.sunsetPlugin.domain.match.services.MatchDataAccess;
import net.serverwars.sunsetPlugin.domain.server.services.ServerService;
import net.serverwars.sunsetPlugin.translations.MessageKt;
import net.serverwars.sunsetPlugin.util.PluginCoroutinesKt;
import net.serverwars.sunsetPlugin.util.SoundKt;
import net.serverwars.sunsetPlugin.util.TimeKt;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u0000 >2\u00020\u0001:\u0001>B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\fJ\u0006\u0010\u001e\u001a\u00020\u0000J'\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010$\"\u00020\u0001\u00a2\u0006\u0002\u0010%J/\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010$\"\u00020\u0001\u00a2\u0006\u0002\u0010(J5\u0010&\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010$\"\u00020\u0001\u00a2\u0006\u0002\u0010+J'\u0010,\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010$\"\u00020\u0001\u00a2\u0006\u0002\u0010%J\u0016\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020 J\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u0002022\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0002J\t\u00104\u001a\u00020\u0003H\u00c2\u0003J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J\t\u00106\u001a\u00020\bH\u00c2\u0003J\t\u00107\u001a\u00020\nH\u00c2\u0003J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u00c2\u0003JG\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u00c6\u0001J\u0013\u0010:\u001a\u00020\u00102\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\u0013H\u00d6\u0001J\t\u0010=\u001a\u00020\"H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby;", "", "lobbyUuid", "Ljava/util/UUID;", "participants", "", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/Participant;", "createdAtTimestamp", "", "lobbySettings", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/LobbySettings;", "invitations", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/LobbyInvitation;", "<init>", "(Ljava/util/UUID;Ljava/util/List;JLnet/serverwars/sunsetPlugin/domain/lobby/models/LobbySettings;Ljava/util/List;)V", "hasParticipant", "", "participant", "getParticipantAmount", "", "getParticipants", "getLobbySettings", "getInvitationForPlayer", "playerUuid", "withLobbySettings", "withParticipant", "withoutParticipant", "withInvite", "invite", "withoutInvite", "withoutInvites", "sendMessage", "", "translationKey", "", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "sendMessageExcluding", "uuidToExclude", "(Ljava/util/UUID;Ljava/lang/String;[Ljava/lang/Object;)V", "uuidsToExclude", "", "(Ljava/util/Collection;Ljava/lang/String;[Ljava/lang/Object;)V", "sendActionBarMessage", "matchFound", "matchUuid", "(Ljava/util/UUID;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendParticipantsToMatch", "getLobbyAudience", "Lnet/kyori/adventure/audience/Audience;", "getLobbyAudienceWithout", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "Companion", "sunset-plugin"})
@SourceDebugExtension(value={"SMAP\nLobby.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lobby.kt\nnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1563#2:124\n1634#2,3:125\n1617#2,9:129\n1869#2:138\n1870#2:140\n1626#2:141\n827#2:142\n855#2,2:143\n1617#2,9:145\n1869#2:154\n1870#2:156\n1626#2:157\n1869#2,2:158\n1#3:128\n1#3:139\n1#3:155\n*S KotlinDebug\n*F\n+ 1 Lobby.kt\nnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby\n*L\n38#1:124\n38#1:125,3\n115#1:129,9\n115#1:138\n115#1:140\n115#1:141\n120#1:142\n120#1:143,2\n121#1:145,9\n121#1:154\n121#1:156\n121#1:157\n105#1:158,2\n115#1:139\n121#1:155\n*E\n"})
public final class Lobby {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID lobbyUuid;
    @NotNull
    private final List<Participant> participants;
    private final long createdAtTimestamp;
    @NotNull
    private final LobbySettings lobbySettings;
    @NotNull
    private final List<LobbyInvitation> invitations;
    @NotNull
    private static final IntRange ALLOWED_LOBBY_SIZES = new IntRange(1, 10);

    public Lobby(@NotNull UUID lobbyUuid, @NotNull List<Participant> participants, long createdAtTimestamp, @NotNull LobbySettings lobbySettings, @NotNull List<LobbyInvitation> invitations) {
        Intrinsics.checkNotNullParameter(lobbyUuid, "lobbyUuid");
        Intrinsics.checkNotNullParameter(participants, "participants");
        Intrinsics.checkNotNullParameter(lobbySettings, "lobbySettings");
        Intrinsics.checkNotNullParameter(invitations, "invitations");
        this.lobbyUuid = lobbyUuid;
        this.participants = participants;
        this.createdAtTimestamp = createdAtTimestamp;
        this.lobbySettings = lobbySettings;
        this.invitations = invitations;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasParticipant(@NotNull Participant participant) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participant, "participant");
        Iterable $this$map$iv = this.participants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Participant participant2 = (Participant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPlayerUuid());
        }
        return ((List)destination$iv$iv).contains(participant.getPlayerUuid());
    }

    public final int getParticipantAmount() {
        return this.participants.size();
    }

    @NotNull
    public final List<Participant> getParticipants() {
        return this.participants;
    }

    @NotNull
    public final LobbySettings getLobbySettings() {
        return this.lobbySettings;
    }

    @Nullable
    public final LobbyInvitation getInvitationForPlayer(@NotNull UUID playerUuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
            Iterable iterable = this.invitations;
            for (Object t : iterable) {
                LobbyInvitation it = (LobbyInvitation)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getInviteeUuid(), playerUuid)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Lobby withLobbySettings(@NotNull LobbySettings lobbySettings) {
        Intrinsics.checkNotNullParameter(lobbySettings, "lobbySettings");
        return Lobby.copy$default(this, null, null, 0L, lobbySettings, null, 23, null);
    }

    @NotNull
    public final Lobby withParticipant(@NotNull Participant participant) {
        Intrinsics.checkNotNullParameter(participant, "participant");
        return Lobby.copy$default(this, null, CollectionsKt.plus((Collection)this.participants, participant), 0L, null, null, 29, null);
    }

    @NotNull
    public final Lobby withoutParticipant(@NotNull Participant participant) {
        Intrinsics.checkNotNullParameter(participant, "participant");
        return Lobby.copy$default(this, null, CollectionsKt.minus((Iterable)this.participants, participant), 0L, null, null, 29, null);
    }

    @NotNull
    public final Lobby withInvite(@NotNull LobbyInvitation invite) {
        Intrinsics.checkNotNullParameter(invite, "invite");
        return Lobby.copy$default(this, null, null, 0L, null, CollectionsKt.plus((Collection)this.invitations, invite), 15, null);
    }

    @NotNull
    public final Lobby withoutInvite(@NotNull LobbyInvitation invite) {
        Intrinsics.checkNotNullParameter(invite, "invite");
        return Lobby.copy$default(this, null, null, 0L, null, CollectionsKt.minus((Iterable)this.invitations, invite), 15, null);
    }

    @NotNull
    public final Lobby withoutInvites() {
        return Lobby.copy$default(this, null, null, 0L, null, CollectionsKt.emptyList(), 15, null);
    }

    public final void sendMessage(@NotNull String translationKey, Object ... args) {
        Intrinsics.checkNotNullParameter(translationKey, "translationKey");
        Intrinsics.checkNotNullParameter(args, "args");
        MessageKt.sendTranslatedMessage(this.getLobbyAudience(), translationKey, Arrays.copyOf(args, args.length));
    }

    public final void sendMessageExcluding(@NotNull UUID uuidToExclude, @NotNull String translationKey, Object ... args) {
        Intrinsics.checkNotNullParameter(uuidToExclude, "uuidToExclude");
        Intrinsics.checkNotNullParameter(translationKey, "translationKey");
        Intrinsics.checkNotNullParameter(args, "args");
        this.sendMessageExcluding((Collection<UUID>)CollectionsKt.listOf(uuidToExclude), translationKey, Arrays.copyOf(args, args.length));
    }

    public final void sendMessageExcluding(@NotNull Collection<UUID> uuidsToExclude, @NotNull String translationKey, Object ... args) {
        Intrinsics.checkNotNullParameter(uuidsToExclude, "uuidsToExclude");
        Intrinsics.checkNotNullParameter(translationKey, "translationKey");
        Intrinsics.checkNotNullParameter(args, "args");
        MessageKt.sendTranslatedMessage(this.getLobbyAudienceWithout(uuidsToExclude), translationKey, Arrays.copyOf(args, args.length));
    }

    public final void sendActionBarMessage(@NotNull String translationKey, Object ... args) {
        Intrinsics.checkNotNullParameter(translationKey, "translationKey");
        Intrinsics.checkNotNullParameter(args, "args");
        MessageKt.sendTranslatedActionBarMessage(this.getLobbyAudience(), translationKey, Arrays.copyOf(args, args.length));
    }

    @Nullable
    public final Object matchFound(@NotNull UUID matchUuid, @NotNull Continuation<? super Unit> $completion) {
        this.sendActionBarMessage("queue.match_found.action_bar", new Object[0]);
        this.sendMessage("queue.success.match_found", new Object[0]);
        SoundKt.playMatchFoundSound(this);
        Object object = MatchDataAccess.INSTANCE.listenToMatchStatusEvents(matchUuid, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void sendParticipantsToMatch() {
        PluginCoroutinesKt.runSync(() -> Lobby.sendParticipantsToMatch$lambda$0(this));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Audience getLobbyAudience() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.participants;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Participant it = (Participant)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)it.getPlayerUuid()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        ForwardingAudience forwardingAudience = Audience.audience((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue(forwardingAudience, "audience(...)");
        return forwardingAudience;
    }

    /*
     * WARNING - void declaration
     */
    private final Audience getLobbyAudienceWithout(Collection<UUID> uuidsToExclude) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.participants;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Participant it = (Participant)element$iv$iv;
            boolean bl = false;
            if (uuidsToExclude.contains(it.getPlayerUuid())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Participant it = (Participant)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)it.getPlayerUuid()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        ForwardingAudience forwardingAudience = Audience.audience((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue(forwardingAudience, "audience(...)");
        return forwardingAudience;
    }

    private final UUID component1() {
        return this.lobbyUuid;
    }

    private final List<Participant> component2() {
        return this.participants;
    }

    private final long component3() {
        return this.createdAtTimestamp;
    }

    private final LobbySettings component4() {
        return this.lobbySettings;
    }

    private final List<LobbyInvitation> component5() {
        return this.invitations;
    }

    @NotNull
    public final Lobby copy(@NotNull UUID lobbyUuid, @NotNull List<Participant> participants, long createdAtTimestamp, @NotNull LobbySettings lobbySettings, @NotNull List<LobbyInvitation> invitations) {
        Intrinsics.checkNotNullParameter(lobbyUuid, "lobbyUuid");
        Intrinsics.checkNotNullParameter(participants, "participants");
        Intrinsics.checkNotNullParameter(lobbySettings, "lobbySettings");
        Intrinsics.checkNotNullParameter(invitations, "invitations");
        return new Lobby(lobbyUuid, participants, createdAtTimestamp, lobbySettings, invitations);
    }

    public static /* synthetic */ Lobby copy$default(Lobby lobby2, UUID uUID, List list, long l, LobbySettings lobbySettings, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = lobby2.lobbyUuid;
        }
        if ((n & 2) != 0) {
            list = lobby2.participants;
        }
        if ((n & 4) != 0) {
            l = lobby2.createdAtTimestamp;
        }
        if ((n & 8) != 0) {
            lobbySettings = lobby2.lobbySettings;
        }
        if ((n & 0x10) != 0) {
            list2 = lobby2.invitations;
        }
        return lobby2.copy(uUID, list, l, lobbySettings, list2);
    }

    @NotNull
    public String toString() {
        return "Lobby(lobbyUuid=" + this.lobbyUuid + ", participants=" + this.participants + ", createdAtTimestamp=" + this.createdAtTimestamp + ", lobbySettings=" + this.lobbySettings + ", invitations=" + this.invitations + ")";
    }

    public int hashCode() {
        int result2 = this.lobbyUuid.hashCode();
        result2 = result2 * 31 + ((Object)this.participants).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.createdAtTimestamp);
        result2 = result2 * 31 + this.lobbySettings.hashCode();
        result2 = result2 * 31 + ((Object)this.invitations).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Lobby)) {
            return false;
        }
        Lobby lobby2 = (Lobby)other;
        if (!Intrinsics.areEqual(this.lobbyUuid, lobby2.lobbyUuid)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.participants, lobby2.participants)) {
            return false;
        }
        if (this.createdAtTimestamp != lobby2.createdAtTimestamp) {
            return false;
        }
        if (!Intrinsics.areEqual(this.lobbySettings, lobby2.lobbySettings)) {
            return false;
        }
        return Intrinsics.areEqual(this.invitations, lobby2.invitations);
    }

    private static final Unit sendParticipantsToMatch$lambda$0(Lobby this$0) {
        String serverSlug = ServerService.INSTANCE.getServerSlug();
        Object[] objectArray = new Object[]{serverSlug};
        this$0.sendMessage("queue.success.match_ready", objectArray);
        boolean shouldAutoTransferPlayers = Config.INSTANCE.shouldTransferOnMatchReady();
        if (shouldAutoTransferPlayers) {
            Iterable $this$forEach$iv = this$0.participants;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Participant participant = (Participant)element$iv;
                boolean bl = false;
                String name = participant.component2();
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "transfer " + serverSlug + "." + Config.INSTANCE.getServerwarsMinecraftServerIP() + " 25565 " + name);
            }
        }
        LobbyService.INSTANCE.deleteLobby();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby$Companion;", "", "<init>", "()V", "ALLOWED_LOBBY_SIZES", "Lkotlin/ranges/IntRange;", "getALLOWED_LOBBY_SIZES", "()Lkotlin/ranges/IntRange;", "create", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/Lobby;", "lobbySettings", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/LobbySettings;", "sunset-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange getALLOWED_LOBBY_SIZES() {
            return ALLOWED_LOBBY_SIZES;
        }

        @NotNull
        public final Lobby create(@NotNull LobbySettings lobbySettings) {
            Intrinsics.checkNotNullParameter(lobbySettings, "lobbySettings");
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
            return new Lobby(uUID, CollectionsKt.emptyList(), TimeKt.now(), lobbySettings, CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

