/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.config;

import java.io.InputStream;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import net.serverwars.sunsetPlugin.Main;
import net.serverwars.sunsetPlugin.config.exceptions.ConfigInvalidValueException;
import net.serverwars.sunsetPlugin.config.exceptions.ConfigKeyNotFoundException;
import net.serverwars.sunsetPlugin.translations.SupportedLocale;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/serverwars/sunsetPlugin/config/Config;", "", "<init>", "()V", "props", "Ljava/util/Properties;", "getProps", "()Ljava/util/Properties;", "props$delegate", "Lkotlin/Lazy;", "getApiBaseUrl", "", "getServerwarsMinecraftServerIP", "getLocale", "Lnet/serverwars/sunsetPlugin/translations/SupportedLocale;", "getServerSecret", "shouldTransferOnMatchReady", "", "sunset-plugin"})
public final class Config {
    @NotNull
    public static final Config INSTANCE = new Config();
    @NotNull
    private static final Lazy props$delegate = LazyKt.lazy(Config::props_delegate$lambda$0);

    private Config() {
    }

    private final Properties getProps() {
        Lazy lazy = props$delegate;
        return (Properties)lazy.getValue();
    }

    @NotNull
    public final String getApiBaseUrl() {
        Object object = this.getProps().get("backend.url");
        if (object == null) {
            throw new IllegalStateException("backend.url not set in properties".toString());
        }
        Object backendUrl = object;
        return backendUrl + "/sunset/v1";
    }

    @NotNull
    public final String getServerwarsMinecraftServerIP() {
        Object object = this.getProps().get("serverwars.minecraft.server.ip");
        if (object == null) {
            throw new IllegalStateException("minecraft.server.ip not set in properties".toString());
        }
        Object ip = object;
        return ip.toString();
    }

    @NotNull
    public final SupportedLocale getLocale() {
        String string = Main.Companion.getInst().getConfig().getString("locale");
        if (string == null) {
            throw new ConfigKeyNotFoundException("Could not find key 'locale' from plugin config.");
        }
        String value = string;
        SupportedLocale supportedLocale = SupportedLocale.Companion.fromValue(value);
        if (supportedLocale == null) {
            throw new ConfigInvalidValueException("Key 'locale' has an invalid value in the plugin config.");
        }
        return supportedLocale;
    }

    @NotNull
    public final String getServerSecret() {
        String string = Main.Companion.getInst().getConfig().getString("server_secret");
        if (string == null) {
            throw new ConfigKeyNotFoundException("Could not find key 'server_secret' in plugin config.");
        }
        return string;
    }

    public final boolean shouldTransferOnMatchReady() {
        return Main.Companion.getInst().getConfig().getBoolean("transfer_on_match_ready", true);
    }

    private static final Properties props_delegate$lambda$0() {
        Properties properties;
        InputStream inputStream = INSTANCE.getClass().getResourceAsStream("/plugin.properties");
        if (inputStream == null) {
            throw new IllegalStateException("plugin.properties not found in resources".toString());
        }
        InputStream stream = inputStream;
        Properties $this$props_delegate_u24lambda_u240_u240 = properties = new Properties();
        boolean bl = false;
        $this$props_delegate_u24lambda_u240_u240.load(stream);
        return properties;
    }
}

