/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.commands.lobby;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.audience.Audience;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.UpdateLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.models.Lobby;
import net.serverwars.sunsetPlugin.domain.lobby.models.Participant;
import net.serverwars.sunsetPlugin.domain.lobby.services.LobbyService;
import net.serverwars.sunsetPlugin.translations.MessageKt;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lnet/serverwars/sunsetPlugin/commands/lobby/CommandLobbyLeave;", "", "<init>", "()V", "self", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "run", "leaver", "Lorg/bukkit/entity/Player;", "sunset-plugin"})
public final class CommandLobbyLeave {
    @NotNull
    public static final CommandLobbyLeave INSTANCE = new CommandLobbyLeave();

    private CommandLobbyLeave() {
    }

    public final int self(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender leaver = commandSender;
        if (!(leaver instanceof Player)) {
            CommandSender commandSender2 = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender2, "getSender(...)");
            MessageKt.sendTranslatedMessage((Audience)commandSender2, "command.lobby.leave.self.error.not_a_player", new Object[0]);
            return 0;
        }
        return this.run((Player)leaver);
    }

    private final int run(Player leaver) {
        try {
            UUID uUID = leaver.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            String string = leaver.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Lobby lobby2 = LobbyService.INSTANCE.participantLeaveLobby(new Participant(uUID, string));
            MessageKt.sendTranslatedMessage((Audience)leaver, "command.lobby.leave.success", new Object[0]);
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue(leaver.getName(), "getName(...)");
            objectArray[1] = lobby2.getParticipantAmount();
            objectArray[2] = lobby2.getLobbySettings().getSize();
            lobby2.sendMessage("command.lobby.leave.success.notify_lobby", objectArray);
            return 1;
        }
        catch (UpdateLobbyException error) {
            Audience audience = (Audience)leaver;
            String string = error.getKey();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(leaver.getName(), "getName(...)");
            MessageKt.sendTranslatedMessage(audience, string, objectArray);
            return 0;
        }
    }
}

