/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.commands.lobby;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.audience.Audience;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.UpdateLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.models.Lobby;
import net.serverwars.sunsetPlugin.domain.lobby.models.Participant;
import net.serverwars.sunsetPlugin.domain.lobby.services.LobbyService;
import net.serverwars.sunsetPlugin.translations.MessageKt;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lnet/serverwars/sunsetPlugin/commands/lobby/CommandLobbyKick;", "", "<init>", "()V", "run", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "kicked", "Lorg/bukkit/entity/Player;", "sunset-plugin"})
public final class CommandLobbyKick {
    @NotNull
    public static final CommandLobbyKick INSTANCE = new CommandLobbyKick();

    private CommandLobbyKick() {
    }

    public final int run(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull Player kicked) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(kicked, "kicked");
        try {
            UUID uUID = kicked.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            String string = kicked.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Lobby lobby2 = LobbyService.INSTANCE.kickParticipantFromLobby(new Participant(uUID, string));
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            Audience audience = (Audience)commandSender;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(kicked.getName(), "getName(...)");
            MessageKt.sendTranslatedMessage(audience, "command.lobby.kick.success", objectArray);
            objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue(kicked.getName(), "getName(...)");
            objectArray[1] = lobby2.getParticipantAmount();
            objectArray[2] = lobby2.getLobbySettings().getSize();
            lobby2.sendMessage("command.lobby.kick.success.notify_lobby", objectArray);
            MessageKt.sendTranslatedMessage((Audience)kicked, "command.lobby.kick.success.notify_kickee", new Object[0]);
            return 1;
        }
        catch (UpdateLobbyException error) {
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            Audience audience = (Audience)commandSender;
            String string = error.getKey();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(kicked.getName(), "getName(...)");
            MessageKt.sendTranslatedMessage(audience, string, objectArray);
            return 0;
        }
    }
}

