/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.commands.lobby;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.audience.Audience;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.UpdateLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.models.Lobby;
import net.serverwars.sunsetPlugin.domain.lobby.models.Participant;
import net.serverwars.sunsetPlugin.domain.lobby.services.LobbyService;
import net.serverwars.sunsetPlugin.translations.MessageKt;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lnet/serverwars/sunsetPlugin/commands/lobby/CommandLobbyInvite;", "", "<init>", "()V", "run", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "invitee", "Lorg/bukkit/entity/Player;", "sunset-plugin"})
public final class CommandLobbyInvite {
    @NotNull
    public static final CommandLobbyInvite INSTANCE = new CommandLobbyInvite();

    private CommandLobbyInvite() {
    }

    public final int run(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull Player invitee) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(invitee, "invitee");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender inviter = commandSender;
        if (!(inviter instanceof Player)) {
            MessageKt.sendTranslatedMessage((Audience)inviter, "command.lobby.invite.error.inviter_not_a_player", new Object[0]);
            return 0;
        }
        try {
            UUID uUID = ((Player)inviter).getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Participant participant = Participant.Companion.create(uUID);
            UUID uUID2 = invitee.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            Lobby lobby2 = LobbyService.INSTANCE.createLobbyInvitation(participant, uUID2);
            Audience audience = (Audience)inviter;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(invitee.getName(), "getName(...)");
            MessageKt.sendTranslatedMessage(audience, "command.lobby.invite.success", objectArray);
            objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue(invitee.getName(), "getName(...)");
            Intrinsics.checkNotNullExpressionValue(((Player)inviter).getName(), "getName(...)");
            lobby2.sendMessage("command.lobby.invite.success.notify_lobby", objectArray);
            Audience audience2 = (Audience)invitee;
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(((Player)inviter).getName(), "getName(...)");
            MessageKt.sendTranslatedMessage(audience2, "command.lobby.invite.success.invitee_receive", objectArray);
            return 1;
        }
        catch (UpdateLobbyException error) {
            Audience audience = (Audience)inviter;
            String string = error.getKey();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(invitee.getName(), "getName(...)");
            MessageKt.sendTranslatedMessage(audience, string, objectArray);
            return 0;
        }
    }
}

