/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.commands.lobby;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.audience.Audience;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.DeleteLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.models.Lobby;
import net.serverwars.sunsetPlugin.domain.lobby.services.LobbyService;
import net.serverwars.sunsetPlugin.translations.MessageKt;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lnet/serverwars/sunsetPlugin/commands/lobby/CommandLobbyDeleteConfirm;", "", "<init>", "()V", "run", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "sunset-plugin"})
public final class CommandLobbyDeleteConfirm {
    @NotNull
    public static final CommandLobbyDeleteConfirm INSTANCE = new CommandLobbyDeleteConfirm();

    private CommandLobbyDeleteConfirm() {
    }

    public final int run(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        try {
            Lobby lobby2 = LobbyService.INSTANCE.deleteLobby();
            lobby2.sendMessage("command.lobby.delete.success.notify_lobby", new Object[0]);
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            MessageKt.sendTranslatedMessage((Audience)commandSender, "command.lobby.delete.success", new Object[0]);
            return 1;
        }
        catch (DeleteLobbyException error) {
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            Object[] objectArray = error.getArgs();
            MessageKt.sendTranslatedMessage((Audience)commandSender, error.getKey(), Arrays.copyOf(objectArray, objectArray.length));
            return 0;
        }
    }
}

