/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.commands.lobby;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.serverwars.sunsetPlugin.domain.lobby.exceptions.CreateLobbyException;
import net.serverwars.sunsetPlugin.domain.lobby.models.LobbyAccessType;
import net.serverwars.sunsetPlugin.domain.lobby.services.LobbyService;
import net.serverwars.sunsetPlugin.translations.MessageKt;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lnet/serverwars/sunsetPlugin/commands/lobby/CommandLobbyCreate;", "", "<init>", "()V", "run", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "size", "accessType", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/LobbyAccessType;", "gameType", "", "sunset-plugin"})
public final class CommandLobbyCreate {
    @NotNull
    public static final CommandLobbyCreate INSTANCE = new CommandLobbyCreate();

    private CommandLobbyCreate() {
    }

    public final int run(@NotNull CommandContext<CommandSourceStack> ctx, int size, @NotNull LobbyAccessType accessType, @NotNull String gameType) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter((Object)accessType, "accessType");
        Intrinsics.checkNotNullParameter(gameType, "gameType");
        try {
            LobbyService.INSTANCE.createLobby(size, accessType, gameType);
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            MessageKt.sendTranslatedMessage((Audience)commandSender, "command.lobby.create.success", new Object[0]);
            if (accessType == LobbyAccessType.OPEN) {
                if (((CommandSourceStack)ctx.getSource()).getSender() instanceof Player) {
                    Server server = Bukkit.getServer();
                    Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
                    Audience audience = (Audience)server;
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue(((CommandSourceStack)ctx.getSource()).getSender().getName(), "getName(...)");
                    MessageKt.sendTranslatedMessage(audience, "command.lobby.create.success.open_announcement_by_player", objectArray);
                } else {
                    ForwardingAudience forwardingAudience = Audience.audience(Bukkit.getOnlinePlayers());
                    Intrinsics.checkNotNullExpressionValue(forwardingAudience, "audience(...)");
                    MessageKt.sendTranslatedMessage(forwardingAudience, "command.lobby.create.success.open_announcement", new Object[0]);
                }
            }
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof Player) {
                CommandSender commandSender2 = ((CommandSourceStack)ctx.getSource()).getSender();
                Intrinsics.checkNotNull(commandSender2, "null cannot be cast to non-null type org.bukkit.entity.Player");
                UUID uUID = ((Player)commandSender2).getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                LobbyService.INSTANCE.playerJoinLobby(uUID, true);
            }
            return 1;
        }
        catch (CreateLobbyException error) {
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            Object[] objectArray = error.getArgs();
            MessageKt.sendTranslatedMessage((Audience)commandSender, error.getKey(), Arrays.copyOf(objectArray, objectArray.length));
            return 0;
        }
    }
}

