/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.serverwars.sunsetPlugin.domain.gameserver.models.GameServerTypes;
import net.serverwars.sunsetPlugin.domain.gameserver.services.GameServerService;
import net.serverwars.sunsetPlugin.translations.Translations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\u00022\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u0002J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/serverwars/sunsetPlugin/commands/arguments/LobbyGameTypeArgumentType;", "Lio/papermc/paper/command/brigadier/argument/CustomArgumentType$Converted;", "", "<init>", "()V", "NOT_ALLOWED", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "get", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "name", "convert", "nativeType", "listSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "S", "", "context", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "getNativeType", "Lcom/mojang/brigadier/arguments/ArgumentType;", "sunset-plugin"})
public final class LobbyGameTypeArgumentType
implements CustomArgumentType.Converted<String, String> {
    @NotNull
    public static final LobbyGameTypeArgumentType INSTANCE = new LobbyGameTypeArgumentType();
    @NotNull
    private static final DynamicCommandExceptionType NOT_ALLOWED = new DynamicCommandExceptionType(LobbyGameTypeArgumentType::NOT_ALLOWED$lambda$0);

    private LobbyGameTypeArgumentType() {
    }

    @NotNull
    public final String get(@NotNull CommandContext<?> ctx, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(name, "name");
        Object object = ctx.getArgument(name, String.class);
        Intrinsics.checkNotNullExpressionValue(object, "getArgument(...)");
        return (String)object;
    }

    @NotNull
    public String convert(@NotNull String nativeType) {
        Intrinsics.checkNotNullParameter(nativeType, "nativeType");
        Object object = GameServerService.INSTANCE.getAvailableGameServerTypes();
        if (!(object != null && (object = ((GameServerTypes)object).getTypes()) != null ? object.contains(nativeType) : false)) {
            CommandSyntaxException commandSyntaxException = NOT_ALLOWED.create((Object)nativeType);
            Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "create(...)");
            throw (Throwable)commandSyntaxException;
        }
        return nativeType;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Object object = GameServerService.INSTANCE.getAvailableGameServerTypes();
        if (object == null || (object = ((GameServerTypes)object).getTypes()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            String gameType = (String)iterator2.next();
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(gameType, string, false, 2, null)) continue;
            builder.suggest(gameType);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        StringArgumentType stringArgumentType = StringArgumentType.word();
        Intrinsics.checkNotNullExpressionValue(stringArgumentType, "word(...)");
        return (ArgumentType)stringArgumentType;
    }

    private static final Message NOT_ALLOWED$lambda$0(Object gameType) {
        Intrinsics.checkNotNullParameter(gameType, "gameType");
        Object[] objectArray = new Object[]{gameType};
        return (Message)MessageComponentSerializer.message().serialize(Translations.INSTANCE.get("command.lobby.error.invalid_game_type", objectArray));
    }
}

