/*
 * Decompiled with CFR 0.152.
 */
package net.serverwars.sunsetPlugin.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.serverwars.sunsetPlugin.domain.lobby.models.LobbyAccessType;
import net.serverwars.sunsetPlugin.translations.Translations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/serverwars/sunsetPlugin/commands/arguments/LobbyAccessTypeArgumentType;", "Lio/papermc/paper/command/brigadier/argument/CustomArgumentType$Converted;", "Lnet/serverwars/sunsetPlugin/domain/lobby/models/LobbyAccessType;", "", "<init>", "()V", "NOT_ALLOWED", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "get", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "name", "convert", "nativeType", "listSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "S", "", "context", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "getNativeType", "Lcom/mojang/brigadier/arguments/ArgumentType;", "sunset-plugin"})
public final class LobbyAccessTypeArgumentType
implements CustomArgumentType.Converted<LobbyAccessType, String> {
    @NotNull
    public static final LobbyAccessTypeArgumentType INSTANCE = new LobbyAccessTypeArgumentType();
    @NotNull
    private static final DynamicCommandExceptionType NOT_ALLOWED = new DynamicCommandExceptionType(LobbyAccessTypeArgumentType::NOT_ALLOWED$lambda$0);

    private LobbyAccessTypeArgumentType() {
    }

    @NotNull
    public final LobbyAccessType get(@NotNull CommandContext<?> ctx, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(name, "name");
        Object object = ctx.getArgument(name, LobbyAccessType.class);
        Intrinsics.checkNotNullExpressionValue(object, "getArgument(...)");
        return (LobbyAccessType)((Object)object);
    }

    @NotNull
    public LobbyAccessType convert(@NotNull String nativeType) {
        Intrinsics.checkNotNullParameter(nativeType, "nativeType");
        LobbyAccessType lobbyAccessType = LobbyAccessType.Companion.fromValue(nativeType);
        if (lobbyAccessType == null) {
            CommandSyntaxException commandSyntaxException = NOT_ALLOWED.create((Object)nativeType);
            Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "create(...)");
            throw (Throwable)commandSyntaxException;
        }
        return lobbyAccessType;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(builder, "builder");
        for (LobbyAccessType accessType : LobbyAccessType.getEntries()) {
            String string = accessType.getValue();
            String string2 = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
            builder.suggest(accessType.getValue());
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        StringArgumentType stringArgumentType = StringArgumentType.word();
        Intrinsics.checkNotNullExpressionValue(stringArgumentType, "word(...)");
        return (ArgumentType)stringArgumentType;
    }

    private static final Message NOT_ALLOWED$lambda$0(Object accessType) {
        Intrinsics.checkNotNullParameter(accessType, "accessType");
        Object[] objectArray = new Object[]{accessType};
        return (Message)MessageComponentSerializer.message().serialize(Translations.INSTANCE.get("command.lobby.error.invalid_access_type", objectArray));
    }
}

