/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.translation;

import java.util.Locale;
import java.util.function.Supplier;
import net.kyori.adventure.internal.properties.AdventureProperties;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.Nullable;

final class TranslationLocales {
    private static final Supplier<Locale> GLOBAL;

    private TranslationLocales() {
    }

    static Locale global() {
        return GLOBAL.get();
    }

    static {
        @Nullable String property2 = AdventureProperties.DEFAULT_TRANSLATION_LOCALE.value();
        if (property2 == null || property2.isEmpty()) {
            GLOBAL = () -> Locale.US;
        } else if (property2.equals("system")) {
            GLOBAL = Locale::getDefault;
        } else {
            Locale locale = Translator.parseLocale(property2);
            GLOBAL = () -> locale;
        }
    }
}

