/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextComponentImpl;
import net.kyori.adventure.text.VirtualComponent;
import net.kyori.adventure.text.VirtualComponentRenderer;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualComponentImpl<C>
extends TextComponentImpl
implements VirtualComponent {
    private final Class<C> contextType;
    private final VirtualComponentRenderer<C> renderer;

    static <C> VirtualComponent createVirtual(@NotNull Class<C> contextType, @NotNull VirtualComponentRenderer<C> renderer) {
        return VirtualComponentImpl.createVirtual(contextType, renderer, Collections.emptyList(), Style.empty());
    }

    static <C> VirtualComponent createVirtual(@NotNull Class<C> contextType, @NotNull VirtualComponentRenderer<C> renderer, List<? extends ComponentLike> children2, Style style) {
        List<Component> filteredChildren = ComponentLike.asComponents(children2, IS_NOT_EMPTY);
        return new VirtualComponentImpl<C>(filteredChildren, style, "", contextType, renderer);
    }

    private VirtualComponentImpl(@NotNull List<Component> children2, @NotNull Style style, @NotNull String content2, @NotNull Class<C> contextType, @NotNull VirtualComponentRenderer<C> renderer) {
        super(children2, style, content2);
        this.contextType = contextType;
        this.renderer = renderer;
    }

    @Override
    VirtualComponent create0(@NotNull List<? extends ComponentLike> children2, @NotNull Style style, @NotNull String content2) {
        return new VirtualComponentImpl<C>(ComponentLike.asComponents(children2, IS_NOT_EMPTY), style, content2, this.contextType, this.renderer);
    }

    @NotNull
    public Class<C> contextType() {
        return this.contextType;
    }

    @NotNull
    public VirtualComponentRenderer<C> renderer() {
        return this.renderer;
    }

    @Override
    @NotNull
    public String content() {
        return this.renderer.fallbackString();
    }

    @Override
    @NotNull
    public TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VirtualComponentImpl)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        VirtualComponentImpl that = (VirtualComponentImpl)other;
        return Objects.equals(this.contextType, that.contextType) && Objects.equals(this.renderer, that.renderer);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.contextType.hashCode();
        result2 = 31 * result2 + this.renderer.hashCode();
        return result2;
    }

    static final class BuilderImpl<C>
    extends TextComponentImpl.BuilderImpl {
        private final Class<C> contextType;
        private final VirtualComponentRenderer<C> renderer;

        BuilderImpl(VirtualComponentImpl<C> other) {
            super(other);
            this.contextType = other.contextType();
            this.renderer = other.renderer();
        }

        @Override
        @NotNull
        public TextComponent build() {
            return VirtualComponentImpl.createVirtual(this.contextType, this.renderer, this.children, this.buildStyle());
        }
    }
}

