/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.LocalTimeKt;
import kotlinx.datetime.Ser;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.LocalTimeFormat;
import kotlinx.datetime.format.LocalTimeFormatKt;
import kotlinx.datetime.serializers.LocalTimeSerializer;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlinx.serialization.Serializable(with=LocalTimeSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002%&B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B-\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0011\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006'"}, d2={"Lkotlinx/datetime/LocalTime;", "", "Ljava/io/Serializable;", "value", "Ljava/time/LocalTime;", "<init>", "(Ljava/time/LocalTime;)V", "hour", "", "minute", "second", "nanosecond", "(IIII)V", "getValue$kotlinx_datetime", "()Ljava/time/LocalTime;", "getHour", "()I", "getMinute", "getSecond", "getNanosecond", "toSecondOfDay", "toMillisecondOfDay", "toNanosecondOfDay", "", "equals", "", "other", "", "hashCode", "toString", "", "compareTo", "readObject", "", "ois", "Ljava/io/ObjectInputStream;", "writeReplace", "Companion", "Formats", "kotlinx-datetime"})
public final class LocalTime
implements Comparable<LocalTime>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.LocalTime value;
    @NotNull
    private static final LocalTime MIN;
    @NotNull
    private static final LocalTime MAX;
    private static final long serialVersionUID = 0L;

    public LocalTime(@NotNull java.time.LocalTime value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final java.time.LocalTime getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalTime(int hour2, int minute2, int second2, int nanosecond) {
        java.time.LocalTime localTime;
        LocalTime localTime2;
        LocalTime localTime3 = this;
        try {
            localTime2 = localTime3;
            localTime = java.time.LocalTime.of(hour2, minute2, second2, nanosecond);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            LocalTime localTime4 = localTime3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.LocalTime localTime5 = localTime;
        Intrinsics.checkNotNull(localTime5);
        localTime2(localTime5);
    }

    public /* synthetic */ LocalTime(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getHour() {
        return this.value.getHour();
    }

    public final int getMinute() {
        return this.value.getMinute();
    }

    public final int getSecond() {
        return this.value.getSecond();
    }

    public final int getNanosecond() {
        return this.value.getNano();
    }

    public final int toSecondOfDay() {
        return this.value.toSecondOfDay();
    }

    public final int toMillisecondOfDay() {
        return (int)(this.value.toNanoOfDay() / (long)1000000);
    }

    public final long toNanosecondOfDay() {
        return this.value.toNanoOfDay();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LocalTime && Intrinsics.areEqual(this.value, ((LocalTime)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull LocalTime other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value.compareTo(other.value);
    }

    private final void readObject(ObjectInputStream ois) {
        throw new InvalidObjectException("kotlinx.datetime.LocalTime must be deserialized via kotlinx.datetime.Ser");
    }

    private final Object writeReplace() {
        return new Ser(3, this);
    }

    static {
        java.time.LocalTime localTime = java.time.LocalTime.MIN;
        Intrinsics.checkNotNullExpressionValue(localTime, "MIN");
        MIN = new LocalTime(localTime);
        java.time.LocalTime localTime2 = java.time.LocalTime.MAX;
        Intrinsics.checkNotNullExpressionValue(localTime2, "MAX");
        MAX = new LocalTime(localTime2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J%\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\u0002\b\u001eJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!R\u0014\u0010\u0014\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u000e\u0010\u001f\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkotlinx/datetime/LocalTime$Companion;", "", "<init>", "()V", "parse", "Lkotlinx/datetime/LocalTime;", "input", "", "format", "Lkotlinx/datetime/format/DateTimeFormat;", "isoString", "", "fromSecondOfDay", "secondOfDay", "", "fromMillisecondOfDay", "millisecondOfDay", "fromNanosecondOfDay", "nanosecondOfDay", "", "MIN", "getMIN$kotlinx_datetime", "()Lkotlinx/datetime/LocalTime;", "MAX", "getMAX$kotlinx_datetime", "Format", "builder", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithTime;", "", "Lkotlin/ExtensionFunctionType;", "serialVersionUID", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    @SourceDebugExtension(value={"SMAP\nLocalTimeJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTimeJvm.kt\nkotlinx/datetime/LocalTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalTime parse(@NotNull CharSequence input2, @NotNull DateTimeFormat<LocalTime> format) {
            LocalTime localTime;
            Intrinsics.checkNotNullParameter(input2, "input");
            Intrinsics.checkNotNullParameter(format, "format");
            if (format == Formats.INSTANCE.getISO()) {
                LocalTime localTime2;
                try {
                    java.time.LocalTime p0 = java.time.LocalTime.parse(input2);
                    boolean bl = false;
                    localTime2 = new LocalTime(p0);
                }
                catch (DateTimeParseException e) {
                    throw new DateTimeFormatException(e);
                }
                localTime = localTime2;
            } else {
                localTime = format.parse(input2);
            }
            return localTime;
        }

        public static /* synthetic */ LocalTime parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = LocalTimeKt.getIsoTimeFormat();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        @Deprecated(message="This overload is only kept for binary compatibility", level=DeprecationLevel.HIDDEN)
        public final /* synthetic */ LocalTime parse(String isoString) {
            Intrinsics.checkNotNullParameter(isoString, "isoString");
            return kotlinx.datetime.LocalTime$Companion.parse$default(this, isoString, null, 2, null);
        }

        @NotNull
        public final LocalTime fromSecondOfDay(int secondOfDay) {
            LocalTime localTime;
            try {
                java.time.LocalTime p0 = java.time.LocalTime.ofSecondOfDay(secondOfDay);
                boolean bl = false;
                localTime = new LocalTime(p0);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
            return localTime;
        }

        @NotNull
        public final LocalTime fromMillisecondOfDay(int millisecondOfDay) {
            LocalTime localTime;
            try {
                java.time.LocalTime p0 = java.time.LocalTime.ofNanoOfDay((long)millisecondOfDay * 1000000L);
                boolean bl = false;
                localTime = new LocalTime(p0);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            return localTime;
        }

        @NotNull
        public final LocalTime fromNanosecondOfDay(long nanosecondOfDay) {
            LocalTime localTime;
            try {
                java.time.LocalTime p0 = java.time.LocalTime.ofNanoOfDay(nanosecondOfDay);
                boolean bl = false;
                localTime = new LocalTime(p0);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
            return localTime;
        }

        @NotNull
        public final LocalTime getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final LocalTime getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final DateTimeFormat<LocalTime> Format(@NotNull Function1<? super DateTimeFormatBuilder.WithTime, Unit> builder) {
            Intrinsics.checkNotNullParameter(builder, "builder");
            return LocalTimeFormat.Companion.build(builder);
        }

        @NotNull
        public final KSerializer<LocalTime> serializer() {
            return LocalTimeSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkotlinx/datetime/LocalTime$Formats;", "", "<init>", "()V", "ISO", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalTime;", "getISO", "()Lkotlinx/datetime/format/DateTimeFormat;", "kotlinx-datetime"})
    public static final class Formats {
        @NotNull
        public static final Formats INSTANCE = new Formats();

        private Formats() {
        }

        @NotNull
        public final DateTimeFormat<LocalTime> getISO() {
            return LocalTimeFormatKt.getISO_TIME();
        }
    }
}

