/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.util.CryptoKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\u001fR\u0014\u0010'\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010\"R\u0014\u0010(\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010%R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010+\u00a8\u0006-"}, d2={"Lio/ktor/network/tls/cipher/CBCCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "Lio/ktor/network/tls/CipherSuite;", "suite", "", "keyMaterial", "<init>", "(Lio/ktor/network/tls/CipherSuite;[B)V", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "(Lio/ktor/network/tls/TLSRecord;)Lio/ktor/network/tls/TLSRecord;", "decrypt", "content", "prepareMac", "(Lio/ktor/network/tls/TLSRecord;[B)[B", "Lkotlinx/io/Sink;", "", "writePadding", "(Lkotlinx/io/Sink;)V", "", "paddingStart", "validatePadding", "([BI)V", "macOffset", "validateMac", "(Lio/ktor/network/tls/TLSRecord;[BI)V", "Lio/ktor/network/tls/CipherSuite;", "[B", "Ljavax/crypto/Cipher;", "sendCipher", "Ljavax/crypto/Cipher;", "Ljavax/crypto/spec/SecretKeySpec;", "sendKey", "Ljavax/crypto/spec/SecretKeySpec;", "Ljavax/crypto/Mac;", "sendMac", "Ljavax/crypto/Mac;", "receiveCipher", "receiveKey", "receiveMac", "", "inputCounter", "J", "outputCounter", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nCBCCipher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CBCCipher.kt\nio/ktor/network/tls/cipher/CBCCipher\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,127:1\n19#2,3:128\n19#2,3:131\n*S KotlinDebug\n*F\n+ 1 CBCCipher.kt\nio/ktor/network/tls/cipher/CBCCipher\n*L\n36#1:128,3\n63#1:131,3\n*E\n"})
public final class CBCCipher
implements TLSCipher {
    @NotNull
    private final CipherSuite suite;
    @NotNull
    private final byte[] keyMaterial;
    @NotNull
    private final Cipher sendCipher;
    @NotNull
    private final SecretKeySpec sendKey;
    @NotNull
    private final Mac sendMac;
    @NotNull
    private final Cipher receiveCipher;
    @NotNull
    private final SecretKeySpec receiveKey;
    @NotNull
    private final Mac receiveMac;
    private long inputCounter;
    private long outputCounter;

    public CBCCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial) {
        Intrinsics.checkNotNullParameter(suite, "suite");
        Intrinsics.checkNotNullParameter(keyMaterial, "keyMaterial");
        this.suite = suite;
        this.keyMaterial = keyMaterial;
        Cipher cipher = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull(cipher);
        this.sendCipher = cipher;
        this.sendKey = KeysKt.clientKey(this.keyMaterial, this.suite);
        Mac mac = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull(mac);
        this.sendMac = mac;
        Cipher cipher2 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull(cipher2);
        this.receiveCipher = cipher2;
        this.receiveKey = KeysKt.serverKey(this.keyMaterial, this.suite);
        Mac mac2 = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull(mac2);
        this.receiveMac = mac2;
    }

    @Override
    @NotNull
    public TLSRecord encrypt(@NotNull TLSRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        this.sendCipher.init(1, (Key)this.sendKey, new IvParameterSpec(CryptoKt.generateNonce(this.suite.getFixedIvLength())));
        byte[] content2 = SourcesKt.readByteArray(record.getPacket());
        byte[] macBytes = this.prepareMac(record, content2);
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$encrypt_u24lambda_u240 = builder$iv;
        boolean bl = false;
        BytePacketBuilderKt.writeFully$default($this$encrypt_u24lambda_u240, content2, 0, 0, 6, null);
        BytePacketBuilderKt.writeFully$default($this$encrypt_u24lambda_u240, macBytes, 0, 0, 6, null);
        this.writePadding($this$encrypt_u24lambda_u240);
        Source encryptionData = builder$iv;
        Source packet = CipherUtilsKt.cipherLoop(encryptionData, this.sendCipher, arg_0 -> CBCCipher.encrypt$lambda$1(this, arg_0));
        return new TLSRecord(record.getType(), null, packet, 2, null);
    }

    @Override
    @NotNull
    public TLSRecord decrypt(@NotNull TLSRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        Source packet = record.getPacket();
        byte[] serverIV = SourcesKt.readByteArray(packet, this.suite.getFixedIvLength());
        this.receiveCipher.init(2, (Key)this.receiveKey, new IvParameterSpec(serverIV));
        byte[] content2 = SourcesKt.readByteArray(CipherUtilsKt.cipherLoop$default(packet, this.receiveCipher, null, 2, null));
        int paddingLength = content2[content2.length - 1] & 0xFF;
        int paddingStart = content2.length - paddingLength - 1;
        int macStart = paddingStart - this.suite.getMacStrengthInBytes();
        this.validatePadding(content2, paddingStart);
        this.validateMac(record, content2, macStart);
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$decrypt_u24lambda_u242 = builder$iv;
        boolean bl = false;
        BytePacketBuilderKt.writeFully($this$decrypt_u24lambda_u242, content2, 0, macStart);
        Source decryptedContent = builder$iv;
        return new TLSRecord(record.getType(), record.getVersion(), decryptedContent);
    }

    private final byte[] prepareMac(TLSRecord record, byte[] content2) {
        byte[] byArray;
        this.sendMac.reset();
        this.sendMac.init(KeysKt.clientMacKey(this.keyMaterial, this.suite));
        byte[] it = byArray = new byte[13];
        boolean bl = false;
        CipherKt.set(it, 0, this.outputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)content2.length);
        byte[] header = byArray;
        ++this.outputCounter;
        this.sendMac.update(header);
        byte[] byArray2 = this.sendMac.doFinal(content2);
        Intrinsics.checkNotNullExpressionValue(byArray2, "doFinal(...)");
        return byArray2;
    }

    private final void writePadding(Sink $this$writePadding) {
        int lastBlockSize = (BytePacketBuilderKt.getSize($this$writePadding) + 1) % this.sendCipher.getBlockSize();
        byte paddingSize = (byte)(this.sendCipher.getBlockSize() - lastBlockSize);
        int n = paddingSize + 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            $this$writePadding.writeByte(paddingSize);
        }
    }

    private final void validatePadding(byte[] content2, int paddingStart) {
        int padding = content2[content2.length - 1] & 0xFF;
        int n = content2.length;
        for (int i = paddingStart; i < n; ++i) {
            int n2 = content2[i] & 0xFF;
            if (padding == n2) continue;
            throw new TLSException("Padding invalid: expected " + padding + ", actual " + n2, null, 2, null);
        }
    }

    private final void validateMac(TLSRecord record, byte[] content2, int macOffset) {
        byte[] byArray;
        this.receiveMac.reset();
        this.receiveMac.init(KeysKt.serverMacKey(this.keyMaterial, this.suite));
        byte[] it = byArray = new byte[13];
        boolean bl = false;
        CipherKt.set(it, 0, this.inputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)macOffset);
        byte[] header = byArray;
        long l = this.inputCounter;
        this.inputCounter = l + 1L;
        this.receiveMac.update(header);
        this.receiveMac.update(content2, 0, macOffset);
        byte[] byArray2 = this.receiveMac.doFinal();
        Intrinsics.checkNotNull(byArray2);
        byte[] expectedMac = byArray2;
        byte[] actual = ArraysKt.sliceArray(content2, RangesKt.until(macOffset, macOffset + this.suite.getMacStrengthInBytes()));
        if (!MessageDigest.isEqual(expectedMac, actual)) {
            throw new TLSException("Failed to verify MAC content", null, 2, null);
        }
    }

    private static final Unit encrypt$lambda$1(CBCCipher this$0, Sink $this$cipherLoop) {
        Intrinsics.checkNotNullParameter($this$cipherLoop, "$this$cipherLoop");
        byte[] byArray = this$0.sendCipher.getIV();
        Intrinsics.checkNotNullExpressionValue(byArray, "getIV(...)");
        BytePacketBuilderKt.writeFully$default($this$cipherLoop, byArray, 0, 0, 6, null);
        return Unit.INSTANCE;
    }
}

