/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.CharArrayBuilder;
import io.ktor.http.cio.internals.MutableRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u001f\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a'\u0010\n\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001f\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"", "text", "Lio/ktor/http/cio/internals/MutableRange;", "range", "nextToken", "(Ljava/lang/CharSequence;Lio/ktor/http/cio/internals/MutableRange;)Ljava/lang/CharSequence;", "Lio/ktor/http/cio/internals/CharArrayBuilder;", "", "start", "end", "skipSpacesAndHorizontalTabs", "(Lio/ktor/http/cio/internals/CharArrayBuilder;II)I", "", "skipSpaces", "(Ljava/lang/CharSequence;Lio/ktor/http/cio/internals/MutableRange;)V", "findSpaceOrEnd", "(Ljava/lang/CharSequence;Lio/ktor/http/cio/internals/MutableRange;)I", "ktor-http-cio"})
public final class TokenizerKt {
    @NotNull
    public static final CharSequence nextToken(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(range, "range");
        int spaceOrEnd = TokenizerKt.findSpaceOrEnd(text, range);
        CharSequence s = text.subSequence(range.getStart(), spaceOrEnd);
        range.setStart(spaceOrEnd);
        return s;
    }

    public static final int skipSpacesAndHorizontalTabs(@NotNull CharArrayBuilder text, int start, int end) {
        char ch;
        int index;
        Intrinsics.checkNotNullParameter(text, "text");
        for (index = start; index < end && (CharsKt.isWhitespace(ch = text.charAt(index)) || ch == '\t'); ++index) {
        }
        return index;
    }

    public static final void skipSpaces(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(range, "range");
        int idx = range.getStart();
        int end = range.getEnd();
        if (idx >= end || !CharsKt.isWhitespace(text.charAt(idx))) {
            return;
        }
        ++idx;
        while (idx < end && CharsKt.isWhitespace(text.charAt(idx))) {
            ++idx;
        }
        range.setStart(idx);
    }

    public static final int findSpaceOrEnd(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(range, "range");
        int idx = range.getStart();
        int end = range.getEnd();
        if (idx >= end || CharsKt.isWhitespace(text.charAt(idx))) {
            return idx;
        }
        ++idx;
        while (idx < end) {
            if (CharsKt.isWhitespace(text.charAt(idx))) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }
}

