/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CookieUtilsKt;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.parsing.ParseException;
import io.ktor.utils.io.InternalAPI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a-\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0002\u00a2\u0006\u0004\b\u0003\u0010\f\u001a7\u0010\u000f\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a3\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a3\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a\u001f\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0013\u0010\u0018\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a#\u0010\u001c\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001b\u0010\u001e\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0017\u001a\u0013\u0010 \u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b \u0010!\u001a\u0013\u0010\"\u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010!\"\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\"\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\"\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\"\u0014\u0010*\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)\u00a8\u0006+"}, d2={"", "headerValue", "Lio/ktor/http/auth/HttpAuthHeader;", "parseAuthorizationHeader", "(Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader;", "", "parseAuthorizationHeaders", "(Ljava/lang/String;)Ljava/util/List;", "", "startIndex", "", "headers", "(Ljava/lang/String;ILjava/util/List;)I", "header", "index", "nextChallengeIndex", "(Ljava/util/List;Lio/ktor/http/auth/HttpAuthHeader;ILjava/lang/String;)Ljava/lang/Integer;", "", "parameters", "matchParameters", "(Ljava/lang/String;ILjava/util/Map;)I", "matchParameter", "matchToken68", "(Ljava/lang/String;I)I", "unescaped", "(Ljava/lang/String;)Ljava/lang/String;", "", "delimiter", "skipDelimiter", "(Ljava/lang/String;IC)I", "skipSpaces", "", "isToken68", "(C)Z", "isToken", "", "TOKEN_EXTRA", "Ljava/util/Set;", "TOKEN68_EXTRA", "Lkotlin/text/Regex;", "token68Pattern", "Lkotlin/text/Regex;", "escapeRegex", "ktor-http"})
public final class HttpAuthHeaderKt {
    @NotNull
    private static final Set<Character> TOKEN_EXTRA;
    @NotNull
    private static final Set<Character> TOKEN68_EXTRA;
    @NotNull
    private static final Regex token68Pattern;
    @NotNull
    private static final Regex escapeRegex;

    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeader(@NotNull String headerValue) {
        Intrinsics.checkNotNullParameter(headerValue, "headerValue");
        int index = 0;
        int tokenStartIndex = index = HttpAuthHeaderKt.skipSpaces(headerValue, index);
        while (index < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index))) {
            ++index;
        }
        String authScheme = StringsKt.substring(headerValue, RangesKt.until(tokenStartIndex, index));
        index = HttpAuthHeaderKt.skipSpaces(headerValue, index);
        if (StringsKt.isBlank(authScheme)) {
            return null;
        }
        if (headerValue.length() == index) {
            return new HttpAuthHeader.Parameterized(authScheme, CollectionsKt.emptyList(), null, 4, null);
        }
        int token68EndIndex = HttpAuthHeaderKt.matchToken68(headerValue, index);
        String token68 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring(headerValue, RangesKt.until(index, token68EndIndex)))).toString();
        if (((CharSequence)token68).length() > 0 && token68EndIndex == headerValue.length()) {
            return new HttpAuthHeader.Single(authScheme, token68);
        }
        Map parameters = new LinkedHashMap();
        int endIndex = HttpAuthHeaderKt.matchParameters(headerValue, index, parameters);
        if (endIndex != -1) {
            throw new ParseException("Function parseAuthorizationHeader can parse only one header", null, 2, null);
        }
        return new HttpAuthHeader.Parameterized(authScheme, parameters, null, 4, null);
    }

    @InternalAPI
    @NotNull
    public static final List<HttpAuthHeader> parseAuthorizationHeaders(@NotNull String headerValue) {
        Intrinsics.checkNotNullParameter(headerValue, "headerValue");
        int index = 0;
        List headers = new ArrayList();
        while (index != -1) {
            index = HttpAuthHeaderKt.parseAuthorizationHeader(headerValue, index, headers);
        }
        return headers;
    }

    private static final int parseAuthorizationHeader(String headerValue, int startIndex, List<HttpAuthHeader> headers) {
        Integer it2;
        int index;
        int schemeStartIndex = index = HttpAuthHeaderKt.skipSpaces(headerValue, startIndex);
        while (index < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index))) {
            ++index;
        }
        String authScheme = StringsKt.substring(headerValue, RangesKt.until(schemeStartIndex, index));
        if (StringsKt.isBlank(authScheme)) {
            throw new ParseException("Invalid authScheme value: it should be token, can't be blank", null, 2, null);
        }
        index = HttpAuthHeaderKt.skipSpaces(headerValue, index);
        Integer n = HttpAuthHeaderKt.nextChallengeIndex(headers, new HttpAuthHeader.Parameterized(authScheme, CollectionsKt.emptyList(), null, 4, null), index, headerValue);
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            return it2;
        }
        int token68EndIndex = HttpAuthHeaderKt.matchToken68(headerValue, index);
        String token68 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring(headerValue, RangesKt.until(index, token68EndIndex)))).toString();
        if (((CharSequence)token68).length() > 0 && (it2 = HttpAuthHeaderKt.nextChallengeIndex(headers, new HttpAuthHeader.Single(authScheme, token68), token68EndIndex, headerValue)) != null) {
            int it3 = ((Number)it2).intValue();
            boolean bl = false;
            return it3;
        }
        Map parameters = new LinkedHashMap();
        int nextIndexChallenge = HttpAuthHeaderKt.matchParameters(headerValue, index, parameters);
        headers.add(new HttpAuthHeader.Parameterized(authScheme, parameters, null, 4, null));
        return nextIndexChallenge;
    }

    private static final Integer nextChallengeIndex(List<HttpAuthHeader> headers, HttpAuthHeader header, int index, String headerValue) {
        if (index == headerValue.length() || headerValue.charAt(index) == ',') {
            Integer n;
            headers.add(header);
            if (index == headerValue.length()) {
                n = -1;
            } else if (headerValue.charAt(index) == ',') {
                n = index + 1;
            } else {
                throw new IllegalStateException("".toString());
            }
            return n;
        }
        return null;
    }

    private static final int matchParameters(String headerValue, int startIndex, Map<String, String> parameters) {
        int index = startIndex;
        while (index > 0 && index < headerValue.length()) {
            int nextIndex = HttpAuthHeaderKt.matchParameter(headerValue, index, parameters);
            if (nextIndex == index) {
                return index;
            }
            index = HttpAuthHeaderKt.skipDelimiter(headerValue, nextIndex, ',');
        }
        return index;
    }

    private static final int matchParameter(String headerValue, int startIndex, Map<String, String> parameters) {
        int keyStart;
        int index;
        for (index = keyStart = HttpAuthHeaderKt.skipSpaces(headerValue, startIndex); index < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index)); ++index) {
        }
        String key = StringsKt.substring(headerValue, RangesKt.until(keyStart, index));
        if ((index = HttpAuthHeaderKt.skipSpaces(headerValue, index)) == headerValue.length() || headerValue.charAt(index) != '=') {
            return startIndex;
        }
        ++index;
        boolean quoted = false;
        int valueStart = index;
        if (headerValue.charAt(index) == '\"') {
            quoted = true;
            valueStart = ++index;
            boolean escaped = false;
            while (index < headerValue.length() && (headerValue.charAt(index) != '\"' || escaped)) {
                escaped = !escaped && headerValue.charAt(index) == '\\';
                ++index;
            }
            if (index == headerValue.length()) {
                throw new ParseException("Expected closing quote'\"' in parameter", null, 2, null);
            }
        } else {
            for (index = HttpAuthHeaderKt.skipSpaces(headerValue, index); index < headerValue.length() && headerValue.charAt(index) != ' ' && headerValue.charAt(index) != ','; ++index) {
            }
        }
        String value = StringsKt.substring(headerValue, RangesKt.until(valueStart, index));
        parameters.put(key, quoted ? HttpAuthHeaderKt.unescaped(value) : value);
        if (quoted) {
            ++index;
        }
        return index;
    }

    private static final int matchToken68(String headerValue, int startIndex) {
        int index;
        for (index = HttpAuthHeaderKt.skipSpaces(headerValue, startIndex); index < headerValue.length() && HttpAuthHeaderKt.isToken68(headerValue.charAt(index)); ++index) {
        }
        while (index < headerValue.length() && headerValue.charAt(index) == '=') {
            ++index;
        }
        return HttpAuthHeaderKt.skipSpaces(headerValue, index);
    }

    private static final String unescaped(String $this$unescaped) {
        CharSequence charSequence = $this$unescaped;
        Regex regex = escapeRegex;
        Function1<MatchResult, CharSequence> function1 = HttpAuthHeaderKt::unescaped$lambda$2;
        return regex.replace(charSequence, function1);
    }

    private static final int skipDelimiter(String $this$skipDelimiter, int startIndex, char delimiter) {
        int index = HttpAuthHeaderKt.skipSpaces($this$skipDelimiter, startIndex);
        if (index == $this$skipDelimiter.length()) {
            return -1;
        }
        if ($this$skipDelimiter.charAt(index) != delimiter) {
            throw new ParseException("Expected delimiter " + delimiter + " at position " + index, null, 2, null);
        }
        return HttpAuthHeaderKt.skipSpaces($this$skipDelimiter, ++index);
    }

    private static final int skipSpaces(String $this$skipSpaces, int startIndex) {
        int index;
        for (index = startIndex; index < $this$skipSpaces.length() && $this$skipSpaces.charAt(index) == ' '; ++index) {
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken68(char $this$isToken68) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isToken68) {
            if ($this$isToken68 < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isToken68) {
            if ($this$isToken68 < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit($this$isToken68)) return true;
        if (!TOKEN68_EXTRA.contains(Character.valueOf($this$isToken68))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken(char $this$isToken) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isToken) {
            if ($this$isToken < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isToken) {
            if ($this$isToken < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit($this$isToken)) return true;
        if (!TOKEN_EXTRA.contains(Character.valueOf($this$isToken))) return false;
        return true;
    }

    private static final CharSequence unescaped$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.takeLast(it.getValue(), 1);
    }

    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')};
        TOKEN_EXTRA = SetsKt.setOf(characterArray);
        characterArray = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('+'), Character.valueOf('/')};
        TOKEN68_EXTRA = SetsKt.setOf(characterArray);
        token68Pattern = new Regex("[a-zA-Z0-9\\-._~+/]+=*");
        escapeRegex = new Regex("\\\\.");
    }
}

