/*
 * Decompiled with CFR 0.152.
 */
package com.fatboyindustrial.gsonjavatime;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.ZoneId;

public class ZoneIdConverter
implements JsonSerializer<ZoneId>,
JsonDeserializer<ZoneId> {
    public JsonElement serialize(ZoneId src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        return new JsonPrimitive(src.getId());
    }

    public ZoneId deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json == null) {
            return null;
        }
        if (json.isJsonNull()) {
            return null;
        }
        String zoneIdentifier = json.getAsString();
        if (zoneIdentifier == null || zoneIdentifier.isEmpty()) {
            return null;
        }
        return ZoneId.of(zoneIdentifier);
    }
}

