/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.velocitab.libraries.annotations.NotNull;

public class StringUtil {
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u([0-9a-fA-F]{4})");

    @NotNull
    public static String unescapeJava(@NotNull String input) {
        StringBuilder output = new StringBuilder();
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (c == '\\' && i + 1 < length) {
                char next = input.charAt(i + 1);
                switch (next) {
                    case 'b': {
                        output.append('\b');
                        ++i;
                        break;
                    }
                    case 't': {
                        output.append('\t');
                        ++i;
                        break;
                    }
                    case 'n': {
                        output.append('\n');
                        ++i;
                        break;
                    }
                    case 'f': {
                        output.append('\f');
                        ++i;
                        break;
                    }
                    case 'r': {
                        output.append('\r');
                        ++i;
                        break;
                    }
                    case '\"': {
                        output.append('\"');
                        ++i;
                        break;
                    }
                    case '\'': {
                        output.append('\'');
                        ++i;
                        break;
                    }
                    case '\\': {
                        output.append('\\');
                        ++i;
                        break;
                    }
                    case 'u': {
                        if (i + 5 < length) {
                            String hex = input.substring(i + 2, i + 6);
                            try {
                                int unicode = Integer.parseInt(hex, 16);
                                output.append((char)unicode);
                                i += 5;
                            }
                            catch (NumberFormatException e) {
                                output.append("\\u").append(hex);
                                i += 5;
                            }
                            break;
                        }
                        output.append(c);
                        break;
                    }
                    default: {
                        output.append(c).append(next);
                        ++i;
                    }
                }
                continue;
            }
            output.append(c);
        }
        return StringUtil.replaceUnicodeEscapes(output.toString());
    }

    @NotNull
    private static String replaceUnicodeEscapes(@NotNull String input) {
        Matcher matcher = UNICODE_PATTERN.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String unicodeStr = matcher.group(1);
            int unicode = Integer.parseInt(unicodeStr, 16);
            matcher.appendReplacement(result, Character.toString(unicode));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

