/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.ast;

import net.william278.velocitab.libraries.mvel2.CompileException;
import net.william278.velocitab.libraries.mvel2.ParserContext;
import net.william278.velocitab.libraries.mvel2.ast.ASTNode;
import net.william278.velocitab.libraries.mvel2.debug.DebugTools;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;

public class OperatorNode
extends ASTNode {
    private Integer operator;

    public OperatorNode(Integer operator, char[] expr, int start, ParserContext pCtx) {
        super(pCtx);
        assert (operator != null);
        this.expr = expr;
        this.operator = operator;
        this.literal = this.operator;
        this.start = start;
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public boolean isOperator(Integer operator) {
        return operator.equals(this.operator);
    }

    @Override
    public Integer getOperator() {
        return this.operator;
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        throw new CompileException("illegal use of operator: " + DebugTools.getOperatorSymbol(this.operator), this.expr, this.start);
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        throw new CompileException("illegal use of operator: " + DebugTools.getOperatorSymbol(this.operator), this.expr, this.start);
    }
}

