/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2;

import java.util.Collections;
import java.util.List;
import net.william278.velocitab.libraries.mvel2.ErrorDetail;
import net.william278.velocitab.libraries.mvel2.ParserContext;
import net.william278.velocitab.libraries.mvel2.util.ParseTools;
import net.william278.velocitab.libraries.mvel2.util.StringAppender;

public class CompileException
extends RuntimeException {
    private char[] expr;
    private int cursor = 0;
    private int msgOffset = 0;
    private int lineNumber = 1;
    private int column = 0;
    private int lastLineStart = 0;
    private List<ErrorDetail> errors;
    private Object evaluationContext;

    public CompileException(String message, List<ErrorDetail> errors, char[] expr, int cursor, ParserContext ctx) {
        super(message);
        this.expr = expr;
        this.cursor = cursor;
        if (!errors.isEmpty()) {
            ErrorDetail detail = errors.iterator().next();
            this.cursor = detail.getCursor();
            this.lineNumber = detail.getLineNumber();
            this.column = detail.getColumn();
        }
        this.errors = errors;
    }

    public void setEvaluationContext(Object evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public String toString() {
        return this.generateErrorMessage();
    }

    public CompileException(String message, char[] expr, int cursor, Throwable e) {
        super(message, e);
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, char[] expr, int cursor) {
        super(message);
        this.expr = expr;
        this.cursor = cursor;
    }

    @Override
    public String getMessage() {
        return this.generateErrorMessage();
    }

    private void calcRowAndColumn() {
        if (this.lineNumber > 1 || this.column > 1) {
            return;
        }
        int row = 1;
        int col = 1;
        if (this.lineNumber != 0 && this.column != 0 || this.expr == null || this.expr.length == 0) {
            return;
        }
        block4: for (int i = 0; i < this.cursor && i < this.expr.length; ++i) {
            switch (this.expr[i]) {
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    ++row;
                    col = 1;
                    continue block4;
                }
                default: {
                    ++col;
                }
            }
        }
        this.lineNumber = row;
        this.column = col;
    }

    private CharSequence showCodeNearError(char[] expr, int cursor) {
        if (expr == null) {
            return "Unknown";
        }
        if (cursor < 0) {
            cursor = 0;
        }
        int start = cursor - 20;
        int end = cursor + 30;
        if (end > expr.length) {
            end = expr.length;
            start -= 30;
        }
        if (start < 0) {
            start = 0;
        }
        String cs = String.copyValueOf(expr, start, end - start).trim();
        int matchStart = -1;
        int matchOffset = 0;
        String match = null;
        if (cursor < end) {
            matchStart = cursor;
            if (matchStart > 0) {
                while (matchStart > 0 && !ParseTools.isWhitespace(expr[matchStart - 1])) {
                    --matchStart;
                }
            }
            matchOffset = cursor - matchStart;
            match = new String(expr, matchStart, expr.length - matchStart);
            block6: for (int i = 0; i < match.length(); ++i) {
                switch (match.charAt(i)) {
                    case '\n': 
                    case ')': {
                        match = match.substring(0, i);
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            if (match.length() >= 30) {
                match = match.substring(0, 30);
            }
        }
        while (true) {
            int matchIndex;
            int firstCr = cs.indexOf(10);
            int lastCr = cs.lastIndexOf(10);
            if (firstCr == -1) break;
            int n = matchIndex = match == null ? 0 : cs.indexOf(match);
            if (firstCr != -1 && firstCr == lastCr) {
                if (firstCr > matchIndex) {
                    cs = cs.substring(0, firstCr);
                    continue;
                }
                if (firstCr >= matchIndex) continue;
                cs = cs.substring(firstCr + 1, cs.length());
                continue;
            }
            if (firstCr < matchIndex) {
                cs = cs.substring(firstCr + 1, lastCr);
                continue;
            }
            cs = cs.substring(0, firstCr);
        }
        String trimmed = cs.trim();
        this.msgOffset = match != null ? trimmed.indexOf(match) + matchOffset : cs.length() - (cs.length() - trimmed.length());
        if (this.msgOffset == 0 && matchOffset == 0) {
            this.msgOffset = cursor;
        }
        return trimmed;
    }

    public CharSequence getCodeNearError() {
        return this.showCodeNearError(this.expr, this.cursor);
    }

    private String generateErrorMessage() {
        StringAppender appender = new StringAppender().append("[Error: " + super.getMessage() + "]\n");
        int offset = appender.length();
        appender.append("[Near : {... ");
        offset = appender.length() - offset;
        appender.append(this.showCodeNearError(this.expr, this.cursor)).append(" ....}]\n").append(ParseTools.repeatChar(' ', offset));
        if (this.msgOffset < 0) {
            this.msgOffset = 0;
        }
        appender.append(ParseTools.repeatChar(' ', this.msgOffset)).append('^');
        this.calcRowAndColumn();
        if (this.evaluationContext != null) {
            appender.append("\n").append("In ").append(this.evaluationContext);
        } else if (this.lineNumber != -1) {
            appender.append("\n").append("[Line: " + this.lineNumber + ", Column: " + this.column + "]");
        }
        return appender.toString();
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getCursor() {
        return this.cursor;
    }

    public List<ErrorDetail> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public void setErrors(List<ErrorDetail> errors) {
        this.errors = errors;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getCursorOffet() {
        return this.msgOffset;
    }

    public void setExpr(char[] expr) {
        this.expr = expr;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public int getLastLineStart() {
        return this.lastLineStart;
    }

    public void setLastLineStart(int lastLineStart) {
        this.lastLineStart = lastLineStart;
    }
}

