/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.Settings;
import net.william278.velocitab.config.TabGroups;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.desertwell.about.AboutMenu;
import net.william278.velocitab.player.TabPlayer;
import org.slf4j.event.Level;

public final class VelocitabCommand {
    private final String systemDumpConfirm = "<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| Prepare a system dump? This will include:</color>\n<gray>\u2022 Your latest server logs and Velocitab config files</gray>\n<gray>\u2022 Current plugin system status information</gray>\n<gray>\u2022 Information about your Java & Minecraft server environment</gray>\n<gray>\u2022 A list of other currently installed plugins</gray>\n<click:run_command:/velocitab dump confirm><hover:show_text:'<gray>Click to prepare dump'><color:#00fb9a>To confirm, use: <italic>/velocitab dump confirm</italic></color></click>\n";
    private final String systemDumpStarted = "<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| Preparing system status dump, please wait\u2026</color>";
    private final String systemDumpReady = "<click:open_url:%url%><color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| System status dump prepared! Click to view:</color>\n<underlined><color:gray>%url%</color></underlined></click>";
    private final String systemUpToDate = "<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| You are running the latest version of Velocitab (v%ver%).</color>";
    private final String systemUpdateAvailable = "<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| A new version of HuskClaims is available: v%new% (running: v%ver%).</color>";
    private final String systemReloaded = "<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| Reloaded config and tab group files.</color>";
    private final String tabNameUpdated = "<color:#00fb9a>Your TAB name has been updated!</color>";
    private final String tabNameReset = "<color:#00fb9a>Your TAB name has been reset.</color>";
    private final String errorPlayerNotFound = "<color:#ff3300>Error:</color> <color:#ff7e5e>Could not find the player %name%.</color>";
    private final String errorTabNameChangeUntracked = "<color:#ff3300>Error:</color> <color:#ff7e5e>You cannot update your TAB name from an untracked server!</color>";
    private final String errorTabNameResetUntracked = "<color:#ff3300>Error:</color> <color:#ff7e5e>You cannot reset your TAB name from an untracked server!</color>";
    private final String errorTabNameResetUnchanged = "<color:#ff3300>Error:</color> <color:#ff7e5e>You do not have a custom TAB name!</color>";
    private final AboutMenu aboutMenu;
    private final Velocitab plugin;

    public VelocitabCommand(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.aboutMenu = AboutMenu.builder().title((Component)Component.text((String)"Velocitab")).description((Component)Component.text((String)((String)plugin.getDescription().getDescription().orElseThrow()))).version(plugin.getVersion()).credits("Authors", AboutMenu.Credit.of("William278").description("Click to visit website").url("https://william278.net"), AboutMenu.Credit.of("AlexDev03").description("Click to visit GitHub").url("https://github.com/alexdev03")).credits("Contributors", AboutMenu.Credit.of("Ironboundred").description("Code"), AboutMenu.Credit.of("Emibergo02").description("Code"), AboutMenu.Credit.of("FreeMonoid").description("Code"), AboutMenu.Credit.of("4drian3d").description("Code")).buttons(AboutMenu.Link.of("https://william278.net/docs/velocitab").text("Docs").icon("\u26cf"), AboutMenu.Link.of("https://discord.gg/tVYhJfyDWG").text("Discord").icon("\u2b50").color(TextColor.color((int)6779893)), AboutMenu.Link.of("https://modrinth.com/plugin/velocitab").text("Modrinth").icon("\u25ce").color(TextColor.color((int)5804355))).build();
    }

    @NotNull
    public BrigadierCommand command() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"velocitab").executes(ctx -> {
            this.sendAboutInfo((CommandSource)ctx.getSource());
            return 1;
        })).then(LiteralArgumentBuilder.literal((String)"about").executes(ctx -> {
            this.sendAboutInfo((CommandSource)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"name").requires(src -> this.hasPermission((CommandSource)src, "name"))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).requires(src -> src instanceof Player)).executes(ctx -> {
            Player player = (Player)ctx.getSource();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(player);
            if (tabPlayer.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#ff3300>Error:</color> <color:#ff7e5e>You cannot update your TAB name from an untracked server!</color>");
                return 1;
            }
            tabPlayer.get().setCustomName(name);
            this.plugin.getTabList().updateDisplayName(tabPlayer.get());
            ((CommandSource)ctx.getSource()).sendRichMessage("<color:#00fb9a>Your TAB name has been updated!</color>");
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)ctx.getSource();
            Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(player);
            if (tabPlayer.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#ff3300>Error:</color> <color:#ff7e5e>You cannot reset your TAB name from an untracked server!</color>");
                return 1;
            }
            String customName = tabPlayer.get().getCustomName().orElse("");
            if (customName.isEmpty() || customName.equals(player.getUsername())) {
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#ff3300>Error:</color> <color:#ff7e5e>You do not have a custom TAB name!</color>");
                return 1;
            }
            tabPlayer.get().setCustomName(null);
            this.plugin.getTabList().updateDisplayName(tabPlayer.get());
            ((CommandSource)ctx.getSource()).sendRichMessage("<color:#00fb9a>Your TAB name has been reset.</color>");
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(src -> this.hasPermission((CommandSource)src, "reload"))).executes(ctx -> {
            Settings settings = this.plugin.getSettings();
            try {
                this.plugin.loadSettings();
            }
            catch (Throwable e) {
                this.plugin.setSettings(settings);
                ((CommandSource)ctx.getSource()).sendRichMessage("<red>An error occurred while reloading the settings file");
                this.plugin.log(Level.ERROR, "An error occurred while reloading the settings file", e);
                return 1;
            }
            Map<String, Group> groups = Map.copyOf(this.plugin.getTabGroupsManager().getGroupsMap());
            Map<TabGroups, String> groupsFiles = Map.copyOf(this.plugin.getTabGroupsManager().getGroupsFilesMap());
            try {
                this.plugin.getTabGroupsManager().loadGroups();
            }
            catch (Throwable e) {
                this.plugin.getTabGroupsManager().loadGroupsBackup(groups, groupsFiles);
                ((CommandSource)ctx.getSource()).sendRichMessage("<red>An error occurred while reloading the tab groups file");
                this.plugin.log(Level.ERROR, "An error occurred while reloading the tab groups file", e);
                return 1;
            }
            this.plugin.getTabList().reloadUpdate();
            ((CommandSource)ctx.getSource()).sendRichMessage("<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| Reloaded config and tab group files.</color>");
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"debug").requires(src -> this.hasPermission((CommandSource)src, "debug"))).then(LiteralArgumentBuilder.literal((String)"tabgroups").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder1) -> {
            String input = builder1.getRemainingLowerCase();
            this.plugin.getTabGroupsManager().getGroups().stream().map(Group::name).filter(s -> input.isEmpty() || s.toLowerCase().contains(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder1).suggest(arg_0));
            return builder1.buildFuture();
        }).then(LiteralArgumentBuilder.literal((String)"players").executes(ctx -> {
            String input = (String)ctx.getArgument("group", String.class);
            Optional<Group> optionalGroup = this.plugin.getTabGroupsManager().getGroup(input);
            if (optionalGroup.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#ff3300>Error:</color> <color:#ff7e5e>You cannot update your TAB name from an untracked server!</color>");
                return 1;
            }
            List<TabPlayer> players = optionalGroup.get().getTabPlayers(this.plugin).stream().sorted(Comparator.comparing(t -> -this.plugin.getScoreboardManager().getPosition(t.getTeamName()))).toList();
            Component playersCount = MiniMessage.miniMessage().deserialize((Object)"<yellow>Players:</yellow> <gray>%s".formatted(players.size()));
            String join = VelocitabCommand.joinPlayersName(players);
            Component playersCountHover = MiniMessage.miniMessage().deserialize((Object)"<yellow>Players:</yellow> <gray>%s".formatted(join));
            playersCount = playersCount.hoverEvent((HoverEventSource)playersCountHover);
            ((CommandSource)ctx.getSource()).sendMessage(playersCount);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"header").executes(ctx -> {
            String input = (String)ctx.getArgument("group", String.class);
            Optional<Group> optionalGroup = this.plugin.getTabGroupsManager().getGroup(input);
            if (optionalGroup.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#ff3300>Error:</color> <color:#ff7e5e>You cannot update your TAB name from an untracked server!</color>");
                return 1;
            }
            Group group = optionalGroup.get();
            for (int i = 0; i < group.headers().size(); ++i) {
                String header = group.getHeader(i);
                Component headerComponent = MiniMessage.miniMessage().deserialize((Object)"<yellow>Header:</yellow> <gray>%s".formatted(i + 1));
                Component headerHover = this.plugin.getFormatter().deserialize(header);
                headerComponent = headerComponent.hoverEvent((HoverEventSource)headerHover);
                ((CommandSource)ctx.getSource()).sendMessage(headerComponent);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"footer").executes(ctx -> {
            String input = (String)ctx.getArgument("group", String.class);
            Optional<Group> optionalGroup = this.plugin.getTabGroupsManager().getGroup(input);
            if (optionalGroup.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#ff3300>Error:</color> <color:#ff7e5e>You cannot update your TAB name from an untracked server!</color>");
                return 1;
            }
            Group group = optionalGroup.get();
            for (int i = 0; i < group.footers().size(); ++i) {
                String footer = group.getFooter(i);
                Component footerComponent = MiniMessage.miniMessage().deserialize((Object)"<yellow>Footer:</yellow> <gray>%s".formatted(i + 1));
                Component footerHover = this.plugin.getFormatter().deserialize(footer);
                footerComponent = footerComponent.hoverEvent((HoverEventSource)footerHover);
                ((CommandSource)ctx.getSource()).sendMessage(footerComponent);
            }
            return 1;
        }))))).then(LiteralArgumentBuilder.literal((String)"tablist").then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder1) -> {
            String input = builder1.getRemainingLowerCase();
            this.plugin.getServer().getAllPlayers().stream().map(Player::getUsername).filter(s -> input.isEmpty() || s.toLowerCase().contains(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder1).suggest(arg_0));
            return builder1.buildFuture();
        }).executes(ctx -> {
            String input = (String)ctx.getArgument("player", String.class);
            Optional player = this.plugin.getServer().getPlayer(input);
            if (player.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#ff3300>Error:</color> <color:#ff7e5e>Could not find the player %name%.</color>".replaceAll("%name%", input));
                return 1;
            }
            ((Player)player.get()).getTabList().getEntries().forEach(entry -> {
                String name = entry.getProfile().getName();
                UUID uuid = entry.getProfile().getId();
                String unformattedDisplayName = entry.getDisplayNameComponent().map(c -> PlainTextComponentSerializer.plainText().serialize(c)).orElse("empty");
                Component hover = MiniMessage.miniMessage().deserialize((Object)"<yellow>UUID:</yellow> <gray>%s<gray>".formatted(uuid)).appendNewline().append(MiniMessage.miniMessage().deserialize((Object)"<yellow>Format</yellow>: ").append((Component)entry.getDisplayNameComponent().orElse(Component.empty())));
                Component component = MiniMessage.miniMessage().deserialize((Object)"<gray>%s<gray> <yellow>-</yellow> <gray>%s".formatted(name, unformattedDisplayName)).hoverEvent((HoverEventSource)hover);
                ((CommandSource)ctx.getSource()).sendMessage(component);
            });
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"dump").requires(src -> this.hasPermission((CommandSource)src, "dump"))).executes(ctx -> {
            ((CommandSource)ctx.getSource()).sendRichMessage("<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| Prepare a system dump? This will include:</color>\n<gray>\u2022 Your latest server logs and Velocitab config files</gray>\n<gray>\u2022 Current plugin system status information</gray>\n<gray>\u2022 Information about your Java & Minecraft server environment</gray>\n<gray>\u2022 A list of other currently installed plugins</gray>\n<click:run_command:/velocitab dump confirm><hover:show_text:'<gray>Click to prepare dump'><color:#00fb9a>To confirm, use: <italic>/velocitab dump confirm</italic></color></click>\n".trim());
            return 1;
        })).then(LiteralArgumentBuilder.literal((String)"confirm").executes(ctx -> {
            ((CommandSource)ctx.getSource()).sendRichMessage("<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| Preparing system status dump, please wait\u2026</color>");
            this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
                String url = this.plugin.createDump((CommandSource)ctx.getSource());
                ((CommandSource)ctx.getSource()).sendRichMessage("<click:open_url:%url%><color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| System status dump prepared! Click to view:</color>\n<underlined><color:gray>%url%</color></underlined></click>".replace("%url%", url));
            }).schedule();
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"update").requires(src -> this.hasPermission((CommandSource)src, "update"))).executes(ctx -> {
            this.plugin.getUpdateChecker().check().thenAccept(checked -> {
                if (checked.isUpToDate()) {
                    ((CommandSource)ctx.getSource()).sendRichMessage("<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| You are running the latest version of Velocitab (v%ver%).</color>".replaceAll("%ver%", this.plugin.getVersion().toString()));
                    return;
                }
                ((CommandSource)ctx.getSource()).sendRichMessage("<color:#00fb9a><bold>Velocitab</bold></color> <color:#00fb9a>| A new version of HuskClaims is available: v%new% (running: v%ver%).</color>".replaceAll("%new%", checked.getLatestVersion().toString()).replaceAll("%ver%", this.plugin.getVersion().toString()));
            });
            return 1;
        }));
        return new BrigadierCommand(builder);
    }

    @NotNull
    private static String joinPlayersName(@NotNull List<TabPlayer> players) {
        StringBuilder join = new StringBuilder();
        for (int i = 0; i < players.size(); ++i) {
            join.append("<yellow>%s</yellow>".formatted(players.get(i).getPlayer().getUsername()));
            if (i != players.size() - 1) {
                join.append("<gray>,</gray> ");
            }
            if (i % 4 != 0) continue;
            join.append("<br>");
        }
        return join.toString();
    }

    private boolean hasPermission(@NotNull CommandSource source, @NotNull String command) {
        return source.hasPermission(String.join((CharSequence)".", "velocitab", "command", command));
    }

    private void sendAboutInfo(@NotNull CommandSource source) {
        source.sendMessage((Component)this.aboutMenu.toComponent());
    }
}

