/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;

public interface MessageHandler {
    default public void handleRequestUserList(@NotNull Message message, @Nullable OnlineUser receiver) {
        if (receiver == null) {
            return;
        }
        Message.builder().type(Message.MessageType.UPDATE_USER_LIST).payload(Payload.userList(this.getPlugin().getOnlineUsers().stream().map(online -> online).toList())).target(message.getSourceServer(), Message.TargetType.SERVER).build().send(this.getBroker(), receiver);
    }

    default public void handleUpdateUserList(@NotNull Message message) {
        message.getPayload().getUserList().ifPresent(players -> this.getPlugin().setUserList(message.getSourceServer(), (List<User>)players));
    }

    default public void handleTeleportToPosition(@NotNull Message message, @NotNull OnlineUser receiver) {
        message.getPayload().getPosition().ifPresent(position -> Teleport.builder(this.getPlugin()).teleporter(receiver).target((Target)position).toTeleport().complete(new String[0]));
    }

    default public void handleTeleportToNetworkedPosition(@NotNull Message message, @NotNull OnlineUser receiver) {
        Message.builder().type(Message.MessageType.TELEPORT_TO_POSITION).target(message.getSender(), Message.TargetType.PLAYER).payload(Payload.position(receiver.getPosition())).build().send(this.getBroker(), receiver);
    }

    default public void handleTeleportToNetworkedUser(@NotNull Message message, @NotNull OnlineUser receiver) {
        message.getPayload().getString().ifPresent(target -> Message.builder().type(Message.MessageType.TELEPORT_TO_NETWORKED_POSITION).target((String)target, Message.TargetType.PLAYER).build().send(this.getBroker(), receiver));
    }

    default public void handleTeleportRequest(@NotNull Message message, @NotNull OnlineUser receiver) {
        message.getPayload().getTeleportRequest().ifPresent(request -> this.getPlugin().getManager().requests().sendLocalTeleportRequest((TeleportRequest)request, receiver));
    }

    default public void handleTeleportRequestResponse(@NotNull Message message, @NotNull OnlineUser receiver) {
        message.getPayload().getTeleportRequest().ifPresent(request -> this.getPlugin().getManager().requests().handleLocalRequestResponse(receiver, (TeleportRequest)request));
    }

    default public void handleUpdateHome(@NotNull Message message, @NotNull OnlineUser receiver) {
        message.getPayload().getString().map(UUID::fromString).ifPresent(id -> {
            Optional<Home> optionalHome = this.getPlugin().getDatabase().getHome((UUID)id);
            if (optionalHome.isPresent()) {
                this.getPlugin().getManager().homes().cacheHome(optionalHome.get(), false);
            } else {
                this.getPlugin().getPlugin().getManager().homes().unCacheHome((UUID)id, false);
            }
        });
    }

    default public void handleUpdateWarp(@NotNull Message message, @NotNull OnlineUser receiver) {
        message.getPayload().getString().map(UUID::fromString).ifPresent(warpId -> {
            Optional<Warp> optionalWarp = this.getPlugin().getDatabase().getWarp((UUID)warpId);
            if (optionalWarp.isPresent()) {
                this.getPlugin().getManager().warps().cacheWarp(optionalWarp.get(), false);
            } else {
                this.getPlugin().getManager().warps().unCacheWarp((UUID)warpId, false);
            }
        });
    }

    default public void handleRtpRequestLocation(@NotNull Message message) {
        Optional<CompletableFuture> requested = message.getPayload().getString().flatMap(name -> this.getPlugin().getWorlds().stream().filter(w -> w.getName().equalsIgnoreCase((String)name)).findFirst());
        requested.map(world -> this.getPlugin().getRandomTeleportEngine().getRandomPosition((World)world, new String[0])).orElse(CompletableFuture.completedFuture(Optional.empty())).thenAccept(teleport -> Message.builder().type(Message.MessageType.RTP_LOCATION).target(message.getSender(), Message.TargetType.PLAYER).payload(Payload.position(teleport.orElse(null))).build().send(this.getBroker(), null));
    }

    default public void handleRtpLocation(@NotNull Message message, @NotNull OnlineUser receiver) {
        Optional<Position> position = message.getPayload().getPosition();
        if (position.isEmpty()) {
            this.getPlugin().getLocales().getLocale("error_rtp_randomization_timeout").ifPresent(receiver::sendMessage);
            return;
        }
        Teleport.builder(this.getPlugin()).teleporter(receiver).actions(TransactionResolver.Action.RANDOM_TELEPORT).target(position.get()).buildAndComplete(true, new String[0]);
    }

    default public void handleUpdateCaches() {
        this.getPlugin().getManager().homes().updatePublicHomeCache();
        this.getPlugin().getManager().warps().updateWarpCache();
    }

    @NotNull
    public Broker getBroker();

    @NotNull
    public HuskHomes getPlugin();
}

