/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import lombok.Generated;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.user.CommandUser;

public class TeleportationException
extends IllegalStateException {
    private final HuskHomes plugin;
    private final Type type;

    public TeleportationException(@NotNull Type cause, @NotNull HuskHomes plugin) {
        super("Error executing teleport: " + cause.name());
        this.type = cause;
        this.plugin = plugin;
    }

    public void displayMessage(@Nullable CommandUser user, String ... args) {
        if (user == null) {
            user = this.plugin.getConsole();
        }
        switch (this.type.ordinal()) {
            case 0: {
                this.plugin.getLocales().getLocale("error_player_not_found", args).ifPresent(user::sendMessage);
                break;
            }
            case 8: {
                this.plugin.getLocales().getLocale("error_player_not_teleportable", args).ifPresent(user::sendMessage);
                break;
            }
            case 1: {
                this.plugin.getLocales().getLocale("error_target_not_found").ifPresent(user::sendMessage);
                break;
            }
            case 2: {
                this.plugin.getLocales().getLocale("error_already_teleporting").ifPresent(user::sendMessage);
                break;
            }
            case 4: {
                this.plugin.getLocales().getLocale("error_teleport_warmup_stand_still").ifPresent(user::sendMessage);
                break;
            }
            case 7: {
                this.plugin.getLocales().getLocale("error_teleport_request_self").ifPresent(user::sendMessage);
                break;
            }
            case 6: {
                this.plugin.getLocales().getLocale("error_illegal_target_coordinates").ifPresent(user::sendMessage);
                break;
            }
            case 5: {
                this.plugin.getLocales().getLocale("error_invalid_world").ifPresent(user::sendMessage);
                break;
            }
        }
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    public static enum Type {
        TELEPORTER_NOT_FOUND,
        TARGET_NOT_FOUND,
        ALREADY_WARMING_UP,
        TRANSACTION_FAILED,
        WARMUP_ALREADY_MOVING,
        WORLD_NOT_FOUND,
        ILLEGAL_TARGET_COORDINATES,
        CANNOT_TELEPORT_TO_SELF,
        TELEPORTER_INVALID;

    }
}

