/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.ListCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;
import net.william278.huskhomes.util.ValidationException;

public class HomesManager {
    private final HuskHomes plugin;
    private final ConcurrentLinkedQueue<Home> publicHomes;
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<Home>> userHomes;

    protected HomesManager(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
        this.publicHomes = new ConcurrentLinkedQueue<Home>(plugin.getDatabase().getPublicHomes());
        this.userHomes = new ConcurrentHashMap();
        plugin.runAsync(() -> plugin.getOnlineUsers().forEach(this::cacheUserHomes));
    }

    @NotNull
    public Map<String, List<String>> getUserHomes() {
        return this.userHomes.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((ConcurrentLinkedQueue)e.getValue()).stream().map(SavedPosition::getName).toList()), HashMap::putAll);
    }

    @NotNull
    public List<String> getUserHomeIdentifiers() {
        return this.userHomes.entrySet().stream().flatMap(e -> ((ConcurrentLinkedQueue)e.getValue()).stream().map(Home::getIdentifier)).toList();
    }

    @NotNull
    public Map<String, List<String>> getPublicHomes() {
        return this.publicHomes.stream().collect(HashMap::new, (m, e) -> m.put(e.getOwner().getName(), List.of(e.getName())), HashMap::putAll);
    }

    @NotNull
    public List<String> getPublicHomeIdentifierNames() {
        return this.publicHomes.stream().map(Home::getIdentifier).toList();
    }

    @NotNull
    public List<String> getPublicHomeNames() {
        return this.publicHomes.stream().map(home -> {
            if (this.publicHomes.stream().filter(h -> h.getName().equals(home.getName())).count() > 1L) {
                return home.getIdentifier();
            }
            return home.getName();
        }).toList();
    }

    public void cacheUserHomes(@NotNull User user) {
        this.userHomes.put(user.getName(), new ConcurrentLinkedQueue<Home>(this.plugin.getDatabase().getHomes(user)));
    }

    public void cacheHome(@NotNull Home home, boolean propagate) {
        this.userHomes.computeIfPresent(home.getOwner().getName(), (k, v) -> {
            v.remove(home);
            v.add(home);
            return v;
        });
        if (this.publicHomes.remove(home) && !home.isPublic()) {
            this.plugin.removeMappedHome(home);
        }
        if (home.isPublic()) {
            this.publicHomes.add(home);
            this.plugin.addMappedHome(home);
        }
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        if (propagate) {
            this.propagateCacheUpdate(home.getUuid());
        }
    }

    public void unCacheHome(@NotNull UUID homeId, boolean propagate) {
        this.userHomes.values().forEach(homes -> homes.removeIf(home -> home.getUuid().equals(homeId)));
        this.publicHomes.removeIf(home -> {
            if (home.getUuid().equals(homeId)) {
                this.plugin.removeMappedHome((Home)home);
                return true;
            }
            return false;
        });
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        if (propagate) {
            this.propagateCacheUpdate(homeId);
        }
    }

    private void propagateCacheUpdate(@NotNull UUID homeId) {
        this.plugin.getBroker().ifPresent(b -> this.plugin.getOnlineUsers().stream().findAny().ifPresent(user -> Message.builder().type(Message.MessageType.UPDATE_HOME).target("ALL", Message.TargetType.SERVER).payload(Payload.string(homeId.toString())).build().send((Broker)b, (OnlineUser)user)));
    }

    public void updatePublicHomeCache() {
        this.plugin.getDatabase().getPublicHomes().forEach(home -> this.cacheHome((Home)home, false));
    }

    public void removeUserHomes(@NotNull User user) {
        this.userHomes.remove(user.getUuid().toString());
    }

    @NotNull
    public Home createHome(@NotNull User owner, @NotNull String name, @NotNull Position position, boolean overwrite, boolean buyAdditionalSlots, boolean ignoreMaxHomes, boolean ignoreHomeSlots) throws ValidationException {
        Optional<Home> existingHome = this.plugin.getDatabase().getHome(owner, name);
        if (existingHome.isPresent() && !overwrite) {
            throw new ValidationException(ValidationException.Type.NAME_TAKEN);
        }
        this.plugin.validateName(name);
        int homes = this.plugin.getDatabase().getHomes(owner).size() + (existingHome.isPresent() ? 0 : 1);
        if (!ignoreMaxHomes && homes > this.getMaxHomes(owner)) {
            throw new ValidationException(ValidationException.Type.REACHED_MAX_HOMES);
        }
        SavedUser savedOwner = this.plugin.getSavedUser(owner).or(() -> this.plugin.getDatabase().getUser(owner.getUuid())).orElseThrow(() -> new IllegalStateException("User data not found for " + String.valueOf(owner.getUuid())));
        if (this.plugin.isUsingEconomy() && !ignoreHomeSlots && homes > this.getFreeHomes(owner) && homes > savedOwner.getHomeSlots()) {
            if (!buyAdditionalSlots || !(owner instanceof OnlineUser)) {
                throw new ValidationException(ValidationException.Type.NOT_ENOUGH_HOME_SLOTS);
            }
            OnlineUser online = (OnlineUser)owner;
            if (!this.plugin.validateTransaction(online, TransactionResolver.Action.ADDITIONAL_HOME_SLOT)) {
                throw new ValidationException(ValidationException.Type.TRANSACTION_FAILED);
            }
            this.plugin.performTransaction(online, TransactionResolver.Action.ADDITIONAL_HOME_SLOT);
            this.plugin.editSavedUser(online, saved -> saved.setHomeSlots(saved.getHomeSlots() + 1));
        }
        Home home = existingHome.map(existing -> {
            existing.getMeta().setName(name);
            existing.update(position);
            return existing;
        }).orElse(Home.from(position, PositionMeta.create(name, ""), owner));
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
        return home;
    }

    public void createHome(@NotNull OnlineUser owner, @NotNull String name, @NotNull Position position) throws ValidationException {
        this.createHome(owner, name, position, this.plugin.getSettings().getGeneral().getNames().isOverwriteExisting(), true, false, false);
    }

    public void deleteHome(@NotNull User owner, @NotNull String name) throws ValidationException {
        Optional<Home> home = this.plugin.getDatabase().getHome(owner, name);
        if (home.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.deleteHome(home.get());
    }

    public void deleteHome(@NotNull Home home) {
        this.plugin.getDatabase().deleteHome(home.getUuid());
        this.unCacheHome(home.getUuid(), true);
    }

    public int deleteAllHomes(@NotNull User owner) {
        int deleted = this.plugin.getDatabase().deleteAllHomes(owner);
        this.userHomes.computeIfPresent(owner.getName(), (k, v) -> {
            v.clear();
            return v;
        });
        this.publicHomes.removeIf(h -> h.getOwner().getUuid().equals(owner.getUuid()));
        this.plugin.removeAllMappedHomes(owner);
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        this.plugin.getManager().propagateCacheUpdate();
        return deleted;
    }

    public int deleteAllHomes(@NotNull String worldName, @NotNull String serverName) {
        int deleted = this.plugin.getDatabase().deleteAllHomes(worldName, serverName);
        this.userHomes.values().forEach(homes -> homes.removeIf(h -> h.getWorld().getName().equals(worldName) && h.getServer().equals(serverName)));
        this.publicHomes.removeIf(h -> h.getWorld().getName().equals(worldName) && h.getServer().equals(serverName));
        if (this.plugin.getSettings().getCrossServer().isEnabled() && serverName.equals(this.plugin.getServerName())) {
            this.plugin.removeAllMappedHomes(worldName);
        }
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        this.plugin.getManager().propagateCacheUpdate();
        return deleted;
    }

    public void setHomePosition(@NotNull User owner, @NotNull String name, @NotNull Position position) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomePosition(optionalHome.get(), position);
    }

    public void setHomePosition(@NotNull Home home, @NotNull Position position) throws ValidationException {
        home.update(position);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomeName(@NotNull User owner, @NotNull String name, @NotNull String newName) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomeName(optionalHome.get(), newName);
    }

    public void setHomeName(@NotNull Home home, @NotNull String newName) throws ValidationException {
        if (this.plugin.getDatabase().getHome(home.getOwner(), newName).isPresent()) {
            throw new ValidationException(ValidationException.Type.NAME_TAKEN);
        }
        this.plugin.validateName(newName);
        home.getMeta().setName(newName);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomeDescription(@NotNull User owner, @NotNull String name, @NotNull String description) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomeDescription(optionalHome.get(), description);
    }

    public void setHomeDescription(@NotNull Home home, @NotNull String description) {
        this.plugin.validateDescription(description);
        home.getMeta().setDescription(description);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomePrivacy(@NotNull User owner, @NotNull String name, boolean isPublic) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomePrivacy(owner, optionalHome.get(), isPublic);
    }

    public void setHomePrivacy(@NotNull Home home, boolean isPublic) {
        this.setHomePrivacy(home.getOwner(), home, isPublic);
    }

    public void setHomePrivacy(@NotNull User owner, @NotNull Home home, boolean isPublic) {
        if (isPublic && owner instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)owner;
            int publicHomes = this.plugin.getDatabase().getHomes(owner).stream().filter(Home::isPublic).toList().size();
            if (publicHomes >= this.getMaxPublicHomes(online)) {
                throw new ValidationException(ValidationException.Type.REACHED_MAX_PUBLIC_HOMES);
            }
        }
        home.setPublic(isPublic);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomeMetaTags(@NotNull User owner, @NotNull String name, @NotNull Map<String, String> tags) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomeMetaTags(optionalHome.get(), tags);
    }

    public void setHomeMetaTags(@NotNull Home home, @NotNull Map<String, String> tags) {
        home.getMeta().setTags(tags);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public int getMaxHomes(@Nullable User user) {
        int n;
        if (user instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            n = online.getMaxHomes(this.plugin.getSettings().getGeneral().getMaxHomes(), this.plugin.getSettings().getGeneral().isStackPermissionLimits());
        } else {
            n = this.plugin.getSettings().getGeneral().getMaxHomes();
        }
        return n;
    }

    public int getMaxPublicHomes(@Nullable User user) {
        int n;
        if (user instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            n = online.getMaxPublicHomes(this.plugin.getSettings().getGeneral().getMaxPublicHomes(), this.plugin.getSettings().getGeneral().isStackPermissionLimits());
        } else {
            n = this.plugin.getSettings().getGeneral().getMaxPublicHomes();
        }
        return n;
    }

    public int getFreeHomes(@Nullable User user) {
        int n;
        if (user instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            n = online.getFreeHomes(this.plugin.getSettings().getEconomy().getFreeHomeSlots(), this.plugin.getSettings().getGeneral().isStackPermissionLimits());
        } else {
            n = this.plugin.getSettings().getEconomy().getFreeHomeSlots();
        }
        return n;
    }
}

