/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.HomeCommand;
import net.william278.huskhomes.command.PublicHomeListCommand;
import net.william278.huskhomes.command.SavedPositionCommand;
import net.william278.huskhomes.command.TabCompletable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;

public class PublicHomeCommand
extends HomeCommand
implements TabCompletable {
    protected PublicHomeCommand(@NotNull HuskHomes plugin) {
        super(List.of("phome", "publichome"), SavedPositionCommand.PositionCommandType.PUBLIC_HOME, plugin);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        if (args.length == 0) {
            this.plugin.getCommand(PublicHomeListCommand.class).ifPresent(cmd -> cmd.showPublicHomeList(executor, null, 1));
            return;
        }
        super.execute(executor, args);
    }

    @Override
    @NotNull
    public List<String> suggest(@NotNull CommandUser executor, @NotNull String[] args) {
        if (args.length <= 2) {
            if (args.length >= 1 && args[0].contains(Home.getDelimiter())) {
                return this.plugin.getManager().homes().getPublicHomeIdentifierNames();
            }
            return this.plugin.getManager().homes().getPublicHomeNames();
        }
        return List.of();
    }
}

