/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.SavedPositionCommand;
import net.william278.huskhomes.command.WarpListCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.util.TransactionResolver;

public class WarpCommand
extends SavedPositionCommand<Warp> {
    protected WarpCommand(@NotNull HuskHomes plugin) {
        super(List.of("warp"), SavedPositionCommand.PositionCommandType.WARP, List.of(), plugin);
        this.addAdditionalPermissions(Map.of("player", true));
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        if (args.length == 0) {
            this.plugin.getCommand(WarpListCommand.class).ifPresent(command -> command.showWarpList(executor, 1));
            return;
        }
        super.execute(executor, args);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull Warp warp, @NotNull String[] args) {
        if (this.plugin.getSettings().getGeneral().isPermissionRestrictWarps() && !warp.hasPermission(executor)) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        Optional<Teleportable> optionalTeleporter = this.resolveTeleporter(executor, args);
        if (optionalTeleporter.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return;
        }
        this.teleport(executor, optionalTeleporter.get(), warp, TransactionResolver.Action.WARP_TELEPORT);
    }
}

